/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.jawk.backend;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.sentrysoftware.jawk.ExitException;
import org.sentrysoftware.jawk.backend.AwkInterpreter;
import org.sentrysoftware.jawk.ext.JawkExtension;
import org.sentrysoftware.jawk.frontend.AwkParser;
import org.sentrysoftware.jawk.intermediate.Address;
import org.sentrysoftware.jawk.intermediate.AwkTuples;
import org.sentrysoftware.jawk.intermediate.Position;
import org.sentrysoftware.jawk.intermediate.PositionForInterpretation;
import org.sentrysoftware.jawk.intermediate.UninitializedObject;
import org.sentrysoftware.jawk.jrt.AssocArray;
import org.sentrysoftware.jawk.jrt.AwkRuntimeException;
import org.sentrysoftware.jawk.jrt.BlockManager;
import org.sentrysoftware.jawk.jrt.BlockObject;
import org.sentrysoftware.jawk.jrt.CharacterTokenizer;
import org.sentrysoftware.jawk.jrt.ConditionPair;
import org.sentrysoftware.jawk.jrt.JRT;
import org.sentrysoftware.jawk.jrt.KeyList;
import org.sentrysoftware.jawk.jrt.KeyListImpl;
import org.sentrysoftware.jawk.jrt.RegexTokenizer;
import org.sentrysoftware.jawk.jrt.SingleCharacterTokenizer;
import org.sentrysoftware.jawk.jrt.VariableManager;
import org.sentrysoftware.jawk.util.ArrayStackImpl;
import org.sentrysoftware.jawk.util.AwkLogger;
import org.sentrysoftware.jawk.util.AwkSettings;
import org.sentrysoftware.jawk.util.LinkedListStackImpl;
import org.sentrysoftware.jawk.util.MyStack;
import org.sentrysoftware.jawk.util.ScriptSource;
import org.sentrysoftware.printf4j.Printf4J;
import org.slf4j.Logger;

public class AVM
implements AwkInterpreter,
VariableManager {
    private static final Logger LOG = AwkLogger.getLogger(AVM.class);
    private static final boolean IS_WINDOWS = System.getProperty("os.name").indexOf("Windows") >= 0;
    private RuntimeStack runtime_stack = new RuntimeStack();
    private MyStack<Object> operand_stack = new ArrayStackImpl<Object>();
    private List<String> arguments;
    private boolean sorted_array_keys;
    private Map<String, Object> initial_variables;
    private String initial_fs_value;
    private boolean trap_illegal_format_exceptions;
    private JRT jrt;
    private final Locale locale;
    private Map<String, JawkExtension> extensions;
    private final AwkSettings settings;
    private long nf_offset = -1L;
    private long nr_offset = -1L;
    private long fnr_offset = -1L;
    private long fs_offset = -1L;
    private long rs_offset = -1L;
    private long ofs_offset = -1L;
    private long ors_offset = -1L;
    private long rstart_offset = -1L;
    private long rlength_offset = -1L;
    private long filename_offset = -1L;
    private long subsep_offset = -1L;
    private long convfmt_offset = -1L;
    private long ofmt_offset = -1L;
    private long environ_offset = -1L;
    private long argc_offset = -1L;
    private long argv_offset = -1L;
    private static final Integer ZERO = 0;
    private static final Integer ONE = 1;
    private Random random_number_generator;
    private int oldseed;
    private Address exit_address = null;
    private boolean within_end_blocks = false;
    private int exit_code = 0;
    private boolean throw_exit_exception = false;
    private Map<String, Integer> global_variable_offsets;
    private Map<String, Boolean> global_variable_arrays;
    private Set<String> function_names;
    private StringBuffer replace_first_sb = new StringBuffer();
    private StringBuffer replace_all_sb = new StringBuffer();
    private static final UninitializedObject BLANK = new UninitializedObject();
    public static final int NULL_OFFSET = -1;

    private Object pop() {
        return this.operand_stack.pop();
    }

    private void push(Object o) {
        this.operand_stack.push(o);
    }

    public AVM() {
        this.settings = null;
        this.arguments = new ArrayList<String>();
        this.sorted_array_keys = false;
        this.initial_variables = new HashMap<String, Object>();
        this.initial_fs_value = null;
        this.trap_illegal_format_exceptions = false;
        this.jrt = new JRT(this);
        this.locale = Locale.getDefault();
        this.extensions = Collections.emptyMap();
    }

    public AVM(AwkSettings parameters, Map<String, JawkExtension> extensions) {
        if (parameters == null) {
            throw new IllegalArgumentException("AwkSettings can not be null");
        }
        this.settings = parameters;
        this.locale = this.settings.getLocale();
        this.arguments = parameters.getNameValueOrFileNames();
        this.sorted_array_keys = parameters.isUseSortedArrayKeys();
        this.initial_variables = parameters.getVariables();
        this.initial_fs_value = parameters.getFieldSeparator();
        this.trap_illegal_format_exceptions = parameters.isCatchIllegalFormatExceptions();
        this.jrt = new JRT(this);
        this.extensions = extensions;
        for (JawkExtension ext : extensions.values()) {
            ext.init(this, this.jrt, this.settings);
        }
    }

    private static int parseIntField(Object obj, PositionForInterpretation position) {
        int fieldVal;
        if (obj instanceof Number) {
            fieldVal = ((Number)obj).intValue();
        } else {
            try {
                fieldVal = (int)Double.parseDouble(obj.toString());
            }
            catch (NumberFormatException nfe) {
                throw new AwkRuntimeException(position.lineNumber(), "Field $(" + obj.toString() + ") is incorrect.");
            }
        }
        return fieldVal;
    }

    private void setNumOnJRT(int fieldNum, double num) {
        String numString = num == (double)((long)num) ? Long.toString((long)num) : Double.toString(num);
        if (fieldNum == 0) {
            this.jrt.setInputLine(numString.toString());
            this.jrt.jrtParseFields();
        } else {
            this.jrt.jrtSetInputField(numString, fieldNum);
        }
    }

    private String execSubOrGSub(PositionForInterpretation position, int gsubArgPos) {
        boolean is_gsub = position.boolArg(gsubArgPos);
        String convfmt = this.getCONVFMT().toString();
        String orig = JRT.toAwkString(this.pop(), convfmt, this.locale);
        String repl = JRT.toAwkString(this.pop(), convfmt, this.locale);
        String ere = JRT.toAwkString(this.pop(), convfmt, this.locale);
        String newString = is_gsub ? this.replaceAll(orig, ere, repl) : this.replaceFirst(orig, ere, repl);
        return newString;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void interpret(AwkTuples tuples) throws ExitException, IOException {
        regexps = new HashMap<String, Pattern>();
        condition_pairs = new HashMap<Integer, ConditionPair>();
        this.global_variable_offsets = tuples.getGlobalVariableOffsetMap();
        this.global_variable_arrays = tuples.getGlobalVariableAarrayMap();
        this.function_names = tuples.getFunctionNameSet();
        position = (PositionForInterpretation)tuples.top();
        try {
            block163: while (!position.isEOF()) {
                opcode = position.opcode();
                switch (opcode) {
                    case 264: {
                        num_args = position.intArg(0);
                        this.printTo(this.settings.getOutputStream(), num_args);
                        position.next();
                        continue block163;
                    }
                    case 265: {
                        num_args = position.intArg(0);
                        append = position.boolArg(1);
                        key = JRT.toAwkString(this.pop(), this.getCONVFMT().toString(), this.locale);
                        ps = this.jrt.getOutputFiles().get(key);
                        if (ps == null) {
                            try {
                                ps = new PrintStream(new FileOutputStream(key, append), true);
                                this.jrt.getOutputFiles().put(key, ps);
                            }
                            catch (IOException ioe) {
                                throw new AwkRuntimeException(position.lineNumber(), "Cannot open " + key + " for writing: " + ioe);
                            }
                        }
                        this.printTo(ps, num_args);
                        position.next();
                        continue block163;
                    }
                    case 266: {
                        num_args = position.intArg(0);
                        cmd = JRT.toAwkString(this.pop(), this.getCONVFMT().toString(), this.locale);
                        ps = this.jrt.jrtSpawnForOutput(cmd);
                        this.printTo(ps, num_args);
                        position.next();
                        continue block163;
                    }
                    case 267: {
                        num_args = position.intArg(0);
                        this.printfTo(this.settings.getOutputStream(), num_args);
                        position.next();
                        continue block163;
                    }
                    case 268: {
                        num_args = position.intArg(0);
                        append = position.boolArg(1);
                        key = JRT.toAwkString(this.pop(), this.getCONVFMT().toString(), this.locale);
                        ps = this.jrt.getOutputFiles().get(key);
                        if (ps == null) {
                            try {
                                ps = new PrintStream(new FileOutputStream(key, append), true);
                                this.jrt.getOutputFiles().put(key, ps);
                            }
                            catch (IOException ioe) {
                                throw new AwkRuntimeException(position.lineNumber(), "Cannot open " + key + " for writing: " + ioe);
                            }
                        }
                        this.printfTo(ps, num_args);
                        position.next();
                        continue block163;
                    }
                    case 269: {
                        num_args = position.intArg(0);
                        cmd = JRT.toAwkString(this.pop(), this.getCONVFMT().toString(), this.locale);
                        ps = this.jrt.jrtSpawnForOutput(cmd);
                        this.printfTo(ps, num_args);
                        position.next();
                        continue block163;
                    }
                    case 270: {
                        num_args = position.intArg(0);
                        this.push(this.sprintfFunction(num_args));
                        position.next();
                        continue block163;
                    }
                    case 271: {
                        num = position.intArg(0);
                        if (num == 0L) {
                            this.push(this.jrt.jrtGetInputField(0).toString().length());
                        } else {
                            this.push(this.pop().toString().length());
                        }
                        position.next();
                        continue block163;
                    }
                    case 258: {
                        this.push(position.arg(0));
                        position.next();
                        continue block163;
                    }
                    case 257: {
                        this.pop();
                        position.next();
                        continue block163;
                    }
                    case 259: {
                        v0 = jump = this.jrt.toBoolean(this.pop()) == false;
                        if (jump) {
                            position.jump(position.addressArg());
                            continue block163;
                        }
                        position.next();
                        continue block163;
                    }
                    case 260: {
                        val = this.jrt.toBoolean(this.pop());
                        this.push(val != false ? AVM.ONE : AVM.ZERO);
                        position.next();
                        continue block163;
                    }
                    case 261: {
                        jump = this.jrt.toBoolean(this.pop());
                        if (jump) {
                            position.jump(position.addressArg());
                            continue block163;
                        }
                        position.next();
                        continue block163;
                    }
                    case 330: {
                        o = this.pop();
                        if (o instanceof Integer) {
                            result = (Integer)o != 0;
                        } else if (o instanceof Long) {
                            result = (Long)o != 0L;
                        } else if (o instanceof Double) {
                            result = (Double)o != 0.0;
                        } else if (o instanceof String) {
                            result = o.toString().length() > 0;
                        } else {
                            if (o instanceof UninitializedObject == false) throw new Error("Unknown operand_stack type: " + o.getClass() + " for value " + o);
                            result = false;
                        }
                        if (result) {
                            this.push(0);
                        } else {
                            this.push(1);
                        }
                        position.next();
                        continue block163;
                    }
                    case 331: {
                        d = JRT.toDouble(this.pop());
                        if (d == (double)((long)d)) {
                            this.push((long)(-d));
                        } else {
                            this.push(-d);
                        }
                        position.next();
                        continue block163;
                    }
                    case 385: {
                        d = JRT.toDouble(this.pop());
                        if (d == (double)((long)d)) {
                            this.push((long)d);
                        } else {
                            this.push(d);
                        }
                        position.next();
                        continue block163;
                    }
                    case 262: {
                        position.jump(position.addressArg());
                        continue block163;
                    }
                    case 263: {
                        position.next();
                        continue block163;
                    }
                    case 272: {
                        convfmt = this.getCONVFMT().toString();
                        s2 = JRT.toAwkString(this.pop(), convfmt, this.locale);
                        s1 = JRT.toAwkString(this.pop(), convfmt, this.locale);
                        result_string = s1 + s2;
                        this.push(result_string);
                        position.next();
                        continue block163;
                    }
                    case 273: {
                        value = this.pop();
                        is_global = position.boolArg(1);
                        this.assign(position.intArg(0), value, is_global, position);
                        position.next();
                        continue block163;
                    }
                    case 274: {
                        arr_idx = this.pop();
                        rhs = this.pop();
                        if (rhs == null) {
                            rhs = AVM.BLANK;
                        }
                        offset = position.intArg(0);
                        is_global = position.boolArg(1);
                        this.assignArray(offset, arr_idx, rhs, is_global);
                        position.next();
                        continue block163;
                    }
                    case 284: 
                    case 285: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: {
                        arr_idx = this.pop();
                        rhs = this.pop();
                        if (rhs == null) {
                            rhs = AVM.BLANK;
                        }
                        offset = position.intArg(0);
                        is_global = position.boolArg(1);
                        val = JRT.toDouble(rhs);
                        o1 = this.runtime_stack.getVariable(offset, is_global);
                        if (o1 == null || o1 instanceof UninitializedObject) {
                            o1 = new AssocArray(this.sorted_array_keys);
                            this.runtime_stack.setVariable(offset, o1, is_global);
                        } else if (!AVM.$assertionsDisabled && !(o1 instanceof AssocArray)) {
                            throw new AssertionError();
                        }
                        array = (AssocArray)o1;
                        o = array.get(arr_idx);
                        if (!AVM.$assertionsDisabled && o == null) {
                            throw new AssertionError();
                        }
                        orig_val = JRT.toDouble(o);
                        switch (opcode) {
                            case 284: {
                                new_val = orig_val + val;
                                break;
                            }
                            case 285: {
                                new_val = orig_val - val;
                                break;
                            }
                            case 286: {
                                new_val = orig_val * val;
                                break;
                            }
                            case 287: {
                                new_val = orig_val / val;
                                break;
                            }
                            case 288: {
                                new_val = orig_val % val;
                                break;
                            }
                            case 289: {
                                new_val = Math.pow(orig_val, val);
                                break;
                            }
                            default: {
                                throw new Error("Invalid op code here: " + opcode);
                            }
                        }
                        if (new_val == (double)((long)new_val)) {
                            this.assignArray(offset, arr_idx, (long)new_val, is_global);
                        } else {
                            this.assignArray(offset, arr_idx, new_val, is_global);
                        }
                        position.next();
                        continue block163;
                    }
                    case 275: {
                        this.jrt.setInputLine(this.pop().toString());
                        this.jrt.jrtParseFields();
                        this.push(this.jrt.getInputLine());
                        position.next();
                        continue block163;
                    }
                    case 276: {
                        field_num_obj = this.pop();
                        if (field_num_obj instanceof Number) {
                            field_num = ((Number)field_num_obj).intValue();
                        } else {
                            try {
                                field_num = Integer.parseInt(field_num_obj.toString());
                            }
                            catch (NumberFormatException nfe) {
                                field_num = 0;
                            }
                        }
                        value = this.pop().toString();
                        this.push(value);
                        if (field_num == 0) {
                            this.jrt.setInputLine(value);
                            this.jrt.jrtParseFields();
                        } else {
                            this.jrt.jrtSetInputField(value, field_num);
                        }
                        position.next();
                        continue block163;
                    }
                    case 278: 
                    case 279: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: {
                        is_global = position.boolArg(1);
                        o1 = this.runtime_stack.getVariable(position.intArg(0), is_global);
                        if (o1 == null) {
                            o1 = AVM.BLANK;
                        }
                        o2 = this.pop();
                        d1 = JRT.toDouble(o1);
                        d2 = JRT.toDouble(o2);
                        switch (opcode) {
                            case 278: {
                                ans = d1 + d2;
                                break;
                            }
                            case 279: {
                                ans = d1 - d2;
                                break;
                            }
                            case 280: {
                                ans = d1 * d2;
                                break;
                            }
                            case 281: {
                                ans = d1 / d2;
                                break;
                            }
                            case 282: {
                                ans = d1 % d2;
                                break;
                            }
                            case 283: {
                                ans = Math.pow(d1, d2);
                                break;
                            }
                            default: {
                                throw new Error("Invalid opcode here: " + opcode);
                            }
                        }
                        if (ans == (double)((long)ans)) {
                            this.push((long)ans);
                            this.runtime_stack.setVariable(position.intArg(0), (int)ans, is_global);
                        } else {
                            this.push(ans);
                            this.runtime_stack.setVariable(position.intArg(0), ans, is_global);
                        }
                        position.next();
                        continue block163;
                    }
                    case 290: 
                    case 291: 
                    case 292: 
                    case 293: 
                    case 294: 
                    case 295: {
                        fieldnum = AVM.parseIntField(this.pop(), position);
                        incval = JRT.toDouble(this.pop());
                        num_obj = this.jrt.jrtGetInputField(fieldnum);
                        switch (opcode) {
                            case 290: {
                                num = JRT.toDouble(num_obj) + incval;
                                break;
                            }
                            case 291: {
                                num = JRT.toDouble(num_obj) - incval;
                                break;
                            }
                            case 292: {
                                num = JRT.toDouble(num_obj) * incval;
                                break;
                            }
                            case 293: {
                                num = JRT.toDouble(num_obj) / incval;
                                break;
                            }
                            case 294: {
                                num = JRT.toDouble(num_obj) % incval;
                                break;
                            }
                            case 295: {
                                num = Math.pow(JRT.toDouble(num_obj), incval);
                                break;
                            }
                            default: {
                                throw new Error("Invalid opcode here: " + opcode);
                            }
                        }
                        this.setNumOnJRT(fieldnum, num);
                        this.push(num);
                        position.next();
                        continue block163;
                    }
                    case 323: {
                        this.inc(position.intArg(0), position.boolArg(1));
                        position.next();
                        continue block163;
                    }
                    case 324: {
                        this.dec(position.intArg(0), position.boolArg(1));
                        position.next();
                        continue block163;
                    }
                    case 388: {
                        this.pop();
                        this.push(this.inc(position.intArg(0), position.boolArg(1)));
                        position.next();
                        continue block163;
                    }
                    case 389: {
                        this.pop();
                        this.push(this.dec(position.intArg(0), position.boolArg(1)));
                        position.next();
                        continue block163;
                    }
                    case 325: {
                        is_global = position.boolArg(1);
                        o1 = this.runtime_stack.getVariable(position.intArg(0), is_global);
                        if (o1 == null || o1 instanceof UninitializedObject) {
                            o1 = new AssocArray(this.sorted_array_keys);
                            this.runtime_stack.setVariable(position.intArg(0), o1, is_global);
                        }
                        aa = (AssocArray)o1;
                        key = this.pop();
                        o = aa.get(key);
                        if (!AVM.$assertionsDisabled && o == null) {
                            throw new AssertionError();
                        }
                        ans = JRT.toDouble(o) + 1.0;
                        if (ans == (double)((long)ans)) {
                            aa.put(key, (Object)((long)ans));
                        } else {
                            aa.put(key, (Object)ans);
                        }
                        position.next();
                        continue block163;
                    }
                    case 326: {
                        is_global = position.boolArg(1);
                        o1 = this.runtime_stack.getVariable(position.intArg(0), is_global);
                        if (o1 == null || o1 instanceof UninitializedObject) {
                            o1 = new AssocArray(this.sorted_array_keys);
                            this.runtime_stack.setVariable(position.intArg(0), o1, is_global);
                        }
                        aa = (AssocArray)o1;
                        key = this.pop();
                        o = aa.get(key);
                        if (!AVM.$assertionsDisabled && o == null) {
                            throw new AssertionError();
                        }
                        ans = JRT.toDouble(o) - 1.0;
                        if (ans == (double)((long)ans)) {
                            aa.put(key, (Object)((long)ans));
                        } else {
                            aa.put(key, (Object)ans);
                        }
                        position.next();
                        continue block163;
                    }
                    case 327: {
                        fieldnum = AVM.parseIntField(this.pop(), position);
                        num_obj = this.jrt.jrtGetInputField(fieldnum);
                        num = JRT.toDouble(num_obj) + 1.0;
                        this.setNumOnJRT(fieldnum, num);
                        position.next();
                        continue block163;
                    }
                    case 328: {
                        fieldnum = AVM.parseIntField(this.pop(), position);
                        num_obj = this.jrt.jrtGetInputField(fieldnum);
                        num = JRT.toDouble(num_obj) - 1.0;
                        this.setNumOnJRT(fieldnum, num);
                        position.next();
                        continue block163;
                    }
                    case 277: {
                        is_global = position.boolArg(2);
                        o = this.runtime_stack.getVariable(position.intArg(0), is_global);
                        if (o != null) ** GOTO lbl405
                        if (position.boolArg(1)) {
                            this.push(this.runtime_stack.setVariable(position.intArg(0), new AssocArray(this.sorted_array_keys), is_global));
                        } else {
                            this.push(this.runtime_stack.setVariable(position.intArg(0), AVM.BLANK, is_global));
                        }
                        ** GOTO lbl406
lbl405:
                        // 1 sources

                        this.push(o);
lbl406:
                        // 3 sources

                        position.next();
                        continue block163;
                    }
                    case 338: {
                        idx = this.pop();
                        array = this.pop();
                        if (!(array instanceof AssocArray)) {
                            throw new AwkRuntimeException("Attempting to index a non-associative-array.");
                        }
                        o = ((AssocArray)array).get(idx);
                        if (!AVM.$assertionsDisabled && o == null) {
                            throw new AssertionError();
                        }
                        this.push(o);
                        position.next();
                        continue block163;
                    }
                    case 296: {
                        numargs = position.intArg(0);
                        if (numargs == 0L) {
                            seed = JRT.timeSeed();
                        } else {
                            o = this.pop();
                            if (o instanceof Double) {
                                seed = ((Double)o).intValue();
                            } else if (o instanceof Long) {
                                seed = ((Long)o).intValue();
                            } else if (o instanceof Integer) {
                                seed = (Integer)o;
                            } else {
                                try {
                                    seed = Integer.parseInt(o.toString());
                                }
                                catch (NumberFormatException nfe) {
                                    seed = 0;
                                }
                            }
                        }
                        this.random_number_generator = new Random(seed);
                        this.push(this.oldseed);
                        this.oldseed = seed;
                        position.next();
                        continue block163;
                    }
                    case 297: {
                        if (this.random_number_generator == null) {
                            seed = JRT.timeSeed();
                            this.random_number_generator = new Random(seed);
                            this.oldseed = seed;
                        }
                        this.push(this.random_number_generator.nextDouble());
                        position.next();
                        continue block163;
                    }
                    case 298: 
                    case 378: {
                        this.push((long)JRT.toDouble(this.pop()));
                        position.next();
                        continue block163;
                    }
                    case 299: {
                        this.push(Math.sqrt(JRT.toDouble(this.pop())));
                        position.next();
                        continue block163;
                    }
                    case 300: {
                        this.push(Math.log(JRT.toDouble(this.pop())));
                        position.next();
                        continue block163;
                    }
                    case 301: {
                        this.push(Math.exp(JRT.toDouble(this.pop())));
                        position.next();
                        continue block163;
                    }
                    case 302: {
                        this.push(Math.sin(JRT.toDouble(this.pop())));
                        position.next();
                        continue block163;
                    }
                    case 303: {
                        this.push(Math.cos(JRT.toDouble(this.pop())));
                        position.next();
                        continue block163;
                    }
                    case 304: {
                        d2 = JRT.toDouble(this.pop());
                        d1 = JRT.toDouble(this.pop());
                        this.push(Math.atan2(d1, d2));
                        position.next();
                        continue block163;
                    }
                    case 305: {
                        convfmt = this.getCONVFMT().toString();
                        ere = JRT.toAwkString(this.pop(), convfmt, this.locale);
                        s = JRT.toAwkString(this.pop(), convfmt, this.locale);
                        flags = 0;
                        if (this.global_variable_offsets.containsKey("IGNORECASE") && JRT.toDouble(ignorecase = this.runtime_stack.getVariable((offset_obj = this.global_variable_offsets.get("IGNORECASE")).intValue(), true)) != 0.0) {
                            flags |= 2;
                        }
                        if (result = (matcher = (pattern = Pattern.compile(ere, flags)).matcher(s)).find()) {
                            this.assign(this.rstart_offset, matcher.start() + 1, true, position);
                            this.assign(this.rlength_offset, matcher.end() - matcher.start(), true, position);
                            this.pop();
                        } else {
                            this.assign(this.rstart_offset, AVM.ZERO, true, position);
                            this.assign(this.rlength_offset, -1, true, position);
                            this.pop();
                        }
                        position.next();
                        continue block163;
                    }
                    case 306: {
                        convfmt = this.getCONVFMT().toString();
                        s2 = JRT.toAwkString(this.pop(), convfmt, this.locale);
                        s1 = JRT.toAwkString(this.pop(), convfmt, this.locale);
                        this.push(s1.indexOf(s2) + 1);
                        position.next();
                        continue block163;
                    }
                    case 307: {
                        is_gsub = position.boolArg(0);
                        convfmt = this.getCONVFMT().toString();
                        repl = JRT.toAwkString(this.pop(), convfmt, this.locale);
                        ere = JRT.toAwkString(this.pop(), convfmt, this.locale);
                        orig = JRT.toAwkString(this.jrt.jrtGetInputField(0), convfmt, this.locale);
                        newstring = is_gsub != false ? this.replaceAll(orig, ere, repl) : this.replaceFirst(orig, ere, repl);
                        this.jrt.setInputLine(newstring);
                        this.jrt.jrtParseFields();
                        position.next();
                        continue block163;
                    }
                    case 308: {
                        newString = this.execSubOrGSub(position, 0);
                        fieldNum = (int)JRT.toDouble(this.pop());
                        if (fieldNum == 0) {
                            this.jrt.setInputLine(newString);
                            this.jrt.jrtParseFields();
                        } else {
                            this.jrt.jrtSetInputField(newString, fieldNum);
                        }
                        position.next();
                        continue block163;
                    }
                    case 309: {
                        offset = position.intArg(0);
                        is_global = position.boolArg(1);
                        newString = this.execSubOrGSub(position, 2);
                        this.assign(offset, newString, is_global, position);
                        this.pop();
                        position.next();
                        continue block163;
                    }
                    case 310: {
                        offset = position.intArg(0);
                        is_global = position.boolArg(1);
                        arr_idx = this.pop();
                        newString = this.execSubOrGSub(position, 2);
                        this.assignArray(offset, arr_idx, newString, is_global);
                        this.pop();
                        position.next();
                        continue block163;
                    }
                    case 311: {
                        convfmt = this.getCONVFMT().toString();
                        numargs = position.intArg(0);
                        if (numargs == 2L) {
                            fs_string = JRT.toAwkString(this.getFS(), convfmt, this.locale);
                        } else {
                            if (numargs != 3L) throw new Error("Invalid # of args. split() requires 2 or 3. Got: " + numargs);
                            fs_string = JRT.toAwkString(this.pop(), convfmt, this.locale);
                        }
                        o = this.pop();
                        if (!(o instanceof AssocArray)) {
                            throw new AwkRuntimeException(position.lineNumber(), o + " is not an array.");
                        }
                        s = JRT.toAwkString(this.pop(), convfmt, this.locale);
                        tokenizer = fs_string.equals(" ") != false ? new StringTokenizer(s) : (fs_string.length() == 1 ? new SingleCharacterTokenizer(s, fs_string.charAt(0)) : (fs_string.isEmpty() != false ? new CharacterTokenizer(s) : new RegexTokenizer(s, fs_string)));
                        assoc_array = (AssocArray)o;
                        assoc_array.clear();
                        cnt = 0;
                        while (tokenizer.hasMoreElements()) {
                            assoc_array.put(++cnt, tokenizer.nextElement());
                        }
                        this.push(cnt);
                        position.next();
                        continue block163;
                    }
                    case 312: {
                        numargs = position.intArg(0);
                        if (numargs == 3L) {
                            length = (int)JRT.toLong(this.pop());
                            startPos = (int)JRT.toDouble(this.pop());
                            s = JRT.toAwkString(this.pop(), this.getCONVFMT().toString(), this.locale);
                        } else {
                            if (numargs != 2L) throw new Error("numargs for _SUBSTR_ must be 2 or 3. It is " + numargs);
                            startPos = (int)JRT.toDouble(this.pop());
                            s = JRT.toAwkString(this.pop(), this.getCONVFMT().toString(), this.locale);
                            length = s.length() - startPos + 1;
                        }
                        if (startPos <= 0) {
                            startPos = 1;
                        }
                        if (length <= 0 || startPos > s.length()) {
                            this.push(AVM.BLANK);
                        } else if (startPos + length > s.length()) {
                            this.push(s.substring(startPos - 1));
                        } else {
                            this.push(s.substring(startPos - 1, startPos + length - 1));
                        }
                        position.next();
                        continue block163;
                    }
                    case 313: {
                        this.push(JRT.toAwkString(this.pop(), this.getCONVFMT().toString(), this.locale).toLowerCase());
                        position.next();
                        continue block163;
                    }
                    case 314: {
                        this.push(JRT.toAwkString(this.pop(), this.getCONVFMT().toString(), this.locale).toUpperCase());
                        position.next();
                        continue block163;
                    }
                    case 315: {
                        s = JRT.toAwkString(this.pop(), this.getCONVFMT().toString(), this.locale);
                        this.push(JRT.jrtSystem(s));
                        position.next();
                        continue block163;
                    }
                    case 316: {
                        this.swapOnStack();
                        position.next();
                        continue block163;
                    }
                    case 332: {
                        o2 = this.pop();
                        o1 = this.pop();
                        this.push(JRT.compare2(o1, o2, 0) != false ? AVM.ONE : AVM.ZERO);
                        position.next();
                        continue block163;
                    }
                    case 333: {
                        o2 = this.pop();
                        o1 = this.pop();
                        this.push(JRT.compare2(o1, o2, -1) != false ? AVM.ONE : AVM.ZERO);
                        position.next();
                        continue block163;
                    }
                    case 334: {
                        o2 = this.pop();
                        o1 = this.pop();
                        this.push(JRT.compare2(o1, o2, 1) != false ? AVM.ONE : AVM.ZERO);
                        position.next();
                        continue block163;
                    }
                    case 335: {
                        o2 = this.pop();
                        o1 = this.pop();
                        s = o1.toString();
                        if (o2 instanceof Pattern) {
                            p = (Pattern)o2;
                            m = p.matcher(s);
                            result = m.find();
                            this.push(result != false ? 1 : 0);
                        } else {
                            r = JRT.toAwkString(o2, this.getCONVFMT().toString(), this.locale);
                            result = Pattern.compile(r).matcher(s).find();
                            this.push(result != false ? 1 : 0);
                        }
                        position.next();
                        continue block163;
                    }
                    case 336: {
                        numargs = position.intArg(0);
                        seconds = numargs == 0L ? 1L : (long)JRT.toDouble(this.pop());
                        try {
                            Thread.sleep(seconds * 1000L);
                        }
                        catch (InterruptedException ie) {
                            throw new AwkRuntimeException(position.lineNumber(), "Caught exception while waiting for process exit: " + ie);
                        }
                        position.next();
                        continue block163;
                    }
                    case 337: {
                        numargs = position.intArg(0);
                        if (numargs == 0L) {
                            aa_array = null;
                        } else {
                            aa_array = new AssocArray[(int)numargs];
                            i = 0;
                            while ((long)i < numargs) {
                                aa_array[i] = (AssocArray)this.pop();
                                ++i;
                            }
                        }
                        this.avmDump(aa_array);
                        position.next();
                        continue block163;
                    }
                    case 317: {
                        o2 = this.pop();
                        o1 = this.pop();
                        d1 = JRT.toDouble(o1);
                        d2 = JRT.toDouble(o2);
                        ans = d1 + d2;
                        if (ans == (double)((long)ans)) {
                            this.push((long)ans);
                        } else {
                            this.push(ans);
                        }
                        position.next();
                        continue block163;
                    }
                    case 318: {
                        o2 = this.pop();
                        o1 = this.pop();
                        d1 = JRT.toDouble(o1);
                        d2 = JRT.toDouble(o2);
                        ans = d1 - d2;
                        if (ans == (double)((long)ans)) {
                            this.push((long)ans);
                        } else {
                            this.push(ans);
                        }
                        position.next();
                        continue block163;
                    }
                    case 319: {
                        o2 = this.pop();
                        o1 = this.pop();
                        d1 = JRT.toDouble(o1);
                        d2 = JRT.toDouble(o2);
                        ans = d1 * d2;
                        if (ans == (double)((long)ans)) {
                            this.push((long)ans);
                        } else {
                            this.push(ans);
                        }
                        position.next();
                        continue block163;
                    }
                    case 320: {
                        o2 = this.pop();
                        o1 = this.pop();
                        d1 = JRT.toDouble(o1);
                        d2 = JRT.toDouble(o2);
                        ans = d1 / d2;
                        if (ans == (double)((long)ans)) {
                            this.push((long)ans);
                        } else {
                            this.push(ans);
                        }
                        position.next();
                        continue block163;
                    }
                    case 321: {
                        o2 = this.pop();
                        o1 = this.pop();
                        d1 = JRT.toDouble(o1);
                        d2 = JRT.toDouble(o2);
                        ans = d1 % d2;
                        if (ans == (double)((long)ans)) {
                            this.push((long)ans);
                        } else {
                            this.push(ans);
                        }
                        position.next();
                        continue block163;
                    }
                    case 322: {
                        o2 = this.pop();
                        o1 = this.pop();
                        d1 = JRT.toDouble(o1);
                        d2 = JRT.toDouble(o2);
                        ans = Math.pow(d1, d2);
                        if (ans == (double)((long)ans)) {
                            this.push((long)ans);
                        } else {
                            this.push(ans);
                        }
                        position.next();
                        continue block163;
                    }
                    case 329: {
                        o = this.pop();
                        this.push(o);
                        this.push(o);
                        position.next();
                        continue block163;
                    }
                    case 339: {
                        o = this.pop();
                        if (!AVM.$assertionsDisabled && o == null) {
                            throw new AssertionError();
                        }
                        if (!(o instanceof AssocArray)) {
                            throw new AwkRuntimeException(position.lineNumber(), "Cannot get a keylist (via 'in') of a non associative array. arg = " + o.getClass() + ", " + o);
                        }
                        aa = (AssocArray)o;
                        this.push(new KeyListImpl(aa.keySet()));
                        position.next();
                        continue block163;
                    }
                    case 340: {
                        o = this.pop();
                        if (o == null) throw new AwkRuntimeException(position.lineNumber(), "Cannot get a keylist (via 'in') of a non associative array. arg = " + o.getClass() + ", " + o);
                        if (!(o instanceof KeyList)) {
                            throw new AwkRuntimeException(position.lineNumber(), "Cannot get a keylist (via 'in') of a non associative array. arg = " + o.getClass() + ", " + o);
                        }
                        keylist = (KeyList)o;
                        if (keylist.size() == 0) {
                            position.jump(position.addressArg());
                            continue block163;
                        }
                        position.next();
                        continue block163;
                    }
                    case 341: {
                        o = this.pop();
                        if (o == null) throw new AwkRuntimeException(position.lineNumber(), "Cannot get a keylist (via 'in') of a non associative array. arg = " + o.getClass() + ", " + o);
                        if (!(o instanceof KeyList)) {
                            throw new AwkRuntimeException(position.lineNumber(), "Cannot get a keylist (via 'in') of a non associative array. arg = " + o.getClass() + ", " + o);
                        }
                        keylist = (KeyList)o;
                        if (!AVM.$assertionsDisabled && keylist.size() <= 0) {
                            throw new AssertionError();
                        }
                        this.push(keylist.getFirstAndRemove());
                        position.next();
                        continue block163;
                    }
                    case 342: {
                        o = this.pop();
                        if (!position.classArg().isInstance(o)) {
                            throw new AwkRuntimeException(position.lineNumber(), "Verification failed. Top-of-stack = " + o.getClass() + " isn't an instance of " + position.classArg());
                        }
                        this.push(o);
                        position.next();
                        continue block163;
                    }
                    case 344: {
                        if (this.avmConsumeInput(false)) {
                            position.next();
                            continue block163;
                        }
                        position.jump(position.addressArg());
                        continue block163;
                    }
                    case 345: {
                        this.avmConsumeInputForGetline();
                        position.next();
                        continue block163;
                    }
                    case 346: {
                        s = JRT.toAwkString(this.pop(), this.getCONVFMT().toString(), this.locale);
                        this.avmConsumeFileInputForGetline(s);
                        position.next();
                        continue block163;
                    }
                    case 347: {
                        s = JRT.toAwkString(this.pop(), this.getCONVFMT().toString(), this.locale);
                        this.avmConsumeCommandInputForGetline(s);
                        position.next();
                        continue block163;
                    }
                    case 348: {
                        this.nf_offset = position.intArg(0);
                        if (!AVM.$assertionsDisabled && this.nf_offset == -1L) {
                            throw new AssertionError();
                        }
                        this.assign(this.nf_offset, 0, true, position);
                        this.pop();
                        position.next();
                        continue block163;
                    }
                    case 349: {
                        this.nr_offset = position.intArg(0);
                        if (!AVM.$assertionsDisabled && this.nr_offset == -1L) {
                            throw new AssertionError();
                        }
                        this.assign(this.nr_offset, 0, true, position);
                        this.pop();
                        position.next();
                        continue block163;
                    }
                    case 350: {
                        this.fnr_offset = position.intArg(0);
                        if (!AVM.$assertionsDisabled && this.fnr_offset == -1L) {
                            throw new AssertionError();
                        }
                        this.assign(this.fnr_offset, 0, true, position);
                        this.pop();
                        position.next();
                        continue block163;
                    }
                    case 351: {
                        this.fs_offset = position.intArg(0);
                        if (!AVM.$assertionsDisabled && this.fs_offset == -1L) {
                            throw new AssertionError();
                        }
                        if (this.initial_fs_value == null) {
                            this.assign(this.fs_offset, " ", true, position);
                        } else {
                            this.assign(this.fs_offset, this.initial_fs_value, true, position);
                        }
                        this.pop();
                        position.next();
                        continue block163;
                    }
                    case 352: {
                        this.rs_offset = position.intArg(0);
                        if (!AVM.$assertionsDisabled && this.rs_offset == -1L) {
                            throw new AssertionError();
                        }
                        this.assign(this.rs_offset, this.settings.getDefaultRS(), true, position);
                        this.pop();
                        position.next();
                        continue block163;
                    }
                    case 353: {
                        this.ofs_offset = position.intArg(0);
                        if (!AVM.$assertionsDisabled && this.ofs_offset == -1L) {
                            throw new AssertionError();
                        }
                        this.assign(this.ofs_offset, " ", true, position);
                        this.pop();
                        position.next();
                        continue block163;
                    }
                    case 387: {
                        this.ors_offset = position.intArg(0);
                        if (!AVM.$assertionsDisabled && this.ors_offset == -1L) {
                            throw new AssertionError();
                        }
                        this.assign(this.ors_offset, this.settings.getDefaultORS(), true, position);
                        this.pop();
                        position.next();
                        continue block163;
                    }
                    case 354: {
                        this.rstart_offset = position.intArg(0);
                        if (!AVM.$assertionsDisabled && this.rstart_offset == -1L) {
                            throw new AssertionError();
                        }
                        this.assign(this.rstart_offset, "", true, position);
                        this.pop();
                        position.next();
                        continue block163;
                    }
                    case 355: {
                        this.rlength_offset = position.intArg(0);
                        if (!AVM.$assertionsDisabled && this.rlength_offset == -1L) {
                            throw new AssertionError();
                        }
                        this.assign(this.rlength_offset, "", true, position);
                        this.pop();
                        position.next();
                        continue block163;
                    }
                    case 356: {
                        this.filename_offset = position.intArg(0);
                        if (!AVM.$assertionsDisabled && this.filename_offset == -1L) {
                            throw new AssertionError();
                        }
                        this.assign(this.filename_offset, "", true, position);
                        this.pop();
                        position.next();
                        continue block163;
                    }
                    case 357: {
                        this.subsep_offset = position.intArg(0);
                        if (!AVM.$assertionsDisabled && this.subsep_offset == -1L) {
                            throw new AssertionError();
                        }
                        this.assign(this.subsep_offset, new String(new byte[]{28}), true, position);
                        this.pop();
                        position.next();
                        continue block163;
                    }
                    case 358: {
                        this.convfmt_offset = position.intArg(0);
                        if (!AVM.$assertionsDisabled && this.convfmt_offset == -1L) {
                            throw new AssertionError();
                        }
                        this.assign(this.convfmt_offset, "%.6g", true, position);
                        this.pop();
                        position.next();
                        continue block163;
                    }
                    case 359: {
                        this.ofmt_offset = position.intArg(0);
                        if (!AVM.$assertionsDisabled && this.ofmt_offset == -1L) {
                            throw new AssertionError();
                        }
                        this.assign(this.ofmt_offset, "%.6g", true, position);
                        this.pop();
                        position.next();
                        continue block163;
                    }
                    case 360: {
                        this.environ_offset = position.intArg(0);
                        if (!AVM.$assertionsDisabled && this.environ_offset == -1L) {
                            throw new AssertionError();
                        }
                        env = System.getenv();
                        for (Map.Entry<String, String> var : env.entrySet()) {
                            this.assignArray(this.environ_offset, var.getKey(), var.getValue(), true);
                            this.pop();
                        }
                        position.next();
                        continue block163;
                    }
                    case 361: {
                        this.argc_offset = position.intArg(0);
                        if (!AVM.$assertionsDisabled && this.argc_offset == -1L) {
                            throw new AssertionError();
                        }
                        this.assign(this.argc_offset, this.arguments.size() + 1, true, position);
                        this.pop();
                        position.next();
                        continue block163;
                    }
                    case 362: {
                        this.argv_offset = position.intArg(0);
                        if (!AVM.$assertionsDisabled && this.argv_offset == -1L) {
                            throw new AssertionError();
                        }
                        argc = (int)JRT.toDouble(this.runtime_stack.getVariable(this.argc_offset, true));
                        this.assignArray(this.argv_offset, 0, "java Awk", true);
                        this.pop();
                        for (i = 1; i < argc; ++i) {
                            this.assignArray(this.argv_offset, i, this.arguments.get(i - 1), true);
                            this.pop();
                        }
                        position.next();
                        continue block163;
                    }
                    case 343: {
                        fieldnum = AVM.parseIntField(this.pop(), position);
                        this.push(this.jrt.jrtGetInputField(fieldnum));
                        position.next();
                        continue block163;
                    }
                    case 363: {
                        if (!AVM.$assertionsDisabled && this.rs_offset == -1L) {
                            throw new AssertionError();
                        }
                        rs_obj = this.runtime_stack.getVariable(this.rs_offset, true);
                        if (this.jrt.getPartitioningReader() != null) {
                            this.jrt.getPartitioningReader().setRecordSeparator(rs_obj.toString());
                        }
                        position.next();
                        continue block163;
                    }
                    case 364: {
                        func_addr = position.addressArg();
                        num_formal_params = position.intArg(2);
                        num_actual_params = position.intArg(3);
                        if (!AVM.$assertionsDisabled && num_formal_params < num_actual_params) {
                            throw new AssertionError();
                        }
                        this.runtime_stack.pushFrame(num_formal_params, position.current());
                        for (i = num_actual_params - 1L; i >= 0L; --i) {
                            this.runtime_stack.setVariable(i, this.pop(), false);
                        }
                        position.jump(func_addr);
                        continue block163;
                    }
                    case 365: {
                        position.next();
                        continue block163;
                    }
                    case 366: {
                        this.runtime_stack.setReturnValue(this.pop());
                        position.next();
                        continue block163;
                    }
                    case 367: {
                        position.jump(this.runtime_stack.popFrame());
                        this.push(this.runtime_stack.getReturnValue());
                        position.next();
                        continue block163;
                    }
                    case 368: {
                        if (!AVM.$assertionsDisabled && position.intArg(0) != (long)this.global_variable_offsets.size()) {
                            throw new AssertionError();
                        }
                        this.runtime_stack.setNumGlobals(position.intArg(0));
                        for (String key : this.initial_variables.keySet()) {
                            if (this.function_names.contains(key)) {
                                throw new IllegalArgumentException("Cannot assign a scalar to a function name (" + key + ").");
                            }
                            offset_obj = this.global_variable_offsets.get(key);
                            array_obj = this.global_variable_arrays.get(key);
                            if (offset_obj == null) continue;
                            if (!AVM.$assertionsDisabled && array_obj == null) {
                                throw new AssertionError();
                            }
                            if (array_obj.booleanValue()) {
                                throw new IllegalArgumentException("Cannot assign a scalar to a non-scalar variable (" + key + ").");
                            }
                            obj = this.initial_variables.get(key);
                            this.runtime_stack.setFilelistVariable(offset_obj, obj);
                        }
                        position.next();
                        continue block163;
                    }
                    case 369: {
                        s = JRT.toAwkString(this.pop(), this.getCONVFMT().toString(), this.locale);
                        this.push(this.jrt.jrtClose(s));
                        position.next();
                        continue block163;
                    }
                    case 370: {
                        count = position.intArg(0);
                        if (!AVM.$assertionsDisabled && count < 1L) {
                            throw new AssertionError();
                        }
                        convfmt = this.getCONVFMT().toString();
                        if (count != 1L) {
                            sb = new StringBuilder();
                            sb.append(JRT.toAwkString(this.pop(), convfmt, this.locale));
                            subsep = JRT.toAwkString(this.runtime_stack.getVariable(this.subsep_offset, true), convfmt, this.locale);
                            i = 1;
                            while ((long)i < count) {
                                sb.insert(0, subsep);
                                sb.insert(0, JRT.toAwkString(this.pop(), convfmt, this.locale));
                                ++i;
                            }
                            this.push(sb.toString());
                        }
                        position.next();
                        continue block163;
                    }
                    case 371: {
                        offset = position.intArg(0);
                        is_global = position.boolArg(1);
                        aa = (AssocArray)this.runtime_stack.getVariable(offset, is_global);
                        key = this.pop();
                        if (aa != null) {
                            aa.remove(key);
                        }
                        position.next();
                        continue block163;
                    }
                    case 384: {
                        offset = position.intArg(0);
                        is_global = position.boolArg(1);
                        this.runtime_stack.removeVariable(offset, is_global);
                        position.next();
                        continue block163;
                    }
                    case 372: {
                        this.exit_address = position.addressArg();
                        position.next();
                        continue block163;
                    }
                    case 373: {
                        this.within_end_blocks = position.boolArg(0);
                        position.next();
                        continue block163;
                    }
                    case 374: 
                    case 386: {
                        if (opcode == 374) {
                            this.exit_code = (int)JRT.toDouble(this.pop());
                        }
                        this.throw_exit_exception = true;
                        if (this.within_end_blocks) {
                            this.jrt.jrtCloseAll();
                            this.operand_stack.clear();
                            throw new ExitException(this.exit_code, "The AWK script requested an exit");
                        }
                        this.runtime_stack.popAllFrames();
                        this.operand_stack.clear();
                        position.jump(this.exit_address);
                        continue block163;
                    }
                    case 375: {
                        key = JRT.toAwkString(position.arg(0), this.getCONVFMT().toString(), this.locale);
                        pattern = (Pattern)regexps.get(key);
                        if (pattern == null) {
                            pattern = Pattern.compile(key);
                            regexps.put(key, pattern);
                        }
                        this.push(pattern);
                        position.next();
                        continue block163;
                    }
                    case 376: {
                        cp = (ConditionPair)condition_pairs.get(position.current());
                        if (cp == null) {
                            cp = new ConditionPair();
                            condition_pairs.put(position.current(), cp);
                        }
                        end = this.jrt.toBoolean(this.pop());
                        start = this.jrt.toBoolean(this.pop());
                        this.push(cp.update(start, end) != false ? AVM.ONE : AVM.ZERO);
                        position.next();
                        continue block163;
                    }
                    case 377: {
                        arr = this.pop();
                        arg = this.pop();
                        aa = (AssocArray)arr;
                        result = aa.isIn(arg);
                        this.push(result != false ? AVM.ONE : AVM.ZERO);
                        position.next();
                        continue block163;
                    }
                    case 379: {
                        this.push(JRT.toDouble(this.pop()));
                        position.next();
                        continue block163;
                    }
                    case 380: {
                        this.push(this.pop().toString());
                        position.next();
                        continue block163;
                    }
                    case 381: {
                        position.next();
                        continue block163;
                    }
                    case 383: {
                        awk_code = JRT.toAwkString(this.pop(), this.getCONVFMT().toString(), this.locale);
                        scriptSources = new ArrayList<ScriptSource>(1);
                        scriptSources.add(new ScriptSource("<command-line-supplied-script>", new StringReader(awk_code), false));
                        ap = new AwkParser(this.settings.isAdditionalFunctions(), this.settings.isAdditionalTypeFunctions(), this.extensions);
                        try {
                            ast = ap.parse(scriptSources);
                            if (ast == null) ** GOTO lbl1146
                            ast.semanticAnalysis();
                            ast.semanticAnalysis();
                            new_tuples = new AwkTuples();
                            result = ast.populateTuples(new_tuples);
                            if (!AVM.$assertionsDisabled && result != 0) {
                                throw new AssertionError();
                            }
                            new_tuples.postProcess();
                            ap.populateGlobalVariableNameToOffsetMappings(new_tuples);
                            new_avm = new AVM(this.settings, this.extensions);
                            subScriptExitCode = 0;
                            try {
                                new_avm.interpret(new_tuples);
                            }
                            catch (ExitException ex) {
                                subScriptExitCode = ex.getCode();
                            }
                            this.push(subScriptExitCode);
                            ** GOTO lbl1150
lbl1146:
                            // 1 sources

                            this.push(-1);
                        }
                        catch (IOException ioe) {
                            throw new AwkRuntimeException(position.lineNumber(), "IO Exception caught : " + ioe);
                        }
lbl1150:
                        // 2 sources

                        position.next();
                        continue block163;
                    }
                    case 382: {
                        extension_keyword = position.arg(0).toString();
                        num_args = position.intArg(1);
                        is_initial = position.boolArg(2);
                        extension = this.extensions.get(extension_keyword);
                        if (extension == null) {
                            throw new AwkRuntimeException("Extension for '" + extension_keyword + "' not found.");
                        }
                        args = new Object[(int)num_args];
                        for (i = (int)num_args - 1; i >= 0; --i) {
                            args[i] = this.pop();
                        }
                        retval = extension.invoke(extension_keyword, args);
                        if (is_initial && retval != null && retval instanceof BlockObject) {
                            retval = new BlockManager().block((BlockObject)retval);
                        }
                        if (retval == null) {
                            retval = "";
                        } else if (!(retval instanceof Integer || retval instanceof Long || retval instanceof Double || retval instanceof String || retval instanceof AssocArray || retval instanceof BlockObject)) {
                            retval = retval.toString();
                        }
                        this.push(retval);
                        position.next();
                        continue block163;
                    }
                }
                throw new Error("invalid opcode: " + AwkTuples.toOpcodeString(position.opcode()));
            }
            this.jrt.jrtCloseAll();
        }
        catch (RuntimeException re) {
            AVM.LOG.error("", re);
            AVM.LOG.error("operand_stack = {}", (Object)this.operand_stack);
            AVM.LOG.error("position = {}", (Object)position);
            AVM.LOG.error("line number = {}", (Object)position.lineNumber());
            this.runtime_stack.popAllFrames();
            this.operand_stack.clear();
            throw re;
        }
        catch (AssertionError ae) {
            AVM.LOG.error("", (Throwable)ae);
            AVM.LOG.error("operand_stack = {}", (Object)this.operand_stack);
            try {
                AVM.LOG.error("position = {}", (Object)position);
            }
            catch (Throwable t) {
                AVM.LOG.error("{ could not report on position", t);
            }
            try {
                AVM.LOG.error("line number = {}", (Object)position.lineNumber());
                throw ae;
            }
            catch (Throwable t) {
                AVM.LOG.error("{ could not report on line number", t);
            }
            throw ae;
        }
        if (this.throw_exit_exception == false) return;
        throw new ExitException(this.exit_code, "The AWK script requested an exit");
    }

    public void waitForIO() {
        this.jrt.jrtCloseAll();
    }

    private void avmDump(AssocArray[] aa_array) {
        if (aa_array == null) {
            Object[] globals = this.runtime_stack.getNumGlobals();
            for (String name : this.global_variable_offsets.keySet()) {
                int idx = this.global_variable_offsets.get(name);
                Object value = globals[idx];
                if (value instanceof AssocArray) {
                    AssocArray aa = (AssocArray)value;
                    value = aa.mapString();
                }
                LOG.info("{} = {}", (Object)name, value);
            }
        } else {
            for (AssocArray aa : aa_array) {
                LOG.info(aa.mapString());
            }
        }
    }

    private void printTo(PrintStream ps, long num_args) {
        if (num_args == 0L) {
            ps.print(this.jrt.jrtGetInputField(0));
            ps.print(this.getORS().toString());
        } else {
            int i;
            String ofs_string = this.getOFS().toString();
            Object[] args2 = new Object[(int)num_args];
            for (i = (int)num_args - 1; i >= 0; --i) {
                args2[i] = this.pop();
            }
            i = 0;
            while ((long)i < num_args) {
                ps.print(JRT.toAwkStringForOutput(args2[i], this.getOFMT().toString(), this.locale));
                if ((long)i < num_args - 1L) {
                    ps.print(ofs_string);
                }
                ++i;
            }
            ps.print(this.getORS().toString());
        }
        if (IS_WINDOWS) {
            ps.flush();
        }
    }

    private void printfTo(PrintStream ps, long num_args) {
        ps.print(this.sprintfFunction(num_args));
        if (IS_WINDOWS) {
            ps.flush();
        }
    }

    private String sprintfFunction(long num_args) {
        if (num_args == 0L) {
            return "";
        }
        Object[] arg_array = new Object[(int)(num_args - 1L)];
        for (int i = (int)num_args - 2; i >= 0; --i) {
            arg_array[i] = this.pop();
        }
        String fmt = JRT.toAwkString(this.pop(), this.getCONVFMT().toString(), this.locale);
        if (this.trap_illegal_format_exceptions) {
            return Printf4J.sprintf(this.locale, fmt, arg_array);
        }
        return JRT.sprintfNoCatch(this.locale, fmt, arg_array);
    }

    private String replaceFirst(String orig, String ere, String repl) {
        this.replace_first_sb.setLength(0);
        this.push(JRT.replaceFirst(orig, repl, ere, this.replace_first_sb, this.getCONVFMT().toString(), this.locale));
        return this.replace_first_sb.toString();
    }

    private String replaceAll(String orig, String ere, String repl) {
        this.replace_all_sb.setLength(0);
        this.push(JRT.replaceAll(orig, repl, ere, this.replace_all_sb, this.getCONVFMT().toString(), this.locale));
        return this.replace_all_sb.toString();
    }

    private void assign(long l, Object value, boolean is_global, Position position) {
        if (this.runtime_stack.getVariable(l, is_global) instanceof AssocArray) {
            throw new AwkRuntimeException(position.lineNumber(), "cannot assign anything to an unindexed associative array");
        }
        this.push(value);
        this.runtime_stack.setVariable(l, value, is_global);
    }

    private void assignArray(long offset, Object arr_idx, Object rhs, boolean is_global) {
        Object o1 = this.runtime_stack.getVariable(offset, is_global);
        if (o1 == null || o1.equals(BLANK)) {
            o1 = new AssocArray(this.sorted_array_keys);
            this.runtime_stack.setVariable(offset, o1, is_global);
        }
        assert (o1 != null);
        assert (o1 instanceof AssocArray);
        AssocArray array = (AssocArray)o1;
        array.put(arr_idx, rhs);
        this.push(rhs);
    }

    private Object inc(long l, boolean is_global) {
        Object o = this.runtime_stack.getVariable(l, is_global);
        if (o == null || o instanceof UninitializedObject) {
            o = ZERO;
            this.runtime_stack.setVariable(l, o, is_global);
        }
        this.runtime_stack.setVariable(l, JRT.inc(o), is_global);
        return o;
    }

    private Object dec(long l, boolean is_global) {
        Object o = this.runtime_stack.getVariable(l, is_global);
        if (o == null) {
            o = ZERO;
            this.runtime_stack.setVariable(l, o, is_global);
        }
        this.runtime_stack.setVariable(l, JRT.dec(o), is_global);
        return o;
    }

    @Override
    public final Object getRS() {
        assert (this.rs_offset != -1L);
        Object rs_obj = this.runtime_stack.getVariable(this.rs_offset, true);
        return rs_obj;
    }

    @Override
    public final Object getOFS() {
        assert (this.ofs_offset != -1L);
        Object ofs_obj = this.runtime_stack.getVariable(this.ofs_offset, true);
        return ofs_obj;
    }

    @Override
    public final Object getORS() {
        return this.runtime_stack.getVariable(this.ors_offset, true);
    }

    @Override
    public final Object getSUBSEP() {
        assert (this.subsep_offset != -1L);
        Object subsep_obj = this.runtime_stack.getVariable(this.subsep_offset, true);
        return subsep_obj;
    }

    private void setFilelistVariable(String name_value) {
        Object obj;
        int eq_idx = name_value.indexOf(61);
        assert (eq_idx >= 0);
        if (eq_idx == 0) {
            throw new IllegalArgumentException("Must have a non-blank variable name in a name=value variable assignment argument.");
        }
        String name = name_value.substring(0, eq_idx);
        String value = name_value.substring(eq_idx + 1);
        try {
            obj = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            try {
                obj = Double.parseDouble(value);
            }
            catch (NumberFormatException nfe2) {
                obj = value;
            }
        }
        if (this.function_names.contains(name)) {
            throw new IllegalArgumentException("Cannot assign a scalar to a function name (" + name + ").");
        }
        Integer offset_obj = this.global_variable_offsets.get(name);
        Boolean array_obj = this.global_variable_arrays.get(name);
        if (offset_obj != null) {
            assert (array_obj != null);
            if (array_obj.booleanValue()) {
                throw new IllegalArgumentException("Cannot assign a scalar to a non-scalar variable (" + name + ").");
            }
            this.runtime_stack.setFilelistVariable(offset_obj, obj);
        }
    }

    @Override
    public final void assignVariable(String name, Object obj) {
        if (this.function_names.contains(name)) {
            throw new IllegalArgumentException("Cannot assign a scalar to a function name (" + name + ").");
        }
        Integer offset_obj = this.global_variable_offsets.get(name);
        Boolean array_obj = this.global_variable_arrays.get(name);
        if (offset_obj != null) {
            assert (array_obj != null);
            if (array_obj.booleanValue()) {
                throw new IllegalArgumentException("Cannot assign a scalar to a non-scalar variable (" + name + ").");
            }
            this.runtime_stack.setFilelistVariable(offset_obj, obj);
        }
    }

    private void swapOnStack() {
        Object o1 = this.pop();
        Object o2 = this.pop();
        this.push(o1);
        this.push(o2);
    }

    private void avmConsumeInputForGetline() throws IOException {
        if (this.avmConsumeInput(true)) {
            this.push(1);
        } else {
            this.push("");
            this.push(0);
        }
        this.swapOnStack();
    }

    private void avmConsumeFileInputForGetline(String filename) throws IOException {
        if (this.avmConsumeFileInput(filename)) {
            this.push(1);
        } else {
            this.push(0);
        }
        this.swapOnStack();
    }

    private void avmConsumeCommandInputForGetline(String cmd) throws IOException {
        if (this.avmConsumeCommandInput(cmd)) {
            this.push(1);
        } else {
            this.push(0);
        }
        this.swapOnStack();
    }

    private boolean avmConsumeFileInput(String filename) throws IOException {
        boolean retval = this.jrt.jrtConsumeFileInput(filename);
        if (retval) {
            this.push(this.jrt.getInputLine());
        } else {
            this.push("");
        }
        return retval;
    }

    private boolean avmConsumeCommandInput(String cmd) throws IOException {
        boolean retval = this.jrt.jrtConsumeCommandInput(cmd);
        if (retval) {
            this.push(this.jrt.getInputLine());
        } else {
            this.push("");
        }
        return retval;
    }

    private boolean avmConsumeInput(boolean for_getline) throws IOException {
        boolean retval = this.jrt.jrtConsumeInput(this.settings.getInput(), for_getline, this.locale);
        if (retval && for_getline) {
            this.push(this.jrt.getInputLine());
        }
        return retval;
    }

    @Override
    public Object getFS() {
        assert (this.fs_offset != -1L);
        Object fs_string = this.runtime_stack.getVariable(this.fs_offset, true);
        return fs_string;
    }

    @Override
    public Object getCONVFMT() {
        assert (this.convfmt_offset != -1L) : "convfmt_offset not defined";
        Object convfmt_string = this.runtime_stack.getVariable(this.convfmt_offset, true);
        return convfmt_string;
    }

    @Override
    public void resetFNR() {
        this.runtime_stack.setVariable(this.fnr_offset, ZERO, true);
    }

    @Override
    public void incFNR() {
        this.inc(this.fnr_offset, true);
    }

    @Override
    public void incNR() {
        this.inc(this.nr_offset, true);
    }

    @Override
    public void setNF(Integer I) {
        this.runtime_stack.setVariable(this.nf_offset, I, true);
    }

    @Override
    public void setFILENAME(String filename) {
        this.runtime_stack.setVariable(this.filename_offset, filename, true);
    }

    @Override
    public Object getARGV() {
        return this.runtime_stack.getVariable(this.argv_offset, true);
    }

    @Override
    public Object getARGC() {
        return this.runtime_stack.getVariable(this.argc_offset, true);
    }

    private String getOFMT() {
        assert (this.ofmt_offset != -1L);
        String ofmt_string = this.runtime_stack.getVariable(this.ofmt_offset, true).toString();
        return ofmt_string;
    }

    private static class RuntimeStack {
        private Object[] globals = null;
        private Object[] locals = null;
        private MyStack<Object[]> locals_stack = new ArrayStackImpl<Object[]>();
        private MyStack<Integer> return_indexes = new LinkedListStackImpl<Integer>();
        private Object return_value;

        private RuntimeStack() {
        }

        public void dump() {
            LOG.info("globals = " + Arrays.toString(this.globals));
            LOG.info("locals = " + Arrays.toString(this.locals));
            LOG.info("locals_stack = " + this.locals_stack);
            LOG.info("return_indexes = " + this.return_indexes);
        }

        Object[] getNumGlobals() {
            return this.globals;
        }

        void setNumGlobals(long l) {
            assert (l >= 0L);
            assert (this.globals == null);
            this.globals = new Object[(int)l];
            int i = 0;
            while ((long)i < l) {
                this.globals[i] = null;
                ++i;
            }
        }

        Object getVariable(long offset, boolean is_global) {
            assert (this.globals != null);
            assert (offset != -1L);
            if (is_global) {
                return this.globals[(int)offset];
            }
            return this.locals[(int)offset];
        }

        Object setVariable(long offset, Object val2, boolean is_global) {
            assert (this.globals != null);
            assert (offset != -1L);
            if (is_global) {
                Object object = val2;
                this.globals[(int)offset] = object;
                return object;
            }
            Object object = val2;
            this.locals[(int)offset] = object;
            return object;
        }

        void removeVariable(long offset, boolean is_global) {
            assert (this.globals != null);
            assert (offset != -1L);
            if (is_global) {
                assert (this.globals[(int)offset] == null || this.globals[(int)offset] instanceof AssocArray);
                this.globals[(int)offset] = null;
            } else {
                assert (this.locals[(int)offset] == null || this.locals[(int)offset] instanceof AssocArray);
                this.locals[(int)offset] = null;
            }
        }

        void setFilelistVariable(int offset, Object value) {
            assert (this.globals != null);
            assert (offset != -1);
            this.globals[offset] = value;
        }

        void pushFrame(long num_formal_params, int position_idx) {
            this.locals_stack.push(this.locals);
            this.locals = new Object[(int)num_formal_params];
            this.return_indexes.push(position_idx);
        }

        int popFrame() {
            this.locals = this.locals_stack.pop();
            return this.return_indexes.pop();
        }

        void popAllFrames() {
            int sz = this.locals_stack.size();
            while (--sz >= 0) {
                this.locals = this.locals_stack.pop();
                this.return_indexes.pop();
            }
        }

        void setReturnValue(Object obj) {
            assert (this.return_value == null);
            this.return_value = obj;
        }

        Object getReturnValue() {
            Object retval = this.return_value == null ? BLANK : this.return_value;
            this.return_value = null;
            return retval;
        }
    }
}

