/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.jawk.ext;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sentrysoftware.jawk.NotImplementedError;
import org.sentrysoftware.jawk.ext.AbstractExtension;
import org.sentrysoftware.jawk.ext.JawkExtension;
import org.sentrysoftware.jawk.jrt.AssocArray;
import org.sentrysoftware.jawk.jrt.AwkRuntimeException;
import org.sentrysoftware.jawk.jrt.BlockObject;
import org.sentrysoftware.jawk.jrt.IllegalAwkArgumentException;
import org.sentrysoftware.jawk.jrt.JRT;
import org.sentrysoftware.jawk.jrt.VariableManager;
import org.sentrysoftware.jawk.util.AwkLogger;
import org.slf4j.Logger;

public class CoreExtension
extends AbstractExtension
implements JawkExtension {
    private static CoreExtension instance = null;
    private static final Object INSTANCE_LOCK = new Object();
    private static final Logger LOG = AwkLogger.getLogger(CoreExtension.class);
    private int refMapIdx = 0;
    private Map<String, Object> referenceMap = new HashMap<String, Object>();
    private Map<AssocArray, Iterator<?>> iterators = new HashMap();
    private static final Integer ZERO = 0;
    private static final Integer ONE = 1;
    private int waitInt = 0;
    private final Date dateObj = new Date();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat();
    private final BlockObject timeoutBlocker = new BlockObject(){

        @Override
        public String getNotifierTag() {
            return "Timeout";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void block() throws InterruptedException {
            BlockObject blockObject = CoreExtension.this.timeoutBlocker;
            synchronized (blockObject) {
                CoreExtension.this.timeoutBlocker.wait(CoreExtension.this.waitInt);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreExtension() {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = this;
            } else {
                LOG.warn("Multiple CoreExtension instances in this VM. Using original instance.");
            }
        }
    }

    @Override
    public String getExtensionName() {
        return "Core Extension";
    }

    @Override
    public String[] extensionKeywords() {
        return new String[]{"Array", "Map", "HashMap", "TreeMap", "LinkedMap", "MapUnion", "MapCopy", "TypeOf", "String", "Double", "Halt", "Dereference", "DeRef", "NewReference", "NewRef", "Unreference", "UnRef", "InRef", "IsInRef", "DumpRefs", "Timeout", "Throw", "Version", "Date", "FileExists"};
    }

    @Override
    public int[] getAssocArrayParameterPositions(String extensionKeyword, int numArgs) {
        if ((extensionKeyword.equals("Map") || extensionKeyword.equals("HashMap") || extensionKeyword.equals("LinkedMap") || extensionKeyword.equals("TreeMap")) && numArgs % 2 == 1) {
            return new int[]{0};
        }
        if (extensionKeyword.equals("Array")) {
            return new int[]{0};
        }
        if (extensionKeyword.equals("NewReference") || extensionKeyword.equals("NewRef")) {
            if (numArgs == 1) {
                return new int[]{0};
            }
            return super.getAssocArrayParameterPositions(extensionKeyword, numArgs);
        }
        return super.getAssocArrayParameterPositions(extensionKeyword, numArgs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(String keyword, Object[] args2) {
        if (keyword.equals("Map") || keyword.equals("HashMap")) {
            return this.map(args2, this.getVm(), 2);
        }
        if (keyword.equals("LinkedMap")) {
            return this.map(args2, this.getVm(), 4);
        }
        if (keyword.equals("TreeMap")) {
            return this.map(args2, this.getVm(), 8);
        }
        if (keyword.equals("MapUnion")) {
            return this.mapUnion(args2, this.getVm(), 4);
        }
        if (keyword.equals("MapCopy")) {
            CoreExtension.checkNumArgs(args2, 2);
            return this.mapCopy(args2);
        }
        if (keyword.equals("Array")) {
            return this.array(args2, this.getVm());
        }
        if (keyword.equals("TypeOf")) {
            CoreExtension.checkNumArgs(args2, 1);
            return CoreExtension.typeOf(args2[0], this.getVm());
        }
        if (keyword.equals("String")) {
            CoreExtension.checkNumArgs(args2, 1);
            return CoreExtension.toString(args2[0], this.getVm());
        }
        if (keyword.equals("Double")) {
            CoreExtension.checkNumArgs(args2, 1);
            return this.toDouble(args2[0], this.getVm());
        }
        if (keyword.equals("Halt")) {
            if (args2.length == 0) {
                Runtime.getRuntime().halt(0);
                return null;
            } else {
                if (args2.length != 1) throw new IllegalAwkArgumentException(keyword + " requires 0 or 1 argument, not " + args2.length);
                Runtime.getRuntime().halt((int)JRT.toDouble(args2[0]));
            }
            return null;
        } else {
            if (keyword.equals("NewReference") || keyword.equals("NewRef")) {
                if (args2.length == 1) {
                    return CoreExtension.newReference(args2[0]);
                }
                if (args2.length != 3) throw new IllegalAwkArgumentException(keyword + " requires 1 or 3 arguments, not " + args2.length);
                return CoreExtension.newReference(this.toAwkString(args2[0]), args2[1], args2[2]);
            }
            if (keyword.equals("Dereference") || keyword.equals("DeRef")) {
                if (args2.length == 1) {
                    return this.resolve(this.dereference(args2[0], this.getVm()), this.getVm());
                }
                if (args2.length != 2) throw new IllegalAwkArgumentException(keyword + " requires 1 or 2 arguments, not " + args2.length);
                return this.resolve(CoreExtension.dereference(this.toAwkString(args2[0]), args2[1], this.getVm()), this.getVm());
            }
            if (keyword.equals("Unreference") || keyword.equals("UnRef")) {
                CoreExtension.checkNumArgs(args2, 1);
                return CoreExtension.unreference(args2[0], this.getVm());
            }
            if (keyword.equals("InRef")) {
                CoreExtension.checkNumArgs(args2, 1);
                return this.inref(args2[0], this.getVm());
            }
            if (keyword.equals("IsInRef")) {
                CoreExtension.checkNumArgs(args2, 2);
                return this.isInRef(args2[0], args2[1], this.getVm());
            }
            if (keyword.equals("DumpRefs")) {
                CoreExtension.checkNumArgs(args2, 0);
                this.dumpRefs();
                return null;
            } else {
                if (keyword.equals("Timeout")) {
                    CoreExtension.checkNumArgs(args2, 1);
                    return this.timeout((int)JRT.toDouble(args2[0]));
                }
                if (keyword.equals("Throw")) {
                    throw new AwkRuntimeException(Arrays.toString(args2));
                }
                if (keyword.equals("Version")) {
                    CoreExtension.checkNumArgs(args2, 1);
                    return this.version(args2[0]);
                }
                if (keyword.equals("Date")) {
                    if (args2.length == 0) {
                        return this.date();
                    }
                    if (args2.length != 1) throw new IllegalAwkArgumentException(keyword + " expects 0 or 1 argument, not " + args2.length);
                    return this.date(this.toAwkString(args2[0]));
                }
                if (!keyword.equals("FileExists")) throw new NotImplementedError(keyword);
                CoreExtension.checkNumArgs(args2, 1);
                return this.fileExists(this.toAwkString(args2[0]));
            }
        }
    }

    private Object resolve(Object arg, VariableManager vm) {
        Object obj = arg;
        while (true) {
            if (obj instanceof AssocArray) {
                return obj;
            }
            String argCheck = this.toAwkString(obj);
            if (this.referenceMap.get(argCheck) == null) break;
            obj = this.referenceMap.get(argCheck);
        }
        return obj;
    }

    static String newReference(Object arg) {
        if (!(arg instanceof AssocArray)) {
            throw new IllegalAwkArgumentException("NewRef[erence] requires an assoc array, not " + arg.getClass().getName());
        }
        int refIdx = CoreExtension.instance.refMapIdx++;
        String argStr = arg instanceof AssocArray ? arg.getClass().getName() : arg.toString();
        if (argStr.length() > 63) {
            argStr = argStr.substring(0, 60) + "...";
        }
        String retval = "@REFERENCE@ " + refIdx + " <" + argStr + ">";
        CoreExtension.instance.referenceMap.put(retval, arg);
        return retval;
    }

    static Object newReference(String refstring, Object key, Object value) {
        AssocArray aa = (AssocArray)CoreExtension.instance.referenceMap.get(refstring);
        if (aa == null) {
            throw new IllegalAwkArgumentException("AssocArray reference doesn't exist.");
        }
        return aa.put(key, value);
    }

    private Object dereference(Object arg, VariableManager vm) {
        if (arg instanceof AssocArray) {
            throw new IllegalAwkArgumentException("an assoc array cannot be a reference handle");
        }
        String argCheck = this.toAwkString(arg);
        return CoreExtension.dereference(argCheck);
    }

    static Object dereference(String argCheck) {
        if (CoreExtension.instance.referenceMap.get(argCheck) != null) {
            return CoreExtension.instance.referenceMap.get(argCheck);
        }
        throw new IllegalAwkArgumentException(argCheck + " not a valid reference");
    }

    static Object dereference(String refstring, Object key, VariableManager vm) {
        String keyCheck;
        AssocArray aa = (AssocArray)CoreExtension.instance.referenceMap.get(refstring);
        if (aa == null) {
            throw new IllegalAwkArgumentException("AssocArray reference doesn't exist.");
        }
        if (!(key instanceof AssocArray) && CoreExtension.instance.referenceMap.get(keyCheck = instance.toAwkString(key)) != null) {
            key = CoreExtension.instance.referenceMap.get(keyCheck);
        }
        return aa.get(key);
    }

    static int unreference(Object arg, VariableManager vm) {
        String argCheck = instance.toAwkString(arg);
        if (CoreExtension.instance.referenceMap.get(argCheck) == null) {
            throw new IllegalAwkArgumentException("Not a reference : " + argCheck);
        }
        CoreExtension.instance.referenceMap.remove(argCheck);
        assert (CoreExtension.instance.referenceMap.get(argCheck) == null);
        return 1;
    }

    private Object inref(Object arg, VariableManager vm) {
        if (arg instanceof AssocArray) {
            throw new IllegalAwkArgumentException("InRef requires a Reference (string) argument, not an assoc array");
        }
        String argCheck = this.toAwkString(arg);
        if (this.referenceMap.get(argCheck) == null) {
            throw new IllegalAwkArgumentException("Not a reference : " + argCheck);
        }
        Object o = this.referenceMap.get(argCheck);
        if (!(o instanceof AssocArray)) {
            throw new IllegalAwkArgumentException("Reference not an assoc array. ref.class = " + o.getClass().getName());
        }
        AssocArray aa = (AssocArray)o;
        Iterator<Object> iter = this.iterators.get(aa);
        if (iter == null) {
            iter = new ArrayList<Object>(aa.keySet()).iterator();
            this.iterators.put(aa, iter);
        }
        Object retval = null;
        if (iter.hasNext() && (retval = (Object)iter.next()) instanceof String && retval.toString().equals("")) {
            throw new AwkRuntimeException("Assoc array key contains a blank string ?!");
        }
        if (retval == null) {
            this.iterators.remove(aa);
            retval = "";
        }
        if (retval instanceof AssocArray) {
            for (String ref : this.referenceMap.keySet()) {
                if (this.referenceMap.get(ref) != retval) continue;
                return ref;
            }
            return CoreExtension.newReference(retval);
        }
        return retval;
    }

    private int isInRef(Object ref, Object key, VariableManager vm) {
        if (ref instanceof AssocArray) {
            throw new IllegalAwkArgumentException("Expecting a reference string for the 1st argument, not an assoc array.");
        }
        String refstring = this.toAwkString(ref);
        return CoreExtension.isInRef(refstring, key);
    }

    static int isInRef(String refstring, Object key) {
        Object o = CoreExtension.instance.referenceMap.get(refstring);
        if (o == null) {
            throw new IllegalAwkArgumentException("Invalid refstring : " + refstring);
        }
        AssocArray aa = (AssocArray)o;
        return aa.isIn(key) ? ONE : ZERO;
    }

    private void dumpRefs() {
        for (Map.Entry<String, Object> entry : this.referenceMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof AssocArray) {
                value = ((AssocArray)value).mapString();
            }
            LOG.info("REF : {} = {}", new Object[]{entry.getKey(), value});
        }
    }

    static String typeOf(Object arg, VariableManager vm) {
        if (arg instanceof AssocArray) {
            return "AssocArray";
        }
        if (arg instanceof Integer) {
            return "Integer";
        }
        if (arg instanceof Double) {
            return "Double";
        }
        String stringRep = instance.toAwkString(arg);
        if (CoreExtension.instance.referenceMap.get(stringRep) != null) {
            return "Reference";
        }
        return "String";
    }

    private int get(AssocArray retval, AssocArray map, Object key) {
        retval.clear();
        retval.put(0L, map.get(key));
        return 1;
    }

    private Object toScalar(AssocArray aa) {
        return aa.get(0);
    }

    private Object map(Object[] args2, VariableManager vm, int mapType) {
        if (args2.length % 2 == 0) {
            return this.subMap(args2, vm, mapType);
        }
        return this.topLevelMap(args2, vm, mapType, false);
    }

    private Object mapUnion(Object[] args2, VariableManager vm, int mapType) {
        return this.topLevelMap(args2, vm, mapType, true);
    }

    private int topLevelMap(Object[] args2, VariableManager vm, int mapType, boolean mapUnion) {
        AssocArray aa = (AssocArray)args2[0];
        if (!mapUnion) {
            aa.clear();
            aa.useMapType(mapType);
        }
        int cnt = 0;
        for (int i = 1; i < args2.length; i += 2) {
            if (args2[i] instanceof AssocArray) {
                args2[i] = CoreExtension.newReference(args2[i]);
            }
            if (args2[i + 1] instanceof AssocArray) {
                args2[i + 1] = CoreExtension.newReference(args2[i + 1]);
            }
            aa.put(args2[i], args2[i + 1]);
            ++cnt;
        }
        return cnt;
    }

    private AssocArray subMap(Object[] args2, VariableManager vm, int mapType) {
        AssocArray aa = new AssocArray(false);
        aa.useMapType(mapType);
        for (int i = 0; i < args2.length; i += 2) {
            if (args2[i] instanceof AssocArray) {
                args2[i] = CoreExtension.newReference(args2[i]);
            }
            if (args2[i + 1] instanceof AssocArray) {
                args2[i + 1] = CoreExtension.newReference(args2[i + 1]);
            }
            aa.put(args2[i], args2[i + 1]);
        }
        return aa;
    }

    private int array(Object[] args2, VariableManager vm) {
        AssocArray aa = (AssocArray)args2[0];
        aa.clear();
        aa.useMapType(8);
        String subsep = this.toAwkString(vm.getSUBSEP());
        int cnt = 0;
        for (int i = 1; i < args2.length; ++i) {
            Object o = args2[i];
            if (o instanceof AssocArray) {
                AssocArray arr = (AssocArray)o;
                for (Object key : arr.keySet()) {
                    aa.put("" + i + subsep + key, arr.get(key));
                }
            } else {
                aa.put("" + i, o);
            }
            ++cnt;
        }
        return cnt;
    }

    private int mapCopy(Object[] args2) {
        AssocArray aaTarget = (AssocArray)args2[0];
        AssocArray aaSource = (AssocArray)args2[1];
        aaTarget.clear();
        int cnt = 0;
        for (Object o : aaSource.keySet()) {
            aaTarget.put(o, aaSource.get(o));
            ++cnt;
        }
        return cnt;
    }

    private Object toDouble(Object arg, VariableManager vm) {
        if (arg instanceof AssocArray) {
            throw new IllegalArgumentException("Cannot deduce double value from an associative array.");
        }
        if (arg instanceof Number) {
            return ((Number)arg).doubleValue();
        }
        try {
            String str = this.toAwkString(arg);
            double d = Double.parseDouble(str);
            return d;
        }
        catch (NumberFormatException nfe) {
            return "";
        }
    }

    private static String toString(Object arg, VariableManager vm) {
        if (arg instanceof AssocArray) {
            return ((AssocArray)arg).mapString();
        }
        return instance.toAwkString(arg);
    }

    private Object timeout(int ms) {
        if (ms <= 0) {
            throw new IllegalAwkArgumentException("Timeout requires a positive # argument, not " + ms + ".");
        }
        this.waitInt = ms;
        return this.timeoutBlocker;
    }

    private String version(Object obj) {
        if (obj instanceof AssocArray) {
            return ((AssocArray)obj).getMapVersion();
        }
        Class<?> cls = obj.getClass();
        return cls.getPackage().getSpecificationVersion();
    }

    private String date() {
        this.dateObj.setTime(System.currentTimeMillis());
        return this.dateObj.toString();
    }

    private String date(String formatString) {
        this.dateObj.setTime(System.currentTimeMillis());
        this.dateFormat.applyPattern(formatString);
        return this.dateFormat.format(this.dateObj);
    }

    private int fileExists(String path) {
        if (new File(path).exists()) {
            return ONE;
        }
        return ZERO;
    }
}

