/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.jawk.intermediate;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sentrysoftware.jawk.intermediate.Address;
import org.sentrysoftware.jawk.intermediate.HasFunctionAddress;
import org.sentrysoftware.jawk.intermediate.Position;
import org.sentrysoftware.jawk.intermediate.PositionForCompilation;
import org.sentrysoftware.jawk.intermediate.PositionForInterpretation;
import org.sentrysoftware.jawk.util.AwkLogger;
import org.sentrysoftware.jawk.util.LinkedListStackImpl;
import org.sentrysoftware.jawk.util.MyStack;
import org.slf4j.Logger;

public class AwkTuples
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = AwkLogger.getLogger(AwkTuples.class);
    private VersionManager version_manager = new VersionManager();
    public static final int _POP_ = 257;
    public static final int _PUSH_ = 258;
    public static final int _IFFALSE_ = 259;
    public static final int _TO_NUMBER_ = 260;
    public static final int _IFTRUE_ = 261;
    public static final int _GOTO_ = 262;
    public static final int _NOP_ = 263;
    public static final int _PRINT_ = 264;
    public static final int _PRINT_TO_FILE_ = 265;
    public static final int _PRINT_TO_PIPE_ = 266;
    public static final int _PRINTF_ = 267;
    public static final int _PRINTF_TO_FILE_ = 268;
    public static final int _PRINTF_TO_PIPE_ = 269;
    public static final int _SPRINTF_ = 270;
    public static final int _LENGTH_ = 271;
    public static final int _CONCAT_ = 272;
    public static final int _ASSIGN_ = 273;
    public static final int _ASSIGN_ARRAY_ = 274;
    public static final int _ASSIGN_AS_INPUT_ = 275;
    public static final int _ASSIGN_AS_INPUT_FIELD_ = 276;
    public static final int _DEREFERENCE_ = 277;
    public static final int _PLUS_EQ_ = 278;
    public static final int _MINUS_EQ_ = 279;
    public static final int _MULT_EQ_ = 280;
    public static final int _DIV_EQ_ = 281;
    public static final int _MOD_EQ_ = 282;
    public static final int _POW_EQ_ = 283;
    public static final int _PLUS_EQ_ARRAY_ = 284;
    public static final int _MINUS_EQ_ARRAY_ = 285;
    public static final int _MULT_EQ_ARRAY_ = 286;
    public static final int _DIV_EQ_ARRAY_ = 287;
    public static final int _MOD_EQ_ARRAY_ = 288;
    public static final int _POW_EQ_ARRAY_ = 289;
    public static final int _PLUS_EQ_INPUT_FIELD_ = 290;
    public static final int _MINUS_EQ_INPUT_FIELD_ = 291;
    public static final int _MULT_EQ_INPUT_FIELD_ = 292;
    public static final int _DIV_EQ_INPUT_FIELD_ = 293;
    public static final int _MOD_EQ_INPUT_FIELD_ = 294;
    public static final int _POW_EQ_INPUT_FIELD_ = 295;
    public static final int _SRAND_ = 296;
    public static final int _RAND_ = 297;
    public static final int _INTFUNC_ = 298;
    public static final int _SQRT_ = 299;
    public static final int _LOG_ = 300;
    public static final int _EXP_ = 301;
    public static final int _SIN_ = 302;
    public static final int _COS_ = 303;
    public static final int _ATAN2_ = 304;
    public static final int _MATCH_ = 305;
    public static final int _INDEX_ = 306;
    public static final int _SUB_FOR_DOLLAR_0_ = 307;
    public static final int _SUB_FOR_DOLLAR_REFERENCE_ = 308;
    public static final int _SUB_FOR_VARIABLE_ = 309;
    public static final int _SUB_FOR_ARRAY_REFERENCE_ = 310;
    public static final int _SPLIT_ = 311;
    public static final int _SUBSTR_ = 312;
    public static final int _TOLOWER_ = 313;
    public static final int _TOUPPER_ = 314;
    public static final int _SYSTEM_ = 315;
    public static final int _SWAP_ = 316;
    public static final int _ADD_ = 317;
    public static final int _SUBTRACT_ = 318;
    public static final int _MULTIPLY_ = 319;
    public static final int _DIVIDE_ = 320;
    public static final int _MOD_ = 321;
    public static final int _POW_ = 322;
    public static final int _INC_ = 323;
    public static final int _DEC_ = 324;
    public static final int _INC_ARRAY_REF_ = 325;
    public static final int _DEC_ARRAY_REF_ = 326;
    public static final int _INC_DOLLAR_REF_ = 327;
    public static final int _DEC_DOLLAR_REF_ = 328;
    public static final int _DUP_ = 329;
    public static final int _NOT_ = 330;
    public static final int _NEGATE_ = 331;
    public static final int _CMP_EQ_ = 332;
    public static final int _CMP_LT_ = 333;
    public static final int _CMP_GT_ = 334;
    public static final int _MATCHES_ = 335;
    public static final int _SLEEP_ = 336;
    public static final int _DUMP_ = 337;
    public static final int _DEREF_ARRAY_ = 338;
    public static final int _KEYLIST_ = 339;
    public static final int _IS_EMPTY_KEYLIST_ = 340;
    public static final int _GET_FIRST_AND_REMOVE_FROM_KEYLIST_ = 341;
    public static final int _CHECK_CLASS_ = 342;
    public static final int _GET_INPUT_FIELD_ = 343;
    public static final int _CONSUME_INPUT_ = 344;
    public static final int _GETLINE_INPUT_ = 345;
    public static final int _USE_AS_FILE_INPUT_ = 346;
    public static final int _USE_AS_COMMAND_INPUT_ = 347;
    public static final int _NF_OFFSET_ = 348;
    public static final int _NR_OFFSET_ = 349;
    public static final int _FNR_OFFSET_ = 350;
    public static final int _FS_OFFSET_ = 351;
    public static final int _RS_OFFSET_ = 352;
    public static final int _OFS_OFFSET_ = 353;
    public static final int _RSTART_OFFSET_ = 354;
    public static final int _RLENGTH_OFFSET_ = 355;
    public static final int _FILENAME_OFFSET_ = 356;
    public static final int _SUBSEP_OFFSET_ = 357;
    public static final int _CONVFMT_OFFSET_ = 358;
    public static final int _OFMT_OFFSET_ = 359;
    public static final int _ENVIRON_OFFSET_ = 360;
    public static final int _ARGC_OFFSET_ = 361;
    public static final int _ARGV_OFFSET_ = 362;
    public static final int _APPLY_RS_ = 363;
    public static final int _CALL_FUNCTION_ = 364;
    public static final int _FUNCTION_ = 365;
    public static final int _SET_RETURN_RESULT_ = 366;
    public static final int _RETURN_FROM_FUNCTION_ = 367;
    public static final int _SET_NUM_GLOBALS_ = 368;
    public static final int _CLOSE_ = 369;
    public static final int _APPLY_SUBSEP_ = 370;
    public static final int _DELETE_ARRAY_ELEMENT_ = 371;
    public static final int _SET_EXIT_ADDRESS_ = 372;
    public static final int _SET_WITHIN_END_BLOCKS_ = 373;
    public static final int _EXIT_WITH_CODE_ = 374;
    public static final int _REGEXP_ = 375;
    public static final int _CONDITION_PAIR_ = 376;
    public static final int _IS_IN_ = 377;
    public static final int _CAST_INT_ = 378;
    public static final int _CAST_DOUBLE_ = 379;
    public static final int _CAST_STRING_ = 380;
    public static final int _THIS_ = 381;
    public static final int _EXTENSION_ = 382;
    public static final int _EXEC_ = 383;
    public static final int _DELETE_ARRAY_ = 384;
    public static final int _UNARY_PLUS_ = 385;
    public static final int _EXIT_WITHOUT_CODE_ = 386;
    public static final int _ORS_OFFSET_ = 387;
    public static final int _POSTINC_ = 388;
    public static final int _POSTDEC_ = 389;
    private List<Tuple> queue = new ArrayList<Tuple>(100){
        private static final long serialVersionUID = -6334362156408598578L;

        @Override
        public boolean add(Tuple t2) {
            t2.setLineNumber((Integer)AwkTuples.this.lineno_stack.peek());
            return super.add(t2);
        }
    };
    private Set<Address> unresolved_addresses = new HashSet<Address>();
    private Map<Integer, Address> address_indexes = new HashMap<Integer, Address>();
    private Map<String, Integer> address_label_counts = new HashMap<String, Integer>();
    private Map<String, Integer> global_var_offset_map = new HashMap<String, Integer>();
    private Map<String, Boolean> global_var_aarray_map = new HashMap<String, Boolean>();
    private Set<String> function_names = null;
    private MyStack<Integer> lineno_stack = new LinkedListStackImpl<Integer>();

    public static String toOpcodeString(int opcode) {
        Class<AwkTuples> c = AwkTuples.class;
        Field[] fields = c.getDeclaredFields();
        try {
            for (Field field : fields) {
                if ((field.getModifiers() & 8) <= 0 || field.getType() != Long.TYPE || field.getLong(null) != (long)opcode) continue;
                return field.getName();
            }
        }
        catch (IllegalAccessException iac) {
            LOG.error("Failed to create OP-Code string", iac);
            return "[" + opcode + ": " + iac + "]";
        }
        return "{" + opcode + "}";
    }

    public void pop() {
        this.queue.add(new Tuple(257));
    }

    public void push(Object o) {
        assert (o instanceof String || o instanceof Long || o instanceof Integer || o instanceof Double);
        if (o instanceof String) {
            this.queue.add(new Tuple(258, o.toString()));
        } else if (o instanceof Integer) {
            this.queue.add(new Tuple(258, (long)((Integer)o).intValue()));
        } else if (o instanceof Long) {
            this.queue.add(new Tuple(258, (long)((Long)o)));
        } else if (o instanceof Double) {
            this.queue.add(new Tuple(258, (Double)o));
        } else assert (false) : "Invalid type for " + o + ", " + o.getClass();
    }

    public void ifFalse(Address address) {
        this.queue.add(new Tuple(259, address));
    }

    public void toNumber() {
        this.queue.add(new Tuple(260));
    }

    public void ifTrue(Address address) {
        this.queue.add(new Tuple(261, address));
    }

    public void gotoAddress(Address address) {
        this.queue.add(new Tuple(262, address));
    }

    public Address createAddress(String label) {
        Integer I = this.address_label_counts.get(label);
        I = I == null ? Integer.valueOf(0) : Integer.valueOf(I + 1);
        this.address_label_counts.put(label, I);
        AddressImpl address = new AddressImpl(label + "_" + I);
        this.unresolved_addresses.add(address);
        return address;
    }

    public AwkTuples address(Address address) {
        if (this.unresolved_addresses.contains(address)) {
            this.unresolved_addresses.remove(address);
            address.assignIndex(this.queue.size());
            this.address_indexes.put(this.queue.size(), address);
            return this;
        }
        throw new Error(address.toString() + " is already resolved, or unresolved from another scope.");
    }

    public void nop() {
        this.queue.add(new Tuple(263));
    }

    public void print(int num_exprs) {
        this.queue.add(new Tuple(264, (long)num_exprs));
    }

    public void printToFile(int num_exprs, boolean append) {
        this.queue.add(new Tuple(265, (long)num_exprs, append));
    }

    public void printToPipe(int num_exprs) {
        this.queue.add(new Tuple(266, (long)num_exprs));
    }

    public void printf(int num_exprs) {
        this.queue.add(new Tuple(267, (long)num_exprs));
    }

    public void printfToFile(int num_exprs, boolean append) {
        this.queue.add(new Tuple(268, (long)num_exprs, append));
    }

    public void printfToPipe(int num_exprs) {
        this.queue.add(new Tuple(269, (long)num_exprs));
    }

    public void sprintf(int num_exprs) {
        this.queue.add(new Tuple(270, (long)num_exprs));
    }

    public void length(int num_exprs) {
        this.queue.add(new Tuple(271, (long)num_exprs));
    }

    public void concat() {
        this.queue.add(new Tuple(272));
    }

    public void assign(int offset, boolean is_global) {
        this.queue.add(new Tuple(273, (long)offset, is_global));
    }

    public void assignArray(int offset, boolean is_global) {
        this.queue.add(new Tuple(274, (long)offset, is_global));
    }

    public void assignAsInput() {
        this.queue.add(new Tuple(275));
    }

    public void assignAsInputField() {
        this.queue.add(new Tuple(276));
    }

    public void dereference(int offset, boolean is_array, boolean is_global) {
        this.queue.add(new Tuple(277, offset, is_array, is_global));
    }

    public void plusEq(int offset, boolean is_global) {
        this.queue.add(new Tuple(278, (long)offset, is_global));
    }

    public void minusEq(int offset, boolean is_global) {
        this.queue.add(new Tuple(279, (long)offset, is_global));
    }

    public void multEq(int offset, boolean is_global) {
        this.queue.add(new Tuple(280, (long)offset, is_global));
    }

    public void divEq(int offset, boolean is_global) {
        this.queue.add(new Tuple(281, (long)offset, is_global));
    }

    public void modEq(int offset, boolean is_global) {
        this.queue.add(new Tuple(282, (long)offset, is_global));
    }

    public void powEq(int offset, boolean is_global) {
        this.queue.add(new Tuple(283, (long)offset, is_global));
    }

    public void plusEqArray(int offset, boolean is_global) {
        this.queue.add(new Tuple(284, (long)offset, is_global));
    }

    public void minusEqArray(int offset, boolean is_global) {
        this.queue.add(new Tuple(285, (long)offset, is_global));
    }

    public void multEqArray(int offset, boolean is_global) {
        this.queue.add(new Tuple(286, (long)offset, is_global));
    }

    public void divEqArray(int offset, boolean is_global) {
        this.queue.add(new Tuple(287, (long)offset, is_global));
    }

    public void modEqArray(int offset, boolean is_global) {
        this.queue.add(new Tuple(288, (long)offset, is_global));
    }

    public void powEqArray(int offset, boolean is_global) {
        this.queue.add(new Tuple(289, (long)offset, is_global));
    }

    public void plusEqInputField() {
        this.queue.add(new Tuple(290));
    }

    public void minusEqInputField() {
        this.queue.add(new Tuple(291));
    }

    public void multEqInputField() {
        this.queue.add(new Tuple(292));
    }

    public void divEqInputField() {
        this.queue.add(new Tuple(293));
    }

    public void modEqInputField() {
        this.queue.add(new Tuple(294));
    }

    public void powEqInputField() {
        this.queue.add(new Tuple(295));
    }

    public void srand(int num) {
        this.queue.add(new Tuple(296, (long)num));
    }

    public void rand() {
        this.queue.add(new Tuple(297));
    }

    public void intFunc() {
        this.queue.add(new Tuple(298));
    }

    public void sqrt() {
        this.queue.add(new Tuple(299));
    }

    public void log() {
        this.queue.add(new Tuple(300));
    }

    public void exp() {
        this.queue.add(new Tuple(301));
    }

    public void sin() {
        this.queue.add(new Tuple(302));
    }

    public void cos() {
        this.queue.add(new Tuple(303));
    }

    public void atan2() {
        this.queue.add(new Tuple(304));
    }

    public void match() {
        this.queue.add(new Tuple(305));
    }

    public void index() {
        this.queue.add(new Tuple(306));
    }

    public void subForDollar0(boolean is_gsub) {
        this.queue.add(new Tuple(307, is_gsub));
    }

    public void subForDollarReference(boolean is_gsub) {
        this.queue.add(new Tuple(308, is_gsub));
    }

    public void subForVariable(int offset, boolean is_global, boolean is_gsub) {
        this.queue.add(new Tuple(309, offset, is_global, is_gsub));
    }

    public void subForArrayReference(int offset, boolean is_global, boolean is_gsub) {
        this.queue.add(new Tuple(310, offset, is_global, is_gsub));
    }

    public void split(int numargs) {
        this.queue.add(new Tuple(311, (long)numargs));
    }

    public void substr(int numargs) {
        this.queue.add(new Tuple(312, (long)numargs));
    }

    public void tolower() {
        this.queue.add(new Tuple(313));
    }

    public void toupper() {
        this.queue.add(new Tuple(314));
    }

    public void system() {
        this.queue.add(new Tuple(315));
    }

    public void exec() {
        this.queue.add(new Tuple(383));
    }

    public void swap() {
        this.queue.add(new Tuple(316));
    }

    public void add() {
        this.queue.add(new Tuple(317));
    }

    public void subtract() {
        this.queue.add(new Tuple(318));
    }

    public void multiply() {
        this.queue.add(new Tuple(319));
    }

    public void divide() {
        this.queue.add(new Tuple(320));
    }

    public void mod() {
        this.queue.add(new Tuple(321));
    }

    public void pow() {
        this.queue.add(new Tuple(322));
    }

    public void inc(int offset, boolean is_global) {
        this.queue.add(new Tuple(323, (long)offset, is_global));
    }

    public void dec(int offset, boolean is_global) {
        this.queue.add(new Tuple(324, (long)offset, is_global));
    }

    public void postInc(int offset, boolean is_global) {
        this.queue.add(new Tuple(388, (long)offset, is_global));
    }

    public void postDec(int offset, boolean is_global) {
        this.queue.add(new Tuple(389, (long)offset, is_global));
    }

    public void incArrayRef(int offset, boolean is_global) {
        this.queue.add(new Tuple(325, (long)offset, is_global));
    }

    public void decArrayRef(int offset, boolean is_global) {
        this.queue.add(new Tuple(326, (long)offset, is_global));
    }

    public void incDollarRef() {
        this.queue.add(new Tuple(327));
    }

    public void decDollarRef() {
        this.queue.add(new Tuple(328));
    }

    public void dup() {
        this.queue.add(new Tuple(329));
    }

    public void not() {
        this.queue.add(new Tuple(330));
    }

    public void negate() {
        this.queue.add(new Tuple(331));
    }

    public void unaryPlus() {
        this.queue.add(new Tuple(385));
    }

    public void cmpEq() {
        this.queue.add(new Tuple(332));
    }

    public void cmpLt() {
        this.queue.add(new Tuple(333));
    }

    public void cmpGt() {
        this.queue.add(new Tuple(334));
    }

    public void matches() {
        this.queue.add(new Tuple(335));
    }

    public void sleep(int num_args) {
        this.queue.add(new Tuple(336, (long)num_args));
    }

    public void dump(int num_args) {
        this.queue.add(new Tuple(337, (long)num_args));
    }

    public void dereferenceArray() {
        this.queue.add(new Tuple(338));
    }

    public void keylist() {
        this.queue.add(new Tuple(339));
    }

    public void isEmptyList(Address address) {
        this.queue.add(new Tuple(340, address));
    }

    public void getFirstAndRemoveFromList() {
        this.queue.add(new Tuple(341));
    }

    public boolean checkClass(Class<?> cls) {
        this.queue.add(new Tuple(342, cls));
        return true;
    }

    public void getInputField() {
        this.queue.add(new Tuple(343));
    }

    public void consumeInput(Address address) {
        this.queue.add(new Tuple(344, address));
    }

    public void getlineInput() {
        this.queue.add(new Tuple(345));
    }

    public void useAsFileInput() {
        this.queue.add(new Tuple(346));
    }

    public void useAsCommandInput() {
        this.queue.add(new Tuple(347));
    }

    public void nfOffset(int offset) {
        this.queue.add(new Tuple(348, (long)offset));
    }

    public void nrOffset(int offset) {
        this.queue.add(new Tuple(349, (long)offset));
    }

    public void fnrOffset(int offset) {
        this.queue.add(new Tuple(350, (long)offset));
    }

    public void fsOffset(int offset) {
        this.queue.add(new Tuple(351, (long)offset));
    }

    public void rsOffset(int offset) {
        this.queue.add(new Tuple(352, (long)offset));
    }

    public void ofsOffset(int offset) {
        this.queue.add(new Tuple(353, (long)offset));
    }

    public void orsOffset(int offset) {
        this.queue.add(new Tuple(387, (long)offset));
    }

    public void rstartOffset(int offset) {
        this.queue.add(new Tuple(354, (long)offset));
    }

    public void rlengthOffset(int offset) {
        this.queue.add(new Tuple(355, (long)offset));
    }

    public void filenameOffset(int offset) {
        this.queue.add(new Tuple(356, (long)offset));
    }

    public void subsepOffset(int offset) {
        this.queue.add(new Tuple(357, (long)offset));
    }

    public void convfmtOffset(int offset) {
        this.queue.add(new Tuple(358, (long)offset));
    }

    public void ofmtOffset(int offset) {
        this.queue.add(new Tuple(359, (long)offset));
    }

    public void environOffset(int offset) {
        this.queue.add(new Tuple(360, (long)offset));
    }

    public void argcOffset(int offset) {
        this.queue.add(new Tuple(361, (long)offset));
    }

    public void argvOffset(int offset) {
        this.queue.add(new Tuple(362, (long)offset));
    }

    public void applyRS() {
        this.queue.add(new Tuple(363));
    }

    public void function(String func_name, int num_formal_params) {
        this.queue.add(new Tuple(365, func_name, (long)num_formal_params));
    }

    public void callFunction(HasFunctionAddress has_func_addr, String func_name, int num_formal_params, int num_actual_params) {
        this.queue.add(new Tuple(364, has_func_addr, func_name, num_formal_params, num_actual_params));
    }

    public void setReturnResult() {
        this.queue.add(new Tuple(366));
    }

    public void returnFromFunction() {
        this.queue.add(new Tuple(367));
    }

    public void setNumGlobals(int num_globals) {
        this.queue.add(new Tuple(368, (long)num_globals));
    }

    public void close() {
        this.queue.add(new Tuple(369));
    }

    public void applySubsep(int count) {
        this.queue.add(new Tuple(370, (long)count));
    }

    public void deleteArrayElement(int offset, boolean is_global) {
        this.queue.add(new Tuple(371, (long)offset, is_global));
    }

    public void deleteArray(int offset, boolean is_global) {
        this.queue.add(new Tuple(384, (long)offset, is_global));
    }

    public void setExitAddress(Address addr) {
        this.queue.add(new Tuple(372, addr));
    }

    public void setWithinEndBlocks(boolean b) {
        this.queue.add(new Tuple(373, b));
    }

    public void exitWithCode() {
        this.queue.add(new Tuple(374));
    }

    public void exitWithoutCode() {
        this.queue.add(new Tuple(386));
    }

    public void regexp(String regexp_str) {
        this.queue.add(new Tuple(375, regexp_str));
    }

    public void conditionPair() {
        this.queue.add(new Tuple(376));
    }

    public void isIn() {
        this.queue.add(new Tuple(377));
    }

    public void castInt() {
        this.queue.add(new Tuple(378));
    }

    public void castDouble() {
        this.queue.add(new Tuple(379));
    }

    public void castString() {
        this.queue.add(new Tuple(380));
    }

    public void scriptThis() {
        this.queue.add(new Tuple(381));
    }

    public void extension(String extension_keyword, int param_count, boolean is_initial) {
        this.queue.add(new Tuple(382, extension_keyword, param_count, is_initial));
    }

    public void dump(PrintStream ps) {
        ps.println("(" + this.version_manager + ")");
        ps.println();
        for (int i = 0; i < this.queue.size(); ++i) {
            Address address = this.address_indexes.get(i);
            if (address == null) {
                ps.println(i + " : " + this.queue.get(i));
                continue;
            }
            ps.println(i + " : [" + address + "] : " + this.queue.get(i));
        }
    }

    public Position top() {
        return new PositionImpl();
    }

    public void postProcess() {
        assert (this.queue.isEmpty() || !this.queue.get(0).hasNext()) : "postProcess() already executed";
        for (int i = 0; i < this.queue.size() - 1; ++i) {
            this.queue.get(i).setNext(this.queue.get(i + 1));
        }
        for (Tuple tuple : this.queue) {
            tuple.touch(this.queue);
        }
    }

    public void addGlobalVariableNameToOffsetMapping(String varname, int offset, boolean is_array) {
        if (this.global_var_offset_map.get(varname) != null) {
            assert (this.global_var_aarray_map.get(varname) != null);
            return;
        }
        this.global_var_offset_map.put(varname, offset);
        this.global_var_aarray_map.put(varname, is_array);
    }

    public void setFunctionNameSet(Set<String> function_names) {
        this.function_names = new HashSet<String>(function_names);
    }

    public Map<String, Integer> getGlobalVariableOffsetMap() {
        return this.global_var_offset_map;
    }

    public Map<String, Boolean> getGlobalVariableAarrayMap() {
        return this.global_var_aarray_map;
    }

    public Set<String> getFunctionNameSet() {
        assert (this.function_names != null);
        return this.function_names;
    }

    public void pushSourceLineNumber(int lineno) {
        this.lineno_stack.push(lineno);
    }

    public void popSourceLineNumber(int lineno) {
        int tos = this.lineno_stack.pop();
        assert (lineno == tos);
    }

    private static class VersionManager
    implements Serializable {
        private static final long serialVersionUID = -2015316238483923915L;
        private static final int CLASS_VERSION = 2;
        private int INSTANCE_VERSION = 2;

        private VersionManager() {
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            this.INSTANCE_VERSION = ois.readInt();
            if (this.INSTANCE_VERSION != 2) {
                throw new InvalidClassException("Invalid intermeidate file format (instance version " + this.INSTANCE_VERSION + " != class version " + 2 + ")");
            }
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeInt(this.INSTANCE_VERSION);
        }

        public String toString() {
            return "intermediate file format version = " + this.INSTANCE_VERSION;
        }
    }

    private static final class Tuple
    implements Serializable {
        private static final long serialVersionUID = 8105941219003992817L;
        private int opcode;
        private long[] ints = new long[4];
        private boolean[] bools = new boolean[4];
        private double[] doubles = new double[4];
        private String[] strings = new String[4];
        private Class<?>[] types = new Class[4];
        private Address address = null;
        private Class<?> cls = null;
        private transient HasFunctionAddress hasFuncAddr = null;
        private int lineno = -1;
        private Tuple next = null;

        private Tuple(int opcode) {
            this.opcode = opcode;
        }

        private Tuple(int opcode, long i1) {
            this(opcode);
            this.ints[0] = i1;
            this.types[0] = Long.class;
        }

        private Tuple(int opcode, long i1, long i2) {
            this(opcode, i1);
            this.ints[1] = i2;
            this.types[1] = Long.class;
        }

        private Tuple(int opcode, long i1, boolean b2) {
            this(opcode, i1);
            this.bools[1] = b2;
            this.types[1] = Boolean.class;
        }

        private Tuple(int opcode, long i1, boolean b2, boolean b3) {
            this(opcode, i1, b2);
            this.bools[2] = b3;
            this.types[2] = Boolean.class;
        }

        private Tuple(int opcode, double d1) {
            this(opcode);
            this.doubles[0] = d1;
            this.types[0] = Double.class;
        }

        private Tuple(int opcode, String s1) {
            this(opcode);
            this.strings[0] = s1;
            this.types[0] = String.class;
        }

        private Tuple(int opcode, boolean b1) {
            this(opcode);
            this.bools[0] = b1;
            this.types[0] = Boolean.class;
        }

        private Tuple(int opcode, String s1, long i2) {
            this(opcode, s1);
            this.ints[1] = i2;
            this.types[1] = Long.class;
        }

        private Tuple(int opcode, Address address) {
            this(opcode);
            this.address = address;
            this.types[0] = Address.class;
        }

        private Tuple(int opcode, String strarg, long intarg, boolean boolarg) {
            this(opcode, strarg, intarg);
            this.bools[2] = boolarg;
            this.types[2] = Boolean.class;
        }

        private Tuple(int opcode, HasFunctionAddress has_func_addr, String s2, long i3, long i4) {
            this(opcode);
            this.hasFuncAddr = has_func_addr;
            this.strings[1] = s2;
            this.types[1] = String.class;
            this.ints[2] = i3;
            this.types[2] = Long.class;
            this.ints[3] = i4;
            this.types[3] = Long.class;
        }

        private Tuple(int opcode, Class<?> cls) {
            this(opcode);
            this.cls = cls;
            this.types[0] = Class.class;
        }

        private Tuple(int opcode, String s1, String s2) {
            this(opcode, s1);
            this.strings[1] = s2;
            this.types[1] = String.class;
        }

        private boolean hasNext() {
            return this.next != null;
        }

        private Tuple getNext() {
            return this.next;
        }

        private void setNext(Tuple next) {
            this.next = next;
        }

        private void setLineNumber(int lineno) {
            assert (this.lineno == -1) : "The line number was already set to " + this.lineno + ". Later lineno = " + lineno + ".";
            this.lineno = lineno;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(AwkTuples.toOpcodeString(this.opcode));
            for (int idx = 0; idx < this.types.length && this.types[idx] != null; ++idx) {
                sb.append(", ");
                Class<?> type = this.types[idx];
                if (type == Long.class) {
                    sb.append(this.ints[idx]);
                    continue;
                }
                if (type == Boolean.class) {
                    sb.append(this.bools[idx]);
                    continue;
                }
                if (type == Double.class) {
                    sb.append(this.doubles[idx]);
                    continue;
                }
                if (type == String.class) {
                    sb.append('\"').append(this.strings[idx]).append('\"');
                    continue;
                }
                if (type == Address.class) {
                    assert (idx == 0);
                    sb.append(this.address);
                    continue;
                }
                if (type == Class.class) {
                    assert (idx == 0);
                    sb.append(this.cls);
                    continue;
                }
                if (type == HasFunctionAddress.class) {
                    assert (idx == 0);
                    sb.append(this.hasFuncAddr);
                    continue;
                }
                throw new Error("Unknown param type (" + idx + "): " + type);
            }
            return sb.toString();
        }

        public void touch(List<Tuple> queue) {
            assert (this.lineno != -1) : "The line number should have been set by queue.add(), but was not.";
            if (this.hasFuncAddr != null) {
                this.address = this.hasFuncAddr.getFunctionAddress();
                this.types[0] = Address.class;
            }
            if (this.address != null) {
                if (this.address.index() == -1) {
                    throw new Error("address " + this.address + " is unresolved");
                }
                if (this.address.index() >= queue.size()) {
                    throw new Error("address " + this.address + " doesn't resolve to an actual list element");
                }
            }
        }

        private int getOpcode() {
            return this.opcode;
        }

        private long[] getInts() {
            return this.ints;
        }

        private boolean[] getBools() {
            return this.bools;
        }

        private double[] getDoubles() {
            return this.doubles;
        }

        private String[] getStrings() {
            return this.strings;
        }

        private Class<?>[] getTypes() {
            return this.types;
        }

        private void setAddress(Address address) {
            this.address = address;
        }

        private Address getAddress() {
            return this.address;
        }

        private int getLineno() {
            return this.lineno;
        }

        private void setOpcode(int opcode) {
            this.opcode = opcode;
        }

        private Class<?> getCls() {
            return this.cls;
        }

        private HasFunctionAddress getHasFuncAddr() {
            return this.hasFuncAddr;
        }
    }

    private static final class AddressImpl
    implements Address,
    Serializable {
        private static final long serialVersionUID = 109610985341478678L;
        private String lbl;
        private int idx = -1;

        private AddressImpl(String lbl) {
            this.lbl = lbl;
        }

        @Override
        public String label() {
            return this.lbl;
        }

        public String toString() {
            return this.label();
        }

        @Override
        public void assignIndex(int idx) {
            this.idx = idx;
        }

        @Override
        public int index() {
            assert (this.idx >= 0) : this.toString();
            return this.idx;
        }
    }

    private class PositionImpl
    implements PositionForInterpretation,
    PositionForCompilation {
        private int idx = 0;
        private Tuple tuple = AwkTuples.access$100(AwkTuples.this).isEmpty() ? null : (Tuple)AwkTuples.access$100(AwkTuples.this).get(this.idx);

        private PositionImpl() {
        }

        @Override
        public int index() {
            return this.idx;
        }

        @Override
        public boolean isEOF() {
            return this.idx >= AwkTuples.this.queue.size();
        }

        @Override
        public void next() {
            assert (this.tuple != null);
            ++this.idx;
            this.tuple = this.tuple.getNext();
            assert (AwkTuples.this.queue.size() == this.idx || AwkTuples.this.queue.get(this.idx) == this.tuple);
        }

        @Override
        public void jump(Address address) {
            this.idx = address.index();
            this.tuple = (Tuple)AwkTuples.this.queue.get(this.idx);
        }

        public String toString() {
            return "[" + this.idx + "]-->" + this.tuple.toString();
        }

        @Override
        public int opcode() {
            return this.tuple.getOpcode();
        }

        @Override
        public long intArg(int arg_idx) {
            Class c = this.tuple.getTypes()[arg_idx];
            if (c == Long.class) {
                return this.tuple.getInts()[arg_idx];
            }
            throw new Error("Invalid arg type: " + c + ", arg_idx = " + arg_idx + ", tuple = " + this.tuple);
        }

        @Override
        public boolean boolArg(int arg_idx) {
            Class c = this.tuple.getTypes()[arg_idx];
            if (c == Boolean.class) {
                return this.tuple.getBools()[arg_idx];
            }
            throw new Error("Invalid arg type: " + c + ", arg_idx = " + arg_idx + ", tuple = " + this.tuple);
        }

        @Override
        public Object arg(int arg_idx) {
            Class c = this.tuple.getTypes()[arg_idx];
            if (c == Long.class) {
                return this.tuple.getInts()[arg_idx];
            }
            if (c == Double.class) {
                return this.tuple.getDoubles()[arg_idx];
            }
            if (c == String.class) {
                return this.tuple.getStrings()[arg_idx];
            }
            if (c == Address.class) {
                assert (arg_idx == 0);
                return this.tuple.getAddress();
            }
            throw new Error("Invalid arg type: " + c + ", arg_idx = " + arg_idx + ", tuple = " + this.tuple);
        }

        @Override
        public Address addressArg() {
            assert (this.tuple.getAddress() != null || this.tuple.getHasFuncAddr() != null) : "tuple.address = " + Tuple.access$900(this.tuple) + ", tuple.has_func_addr = " + Tuple.access$1000(this.tuple);
            if (this.tuple.getAddress() == null) {
                this.tuple.setAddress(this.tuple.getHasFuncAddr().getFunctionAddress());
            }
            return this.tuple.getAddress();
        }

        @Override
        public Class<?> classArg() {
            assert (this.tuple.getCls() != null);
            return this.tuple.getCls();
        }

        @Override
        public int lineNumber() {
            assert (this.tuple.getLineno() != -1) : "The line number should have been set by queue.add(), but was not.";
            return this.tuple.getLineno();
        }

        @Override
        public int current() {
            return this.idx;
        }

        @Override
        public void jump(int idx) {
            this.idx = idx;
            this.tuple = (Tuple)AwkTuples.this.queue.get(this.idx);
        }
    }
}

