/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.jawk.jrt;

import java.util.LinkedList;
import java.util.List;
import org.sentrysoftware.jawk.jrt.BlockObject;
import org.sentrysoftware.jawk.util.AwkLogger;
import org.slf4j.Logger;

public class BlockManager {
    private static final Logger LOG = AwkLogger.getLogger(BlockManager.class);
    private final Object notifierLock = "NOTIFIER_LOCK";
    private String notifier = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String block(BlockObject bo) {
        List<BlockObject> bos = bo.getBlockObjects();
        LinkedList<BlockThread> threadList = new LinkedList<BlockThread>();
        BlockManager blockManager = this;
        synchronized (blockManager) {
            for (BlockObject blockobj : bos) {
                BlockThread t2 = new BlockThread(blockobj);
                t2.start();
                threadList.add(t2);
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (Thread thread2 : threadList) {
            thread2.interrupt();
            try {
                thread2.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        assert (this.notifier != null);
        return this.notifier;
    }

    private final class BlockThread
    extends Thread {
        private BlockObject bo;

        private BlockThread(BlockObject bo) {
            this.setName("BlockThread for " + bo.getNotifierTag());
            this.bo = bo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.bo.block();
                Object object = BlockManager.this.notifierLock;
                synchronized (object) {
                    if (BlockManager.this.notifier == null) {
                        BlockManager.this.notifier = this.bo.getNotifierTag();
                    }
                }
                object = BlockManager.this;
                synchronized (object) {
                    BlockManager.this.notify();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (RuntimeException re) {
                LOG.error("exitting", re);
                System.exit(1);
            }
        }
    }
}

