/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.jawk.util;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.sentrysoftware.jawk.util.ScriptSource;

public class AwkSettings {
    private InputStream input = System.in;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private List<String> nameValueOrFileNames = new ArrayList<String>();
    private List<ScriptSource> scriptSources = new ArrayList<ScriptSource>();
    private String fieldSeparator = null;
    private boolean dumpSyntaxTree = false;
    private boolean dumpIntermediateCode = false;
    private boolean additionalFunctions = false;
    private boolean additionalTypeFunctions = false;
    private boolean useSortedArrayKeys = false;
    private boolean catchIllegalFormatExceptions = true;
    private boolean userExtensions = false;
    private boolean writeIntermediateFile = false;
    private String outputFilename = null;
    private PrintStream outputStream = System.out;
    private String destinationDirectory = ".";
    private Locale locale = Locale.US;
    private String defaultRS = System.getProperty("line.separator", "\n");
    private String defaultORS = System.getProperty("line.separator", "\n");

    public String toDescriptionString() {
        StringBuilder desc = new StringBuilder();
        int newLine = 10;
        desc.append("variables = ").append(this.getVariables()).append('\n');
        desc.append("nameValueOrFileNames = ").append(this.getNameValueOrFileNames()).append('\n');
        desc.append("scriptSources = ").append(this.scriptSources).append('\n');
        desc.append("fieldSeparator = ").append(this.getFieldSeparator()).append('\n');
        desc.append("dumpSyntaxTree = ").append(this.isDumpSyntaxTree()).append('\n');
        desc.append("dumpIntermediateCode = ").append(this.isDumpIntermediateCode()).append('\n');
        desc.append("additionalFunctions = ").append(this.isAdditionalFunctions()).append('\n');
        desc.append("additionalTypeFunctions = ").append(this.isAdditionalTypeFunctions()).append('\n');
        desc.append("useSortedArrayKeys = ").append(this.isUseSortedArrayKeys()).append('\n');
        desc.append("catchIllegalFormatExceptions = ").append(this.isCatchIllegalFormatExceptions()).append('\n');
        desc.append("writeIntermediateFile = ").append(this.isWriteIntermediateFile()).append('\n');
        desc.append("outputFilename = ").append(this.getOutputFilename()).append('\n');
        desc.append("destinationDirectory = ").append(this.getDestinationDirectory()).append('\n');
        return desc.toString();
    }

    public String toExtensionDescription() {
        StringBuilder extensions = new StringBuilder();
        if (this.isAdditionalFunctions()) {
            extensions.append(", _sleep & _dump enabled");
        }
        if (this.isAdditionalTypeFunctions()) {
            extensions.append(", _INTEGER, _DOUBLE, _STRING enabled");
        }
        if (this.isUseSortedArrayKeys()) {
            extensions.append(", associative array keys are sorted");
        }
        if (this.isCatchIllegalFormatExceptions()) {
            extensions.append(", IllegalFormatExceptions NOT trapped");
        }
        if (extensions.length() > 0) {
            return "{extensions: " + extensions.substring(2) + "}";
        }
        return "{no compiled extensions utilized}";
    }

    private void addInitialVariable(String keyValue) {
        Object value;
        int equalsIdx = keyValue.indexOf(61);
        assert (equalsIdx >= 0);
        String name = keyValue.substring(0, equalsIdx);
        String valueString = keyValue.substring(equalsIdx + 1);
        try {
            value = Integer.parseInt(valueString);
        }
        catch (NumberFormatException nfe) {
            try {
                value = Double.parseDouble(valueString);
            }
            catch (NumberFormatException nfe2) {
                value = valueString;
            }
        }
        this.getVariables().put(name, value);
    }

    public String getOutputFilename(String defaultFileName) {
        if (this.getOutputFilename() == null) {
            return defaultFileName;
        }
        return this.getOutputFilename();
    }

    public List<ScriptSource> getScriptSources() {
        return this.scriptSources;
    }

    public void addScriptSource(ScriptSource scriptSource) {
        this.scriptSources.add(scriptSource);
    }

    public InputStream getInput() {
        return this.input;
    }

    public void setInput(InputStream input) {
        this.input = input;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public List<String> getNameValueOrFileNames() {
        return this.nameValueOrFileNames;
    }

    public void setNameValueOrFileNames(List<String> nameValueOrFileNames) {
        this.nameValueOrFileNames = nameValueOrFileNames;
    }

    public void setScriptSources(List<ScriptSource> scriptSources) {
        this.scriptSources = scriptSources;
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public boolean isDumpSyntaxTree() {
        return this.dumpSyntaxTree;
    }

    public void setDumpSyntaxTree(boolean dumpSyntaxTree) {
        this.dumpSyntaxTree = dumpSyntaxTree;
    }

    public boolean isDumpIntermediateCode() {
        return this.dumpIntermediateCode;
    }

    public void setDumpIntermediateCode(boolean dumpIntermediateCode) {
        this.dumpIntermediateCode = dumpIntermediateCode;
    }

    public boolean isAdditionalFunctions() {
        return this.additionalFunctions;
    }

    public void setAdditionalFunctions(boolean additionalFunctions) {
        this.additionalFunctions = additionalFunctions;
    }

    public boolean isAdditionalTypeFunctions() {
        return this.additionalTypeFunctions;
    }

    public void setAdditionalTypeFunctions(boolean additionalTypeFunctions) {
        this.additionalTypeFunctions = additionalTypeFunctions;
    }

    public boolean isUseSortedArrayKeys() {
        return this.useSortedArrayKeys;
    }

    public void setUseSortedArrayKeys(boolean useSortedArrayKeys) {
        this.useSortedArrayKeys = useSortedArrayKeys;
    }

    public boolean isUserExtensions() {
        return this.userExtensions;
    }

    public void setUserExtensions(boolean userExtensions) {
        this.userExtensions = userExtensions;
    }

    public boolean isWriteIntermediateFile() {
        return this.writeIntermediateFile;
    }

    public void setWriteIntermediateFile(boolean writeIntermediateFile) {
        this.writeIntermediateFile = writeIntermediateFile;
    }

    public String getOutputFilename() {
        return this.outputFilename;
    }

    public void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(PrintStream pOutputStream) {
        this.outputStream = pOutputStream;
    }

    public String getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public void setDestinationDirectory(String destinationDirectory) {
        if (destinationDirectory == null) {
            throw new IllegalArgumentException("The destination directory might never be null (you might want to use \".\")");
        }
        this.destinationDirectory = destinationDirectory;
    }

    public boolean isCatchIllegalFormatExceptions() {
        return this.catchIllegalFormatExceptions;
    }

    public void setCatchIllegalFormatExceptions(boolean catchIllegalFormatExceptions) {
        this.catchIllegalFormatExceptions = catchIllegalFormatExceptions;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale pLocale) {
        this.locale = pLocale;
    }

    public String getDefaultRS() {
        return this.defaultRS;
    }

    public void setDefaultRS(String rs) {
        this.defaultRS = rs;
    }

    public String getDefaultORS() {
        return this.defaultORS;
    }

    public void setDefaultORS(String ors) {
        this.defaultORS = ors;
    }
}

