/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent;

import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.sentrysoftware.metricshub.agent.context.AgentContext;
import org.sentrysoftware.metricshub.agent.helper.AgentConstants;
import org.sentrysoftware.metricshub.agent.helper.ConfigHelper;
import org.sentrysoftware.metricshub.agent.service.task.FileWatcherTask;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class MetricsHubAgentApplication
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsHubAgentApplication.class);
    @CommandLine.Option(names={"-h", "-?", "--help"}, usageHelp=true, description={"Shows this help message and exits"})
    private boolean usageHelpRequested;
    @CommandLine.Option(names={"-c", "--config"}, usageHelp=false, required=false, description={"Alternate MetricsHub's configuration file"})
    private String alternateConfigFile;

    public static void main(String[] args2) {
        new CommandLine(new MetricsHubAgentApplication()).execute(args2);
    }

    @Override
    public void run() {
        try {
            ExtensionManager extensionManager = ConfigHelper.loadExtensionManager();
            AgentContext agentContext = new AgentContext(this.alternateConfigFile, extensionManager);
            agentContext.getOtelCollectorProcessService().launch();
            agentContext.getTaskSchedulingService().start();
            FileWatcherTask.builder().file(agentContext.getConfigFile()).filter(event -> event.context() != null && agentContext.getConfigFile().getName().equals(event.context().toString())).checksum(ConfigHelper.calculateMD5Checksum(agentContext.getConfigFile())).await(500L).onChange(() -> this.resetContext(agentContext, this.alternateConfigFile)).build().start();
        }
        catch (Exception e) {
            MetricsHubAgentApplication.configureGlobalErrorLogger();
            log.error("Failed to start MetricsHub Agent.", e);
            throw new IllegalStateException("Error dectected during MetricsHub agent startup.", e);
        }
    }

    private synchronized void resetContext(AgentContext agentContext, String alternateConfigFile) {
        try {
            agentContext.getTaskSchedulingService().stop();
            agentContext.getOtelCollectorProcessService().stop();
            agentContext.build(alternateConfigFile, false);
            agentContext.getOtelCollectorProcessService().launch();
            agentContext.getTaskSchedulingService().start();
        }
        catch (Exception e) {
            MetricsHubAgentApplication.configureGlobalErrorLogger();
            log.error("Failed to start MetricsHub Agent.", e);
            throw new IllegalStateException("Error detected during MetricsHub agent startup.", e);
        }
    }

    static void configureGlobalErrorLogger() {
        ThreadContext.put("logId", "metricshub-agent-global-error");
        ThreadContext.put("loggerLevel", Level.ERROR.toString());
        ThreadContext.put("outputDirectory", AgentConstants.DEFAULT_OUTPUT_DIRECTORY.toString());
    }

    @Generated
    public MetricsHubAgentApplication() {
    }

    @Generated
    public boolean isUsageHelpRequested() {
        return this.usageHelpRequested;
    }

    @Generated
    public String getAlternateConfigFile() {
        return this.alternateConfigFile;
    }

    @Generated
    public void setUsageHelpRequested(boolean usageHelpRequested) {
        this.usageHelpRequested = usageHelpRequested;
    }

    @Generated
    public void setAlternateConfigFile(String alternateConfigFile) {
        this.alternateConfigFile = alternateConfigFile;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricsHubAgentApplication)) {
            return false;
        }
        MetricsHubAgentApplication other = (MetricsHubAgentApplication)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUsageHelpRequested() != other.isUsageHelpRequested()) {
            return false;
        }
        String this$alternateConfigFile = this.getAlternateConfigFile();
        String other$alternateConfigFile = other.getAlternateConfigFile();
        return !(this$alternateConfigFile == null ? other$alternateConfigFile != null : !this$alternateConfigFile.equals(other$alternateConfigFile));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetricsHubAgentApplication;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUsageHelpRequested() ? 79 : 97);
        String $alternateConfigFile = this.getAlternateConfigFile();
        result = result * 59 + ($alternateConfigFile == null ? 43 : $alternateConfigFile.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetricsHubAgentApplication(usageHelpRequested=" + this.isUsageHelpRequested() + ", alternateConfigFile=" + this.getAlternateConfigFile() + ")";
    }

    static {
        Locale.setDefault(Locale.US);
    }
}

