/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.sentrysoftware.metricshub.agent.config.AlertingSystemConfig;
import org.sentrysoftware.metricshub.agent.config.ResourceConfig;
import org.sentrysoftware.metricshub.agent.config.ResourceGroupConfig;
import org.sentrysoftware.metricshub.agent.config.otel.OtelCollectorConfig;
import org.sentrysoftware.metricshub.agent.deserialization.AttributesDeserializer;
import org.sentrysoftware.metricshub.agent.helper.AgentConstants;
import org.sentrysoftware.metricshub.agent.helper.OtelSdkConfigConstants;
import org.sentrysoftware.metricshub.engine.deserialization.TimeDeserializer;

public class AgentConfig {
    public static final String PROBLEM_DEFAULT_TEMPLATE = "Problem on ${FQDN} with ${MONITOR_NAME}.${NEWLINE}${NEWLINE}${ALERT_DETAILS}${NEWLINE}${NEWLINE}${FULLREPORT}";
    public static final int DEFAULT_JOB_POOL_SIZE = 20;
    public static final long DEFAULT_COLLECT_PERIOD = 120L;
    public static final int DEFAULT_DISCOVERY_CYCLE = 30;
    private int jobPoolSize;
    @JsonSetter(nulls=Nulls.SKIP)
    private String loggerLevel;
    @JsonSetter(nulls=Nulls.SKIP)
    private String outputDirectory;
    @JsonDeserialize(using=TimeDeserializer.class)
    private long collectPeriod;
    private int discoveryCycle;
    @JsonSetter(nulls=Nulls.SKIP)
    private AlertingSystemConfig alertingSystemConfig;
    private boolean sequential;
    private boolean enableSelfMonitoring;
    private boolean resolveHostnameToFqdn;
    @JsonSetter(nulls=Nulls.SKIP)
    private Set<String> monitorFilters;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=TimeDeserializer.class)
    private long jobTimeout;
    @JsonSetter(nulls=Nulls.SKIP)
    private OtelCollectorConfig otelCollector;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonProperty(value="otel")
    private Map<String, String> otelSdkConfig;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=AttributesDeserializer.class)
    private Map<String, String> attributes;
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, Double> metrics;
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, ResourceConfig> resources;
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, ResourceGroupConfig> resourceGroups;
    @JsonSetter(nulls=Nulls.SKIP)
    private String stateSetCompression;
    @JsonSetter(nulls=Nulls.SKIP)
    private String patchDirectory;

    public static AgentConfig empty() {
        return AgentConfig.builder().build();
    }

    @Generated
    private static int $default$jobPoolSize() {
        return 20;
    }

    @Generated
    private static String $default$loggerLevel() {
        return "error";
    }

    @Generated
    private static String $default$outputDirectory() {
        return AgentConstants.DEFAULT_OUTPUT_DIRECTORY.toString();
    }

    @Generated
    private static long $default$collectPeriod() {
        return 120L;
    }

    @Generated
    private static int $default$discoveryCycle() {
        return 30;
    }

    @Generated
    private static AlertingSystemConfig $default$alertingSystemConfig() {
        return AlertingSystemConfig.builder().build();
    }

    @Generated
    private static boolean $default$enableSelfMonitoring() {
        return true;
    }

    @Generated
    private static long $default$jobTimeout() {
        return 300L;
    }

    @Generated
    private static OtelCollectorConfig $default$otelCollector() {
        return OtelCollectorConfig.builder().build();
    }

    @Generated
    private static Map<String, String> $default$otelSdkConfig() {
        return OtelSdkConfigConstants.DEFAULT_CONFIGURATION;
    }

    @Generated
    private static Map<String, String> $default$attributes() {
        return new HashMap<String, String>();
    }

    @Generated
    private static Map<String, Double> $default$metrics() {
        return new HashMap<String, Double>();
    }

    @Generated
    private static Map<String, ResourceConfig> $default$resources() {
        return new HashMap<String, ResourceConfig>();
    }

    @Generated
    private static Map<String, ResourceGroupConfig> $default$resourceGroups() {
        return new HashMap<String, ResourceGroupConfig>();
    }

    @Generated
    private static String $default$stateSetCompression() {
        return "suppressZeros";
    }

    @Generated
    public static AgentConfigBuilder builder() {
        return new AgentConfigBuilder();
    }

    @Generated
    public int getJobPoolSize() {
        return this.jobPoolSize;
    }

    @Generated
    public String getLoggerLevel() {
        return this.loggerLevel;
    }

    @Generated
    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public long getCollectPeriod() {
        return this.collectPeriod;
    }

    @Generated
    public int getDiscoveryCycle() {
        return this.discoveryCycle;
    }

    @Generated
    public AlertingSystemConfig getAlertingSystemConfig() {
        return this.alertingSystemConfig;
    }

    @Generated
    public boolean isSequential() {
        return this.sequential;
    }

    @Generated
    public boolean isEnableSelfMonitoring() {
        return this.enableSelfMonitoring;
    }

    @Generated
    public boolean isResolveHostnameToFqdn() {
        return this.resolveHostnameToFqdn;
    }

    @Generated
    public Set<String> getMonitorFilters() {
        return this.monitorFilters;
    }

    @Generated
    public long getJobTimeout() {
        return this.jobTimeout;
    }

    @Generated
    public OtelCollectorConfig getOtelCollector() {
        return this.otelCollector;
    }

    @Generated
    public Map<String, String> getOtelSdkConfig() {
        return this.otelSdkConfig;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public Map<String, Double> getMetrics() {
        return this.metrics;
    }

    @Generated
    public Map<String, ResourceConfig> getResources() {
        return this.resources;
    }

    @Generated
    public Map<String, ResourceGroupConfig> getResourceGroups() {
        return this.resourceGroups;
    }

    @Generated
    public String getStateSetCompression() {
        return this.stateSetCompression;
    }

    @Generated
    public String getPatchDirectory() {
        return this.patchDirectory;
    }

    @Generated
    public void setJobPoolSize(int jobPoolSize) {
        this.jobPoolSize = jobPoolSize;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setLoggerLevel(String loggerLevel) {
        this.loggerLevel = loggerLevel;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @JsonDeserialize(using=TimeDeserializer.class)
    @Generated
    public void setCollectPeriod(long collectPeriod) {
        this.collectPeriod = collectPeriod;
    }

    @Generated
    public void setDiscoveryCycle(int discoveryCycle) {
        this.discoveryCycle = discoveryCycle;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setAlertingSystemConfig(AlertingSystemConfig alertingSystemConfig) {
        this.alertingSystemConfig = alertingSystemConfig;
    }

    @Generated
    public void setSequential(boolean sequential) {
        this.sequential = sequential;
    }

    @Generated
    public void setEnableSelfMonitoring(boolean enableSelfMonitoring) {
        this.enableSelfMonitoring = enableSelfMonitoring;
    }

    @Generated
    public void setResolveHostnameToFqdn(boolean resolveHostnameToFqdn) {
        this.resolveHostnameToFqdn = resolveHostnameToFqdn;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setMonitorFilters(Set<String> monitorFilters) {
        this.monitorFilters = monitorFilters;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=TimeDeserializer.class)
    @Generated
    public void setJobTimeout(long jobTimeout) {
        this.jobTimeout = jobTimeout;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setOtelCollector(OtelCollectorConfig otelCollector) {
        this.otelCollector = otelCollector;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonProperty(value="otel")
    @Generated
    public void setOtelSdkConfig(Map<String, String> otelSdkConfig) {
        this.otelSdkConfig = otelSdkConfig;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=AttributesDeserializer.class)
    @Generated
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setMetrics(Map<String, Double> metrics) {
        this.metrics = metrics;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setResources(Map<String, ResourceConfig> resources) {
        this.resources = resources;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setResourceGroups(Map<String, ResourceGroupConfig> resourceGroups) {
        this.resourceGroups = resourceGroups;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setStateSetCompression(String stateSetCompression) {
        this.stateSetCompression = stateSetCompression;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setPatchDirectory(String patchDirectory) {
        this.patchDirectory = patchDirectory;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentConfig)) {
            return false;
        }
        AgentConfig other = (AgentConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getJobPoolSize() != other.getJobPoolSize()) {
            return false;
        }
        if (this.getCollectPeriod() != other.getCollectPeriod()) {
            return false;
        }
        if (this.getDiscoveryCycle() != other.getDiscoveryCycle()) {
            return false;
        }
        if (this.isSequential() != other.isSequential()) {
            return false;
        }
        if (this.isEnableSelfMonitoring() != other.isEnableSelfMonitoring()) {
            return false;
        }
        if (this.isResolveHostnameToFqdn() != other.isResolveHostnameToFqdn()) {
            return false;
        }
        if (this.getJobTimeout() != other.getJobTimeout()) {
            return false;
        }
        String this$loggerLevel = this.getLoggerLevel();
        String other$loggerLevel = other.getLoggerLevel();
        if (this$loggerLevel == null ? other$loggerLevel != null : !this$loggerLevel.equals(other$loggerLevel)) {
            return false;
        }
        String this$outputDirectory = this.getOutputDirectory();
        String other$outputDirectory = other.getOutputDirectory();
        if (this$outputDirectory == null ? other$outputDirectory != null : !this$outputDirectory.equals(other$outputDirectory)) {
            return false;
        }
        AlertingSystemConfig this$alertingSystemConfig = this.getAlertingSystemConfig();
        AlertingSystemConfig other$alertingSystemConfig = other.getAlertingSystemConfig();
        if (this$alertingSystemConfig == null ? other$alertingSystemConfig != null : !((Object)this$alertingSystemConfig).equals(other$alertingSystemConfig)) {
            return false;
        }
        Set<String> this$monitorFilters = this.getMonitorFilters();
        Set<String> other$monitorFilters = other.getMonitorFilters();
        if (this$monitorFilters == null ? other$monitorFilters != null : !((Object)this$monitorFilters).equals(other$monitorFilters)) {
            return false;
        }
        OtelCollectorConfig this$otelCollector = this.getOtelCollector();
        OtelCollectorConfig other$otelCollector = other.getOtelCollector();
        if (this$otelCollector == null ? other$otelCollector != null : !((Object)this$otelCollector).equals(other$otelCollector)) {
            return false;
        }
        Map<String, String> this$otelSdkConfig = this.getOtelSdkConfig();
        Map<String, String> other$otelSdkConfig = other.getOtelSdkConfig();
        if (this$otelSdkConfig == null ? other$otelSdkConfig != null : !((Object)this$otelSdkConfig).equals(other$otelSdkConfig)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Map<String, Double> this$metrics = this.getMetrics();
        Map<String, Double> other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        Map<String, ResourceConfig> this$resources = this.getResources();
        Map<String, ResourceConfig> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Map<String, ResourceGroupConfig> this$resourceGroups = this.getResourceGroups();
        Map<String, ResourceGroupConfig> other$resourceGroups = other.getResourceGroups();
        if (this$resourceGroups == null ? other$resourceGroups != null : !((Object)this$resourceGroups).equals(other$resourceGroups)) {
            return false;
        }
        String this$stateSetCompression = this.getStateSetCompression();
        String other$stateSetCompression = other.getStateSetCompression();
        if (this$stateSetCompression == null ? other$stateSetCompression != null : !this$stateSetCompression.equals(other$stateSetCompression)) {
            return false;
        }
        String this$patchDirectory = this.getPatchDirectory();
        String other$patchDirectory = other.getPatchDirectory();
        return !(this$patchDirectory == null ? other$patchDirectory != null : !this$patchDirectory.equals(other$patchDirectory));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AgentConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getJobPoolSize();
        long $collectPeriod = this.getCollectPeriod();
        result = result * 59 + (int)($collectPeriod >>> 32 ^ $collectPeriod);
        result = result * 59 + this.getDiscoveryCycle();
        result = result * 59 + (this.isSequential() ? 79 : 97);
        result = result * 59 + (this.isEnableSelfMonitoring() ? 79 : 97);
        result = result * 59 + (this.isResolveHostnameToFqdn() ? 79 : 97);
        long $jobTimeout = this.getJobTimeout();
        result = result * 59 + (int)($jobTimeout >>> 32 ^ $jobTimeout);
        String $loggerLevel = this.getLoggerLevel();
        result = result * 59 + ($loggerLevel == null ? 43 : $loggerLevel.hashCode());
        String $outputDirectory = this.getOutputDirectory();
        result = result * 59 + ($outputDirectory == null ? 43 : $outputDirectory.hashCode());
        AlertingSystemConfig $alertingSystemConfig = this.getAlertingSystemConfig();
        result = result * 59 + ($alertingSystemConfig == null ? 43 : ((Object)$alertingSystemConfig).hashCode());
        Set<String> $monitorFilters = this.getMonitorFilters();
        result = result * 59 + ($monitorFilters == null ? 43 : ((Object)$monitorFilters).hashCode());
        OtelCollectorConfig $otelCollector = this.getOtelCollector();
        result = result * 59 + ($otelCollector == null ? 43 : ((Object)$otelCollector).hashCode());
        Map<String, String> $otelSdkConfig = this.getOtelSdkConfig();
        result = result * 59 + ($otelSdkConfig == null ? 43 : ((Object)$otelSdkConfig).hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Map<String, Double> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        Map<String, ResourceConfig> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Map<String, ResourceGroupConfig> $resourceGroups = this.getResourceGroups();
        result = result * 59 + ($resourceGroups == null ? 43 : ((Object)$resourceGroups).hashCode());
        String $stateSetCompression = this.getStateSetCompression();
        result = result * 59 + ($stateSetCompression == null ? 43 : $stateSetCompression.hashCode());
        String $patchDirectory = this.getPatchDirectory();
        result = result * 59 + ($patchDirectory == null ? 43 : $patchDirectory.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AgentConfig(jobPoolSize=" + this.getJobPoolSize() + ", loggerLevel=" + this.getLoggerLevel() + ", outputDirectory=" + this.getOutputDirectory() + ", collectPeriod=" + this.getCollectPeriod() + ", discoveryCycle=" + this.getDiscoveryCycle() + ", alertingSystemConfig=" + String.valueOf(this.getAlertingSystemConfig()) + ", sequential=" + this.isSequential() + ", enableSelfMonitoring=" + this.isEnableSelfMonitoring() + ", resolveHostnameToFqdn=" + this.isResolveHostnameToFqdn() + ", monitorFilters=" + String.valueOf(this.getMonitorFilters()) + ", jobTimeout=" + this.getJobTimeout() + ", otelCollector=" + String.valueOf(this.getOtelCollector()) + ", otelSdkConfig=" + String.valueOf(this.getOtelSdkConfig()) + ", attributes=" + String.valueOf(this.getAttributes()) + ", metrics=" + String.valueOf(this.getMetrics()) + ", resources=" + String.valueOf(this.getResources()) + ", resourceGroups=" + String.valueOf(this.getResourceGroups()) + ", stateSetCompression=" + this.getStateSetCompression() + ", patchDirectory=" + this.getPatchDirectory() + ")";
    }

    @Generated
    public AgentConfig(int jobPoolSize, String loggerLevel, String outputDirectory, long collectPeriod, int discoveryCycle, AlertingSystemConfig alertingSystemConfig, boolean sequential, boolean enableSelfMonitoring, boolean resolveHostnameToFqdn, Set<String> monitorFilters, long jobTimeout, OtelCollectorConfig otelCollector, Map<String, String> otelSdkConfig, Map<String, String> attributes, Map<String, Double> metrics, Map<String, ResourceConfig> resources, Map<String, ResourceGroupConfig> resourceGroups, String stateSetCompression, String patchDirectory) {
        this.jobPoolSize = jobPoolSize;
        this.loggerLevel = loggerLevel;
        this.outputDirectory = outputDirectory;
        this.collectPeriod = collectPeriod;
        this.discoveryCycle = discoveryCycle;
        this.alertingSystemConfig = alertingSystemConfig;
        this.sequential = sequential;
        this.enableSelfMonitoring = enableSelfMonitoring;
        this.resolveHostnameToFqdn = resolveHostnameToFqdn;
        this.monitorFilters = monitorFilters;
        this.jobTimeout = jobTimeout;
        this.otelCollector = otelCollector;
        this.otelSdkConfig = otelSdkConfig;
        this.attributes = attributes;
        this.metrics = metrics;
        this.resources = resources;
        this.resourceGroups = resourceGroups;
        this.stateSetCompression = stateSetCompression;
        this.patchDirectory = patchDirectory;
    }

    @Generated
    public AgentConfig() {
        this.jobPoolSize = AgentConfig.$default$jobPoolSize();
        this.loggerLevel = AgentConfig.$default$loggerLevel();
        this.outputDirectory = AgentConfig.$default$outputDirectory();
        this.collectPeriod = AgentConfig.$default$collectPeriod();
        this.discoveryCycle = AgentConfig.$default$discoveryCycle();
        this.alertingSystemConfig = AgentConfig.$default$alertingSystemConfig();
        this.enableSelfMonitoring = AgentConfig.$default$enableSelfMonitoring();
        this.jobTimeout = AgentConfig.$default$jobTimeout();
        this.otelCollector = AgentConfig.$default$otelCollector();
        this.otelSdkConfig = AgentConfig.$default$otelSdkConfig();
        this.attributes = AgentConfig.$default$attributes();
        this.metrics = AgentConfig.$default$metrics();
        this.resources = AgentConfig.$default$resources();
        this.resourceGroups = AgentConfig.$default$resourceGroups();
        this.stateSetCompression = AgentConfig.$default$stateSetCompression();
    }

    @Generated
    public static class AgentConfigBuilder {
        @Generated
        private boolean jobPoolSize$set;
        @Generated
        private int jobPoolSize$value;
        @Generated
        private boolean loggerLevel$set;
        @Generated
        private String loggerLevel$value;
        @Generated
        private boolean outputDirectory$set;
        @Generated
        private String outputDirectory$value;
        @Generated
        private boolean collectPeriod$set;
        @Generated
        private long collectPeriod$value;
        @Generated
        private boolean discoveryCycle$set;
        @Generated
        private int discoveryCycle$value;
        @Generated
        private boolean alertingSystemConfig$set;
        @Generated
        private AlertingSystemConfig alertingSystemConfig$value;
        @Generated
        private boolean sequential;
        @Generated
        private boolean enableSelfMonitoring$set;
        @Generated
        private boolean enableSelfMonitoring$value;
        @Generated
        private boolean resolveHostnameToFqdn;
        @Generated
        private Set<String> monitorFilters;
        @Generated
        private boolean jobTimeout$set;
        @Generated
        private long jobTimeout$value;
        @Generated
        private boolean otelCollector$set;
        @Generated
        private OtelCollectorConfig otelCollector$value;
        @Generated
        private boolean otelSdkConfig$set;
        @Generated
        private Map<String, String> otelSdkConfig$value;
        @Generated
        private boolean attributes$set;
        @Generated
        private Map<String, String> attributes$value;
        @Generated
        private boolean metrics$set;
        @Generated
        private Map<String, Double> metrics$value;
        @Generated
        private boolean resources$set;
        @Generated
        private Map<String, ResourceConfig> resources$value;
        @Generated
        private boolean resourceGroups$set;
        @Generated
        private Map<String, ResourceGroupConfig> resourceGroups$value;
        @Generated
        private boolean stateSetCompression$set;
        @Generated
        private String stateSetCompression$value;
        @Generated
        private String patchDirectory;

        @Generated
        AgentConfigBuilder() {
        }

        @Generated
        public AgentConfigBuilder jobPoolSize(int jobPoolSize) {
            this.jobPoolSize$value = jobPoolSize;
            this.jobPoolSize$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public AgentConfigBuilder loggerLevel(String loggerLevel) {
            this.loggerLevel$value = loggerLevel;
            this.loggerLevel$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public AgentConfigBuilder outputDirectory(String outputDirectory) {
            this.outputDirectory$value = outputDirectory;
            this.outputDirectory$set = true;
            return this;
        }

        @JsonDeserialize(using=TimeDeserializer.class)
        @Generated
        public AgentConfigBuilder collectPeriod(long collectPeriod) {
            this.collectPeriod$value = collectPeriod;
            this.collectPeriod$set = true;
            return this;
        }

        @Generated
        public AgentConfigBuilder discoveryCycle(int discoveryCycle) {
            this.discoveryCycle$value = discoveryCycle;
            this.discoveryCycle$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public AgentConfigBuilder alertingSystemConfig(AlertingSystemConfig alertingSystemConfig) {
            this.alertingSystemConfig$value = alertingSystemConfig;
            this.alertingSystemConfig$set = true;
            return this;
        }

        @Generated
        public AgentConfigBuilder sequential(boolean sequential) {
            this.sequential = sequential;
            return this;
        }

        @Generated
        public AgentConfigBuilder enableSelfMonitoring(boolean enableSelfMonitoring) {
            this.enableSelfMonitoring$value = enableSelfMonitoring;
            this.enableSelfMonitoring$set = true;
            return this;
        }

        @Generated
        public AgentConfigBuilder resolveHostnameToFqdn(boolean resolveHostnameToFqdn) {
            this.resolveHostnameToFqdn = resolveHostnameToFqdn;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public AgentConfigBuilder monitorFilters(Set<String> monitorFilters) {
            this.monitorFilters = monitorFilters;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=TimeDeserializer.class)
        @Generated
        public AgentConfigBuilder jobTimeout(long jobTimeout) {
            this.jobTimeout$value = jobTimeout;
            this.jobTimeout$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public AgentConfigBuilder otelCollector(OtelCollectorConfig otelCollector) {
            this.otelCollector$value = otelCollector;
            this.otelCollector$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonProperty(value="otel")
        @Generated
        public AgentConfigBuilder otelSdkConfig(Map<String, String> otelSdkConfig) {
            this.otelSdkConfig$value = otelSdkConfig;
            this.otelSdkConfig$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=AttributesDeserializer.class)
        @Generated
        public AgentConfigBuilder attributes(Map<String, String> attributes) {
            this.attributes$value = attributes;
            this.attributes$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public AgentConfigBuilder metrics(Map<String, Double> metrics) {
            this.metrics$value = metrics;
            this.metrics$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public AgentConfigBuilder resources(Map<String, ResourceConfig> resources) {
            this.resources$value = resources;
            this.resources$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public AgentConfigBuilder resourceGroups(Map<String, ResourceGroupConfig> resourceGroups) {
            this.resourceGroups$value = resourceGroups;
            this.resourceGroups$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public AgentConfigBuilder stateSetCompression(String stateSetCompression) {
            this.stateSetCompression$value = stateSetCompression;
            this.stateSetCompression$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public AgentConfigBuilder patchDirectory(String patchDirectory) {
            this.patchDirectory = patchDirectory;
            return this;
        }

        @Generated
        public AgentConfig build() {
            int jobPoolSize$value = this.jobPoolSize$value;
            if (!this.jobPoolSize$set) {
                jobPoolSize$value = AgentConfig.$default$jobPoolSize();
            }
            String loggerLevel$value = this.loggerLevel$value;
            if (!this.loggerLevel$set) {
                loggerLevel$value = AgentConfig.$default$loggerLevel();
            }
            String outputDirectory$value = this.outputDirectory$value;
            if (!this.outputDirectory$set) {
                outputDirectory$value = AgentConfig.$default$outputDirectory();
            }
            long collectPeriod$value = this.collectPeriod$value;
            if (!this.collectPeriod$set) {
                collectPeriod$value = AgentConfig.$default$collectPeriod();
            }
            int discoveryCycle$value = this.discoveryCycle$value;
            if (!this.discoveryCycle$set) {
                discoveryCycle$value = AgentConfig.$default$discoveryCycle();
            }
            AlertingSystemConfig alertingSystemConfig$value = this.alertingSystemConfig$value;
            if (!this.alertingSystemConfig$set) {
                alertingSystemConfig$value = AgentConfig.$default$alertingSystemConfig();
            }
            boolean enableSelfMonitoring$value = this.enableSelfMonitoring$value;
            if (!this.enableSelfMonitoring$set) {
                enableSelfMonitoring$value = AgentConfig.$default$enableSelfMonitoring();
            }
            long jobTimeout$value = this.jobTimeout$value;
            if (!this.jobTimeout$set) {
                jobTimeout$value = AgentConfig.$default$jobTimeout();
            }
            OtelCollectorConfig otelCollector$value = this.otelCollector$value;
            if (!this.otelCollector$set) {
                otelCollector$value = AgentConfig.$default$otelCollector();
            }
            Map<String, String> otelSdkConfig$value = this.otelSdkConfig$value;
            if (!this.otelSdkConfig$set) {
                otelSdkConfig$value = AgentConfig.$default$otelSdkConfig();
            }
            Map<String, String> attributes$value = this.attributes$value;
            if (!this.attributes$set) {
                attributes$value = AgentConfig.$default$attributes();
            }
            Map<String, Double> metrics$value = this.metrics$value;
            if (!this.metrics$set) {
                metrics$value = AgentConfig.$default$metrics();
            }
            Map<String, ResourceConfig> resources$value = this.resources$value;
            if (!this.resources$set) {
                resources$value = AgentConfig.$default$resources();
            }
            Map<String, ResourceGroupConfig> resourceGroups$value = this.resourceGroups$value;
            if (!this.resourceGroups$set) {
                resourceGroups$value = AgentConfig.$default$resourceGroups();
            }
            String stateSetCompression$value = this.stateSetCompression$value;
            if (!this.stateSetCompression$set) {
                stateSetCompression$value = AgentConfig.$default$stateSetCompression();
            }
            return new AgentConfig(jobPoolSize$value, loggerLevel$value, outputDirectory$value, collectPeriod$value, discoveryCycle$value, alertingSystemConfig$value, this.sequential, enableSelfMonitoring$value, this.resolveHostnameToFqdn, this.monitorFilters, jobTimeout$value, otelCollector$value, otelSdkConfig$value, attributes$value, metrics$value, resources$value, resourceGroups$value, stateSetCompression$value, this.patchDirectory);
        }

        @Generated
        public String toString() {
            return "AgentConfig.AgentConfigBuilder(jobPoolSize$value=" + this.jobPoolSize$value + ", loggerLevel$value=" + this.loggerLevel$value + ", outputDirectory$value=" + this.outputDirectory$value + ", collectPeriod$value=" + this.collectPeriod$value + ", discoveryCycle$value=" + this.discoveryCycle$value + ", alertingSystemConfig$value=" + String.valueOf(this.alertingSystemConfig$value) + ", sequential=" + this.sequential + ", enableSelfMonitoring$value=" + this.enableSelfMonitoring$value + ", resolveHostnameToFqdn=" + this.resolveHostnameToFqdn + ", monitorFilters=" + String.valueOf(this.monitorFilters) + ", jobTimeout$value=" + this.jobTimeout$value + ", otelCollector$value=" + String.valueOf(this.otelCollector$value) + ", otelSdkConfig$value=" + String.valueOf(this.otelSdkConfig$value) + ", attributes$value=" + String.valueOf(this.attributes$value) + ", metrics$value=" + String.valueOf(this.metrics$value) + ", resources$value=" + String.valueOf(this.resources$value) + ", resourceGroups$value=" + String.valueOf(this.resourceGroups$value) + ", stateSetCompression$value=" + this.stateSetCompression$value + ", patchDirectory=" + this.patchDirectory + ")";
        }
    }
}

