/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.sentrysoftware.metricshub.agent.config.AdditionalConnector;
import org.sentrysoftware.metricshub.agent.config.AlertingSystemConfig;
import org.sentrysoftware.metricshub.agent.deserialization.AttributesDeserializer;
import org.sentrysoftware.metricshub.agent.deserialization.ExtensionProtocolsDeserializer;
import org.sentrysoftware.metricshub.agent.deserialization.MonitorJobsDeserializer;
import org.sentrysoftware.metricshub.engine.configuration.ConnectorVariables;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.MonitorJob;
import org.sentrysoftware.metricshub.engine.deserialization.TimeDeserializer;

public class ResourceConfig {
    private String loggerLevel;
    private String outputDirectory;
    @JsonDeserialize(using=TimeDeserializer.class)
    private Long collectPeriod;
    private Integer discoveryCycle;
    private AlertingSystemConfig alertingSystemConfig;
    private Boolean sequential;
    private Boolean enableSelfMonitoring;
    private Boolean resolveHostnameToFqdn;
    @JsonSetter(nulls=Nulls.SKIP)
    private Set<String> monitorFilters;
    @JsonDeserialize(using=TimeDeserializer.class)
    private Long jobTimeout;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=AttributesDeserializer.class)
    private Map<String, String> attributes;
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, Double> metrics;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=ExtensionProtocolsDeserializer.class)
    private Map<String, IConfiguration> protocols;
    @JsonSetter(nulls=Nulls.SKIP)
    private Set<String> connectors;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MonitorJobsDeserializer.class)
    private Map<String, MonitorJob> monitors;
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, AdditionalConnector> additionalConnectors;
    @JsonIgnore
    private Connector connector;
    private String stateSetCompression;

    public ResourceConfig copy() {
        return ResourceConfig.builder().loggerLevel(this.loggerLevel).outputDirectory(this.outputDirectory).collectPeriod(this.collectPeriod).discoveryCycle(this.discoveryCycle).alertingSystemConfig(this.alertingSystemConfig).sequential(this.sequential).enableSelfMonitoring(this.enableSelfMonitoring).monitorFilters(this.monitorFilters).resolveHostnameToFqdn(this.resolveHostnameToFqdn).jobTimeout(this.jobTimeout).attributes(this.attributes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, HashMap::new))).metrics(this.metrics).protocols(this.protocols.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((IConfiguration)entry.getValue()).copy()))).additionalConnectors(this.additionalConnectors).connectors(this.connectors).connector(this.connector).stateSetCompression(this.stateSetCompression).build();
    }

    public Map<String, ConnectorVariables> getConnectorVariables() {
        return Optional.ofNullable(this.additionalConnectors).map(map -> map.entrySet().stream().filter(entry -> entry.getValue() != null && ((AdditionalConnector)entry.getValue()).getVariables() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> new ConnectorVariables(new HashMap<String, String>(((AdditionalConnector)entry.getValue()).getVariables()))))).orElseGet(Collections::emptyMap);
    }

    @Generated
    private static Map<String, String> $default$attributes() {
        return new HashMap<String, String>();
    }

    @Generated
    private static Map<String, Double> $default$metrics() {
        return new HashMap<String, Double>();
    }

    @Generated
    private static Map<String, IConfiguration> $default$protocols() {
        return new HashMap<String, IConfiguration>();
    }

    @Generated
    private static Set<String> $default$connectors() {
        return new HashSet<String>();
    }

    @Generated
    private static Map<String, MonitorJob> $default$monitors() {
        return new HashMap<String, MonitorJob>();
    }

    @Generated
    private static Map<String, AdditionalConnector> $default$additionalConnectors() {
        return new TreeMap<String, AdditionalConnector>(String.CASE_INSENSITIVE_ORDER);
    }

    @Generated
    public static ResourceConfigBuilder builder() {
        return new ResourceConfigBuilder();
    }

    @Generated
    public String getLoggerLevel() {
        return this.loggerLevel;
    }

    @Generated
    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public Long getCollectPeriod() {
        return this.collectPeriod;
    }

    @Generated
    public Integer getDiscoveryCycle() {
        return this.discoveryCycle;
    }

    @Generated
    public AlertingSystemConfig getAlertingSystemConfig() {
        return this.alertingSystemConfig;
    }

    @Generated
    public Boolean getSequential() {
        return this.sequential;
    }

    @Generated
    public Boolean getEnableSelfMonitoring() {
        return this.enableSelfMonitoring;
    }

    @Generated
    public Boolean getResolveHostnameToFqdn() {
        return this.resolveHostnameToFqdn;
    }

    @Generated
    public Set<String> getMonitorFilters() {
        return this.monitorFilters;
    }

    @Generated
    public Long getJobTimeout() {
        return this.jobTimeout;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public Map<String, Double> getMetrics() {
        return this.metrics;
    }

    @Generated
    public Map<String, IConfiguration> getProtocols() {
        return this.protocols;
    }

    @Generated
    public Set<String> getConnectors() {
        return this.connectors;
    }

    @Generated
    public Map<String, MonitorJob> getMonitors() {
        return this.monitors;
    }

    @Generated
    public Map<String, AdditionalConnector> getAdditionalConnectors() {
        return this.additionalConnectors;
    }

    @Generated
    public Connector getConnector() {
        return this.connector;
    }

    @Generated
    public String getStateSetCompression() {
        return this.stateSetCompression;
    }

    @Generated
    public void setLoggerLevel(String loggerLevel) {
        this.loggerLevel = loggerLevel;
    }

    @Generated
    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @JsonDeserialize(using=TimeDeserializer.class)
    @Generated
    public void setCollectPeriod(Long collectPeriod) {
        this.collectPeriod = collectPeriod;
    }

    @Generated
    public void setDiscoveryCycle(Integer discoveryCycle) {
        this.discoveryCycle = discoveryCycle;
    }

    @Generated
    public void setAlertingSystemConfig(AlertingSystemConfig alertingSystemConfig) {
        this.alertingSystemConfig = alertingSystemConfig;
    }

    @Generated
    public void setSequential(Boolean sequential) {
        this.sequential = sequential;
    }

    @Generated
    public void setEnableSelfMonitoring(Boolean enableSelfMonitoring) {
        this.enableSelfMonitoring = enableSelfMonitoring;
    }

    @Generated
    public void setResolveHostnameToFqdn(Boolean resolveHostnameToFqdn) {
        this.resolveHostnameToFqdn = resolveHostnameToFqdn;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setMonitorFilters(Set<String> monitorFilters) {
        this.monitorFilters = monitorFilters;
    }

    @JsonDeserialize(using=TimeDeserializer.class)
    @Generated
    public void setJobTimeout(Long jobTimeout) {
        this.jobTimeout = jobTimeout;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=AttributesDeserializer.class)
    @Generated
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setMetrics(Map<String, Double> metrics) {
        this.metrics = metrics;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=ExtensionProtocolsDeserializer.class)
    @Generated
    public void setProtocols(Map<String, IConfiguration> protocols) {
        this.protocols = protocols;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setConnectors(Set<String> connectors) {
        this.connectors = connectors;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MonitorJobsDeserializer.class)
    @Generated
    public void setMonitors(Map<String, MonitorJob> monitors) {
        this.monitors = monitors;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setAdditionalConnectors(Map<String, AdditionalConnector> additionalConnectors) {
        this.additionalConnectors = additionalConnectors;
    }

    @JsonIgnore
    @Generated
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Generated
    public void setStateSetCompression(String stateSetCompression) {
        this.stateSetCompression = stateSetCompression;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceConfig)) {
            return false;
        }
        ResourceConfig other = (ResourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$collectPeriod = this.getCollectPeriod();
        Long other$collectPeriod = other.getCollectPeriod();
        if (this$collectPeriod == null ? other$collectPeriod != null : !((Object)this$collectPeriod).equals(other$collectPeriod)) {
            return false;
        }
        Integer this$discoveryCycle = this.getDiscoveryCycle();
        Integer other$discoveryCycle = other.getDiscoveryCycle();
        if (this$discoveryCycle == null ? other$discoveryCycle != null : !((Object)this$discoveryCycle).equals(other$discoveryCycle)) {
            return false;
        }
        Boolean this$sequential = this.getSequential();
        Boolean other$sequential = other.getSequential();
        if (this$sequential == null ? other$sequential != null : !((Object)this$sequential).equals(other$sequential)) {
            return false;
        }
        Boolean this$enableSelfMonitoring = this.getEnableSelfMonitoring();
        Boolean other$enableSelfMonitoring = other.getEnableSelfMonitoring();
        if (this$enableSelfMonitoring == null ? other$enableSelfMonitoring != null : !((Object)this$enableSelfMonitoring).equals(other$enableSelfMonitoring)) {
            return false;
        }
        Boolean this$resolveHostnameToFqdn = this.getResolveHostnameToFqdn();
        Boolean other$resolveHostnameToFqdn = other.getResolveHostnameToFqdn();
        if (this$resolveHostnameToFqdn == null ? other$resolveHostnameToFqdn != null : !((Object)this$resolveHostnameToFqdn).equals(other$resolveHostnameToFqdn)) {
            return false;
        }
        Long this$jobTimeout = this.getJobTimeout();
        Long other$jobTimeout = other.getJobTimeout();
        if (this$jobTimeout == null ? other$jobTimeout != null : !((Object)this$jobTimeout).equals(other$jobTimeout)) {
            return false;
        }
        String this$loggerLevel = this.getLoggerLevel();
        String other$loggerLevel = other.getLoggerLevel();
        if (this$loggerLevel == null ? other$loggerLevel != null : !this$loggerLevel.equals(other$loggerLevel)) {
            return false;
        }
        String this$outputDirectory = this.getOutputDirectory();
        String other$outputDirectory = other.getOutputDirectory();
        if (this$outputDirectory == null ? other$outputDirectory != null : !this$outputDirectory.equals(other$outputDirectory)) {
            return false;
        }
        AlertingSystemConfig this$alertingSystemConfig = this.getAlertingSystemConfig();
        AlertingSystemConfig other$alertingSystemConfig = other.getAlertingSystemConfig();
        if (this$alertingSystemConfig == null ? other$alertingSystemConfig != null : !((Object)this$alertingSystemConfig).equals(other$alertingSystemConfig)) {
            return false;
        }
        Set<String> this$monitorFilters = this.getMonitorFilters();
        Set<String> other$monitorFilters = other.getMonitorFilters();
        if (this$monitorFilters == null ? other$monitorFilters != null : !((Object)this$monitorFilters).equals(other$monitorFilters)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Map<String, Double> this$metrics = this.getMetrics();
        Map<String, Double> other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        Map<String, IConfiguration> this$protocols = this.getProtocols();
        Map<String, IConfiguration> other$protocols = other.getProtocols();
        if (this$protocols == null ? other$protocols != null : !((Object)this$protocols).equals(other$protocols)) {
            return false;
        }
        Set<String> this$connectors = this.getConnectors();
        Set<String> other$connectors = other.getConnectors();
        if (this$connectors == null ? other$connectors != null : !((Object)this$connectors).equals(other$connectors)) {
            return false;
        }
        Map<String, MonitorJob> this$monitors = this.getMonitors();
        Map<String, MonitorJob> other$monitors = other.getMonitors();
        if (this$monitors == null ? other$monitors != null : !((Object)this$monitors).equals(other$monitors)) {
            return false;
        }
        Map<String, AdditionalConnector> this$additionalConnectors = this.getAdditionalConnectors();
        Map<String, AdditionalConnector> other$additionalConnectors = other.getAdditionalConnectors();
        if (this$additionalConnectors == null ? other$additionalConnectors != null : !((Object)this$additionalConnectors).equals(other$additionalConnectors)) {
            return false;
        }
        Connector this$connector = this.getConnector();
        Connector other$connector = other.getConnector();
        if (this$connector == null ? other$connector != null : !((Object)this$connector).equals(other$connector)) {
            return false;
        }
        String this$stateSetCompression = this.getStateSetCompression();
        String other$stateSetCompression = other.getStateSetCompression();
        return !(this$stateSetCompression == null ? other$stateSetCompression != null : !this$stateSetCompression.equals(other$stateSetCompression));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResourceConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $collectPeriod = this.getCollectPeriod();
        result = result * 59 + ($collectPeriod == null ? 43 : ((Object)$collectPeriod).hashCode());
        Integer $discoveryCycle = this.getDiscoveryCycle();
        result = result * 59 + ($discoveryCycle == null ? 43 : ((Object)$discoveryCycle).hashCode());
        Boolean $sequential = this.getSequential();
        result = result * 59 + ($sequential == null ? 43 : ((Object)$sequential).hashCode());
        Boolean $enableSelfMonitoring = this.getEnableSelfMonitoring();
        result = result * 59 + ($enableSelfMonitoring == null ? 43 : ((Object)$enableSelfMonitoring).hashCode());
        Boolean $resolveHostnameToFqdn = this.getResolveHostnameToFqdn();
        result = result * 59 + ($resolveHostnameToFqdn == null ? 43 : ((Object)$resolveHostnameToFqdn).hashCode());
        Long $jobTimeout = this.getJobTimeout();
        result = result * 59 + ($jobTimeout == null ? 43 : ((Object)$jobTimeout).hashCode());
        String $loggerLevel = this.getLoggerLevel();
        result = result * 59 + ($loggerLevel == null ? 43 : $loggerLevel.hashCode());
        String $outputDirectory = this.getOutputDirectory();
        result = result * 59 + ($outputDirectory == null ? 43 : $outputDirectory.hashCode());
        AlertingSystemConfig $alertingSystemConfig = this.getAlertingSystemConfig();
        result = result * 59 + ($alertingSystemConfig == null ? 43 : ((Object)$alertingSystemConfig).hashCode());
        Set<String> $monitorFilters = this.getMonitorFilters();
        result = result * 59 + ($monitorFilters == null ? 43 : ((Object)$monitorFilters).hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Map<String, Double> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        Map<String, IConfiguration> $protocols = this.getProtocols();
        result = result * 59 + ($protocols == null ? 43 : ((Object)$protocols).hashCode());
        Set<String> $connectors = this.getConnectors();
        result = result * 59 + ($connectors == null ? 43 : ((Object)$connectors).hashCode());
        Map<String, MonitorJob> $monitors = this.getMonitors();
        result = result * 59 + ($monitors == null ? 43 : ((Object)$monitors).hashCode());
        Map<String, AdditionalConnector> $additionalConnectors = this.getAdditionalConnectors();
        result = result * 59 + ($additionalConnectors == null ? 43 : ((Object)$additionalConnectors).hashCode());
        Connector $connector = this.getConnector();
        result = result * 59 + ($connector == null ? 43 : ((Object)$connector).hashCode());
        String $stateSetCompression = this.getStateSetCompression();
        result = result * 59 + ($stateSetCompression == null ? 43 : $stateSetCompression.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResourceConfig(loggerLevel=" + this.getLoggerLevel() + ", outputDirectory=" + this.getOutputDirectory() + ", collectPeriod=" + this.getCollectPeriod() + ", discoveryCycle=" + this.getDiscoveryCycle() + ", alertingSystemConfig=" + String.valueOf(this.getAlertingSystemConfig()) + ", sequential=" + this.getSequential() + ", enableSelfMonitoring=" + this.getEnableSelfMonitoring() + ", resolveHostnameToFqdn=" + this.getResolveHostnameToFqdn() + ", monitorFilters=" + String.valueOf(this.getMonitorFilters()) + ", jobTimeout=" + this.getJobTimeout() + ", attributes=" + String.valueOf(this.getAttributes()) + ", metrics=" + String.valueOf(this.getMetrics()) + ", protocols=" + String.valueOf(this.getProtocols()) + ", connectors=" + String.valueOf(this.getConnectors()) + ", monitors=" + String.valueOf(this.getMonitors()) + ", additionalConnectors=" + String.valueOf(this.getAdditionalConnectors()) + ", connector=" + String.valueOf(this.getConnector()) + ", stateSetCompression=" + this.getStateSetCompression() + ")";
    }

    @Generated
    public ResourceConfig(String loggerLevel, String outputDirectory, Long collectPeriod, Integer discoveryCycle, AlertingSystemConfig alertingSystemConfig, Boolean sequential, Boolean enableSelfMonitoring, Boolean resolveHostnameToFqdn, Set<String> monitorFilters, Long jobTimeout, Map<String, String> attributes, Map<String, Double> metrics, Map<String, IConfiguration> protocols, Set<String> connectors, Map<String, MonitorJob> monitors, Map<String, AdditionalConnector> additionalConnectors, Connector connector, String stateSetCompression) {
        this.loggerLevel = loggerLevel;
        this.outputDirectory = outputDirectory;
        this.collectPeriod = collectPeriod;
        this.discoveryCycle = discoveryCycle;
        this.alertingSystemConfig = alertingSystemConfig;
        this.sequential = sequential;
        this.enableSelfMonitoring = enableSelfMonitoring;
        this.resolveHostnameToFqdn = resolveHostnameToFqdn;
        this.monitorFilters = monitorFilters;
        this.jobTimeout = jobTimeout;
        this.attributes = attributes;
        this.metrics = metrics;
        this.protocols = protocols;
        this.connectors = connectors;
        this.monitors = monitors;
        this.additionalConnectors = additionalConnectors;
        this.connector = connector;
        this.stateSetCompression = stateSetCompression;
    }

    @Generated
    public ResourceConfig() {
        this.attributes = ResourceConfig.$default$attributes();
        this.metrics = ResourceConfig.$default$metrics();
        this.protocols = ResourceConfig.$default$protocols();
        this.connectors = ResourceConfig.$default$connectors();
        this.monitors = ResourceConfig.$default$monitors();
        this.additionalConnectors = ResourceConfig.$default$additionalConnectors();
    }

    @Generated
    public static class ResourceConfigBuilder {
        @Generated
        private String loggerLevel;
        @Generated
        private String outputDirectory;
        @Generated
        private Long collectPeriod;
        @Generated
        private Integer discoveryCycle;
        @Generated
        private AlertingSystemConfig alertingSystemConfig;
        @Generated
        private Boolean sequential;
        @Generated
        private Boolean enableSelfMonitoring;
        @Generated
        private Boolean resolveHostnameToFqdn;
        @Generated
        private Set<String> monitorFilters;
        @Generated
        private Long jobTimeout;
        @Generated
        private boolean attributes$set;
        @Generated
        private Map<String, String> attributes$value;
        @Generated
        private boolean metrics$set;
        @Generated
        private Map<String, Double> metrics$value;
        @Generated
        private boolean protocols$set;
        @Generated
        private Map<String, IConfiguration> protocols$value;
        @Generated
        private boolean connectors$set;
        @Generated
        private Set<String> connectors$value;
        @Generated
        private boolean monitors$set;
        @Generated
        private Map<String, MonitorJob> monitors$value;
        @Generated
        private boolean additionalConnectors$set;
        @Generated
        private Map<String, AdditionalConnector> additionalConnectors$value;
        @Generated
        private Connector connector;
        @Generated
        private String stateSetCompression;

        @Generated
        ResourceConfigBuilder() {
        }

        @Generated
        public ResourceConfigBuilder loggerLevel(String loggerLevel) {
            this.loggerLevel = loggerLevel;
            return this;
        }

        @Generated
        public ResourceConfigBuilder outputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @JsonDeserialize(using=TimeDeserializer.class)
        @Generated
        public ResourceConfigBuilder collectPeriod(Long collectPeriod) {
            this.collectPeriod = collectPeriod;
            return this;
        }

        @Generated
        public ResourceConfigBuilder discoveryCycle(Integer discoveryCycle) {
            this.discoveryCycle = discoveryCycle;
            return this;
        }

        @Generated
        public ResourceConfigBuilder alertingSystemConfig(AlertingSystemConfig alertingSystemConfig) {
            this.alertingSystemConfig = alertingSystemConfig;
            return this;
        }

        @Generated
        public ResourceConfigBuilder sequential(Boolean sequential) {
            this.sequential = sequential;
            return this;
        }

        @Generated
        public ResourceConfigBuilder enableSelfMonitoring(Boolean enableSelfMonitoring) {
            this.enableSelfMonitoring = enableSelfMonitoring;
            return this;
        }

        @Generated
        public ResourceConfigBuilder resolveHostnameToFqdn(Boolean resolveHostnameToFqdn) {
            this.resolveHostnameToFqdn = resolveHostnameToFqdn;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public ResourceConfigBuilder monitorFilters(Set<String> monitorFilters) {
            this.monitorFilters = monitorFilters;
            return this;
        }

        @JsonDeserialize(using=TimeDeserializer.class)
        @Generated
        public ResourceConfigBuilder jobTimeout(Long jobTimeout) {
            this.jobTimeout = jobTimeout;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=AttributesDeserializer.class)
        @Generated
        public ResourceConfigBuilder attributes(Map<String, String> attributes) {
            this.attributes$value = attributes;
            this.attributes$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public ResourceConfigBuilder metrics(Map<String, Double> metrics) {
            this.metrics$value = metrics;
            this.metrics$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=ExtensionProtocolsDeserializer.class)
        @Generated
        public ResourceConfigBuilder protocols(Map<String, IConfiguration> protocols) {
            this.protocols$value = protocols;
            this.protocols$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public ResourceConfigBuilder connectors(Set<String> connectors) {
            this.connectors$value = connectors;
            this.connectors$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=MonitorJobsDeserializer.class)
        @Generated
        public ResourceConfigBuilder monitors(Map<String, MonitorJob> monitors) {
            this.monitors$value = monitors;
            this.monitors$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public ResourceConfigBuilder additionalConnectors(Map<String, AdditionalConnector> additionalConnectors) {
            this.additionalConnectors$value = additionalConnectors;
            this.additionalConnectors$set = true;
            return this;
        }

        @JsonIgnore
        @Generated
        public ResourceConfigBuilder connector(Connector connector) {
            this.connector = connector;
            return this;
        }

        @Generated
        public ResourceConfigBuilder stateSetCompression(String stateSetCompression) {
            this.stateSetCompression = stateSetCompression;
            return this;
        }

        @Generated
        public ResourceConfig build() {
            Map<String, String> attributes$value = this.attributes$value;
            if (!this.attributes$set) {
                attributes$value = ResourceConfig.$default$attributes();
            }
            Map<String, Double> metrics$value = this.metrics$value;
            if (!this.metrics$set) {
                metrics$value = ResourceConfig.$default$metrics();
            }
            Map<String, IConfiguration> protocols$value = this.protocols$value;
            if (!this.protocols$set) {
                protocols$value = ResourceConfig.$default$protocols();
            }
            Set<String> connectors$value = this.connectors$value;
            if (!this.connectors$set) {
                connectors$value = ResourceConfig.$default$connectors();
            }
            Map<String, MonitorJob> monitors$value = this.monitors$value;
            if (!this.monitors$set) {
                monitors$value = ResourceConfig.$default$monitors();
            }
            Map<String, AdditionalConnector> additionalConnectors$value = this.additionalConnectors$value;
            if (!this.additionalConnectors$set) {
                additionalConnectors$value = ResourceConfig.$default$additionalConnectors();
            }
            return new ResourceConfig(this.loggerLevel, this.outputDirectory, this.collectPeriod, this.discoveryCycle, this.alertingSystemConfig, this.sequential, this.enableSelfMonitoring, this.resolveHostnameToFqdn, this.monitorFilters, this.jobTimeout, attributes$value, metrics$value, protocols$value, connectors$value, monitors$value, additionalConnectors$value, this.connector, this.stateSetCompression);
        }

        @Generated
        public String toString() {
            return "ResourceConfig.ResourceConfigBuilder(loggerLevel=" + this.loggerLevel + ", outputDirectory=" + this.outputDirectory + ", collectPeriod=" + this.collectPeriod + ", discoveryCycle=" + this.discoveryCycle + ", alertingSystemConfig=" + String.valueOf(this.alertingSystemConfig) + ", sequential=" + this.sequential + ", enableSelfMonitoring=" + this.enableSelfMonitoring + ", resolveHostnameToFqdn=" + this.resolveHostnameToFqdn + ", monitorFilters=" + String.valueOf(this.monitorFilters) + ", jobTimeout=" + this.jobTimeout + ", attributes$value=" + String.valueOf(this.attributes$value) + ", metrics$value=" + String.valueOf(this.metrics$value) + ", protocols$value=" + String.valueOf(this.protocols$value) + ", connectors$value=" + String.valueOf(this.connectors$value) + ", monitors$value=" + String.valueOf(this.monitors$value) + ", additionalConnectors$value=" + String.valueOf(this.additionalConnectors$value) + ", connector=" + String.valueOf(this.connector) + ", stateSetCompression=" + this.stateSetCompression + ")";
        }
    }
}

