/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.config.otel;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.sentrysoftware.metricshub.agent.config.otel.OtelCollectorOutput;
import org.sentrysoftware.metricshub.agent.helper.ConfigHelper;
import org.sentrysoftware.metricshub.agent.process.config.ProcessConfig;
import org.sentrysoftware.metricshub.engine.common.helpers.LocalOsHandler;
import org.sentrysoftware.metricshub.engine.common.helpers.MapHelper;
import org.sentrysoftware.metricshub.engine.deserialization.TimeDeserializer;

public class OtelCollectorConfig {
    protected static final List<String> DEFAULT_COMMAND_LINE = OtelCollectorConfig.buildDefaultCommandLine();
    protected static final String DEFAULT_WORKING_DIR = ConfigHelper.getSubPath("otel").toString();
    protected static final Map<String, String> DEFAULT_ENVIRONMENT = new HashMap<String, String>();
    public static final String EXECUTABLE_OUTPUT_ID = "otelcol";
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> commandLine;
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> environment;
    @JsonSetter(nulls=Nulls.SKIP)
    private OtelCollectorOutput output;
    @JsonSetter(nulls=Nulls.SKIP)
    private String workingDir;
    private boolean disabled;
    @JsonDeserialize(using=TimeDeserializer.class)
    private long startupDelay;

    private static List<String> buildDefaultCommandLine() {
        ArrayList<String> commandLine = new ArrayList<String>();
        String executableFileName = LocalOsHandler.isWindows() ? "otelcol-contrib.exe" : "otelcol-contrib";
        commandLine.add(ConfigHelper.getSubPath("otel/" + executableFileName).toString());
        commandLine.add("--config");
        String defaultConfigFilePath = ConfigHelper.getDefaultConfigFilePath("otel", "otel-config.yaml").toString();
        commandLine.add(LocalOsHandler.isWindows() ? String.format("\"%s\"", defaultConfigFilePath) : defaultConfigFilePath);
        commandLine.add("--feature-gates=pkg.translator.prometheus.NormalizeName");
        return commandLine;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OtelCollectorConfig other = (OtelCollectorConfig)obj;
        return Objects.equals(this.commandLine, other.commandLine) && this.disabled == other.disabled && MapHelper.areEqual(this.environment, other.environment) && this.output == other.output && Objects.equals(this.workingDir, other.workingDir);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.commandLine, this.disabled, this.environment, this.output, this.workingDir});
    }

    public ProcessConfig toProcessConfig() {
        return ProcessConfig.builder().commandLine(this.getCommandLine()).environment(this.getEnvironment()).output(this.getOutput().getProcessOutputSupplier().get()).workingDir(new File(this.getWorkingDir())).build();
    }

    @Generated
    private static List<String> $default$commandLine() {
        return DEFAULT_COMMAND_LINE;
    }

    @Generated
    private static Map<String, String> $default$environment() {
        return DEFAULT_ENVIRONMENT;
    }

    @Generated
    private static OtelCollectorOutput $default$output() {
        return OtelCollectorOutput.LOG;
    }

    @Generated
    private static String $default$workingDir() {
        return DEFAULT_WORKING_DIR;
    }

    @Generated
    private static boolean $default$disabled() {
        return false;
    }

    @Generated
    private static long $default$startupDelay() {
        return 10L;
    }

    @Generated
    public static OtelCollectorConfigBuilder builder() {
        return new OtelCollectorConfigBuilder();
    }

    @Generated
    public List<String> getCommandLine() {
        return this.commandLine;
    }

    @Generated
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Generated
    public OtelCollectorOutput getOutput() {
        return this.output;
    }

    @Generated
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Generated
    public boolean isDisabled() {
        return this.disabled;
    }

    @Generated
    public long getStartupDelay() {
        return this.startupDelay;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setCommandLine(List<String> commandLine) {
        this.commandLine = commandLine;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setEnvironment(Map<String, String> environment2) {
        this.environment = environment2;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setOutput(OtelCollectorOutput output) {
        this.output = output;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    @Generated
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @JsonDeserialize(using=TimeDeserializer.class)
    @Generated
    public void setStartupDelay(long startupDelay) {
        this.startupDelay = startupDelay;
    }

    @Generated
    public String toString() {
        return "OtelCollectorConfig(commandLine=" + String.valueOf(this.getCommandLine()) + ", environment=" + String.valueOf(this.getEnvironment()) + ", output=" + String.valueOf((Object)this.getOutput()) + ", workingDir=" + this.getWorkingDir() + ", disabled=" + this.isDisabled() + ", startupDelay=" + this.getStartupDelay() + ")";
    }

    @Generated
    public OtelCollectorConfig(List<String> commandLine, Map<String, String> environment2, OtelCollectorOutput output, String workingDir, boolean disabled, long startupDelay) {
        this.commandLine = commandLine;
        this.environment = environment2;
        this.output = output;
        this.workingDir = workingDir;
        this.disabled = disabled;
        this.startupDelay = startupDelay;
    }

    @Generated
    public OtelCollectorConfig() {
        this.commandLine = OtelCollectorConfig.$default$commandLine();
        this.environment = OtelCollectorConfig.$default$environment();
        this.output = OtelCollectorConfig.$default$output();
        this.workingDir = OtelCollectorConfig.$default$workingDir();
        this.disabled = OtelCollectorConfig.$default$disabled();
        this.startupDelay = OtelCollectorConfig.$default$startupDelay();
    }

    static {
        if (LocalOsHandler.isWindows()) {
            DEFAULT_ENVIRONMENT.put("NO_WINDOWS_SERVICE", "1");
        }
    }

    @Generated
    public static class OtelCollectorConfigBuilder {
        @Generated
        private boolean commandLine$set;
        @Generated
        private List<String> commandLine$value;
        @Generated
        private boolean environment$set;
        @Generated
        private Map<String, String> environment$value;
        @Generated
        private boolean output$set;
        @Generated
        private OtelCollectorOutput output$value;
        @Generated
        private boolean workingDir$set;
        @Generated
        private String workingDir$value;
        @Generated
        private boolean disabled$set;
        @Generated
        private boolean disabled$value;
        @Generated
        private boolean startupDelay$set;
        @Generated
        private long startupDelay$value;

        @Generated
        OtelCollectorConfigBuilder() {
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public OtelCollectorConfigBuilder commandLine(List<String> commandLine) {
            this.commandLine$value = commandLine;
            this.commandLine$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public OtelCollectorConfigBuilder environment(Map<String, String> environment2) {
            this.environment$value = environment2;
            this.environment$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public OtelCollectorConfigBuilder output(OtelCollectorOutput output) {
            this.output$value = output;
            this.output$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public OtelCollectorConfigBuilder workingDir(String workingDir) {
            this.workingDir$value = workingDir;
            this.workingDir$set = true;
            return this;
        }

        @Generated
        public OtelCollectorConfigBuilder disabled(boolean disabled) {
            this.disabled$value = disabled;
            this.disabled$set = true;
            return this;
        }

        @JsonDeserialize(using=TimeDeserializer.class)
        @Generated
        public OtelCollectorConfigBuilder startupDelay(long startupDelay) {
            this.startupDelay$value = startupDelay;
            this.startupDelay$set = true;
            return this;
        }

        @Generated
        public OtelCollectorConfig build() {
            List<String> commandLine$value = this.commandLine$value;
            if (!this.commandLine$set) {
                commandLine$value = OtelCollectorConfig.$default$commandLine();
            }
            Map<String, String> environment$value = this.environment$value;
            if (!this.environment$set) {
                environment$value = OtelCollectorConfig.$default$environment();
            }
            OtelCollectorOutput output$value = this.output$value;
            if (!this.output$set) {
                output$value = OtelCollectorConfig.$default$output();
            }
            String workingDir$value = this.workingDir$value;
            if (!this.workingDir$set) {
                workingDir$value = OtelCollectorConfig.$default$workingDir();
            }
            boolean disabled$value = this.disabled$value;
            if (!this.disabled$set) {
                disabled$value = OtelCollectorConfig.$default$disabled();
            }
            long startupDelay$value = this.startupDelay$value;
            if (!this.startupDelay$set) {
                startupDelay$value = OtelCollectorConfig.$default$startupDelay();
            }
            return new OtelCollectorConfig(commandLine$value, environment$value, output$value, workingDir$value, disabled$value, startupDelay$value);
        }

        @Generated
        public String toString() {
            return "OtelCollectorConfig.OtelCollectorConfigBuilder(commandLine$value=" + String.valueOf(this.commandLine$value) + ", environment$value=" + String.valueOf(this.environment$value) + ", output$value=" + String.valueOf((Object)this.output$value) + ", workingDir$value=" + this.workingDir$value + ", disabled$value=" + this.disabled$value + ", startupDelay$value=" + this.startupDelay$value + ")";
        }
    }
}

