/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.connector;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.agent.config.AdditionalConnector;
import org.sentrysoftware.metricshub.agent.connector.AdditionalConnectorsParsingResult;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.parser.ConnectorParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorVariablesLibraryParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectorVariablesLibraryParser.class);

    public AdditionalConnectorsParsingResult parse(@NonNull Path yamlParentDirectory, @NonNull Map<String, AdditionalConnector> additionalConnectorConfig) throws IOException {
        if (yamlParentDirectory == null) {
            throw new IllegalArgumentException("yamlParentDirectory is marked non-null but is null");
        }
        if (additionalConnectorConfig == null) {
            throw new IllegalArgumentException("additionalConnectorConfig is marked non-null but is null");
        }
        long startTime = System.currentTimeMillis();
        ConnectorFileVisitor connectorFileVisitor = new ConnectorFileVisitor(additionalConnectorConfig);
        Files.walkFileTree(yamlParentDirectory, connectorFileVisitor);
        log.info("Connectors with variables parsing duration: {} seconds", (Object)((System.currentTimeMillis() - startTime) / 1000L));
        return connectorFileVisitor.getConnectorsParsingResult();
    }

    private static class ConnectorFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Map<String, AdditionalConnector> additionalConnectorConfig;
        private final AdditionalConnectorsParsingResult connectorsParsingResult = new AdditionalConnectorsParsingResult();

        public AdditionalConnectorsParsingResult getConnectorsParsingResult() {
            return this.connectorsParsingResult;
        }

        ConnectorFileVisitor(Map<String, AdditionalConnector> additionalConnectorConfig) {
            this.additionalConnectorConfig = additionalConnectorConfig;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            if (Files.isDirectory(path, new LinkOption[0]) || !this.isYamlFile(path.toFile().getName())) {
                return FileVisitResult.CONTINUE;
            }
            YAMLMapper yamlMapper = new YAMLMapper();
            JsonNode connectorNode = yamlMapper.readTree(path.toFile());
            if (!this.isConnector(connectorNode)) {
                return FileVisitResult.CONTINUE;
            }
            String filename = path.getFileName().toString();
            String connectorId = filename.substring(0, filename.lastIndexOf(46));
            if (!connectorNode.toString().contains("${var::")) {
                return FileVisitResult.CONTINUE;
            }
            this.normalizeAdditionalConnectors();
            Map<String, AdditionalConnector> filteredConnectors = this.additionalConnectorConfig.entrySet().stream().filter(entry -> connectorId.equalsIgnoreCase(((AdditionalConnector)entry.getValue()).getUses())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            HashMap<String, String> defaultVariables = new HashMap<String, String>(ConnectorFileVisitor.getDefaultConnectorVariables(connectorNode));
            if (filteredConnectors.isEmpty()) {
                this.parseConnectorWithModifier(path, defaultVariables, connectorId, filename, connector -> {});
            } else {
                this.generateNewConnectors(path, filename, filteredConnectors, defaultVariables);
            }
            return FileVisitResult.CONTINUE;
        }

        private boolean isConnector(JsonNode connector) {
            JsonNode connectorNode = connector.get("connector");
            if (connectorNode != null && !connectorNode.isNull()) {
                JsonNode displayName = connectorNode.get("displayName");
                return displayName != null && !displayName.isNull();
            }
            return false;
        }

        private boolean isYamlFile(String name) {
            return name.toLowerCase().endsWith(".yaml");
        }

        private static Map<String, String> getDefaultConnectorVariables(JsonNode connectorNode) {
            JsonNode variablesNode = connectorNode.get("connector").get("variables");
            if (variablesNode == null) {
                return new HashMap<String, String>();
            }
            HashMap<String, String> connectorVariablesMap = new HashMap<String, String>();
            variablesNode.fields().forEachRemaining(entry -> {
                String variableName = (String)entry.getKey();
                JsonNode variableValue = (JsonNode)entry.getValue();
                JsonNode defaultValue = variableValue.get("defaultValue");
                if (defaultValue != null && !defaultValue.isNull()) {
                    connectorVariablesMap.put(variableName, variableValue.get("defaultValue").asText());
                }
            });
            return connectorVariablesMap;
        }

        private void generateNewConnectors(Path path, String filename, Map<String, AdditionalConnector> filteredConnectors, Map<String, String> defaultVariables) {
            for (Map.Entry<String, AdditionalConnector> connectorConfigurationEntry : filteredConnectors.entrySet()) {
                String additionalConnectorId = connectorConfigurationEntry.getKey();
                AdditionalConnector additionalConnectorValue = connectorConfigurationEntry.getValue();
                this.connectorsParsingResult.getHostConnectors().add((String)(additionalConnectorValue.isForce() ? "+" + additionalConnectorId : additionalConnectorId));
                HashMap<String, String> connectorVariables = new HashMap<String, String>(defaultVariables);
                Map<String, String> configuredVariables = additionalConnectorValue.getVariables();
                if (configuredVariables != null) {
                    connectorVariables.putAll(configuredVariables);
                }
                this.parseConnectorWithModifier(path, connectorVariables, additionalConnectorId, filename, connector -> connector.getConnectorIdentity().setCompiledFilename(additionalConnectorId));
            }
        }

        private void parseConnectorWithModifier(Path path, Map<String, String> variables, String connectorId, String filename, Consumer<Connector> connectorModifier) {
            ConnectorParser connectorParser = ConnectorParser.withNodeProcessorAndUpdateChain(path.getParent(), variables);
            try {
                Connector connector = connectorParser.parse(path.toFile());
                connectorModifier.accept(connector);
                this.connectorsParsingResult.getCustomConnectorsMap().put(connectorId, connector);
            }
            catch (Exception e) {
                log.error("Error while parsing connector with variables {}: {}", (Object)filename, (Object)e.getMessage());
                log.debug("Exception: ", e);
            }
        }

        private void normalizeAdditionalConnectors() {
            this.additionalConnectorConfig.entrySet().forEach(entry -> {
                String connectorId = (String)entry.getKey();
                AdditionalConnector additionalConnector = (AdditionalConnector)entry.getValue();
                if (additionalConnector == null) {
                    entry.setValue(AdditionalConnector.builder().force(true).uses(connectorId).variables(null).build());
                    return;
                }
                if (additionalConnector.getUses() == null) {
                    additionalConnector.setUses(connectorId);
                }
            });
        }
    }
}

