/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.context;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.sentrysoftware.metricshub.agent.config.AgentConfig;
import org.sentrysoftware.metricshub.agent.context.AgentInfo;
import org.sentrysoftware.metricshub.agent.context.ApplicationProperties;
import org.sentrysoftware.metricshub.agent.context.MetricDefinitions;
import org.sentrysoftware.metricshub.agent.helper.AgentConstants;
import org.sentrysoftware.metricshub.agent.helper.ConfigHelper;
import org.sentrysoftware.metricshub.agent.helper.OtelConfigHelper;
import org.sentrysoftware.metricshub.agent.helper.PostConfigDeserializeHelper;
import org.sentrysoftware.metricshub.agent.service.OtelCollectorProcessService;
import org.sentrysoftware.metricshub.agent.service.TaskSchedulingService;
import org.sentrysoftware.metricshub.engine.common.helpers.JsonHelper;
import org.sentrysoftware.metricshub.engine.connector.model.ConnectorStore;
import org.sentrysoftware.metricshub.engine.connector.parser.EnvironmentProcessor;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentContext.class);
    private AgentInfo agentInfo;
    private File configFile;
    private AgentConfig agentConfig;
    private ConnectorStore connectorStore;
    private String pid;
    private Map<String, String> otelSdkConfiguration;
    private Map<String, Map<String, TelemetryManager>> telemetryManagers;
    private OtelCollectorProcessService otelCollectorProcessService;
    private TaskSchedulingService taskSchedulingService;
    private MetricDefinitions hostMetricDefinitions;
    protected ExtensionManager extensionManager;

    public AgentContext(String alternateConfigFile, ExtensionManager extensionManager) throws IOException {
        this.extensionManager = extensionManager;
        this.build(alternateConfigFile, true);
    }

    public void build(String alternateConfigFile, boolean createConnectorStore) throws IOException {
        long startTime = System.nanoTime();
        this.configFile = ConfigHelper.findConfigFile(alternateConfigFile);
        PreConfig preConfig = this.loadPreConfig();
        ConfigHelper.configureGlobalLogger(preConfig.getLoggerLevel(), preConfig.getOutputDirectory());
        log.info("Starting MetricsHub Agent...");
        this.pid = AgentContext.findPid();
        if (createConnectorStore) {
            this.connectorStore = ConfigHelper.buildConnectorStore(this.extensionManager, preConfig.getPatchDirectory());
        }
        this.agentInfo = new AgentInfo();
        this.agentConfig = this.loadConfiguration();
        this.logProductInformation();
        ConfigHelper.normalizeAgentConfiguration(this.agentConfig);
        this.telemetryManagers = ConfigHelper.buildTelemetryManagers(this.agentConfig, this.connectorStore);
        this.otelSdkConfiguration = OtelConfigHelper.buildOtelSdkConfiguration(this.agentConfig);
        this.otelCollectorProcessService = new OtelCollectorProcessService(this.agentConfig);
        this.hostMetricDefinitions = ConfigHelper.readHostMetricDefinitions();
        this.taskSchedulingService = TaskSchedulingService.builder().withAgentConfig(this.agentConfig).withAgentInfo(this.agentInfo).withConfigFile(this.configFile).withOtelCollectorProcessService(this.otelCollectorProcessService).withTaskScheduler(TaskSchedulingService.newScheduler(this.agentConfig.getJobPoolSize())).withTelemetryManagers(this.telemetryManagers).withSchedules(new HashMap()).withOtelSdkConfiguration(this.otelSdkConfiguration).withHostMetricDefinitions(this.hostMetricDefinitions).withExtensionManager(this.extensionManager).build();
        Duration startupDuration = Duration.ofNanos(System.nanoTime() - startTime);
        log.info("Started MetricsHub Agent in {} seconds.", (Object)((double)startupDuration.toMillis() / 1000.0));
    }

    private PreConfig loadPreConfig() throws IOException {
        JsonMapper objectMapper = ConfigHelper.newObjectMapper();
        return JsonHelper.deserialize((ObjectMapper)objectMapper, new FileInputStream(this.configFile), PreConfig.class);
    }

    private AgentConfig loadConfiguration() throws IOException {
        ObjectMapper objectMapper = AgentContext.newAgentConfigObjectMapper(this.extensionManager);
        JsonNode configNode = objectMapper.readTree(new FileInputStream(this.configFile));
        new EnvironmentProcessor().process(configNode);
        return JsonHelper.deserialize(objectMapper, configNode, AgentConfig.class);
    }

    public static ObjectMapper newAgentConfigObjectMapper(ExtensionManager extensionManager) {
        JsonMapper objectMapper = ConfigHelper.newObjectMapper();
        PostConfigDeserializeHelper.addPostDeserializeSupport(objectMapper);
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(ExtensionManager.class, (Object)extensionManager);
        objectMapper.setInjectableValues(injectableValues);
        return objectMapper;
    }

    public void logProductInformation() {
        if (AgentContext.isLogInfoEnabled()) {
            ApplicationProperties applicationProperties = this.agentInfo.getApplicationProperties();
            ApplicationProperties.Project project = applicationProperties.project();
            log.info("Product information:\nName: {}\nVersion: {}\nBuild number: {}\nBuild date: {}\nCommunity Connector Library version: {}\nJava version: {}\nJava Runtime Environment directory: {}\nOperating System: {} {}\nUser working directory: {}\nPID: {}", project.name(), project.version(), applicationProperties.buildNumber(), applicationProperties.buildDate(), applicationProperties.ccVersion(), System.getProperty("java.version"), System.getProperty("java.home"), System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("user.dir"), this.pid);
        }
    }

    static boolean isLogInfoEnabled() {
        return log.isInfoEnabled();
    }

    private static String findPid() {
        try {
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            return jvmName.split("@")[0];
        }
        catch (Throwable ex) {
            return "";
        }
    }

    @Generated
    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    @Generated
    public File getConfigFile() {
        return this.configFile;
    }

    @Generated
    public AgentConfig getAgentConfig() {
        return this.agentConfig;
    }

    @Generated
    public ConnectorStore getConnectorStore() {
        return this.connectorStore;
    }

    @Generated
    public String getPid() {
        return this.pid;
    }

    @Generated
    public Map<String, String> getOtelSdkConfiguration() {
        return this.otelSdkConfiguration;
    }

    @Generated
    public Map<String, Map<String, TelemetryManager>> getTelemetryManagers() {
        return this.telemetryManagers;
    }

    @Generated
    public OtelCollectorProcessService getOtelCollectorProcessService() {
        return this.otelCollectorProcessService;
    }

    @Generated
    public TaskSchedulingService getTaskSchedulingService() {
        return this.taskSchedulingService;
    }

    @Generated
    public MetricDefinitions getHostMetricDefinitions() {
        return this.hostMetricDefinitions;
    }

    @Generated
    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Generated
    public void setAgentInfo(AgentInfo agentInfo) {
        this.agentInfo = agentInfo;
    }

    @Generated
    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    @Generated
    public void setAgentConfig(AgentConfig agentConfig) {
        this.agentConfig = agentConfig;
    }

    @Generated
    public void setConnectorStore(ConnectorStore connectorStore) {
        this.connectorStore = connectorStore;
    }

    @Generated
    public void setPid(String pid) {
        this.pid = pid;
    }

    @Generated
    public void setOtelSdkConfiguration(Map<String, String> otelSdkConfiguration) {
        this.otelSdkConfiguration = otelSdkConfiguration;
    }

    @Generated
    public void setTelemetryManagers(Map<String, Map<String, TelemetryManager>> telemetryManagers) {
        this.telemetryManagers = telemetryManagers;
    }

    @Generated
    public void setOtelCollectorProcessService(OtelCollectorProcessService otelCollectorProcessService) {
        this.otelCollectorProcessService = otelCollectorProcessService;
    }

    @Generated
    public void setTaskSchedulingService(TaskSchedulingService taskSchedulingService) {
        this.taskSchedulingService = taskSchedulingService;
    }

    @Generated
    public void setHostMetricDefinitions(MetricDefinitions hostMetricDefinitions) {
        this.hostMetricDefinitions = hostMetricDefinitions;
    }

    @Generated
    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentContext)) {
            return false;
        }
        AgentContext other = (AgentContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AgentInfo this$agentInfo = this.getAgentInfo();
        AgentInfo other$agentInfo = other.getAgentInfo();
        if (this$agentInfo == null ? other$agentInfo != null : !this$agentInfo.equals(other$agentInfo)) {
            return false;
        }
        File this$configFile = this.getConfigFile();
        File other$configFile = other.getConfigFile();
        if (this$configFile == null ? other$configFile != null : !((Object)this$configFile).equals(other$configFile)) {
            return false;
        }
        AgentConfig this$agentConfig = this.getAgentConfig();
        AgentConfig other$agentConfig = other.getAgentConfig();
        if (this$agentConfig == null ? other$agentConfig != null : !((Object)this$agentConfig).equals(other$agentConfig)) {
            return false;
        }
        ConnectorStore this$connectorStore = this.getConnectorStore();
        ConnectorStore other$connectorStore = other.getConnectorStore();
        if (this$connectorStore == null ? other$connectorStore != null : !((Object)this$connectorStore).equals(other$connectorStore)) {
            return false;
        }
        String this$pid = this.getPid();
        String other$pid = other.getPid();
        if (this$pid == null ? other$pid != null : !this$pid.equals(other$pid)) {
            return false;
        }
        Map<String, String> this$otelSdkConfiguration = this.getOtelSdkConfiguration();
        Map<String, String> other$otelSdkConfiguration = other.getOtelSdkConfiguration();
        if (this$otelSdkConfiguration == null ? other$otelSdkConfiguration != null : !((Object)this$otelSdkConfiguration).equals(other$otelSdkConfiguration)) {
            return false;
        }
        Map<String, Map<String, TelemetryManager>> this$telemetryManagers = this.getTelemetryManagers();
        Map<String, Map<String, TelemetryManager>> other$telemetryManagers = other.getTelemetryManagers();
        if (this$telemetryManagers == null ? other$telemetryManagers != null : !((Object)this$telemetryManagers).equals(other$telemetryManagers)) {
            return false;
        }
        OtelCollectorProcessService this$otelCollectorProcessService = this.getOtelCollectorProcessService();
        OtelCollectorProcessService other$otelCollectorProcessService = other.getOtelCollectorProcessService();
        if (this$otelCollectorProcessService == null ? other$otelCollectorProcessService != null : !this$otelCollectorProcessService.equals(other$otelCollectorProcessService)) {
            return false;
        }
        TaskSchedulingService this$taskSchedulingService = this.getTaskSchedulingService();
        TaskSchedulingService other$taskSchedulingService = other.getTaskSchedulingService();
        if (this$taskSchedulingService == null ? other$taskSchedulingService != null : !((Object)this$taskSchedulingService).equals(other$taskSchedulingService)) {
            return false;
        }
        MetricDefinitions this$hostMetricDefinitions = this.getHostMetricDefinitions();
        MetricDefinitions other$hostMetricDefinitions = other.getHostMetricDefinitions();
        if (this$hostMetricDefinitions == null ? other$hostMetricDefinitions != null : !((Object)this$hostMetricDefinitions).equals(other$hostMetricDefinitions)) {
            return false;
        }
        ExtensionManager this$extensionManager = this.getExtensionManager();
        ExtensionManager other$extensionManager = other.getExtensionManager();
        return !(this$extensionManager == null ? other$extensionManager != null : !((Object)this$extensionManager).equals(other$extensionManager));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AgentContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AgentInfo $agentInfo = this.getAgentInfo();
        result = result * 59 + ($agentInfo == null ? 43 : $agentInfo.hashCode());
        File $configFile = this.getConfigFile();
        result = result * 59 + ($configFile == null ? 43 : ((Object)$configFile).hashCode());
        AgentConfig $agentConfig = this.getAgentConfig();
        result = result * 59 + ($agentConfig == null ? 43 : ((Object)$agentConfig).hashCode());
        ConnectorStore $connectorStore = this.getConnectorStore();
        result = result * 59 + ($connectorStore == null ? 43 : ((Object)$connectorStore).hashCode());
        String $pid = this.getPid();
        result = result * 59 + ($pid == null ? 43 : $pid.hashCode());
        Map<String, String> $otelSdkConfiguration = this.getOtelSdkConfiguration();
        result = result * 59 + ($otelSdkConfiguration == null ? 43 : ((Object)$otelSdkConfiguration).hashCode());
        Map<String, Map<String, TelemetryManager>> $telemetryManagers = this.getTelemetryManagers();
        result = result * 59 + ($telemetryManagers == null ? 43 : ((Object)$telemetryManagers).hashCode());
        OtelCollectorProcessService $otelCollectorProcessService = this.getOtelCollectorProcessService();
        result = result * 59 + ($otelCollectorProcessService == null ? 43 : $otelCollectorProcessService.hashCode());
        TaskSchedulingService $taskSchedulingService = this.getTaskSchedulingService();
        result = result * 59 + ($taskSchedulingService == null ? 43 : ((Object)$taskSchedulingService).hashCode());
        MetricDefinitions $hostMetricDefinitions = this.getHostMetricDefinitions();
        result = result * 59 + ($hostMetricDefinitions == null ? 43 : ((Object)$hostMetricDefinitions).hashCode());
        ExtensionManager $extensionManager = this.getExtensionManager();
        result = result * 59 + ($extensionManager == null ? 43 : ((Object)$extensionManager).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AgentContext(agentInfo=" + String.valueOf(this.getAgentInfo()) + ", configFile=" + String.valueOf(this.getConfigFile()) + ", agentConfig=" + String.valueOf(this.getAgentConfig()) + ", connectorStore=" + String.valueOf(this.getConnectorStore()) + ", pid=" + this.getPid() + ", otelSdkConfiguration=" + String.valueOf(this.getOtelSdkConfiguration()) + ", telemetryManagers=" + String.valueOf(this.getTelemetryManagers()) + ", otelCollectorProcessService=" + String.valueOf(this.getOtelCollectorProcessService()) + ", taskSchedulingService=" + String.valueOf(this.getTaskSchedulingService()) + ", hostMetricDefinitions=" + String.valueOf(this.getHostMetricDefinitions()) + ", extensionManager=" + String.valueOf(this.getExtensionManager()) + ")";
    }

    public static class PreConfig {
        @JsonSetter(nulls=Nulls.SKIP)
        private String loggerLevel;
        @JsonSetter(nulls=Nulls.SKIP)
        private String outputDirectory;
        @JsonSetter(nulls=Nulls.SKIP)
        private String patchDirectory;

        @Generated
        private static String $default$loggerLevel() {
            return "error";
        }

        @Generated
        private static String $default$outputDirectory() {
            return AgentConstants.DEFAULT_OUTPUT_DIRECTORY.toString();
        }

        @Generated
        public static PreConfigBuilder builder() {
            return new PreConfigBuilder();
        }

        @Generated
        public String getLoggerLevel() {
            return this.loggerLevel;
        }

        @Generated
        public String getOutputDirectory() {
            return this.outputDirectory;
        }

        @Generated
        public String getPatchDirectory() {
            return this.patchDirectory;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public void setLoggerLevel(String loggerLevel) {
            this.loggerLevel = loggerLevel;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public void setOutputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public void setPatchDirectory(String patchDirectory) {
            this.patchDirectory = patchDirectory;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PreConfig)) {
                return false;
            }
            PreConfig other = (PreConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$loggerLevel = this.getLoggerLevel();
            String other$loggerLevel = other.getLoggerLevel();
            if (this$loggerLevel == null ? other$loggerLevel != null : !this$loggerLevel.equals(other$loggerLevel)) {
                return false;
            }
            String this$outputDirectory = this.getOutputDirectory();
            String other$outputDirectory = other.getOutputDirectory();
            if (this$outputDirectory == null ? other$outputDirectory != null : !this$outputDirectory.equals(other$outputDirectory)) {
                return false;
            }
            String this$patchDirectory = this.getPatchDirectory();
            String other$patchDirectory = other.getPatchDirectory();
            return !(this$patchDirectory == null ? other$patchDirectory != null : !this$patchDirectory.equals(other$patchDirectory));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PreConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $loggerLevel = this.getLoggerLevel();
            result = result * 59 + ($loggerLevel == null ? 43 : $loggerLevel.hashCode());
            String $outputDirectory = this.getOutputDirectory();
            result = result * 59 + ($outputDirectory == null ? 43 : $outputDirectory.hashCode());
            String $patchDirectory = this.getPatchDirectory();
            result = result * 59 + ($patchDirectory == null ? 43 : $patchDirectory.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AgentContext.PreConfig(loggerLevel=" + this.getLoggerLevel() + ", outputDirectory=" + this.getOutputDirectory() + ", patchDirectory=" + this.getPatchDirectory() + ")";
        }

        @Generated
        public PreConfig() {
            this.loggerLevel = PreConfig.$default$loggerLevel();
            this.outputDirectory = PreConfig.$default$outputDirectory();
        }

        @Generated
        public PreConfig(String loggerLevel, String outputDirectory, String patchDirectory) {
            this.loggerLevel = loggerLevel;
            this.outputDirectory = outputDirectory;
            this.patchDirectory = patchDirectory;
        }

        @Generated
        public static class PreConfigBuilder {
            @Generated
            private boolean loggerLevel$set;
            @Generated
            private String loggerLevel$value;
            @Generated
            private boolean outputDirectory$set;
            @Generated
            private String outputDirectory$value;
            @Generated
            private String patchDirectory;

            @Generated
            PreConfigBuilder() {
            }

            @JsonSetter(nulls=Nulls.SKIP)
            @Generated
            public PreConfigBuilder loggerLevel(String loggerLevel) {
                this.loggerLevel$value = loggerLevel;
                this.loggerLevel$set = true;
                return this;
            }

            @JsonSetter(nulls=Nulls.SKIP)
            @Generated
            public PreConfigBuilder outputDirectory(String outputDirectory) {
                this.outputDirectory$value = outputDirectory;
                this.outputDirectory$set = true;
                return this;
            }

            @JsonSetter(nulls=Nulls.SKIP)
            @Generated
            public PreConfigBuilder patchDirectory(String patchDirectory) {
                this.patchDirectory = patchDirectory;
                return this;
            }

            @Generated
            public PreConfig build() {
                String loggerLevel$value = this.loggerLevel$value;
                if (!this.loggerLevel$set) {
                    loggerLevel$value = PreConfig.$default$loggerLevel();
                }
                String outputDirectory$value = this.outputDirectory$value;
                if (!this.outputDirectory$set) {
                    outputDirectory$value = PreConfig.$default$outputDirectory();
                }
                return new PreConfig(loggerLevel$value, outputDirectory$value, this.patchDirectory);
            }

            @Generated
            public String toString() {
                return "AgentContext.PreConfig.PreConfigBuilder(loggerLevel$value=" + this.loggerLevel$value + ", outputDirectory$value=" + this.outputDirectory$value + ", patchDirectory=" + this.patchDirectory + ")";
            }
        }
    }
}

