/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.context;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.sentrysoftware.metricshub.agent.context.ApplicationProperties;
import org.sentrysoftware.metricshub.agent.helper.AgentConstants;
import org.sentrysoftware.metricshub.engine.common.helpers.JsonHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.LocalOsHandler;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class AgentInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentInfo.class);
    public static final String METRICS_HUB_AGENT_METRIC_NAME = "metricshub.agent.info";
    private static final Map<LocalOsHandler.ILocalOs, String> LOCAL_OS_TO_OTEL_OS_TYPE = Map.of(LocalOsHandler.WINDOWS, "windows", LocalOsHandler.LINUX, "linux", LocalOsHandler.SUN, "sun", LocalOsHandler.HP, "hpux", LocalOsHandler.SOLARIS, "solaris", LocalOsHandler.FREE_BSD, "freebsd", LocalOsHandler.NET_BSD, "netbsd", LocalOsHandler.OPEN_BSD, "openbsd", LocalOsHandler.MAC_OS_X, "macosx", LocalOsHandler.AIX, "aix");
    private static final String UNKNOWN = "unknown";
    private static final String AGENT_HOSTNAME = StringHelper.getValue(() -> InetAddress.getLocalHost().getCanonicalHostName(), "unknown");
    private static final String OTEL_LOCAL_OS_TYPE = StringHelper.getValue(AgentInfo::getLocalOsTypeForOtel, "unknown");
    private ApplicationProperties applicationProperties;
    private Map<String, String> metricAttributes = new HashMap<String, String>();
    private Map<String, String> resourceAttributes = new HashMap<String, String>();

    public AgentInfo() {
        ClassPathResource classPathResource = new ClassPathResource("application.yaml");
        try {
            this.applicationProperties = JsonHelper.deserialize(AgentConstants.OBJECT_MAPPER, classPathResource.getInputStream(), ApplicationProperties.class);
        }
        catch (IOException e) {
            log.error("Cannot read internal application configuration file: {}", (Object)classPathResource.getPath());
            log.debug("Exception: ", e);
            throw new IllegalStateException("Cannot read application.yaml file.", e);
        }
        ApplicationProperties.Project project = this.applicationProperties.project();
        this.metricAttributes = Map.of("name", project.name(), "version", project.version(), "build_number", this.applicationProperties.buildNumber(), "build_date", this.applicationProperties.buildDate(), "cc_version", this.applicationProperties.ccVersion());
        this.resourceAttributes = Map.of("service.name", project.name(), "host.id", AGENT_HOSTNAME, "host.name", AGENT_HOSTNAME, "agent.host.name", AGENT_HOSTNAME, "host.type", "compute", "os.type", OTEL_LOCAL_OS_TYPE);
    }

    private static String getLocalOsTypeForOtel() {
        Optional<LocalOsHandler.ILocalOs> localOs = LocalOsHandler.getOS();
        if (localOs.isPresent()) {
            return LOCAL_OS_TO_OTEL_OS_TYPE.getOrDefault(localOs.get(), UNKNOWN);
        }
        return UNKNOWN;
    }

    @Generated
    public ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    @Generated
    public Map<String, String> getMetricAttributes() {
        return this.metricAttributes;
    }

    @Generated
    public Map<String, String> getResourceAttributes() {
        return this.resourceAttributes;
    }
}

