/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.deserialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.sentrysoftware.metricshub.agent.helper.ConfigHelper;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionProtocolsDeserializer
extends JsonDeserializer<Map<String, IConfiguration>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtensionProtocolsDeserializer.class);

    @Override
    public Map<String, IConfiguration> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        HashMap<String, IConfiguration> protocols = new HashMap<String, IConfiguration>();
        if (parser == null || context == null) {
            return protocols;
        }
        JsonNode node = (JsonNode)parser.readValueAsTree();
        if (node != null) {
            ExtensionManager extensionManager = (ExtensionManager)context.findInjectableValue(ExtensionManager.class.getName(), null, null);
            node.fields().forEachRemaining(entry -> {
                String protocolName = (String)entry.getKey();
                JsonNode protocolConfigNode = (JsonNode)entry.getValue();
                Optional<IConfiguration> protocolConfig = this.buildConfigurationFromJsonNode(extensionManager, protocolName, protocolConfigNode);
                protocolConfig.ifPresent(config -> protocols.put(protocolName, (IConfiguration)config));
            });
        }
        return protocols;
    }

    private Optional<IConfiguration> buildConfigurationFromJsonNode(ExtensionManager extensionManager, String protocolName, JsonNode configNode) {
        if (protocolName.isBlank()) {
            log.error("The protocol name cannot be blank. Returning an empty configuration.");
            return Optional.empty();
        }
        if (configNode == null || configNode.isNull()) {
            configNode = JsonNodeFactory.instance.objectNode();
        }
        try {
            return extensionManager.buildConfigurationFromJsonNode(protocolName, configNode, ConfigHelper::decrypt);
        }
        catch (Exception e) {
            log.error("Failed to build protocol configuration for {}: {}", (Object)protocolName, (Object)e.getMessage());
            log.debug("Failed to build protocol configuration for {}", (Object)protocolName, (Object)e);
            return Optional.empty();
        }
    }
}

