/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.deserialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.sentrysoftware.metricshub.agent.config.ResourceConfig;
import org.sentrysoftware.metricshub.agent.helper.ConfigHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.JsonHelper;
import org.sentrysoftware.metricshub.engine.connector.deserializer.PostDeserializeHelper;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.MonitorJob;
import org.sentrysoftware.metricshub.engine.connector.parser.ConnectorParser;
import org.sentrysoftware.metricshub.engine.connector.parser.ReferenceResolverProcessor;
import org.sentrysoftware.metricshub.engine.connector.parser.SourceKeyProcessor;
import org.sentrysoftware.metricshub.engine.connector.update.ConnectorUpdateChain;

public class MonitorJobsDeserializer
extends JsonDeserializer<Map<String, MonitorJob>> {
    public static final ObjectMapper OBJECT_MAPPER = MonitorJobsDeserializer.newObjectMapper();

    @Override
    public Map<String, MonitorJob> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        if (parser == null) {
            return new HashMap<String, MonitorJob>();
        }
        JsonNode jsonNode = parser.readValueAs(JsonNode.class);
        if (jsonNode == null) {
            return new HashMap<String, MonitorJob>();
        }
        JsonNode monitorsNode = new ReferenceResolverProcessor(new SourceKeyProcessor()).process((JsonNode)JsonNodeFactory.instance.objectNode().set("monitors", jsonNode));
        Connector connector = JsonHelper.deserialize(OBJECT_MAPPER, monitorsNode, Connector.class);
        ConnectorUpdateChain connectorUpdateChain = ConnectorParser.createUpdateChain();
        if (connectorUpdateChain != null) {
            connectorUpdateChain.update(connector);
        }
        JsonStreamContext parsingContext = parser.getParsingContext();
        Object parent = parsingContext.getCurrentValue();
        ((ResourceConfig)parent).setConnector(connector);
        return connector.getMonitors();
    }

    private static ObjectMapper newObjectMapper() {
        JsonMapper objectMapper = ConfigHelper.newObjectMapper();
        PostDeserializeHelper.addPostDeserializeSupport(objectMapper);
        return objectMapper;
    }
}

