/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.deserialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.sentrysoftware.metricshub.agent.config.AgentConfig;
import org.sentrysoftware.metricshub.agent.config.ResourceConfig;
import org.sentrysoftware.metricshub.agent.config.ResourceGroupConfig;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;

public class PostConfigDeserializer
extends DelegatingDeserializer {
    @Deprecated(since="0.9.08", forRemoval=true)
    private static final String MULTI_HOST_ATTRIBUTE_KEY = "host.names";
    private static final long serialVersionUID = 1L;

    public PostConfigDeserializer(JsonDeserializer<?> delegate) {
        super(delegate);
    }

    @Override
    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
        return new PostConfigDeserializer(newDelegatee);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        Object deserializedObject = super.deserialize(jsonParser, ctxt);
        if (deserializedObject instanceof ResourceGroupConfig) {
            ResourceGroupConfig resourceGroupConfig = (ResourceGroupConfig)deserializedObject;
            this.resolveMultiResourceConfigurations(resourceGroupConfig);
        }
        if (deserializedObject instanceof AgentConfig) {
            AgentConfig agentConfig = (AgentConfig)deserializedObject;
            this.resolveResources(agentConfig.getResources());
        }
        return deserializedObject;
    }

    private void resolveMultiResourceConfigurations(ResourceGroupConfig resourceGroupConfig) {
        this.resolveResources(resourceGroupConfig.getResources());
    }

    private void resolveResources(Map<String, ResourceConfig> existingResourceConfigMap) {
        HashSet resolvedMultiResourceConfigKeys = new HashSet();
        HashMap newResourceConfigMap = new HashMap();
        existingResourceConfigMap.entrySet().stream().filter(resourceConfigEntry -> Objects.nonNull(resourceConfigEntry.getValue()) && ((ResourceConfig)resourceConfigEntry.getValue()).getAttributes().values().stream().filter(Objects::nonNull).anyMatch(s2 -> s2.contains("_@M8B_MULTI_VALUE_SEP@_"))).forEach(resourceConfigEntry -> this.resolveMultiResourceConfig(resolvedMultiResourceConfigKeys, newResourceConfigMap, (Map.Entry<String, ResourceConfig>)resourceConfigEntry));
        existingResourceConfigMap.putAll(newResourceConfigMap);
        resolvedMultiResourceConfigKeys.forEach(existingResourceConfigMap::remove);
    }

    private void resolveMultiResourceConfig(Set<String> resolvedMultiResourceKeys, Map<String, ResourceConfig> newResourceConfigMap, Map.Entry<String, ResourceConfig> multiResourceConfigEntry) {
        String multiResourceConfigKey = multiResourceConfigEntry.getKey();
        resolvedMultiResourceKeys.add(multiResourceConfigKey);
        ResourceConfig multiResourceConfig = multiResourceConfigEntry.getValue();
        Map<String, String> originalAttributes = multiResourceConfig.getAttributes();
        String legacyHostnames = originalAttributes.get(MULTI_HOST_ATTRIBUTE_KEY);
        if (legacyHostnames != null) {
            originalAttributes.put("host.name", legacyHostnames);
            originalAttributes.remove(MULTI_HOST_ATTRIBUTE_KEY);
        }
        Map<String, List<String>> attributeValues = this.determineAttributeValues(originalAttributes);
        int maxSize = attributeValues.values().stream().mapToInt(List::size).max().orElse(1);
        for (int i = 0; i < maxSize; ++i) {
            ResourceConfig newResourceConfig = multiResourceConfig.copy();
            Map<String, String> newAttributes = newResourceConfig.getAttributes();
            this.normalizeProtocolHostnames(newResourceConfig.getProtocols(), i);
            for (Map.Entry<String, List<String>> attrEntry : attributeValues.entrySet()) {
                String key = attrEntry.getKey();
                List<String> values2 = attrEntry.getValue();
                String assignedValue = i < values2.size() ? values2.get(i) : values2.get(values2.size() - 1);
                newAttributes.put(key, assignedValue);
            }
            String additionalIdentification = null;
            String hostname = newAttributes.get("host.name");
            additionalIdentification = hostname != null ? hostname : newAttributes.get("host.id");
            String uniqueKey = String.format("%s-%d", multiResourceConfigKey, i + 1);
            if (additionalIdentification != null) {
                uniqueKey = String.format("%s-%s", uniqueKey, additionalIdentification);
            }
            newResourceConfigMap.put(uniqueKey, newResourceConfig);
        }
    }

    private void normalizeProtocolHostnames(Map<String, IConfiguration> protocols, int resourceIndex) {
        if (protocols == null) {
            return;
        }
        for (IConfiguration protocol : protocols.values()) {
            String hostname = protocol.getHostname();
            if (hostname == null || !hostname.contains("_@M8B_MULTI_VALUE_SEP@_")) continue;
            String[] hostnames = hostname.split("_@M8B_MULTI_VALUE_SEP@_");
            if (resourceIndex < hostnames.length) {
                protocol.setHostname(hostnames[resourceIndex]);
                continue;
            }
            protocol.setHostname(hostnames[hostnames.length - 1]);
        }
    }

    private Map<String, List<String>> determineAttributeValues(Map<String, String> originalAttributes) {
        HashMap<String, List<String>> attributeValues = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : originalAttributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            List splitValues = Arrays.stream(value.split("_@M8B_MULTI_VALUE_SEP@_")).collect(Collectors.toList());
            attributeValues.put(key, splitValues);
        }
        return attributeValues;
    }
}

