/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.helper;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.sentrysoftware.metricshub.agent.config.AgentConfig;
import org.sentrysoftware.metricshub.agent.config.AlertingSystemConfig;
import org.sentrysoftware.metricshub.agent.config.ResourceConfig;
import org.sentrysoftware.metricshub.agent.config.ResourceGroupConfig;
import org.sentrysoftware.metricshub.agent.connector.AdditionalConnectorsParsingResult;
import org.sentrysoftware.metricshub.agent.connector.ConnectorVariablesLibraryParser;
import org.sentrysoftware.metricshub.agent.context.MetricDefinitions;
import org.sentrysoftware.metricshub.agent.security.PasswordEncrypt;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.common.helpers.JsonHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.LocalOsHandler;
import org.sentrysoftware.metricshub.engine.common.helpers.MetricsHubConstants;
import org.sentrysoftware.metricshub.engine.common.helpers.ResourceHelper;
import org.sentrysoftware.metricshub.engine.configuration.HostConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.ConnectorStore;
import org.sentrysoftware.metricshub.engine.connector.model.common.DeviceKind;
import org.sentrysoftware.metricshub.engine.connector.model.identity.ConnectorIdentity;
import org.sentrysoftware.metricshub.engine.connector.model.metric.MetricDefinition;
import org.sentrysoftware.metricshub.engine.extension.ExtensionLoader;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.security.SecurityManager;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class ConfigHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigHelper.class);
    public static final String TOP_LEVEL_VIRTUAL_RESOURCE_GROUP_KEY = "metricshub-top-level-rg";

    public static Path getDefaultOutputDirectory() {
        String localAppDataPath;
        if (LocalOsHandler.isWindows() && (localAppDataPath = System.getenv("LOCALAPPDATA")) != null && !localAppDataPath.isBlank()) {
            return ConfigHelper.createDirectories(Paths.get(localAppDataPath, "MetricsHub", "logs"));
        }
        return ConfigHelper.getSubDirectory("logs", true);
    }

    public static Path getSubDirectory(@NonNull String dir, boolean create) {
        if (dir == null) {
            throw new IllegalArgumentException("dir is marked non-null but is null");
        }
        Path subDirectory = ConfigHelper.getSubPath(dir);
        if (!create) {
            return subDirectory;
        }
        return ConfigHelper.createDirectories(subDirectory);
    }

    public static Path createDirectories(Path path) {
        try {
            return Files.createDirectories(path, new FileAttribute[0]).toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create directory '" + String.valueOf(path) + "'.", e);
        }
    }

    public static Path getSubPath(@NonNull String subPath) {
        if (subPath == null) {
            throw new IllegalArgumentException("subPath is marked non-null but is null");
        }
        File sourceDirectory = ConfigHelper.getSourceDirectory();
        Path path = sourceDirectory.getAbsoluteFile().toPath();
        Path parentLibPath = path.getParent();
        if (parentLibPath == null) {
            parentLibPath = path;
        }
        return parentLibPath.resolve("../" + subPath);
    }

    public static File getSourceDirectory() {
        File sourceDirectory;
        try {
            sourceDirectory = ResourceHelper.findSourceDirectory(ConfigHelper.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error detected when getting local source file: ", e);
        }
        if (sourceDirectory == null) {
            throw new IllegalStateException("Could not get the local source file.");
        }
        return sourceDirectory;
    }

    public static Path getDefaultConfigFilePath(String directory, String configFilename) {
        if (LocalOsHandler.isWindows()) {
            return ConfigHelper.getProgramDataConfigFile(directory, configFilename);
        }
        return ConfigHelper.getSubPath(String.format("%s/%s", directory, configFilename));
    }

    static Path getProgramDataConfigFile(String directory, String configFilename) {
        return ConfigHelper.getProgramDataPath().stream().map(path -> Paths.get(ConfigHelper.createDirectories(Paths.get(path, "MetricsHub", directory)).toAbsolutePath().toString(), configFilename)).findFirst().orElseGet(() -> ConfigHelper.getSubPath(String.format("%s/%s", directory, configFilename)));
    }

    public static Optional<String> getProgramDataPath() {
        String programDataPath = System.getenv("ProgramData");
        if (programDataPath != null && !programDataPath.isBlank()) {
            return Optional.of(programDataPath);
        }
        return Optional.empty();
    }

    public static char[] decrypt(char[] encrypted) {
        try {
            return SecurityManager.decrypt(encrypted, PasswordEncrypt.getKeyStoreFile(false));
        }
        catch (Exception e) {
            log.error("Could not decrypt password: {}", (Object)e.getMessage());
            log.debug("Exception", e);
            return encrypted;
        }
    }

    public static File findConfigFile(String configFilePath) throws IOException {
        if (configFilePath != null && !configFilePath.isBlank()) {
            File configFile = new File(configFilePath);
            if (configFile.exists()) {
                return configFile;
            }
            throw new IllegalStateException(String.format("Cannot find %s. Please make sure the file exists on your system", configFilePath));
        }
        return ConfigHelper.getDefaultConfigFile("config", "metricshub.yaml", "metricshub-example.yaml");
    }

    public static File getDefaultConfigFile(String directory, String configFilename, String configFilenameExample) throws IOException {
        Path configPath = ConfigHelper.getDefaultConfigFilePath(directory, configFilename);
        if (Files.exists(configPath, new LinkOption[0])) {
            ConfigHelper.setUserPermissionsOnWindows(configPath, false);
            return configPath.toFile();
        }
        Path exampleConfigPath = ConfigHelper.getSubPath(String.format("%s/%s", directory, configFilenameExample));
        if (!Files.exists(exampleConfigPath, new LinkOption[0])) {
            throw new IllegalStateException(String.format("Cannot find '%s' . Please create the configuration file '%s' before starting the MetricsHub Agent.", exampleConfigPath.toAbsolutePath(), configPath.toAbsolutePath()));
        }
        File configFile = Files.copy(exampleConfigPath, configPath, StandardCopyOption.REPLACE_EXISTING).toFile();
        ConfigHelper.setUserPermissionsOnWindows(configPath, true);
        return configFile;
    }

    private static void setUserPermissionsOnWindows(Path configPath, boolean logError) {
        if (LocalOsHandler.isWindows()) {
            ConfigHelper.setUserPermissions(configPath, logError);
        }
    }

    private static void setUserPermissions(Path configPath, boolean logError) {
        try {
            GroupPrincipal users = configPath.getFileSystem().getUserPrincipalLookupService().lookupPrincipalByGroupName("Users");
            AclFileAttributeView view = Files.getFileAttributeView(configPath, AclFileAttributeView.class, new LinkOption[0]);
            AclEntry entry = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(users).setPermissions(AclEntryPermission.WRITE_DATA, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.WRITE_ACL, AclEntryPermission.WRITE_OWNER, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.READ_DATA, AclEntryPermission.READ_ACL, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.DELETE, AclEntryPermission.APPEND_DATA, AclEntryPermission.DELETE).build();
            List<AclEntry> acl = view.getAcl();
            acl.add(0, entry);
            view.setAcl(acl);
        }
        catch (Exception e) {
            if (logError) {
                log.error("Could not set write permissions to file: {}. Error: {}", (Object)configPath.toString(), (Object)e.getMessage());
                log.error("Exception: ", e);
            }
            log.info("Could not set write permissions to file: {}. Message: {}", (Object)configPath.toString(), (Object)e.getMessage());
        }
    }

    public static JsonMapper newObjectMapper() {
        return (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder(new YAMLFactory()).enable(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS)).enable(SerializationFeature.INDENT_OUTPUT)).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false)).build();
    }

    public static void normalizeAgentConfiguration(AgentConfig agentConfig) {
        agentConfig.getResources().entrySet().forEach(resourceConfigEntry -> ConfigHelper.normalizeResourceConfigUsingAgentConfig(agentConfig, resourceConfigEntry));
        agentConfig.getResourceGroups().entrySet().forEach(resourceGroupConfigEntry -> {
            ResourceGroupConfig resourceGroupConfig = (ResourceGroupConfig)resourceGroupConfigEntry.getValue();
            ConfigHelper.normalizeResourceGroupConfig(agentConfig, resourceGroupConfig);
            resourceGroupConfig.getResources().entrySet().forEach(resourceConfigEntry -> ConfigHelper.normalizeResourceConfig(resourceGroupConfigEntry, resourceConfigEntry));
        });
    }

    private static void normalizeResourceConfigUsingAgentConfig(AgentConfig agentConfig, Map.Entry<String, ResourceConfig> resourceConfigEntry) {
        ResourceConfig resourceConfig = resourceConfigEntry.getValue();
        if (resourceConfig.getCollectPeriod() == null) {
            resourceConfig.setCollectPeriod(agentConfig.getCollectPeriod());
        }
        if (resourceConfig.getDiscoveryCycle() == null) {
            resourceConfig.setDiscoveryCycle(agentConfig.getDiscoveryCycle());
        }
        if (resourceConfig.getLoggerLevel() == null) {
            resourceConfig.setLoggerLevel(agentConfig.getLoggerLevel());
        }
        if (resourceConfig.getOutputDirectory() == null) {
            resourceConfig.setOutputDirectory(agentConfig.getOutputDirectory());
        }
        if (resourceConfig.getSequential() == null) {
            resourceConfig.setSequential(agentConfig.isSequential());
        }
        if (resourceConfig.getEnableSelfMonitoring() == null) {
            resourceConfig.setEnableSelfMonitoring(agentConfig.isEnableSelfMonitoring());
        }
        if (resourceConfig.getMonitorFilters() == null) {
            resourceConfig.setMonitorFilters(agentConfig.getMonitorFilters());
        }
        AlertingSystemConfig resourceGroupAlertingSystemConfig = agentConfig.getAlertingSystemConfig();
        AlertingSystemConfig alertingSystemConfig = resourceConfig.getAlertingSystemConfig();
        if (alertingSystemConfig == null) {
            resourceConfig.setAlertingSystemConfig(resourceGroupAlertingSystemConfig);
        } else if (alertingSystemConfig.getProblemTemplate() == null) {
            alertingSystemConfig.setProblemTemplate(resourceGroupAlertingSystemConfig.getProblemTemplate());
        } else if (alertingSystemConfig.getDisable() == null) {
            alertingSystemConfig.setDisable(resourceGroupAlertingSystemConfig.getDisable());
        }
        if (resourceConfig.getResolveHostnameToFqdn() == null) {
            resourceConfig.setResolveHostnameToFqdn(agentConfig.isResolveHostnameToFqdn());
        }
        if (resourceConfig.getJobTimeout() == null) {
            resourceConfig.setJobTimeout(agentConfig.getJobTimeout());
        }
        if (resourceConfig.getStateSetCompression() == null) {
            resourceConfig.setStateSetCompression(agentConfig.getStateSetCompression());
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        ConfigHelper.mergeAttributes(agentConfig.getAttributes(), attributes);
        ConfigHelper.mergeAttributes(resourceConfig.getAttributes(), attributes);
        resourceConfig.setAttributes(attributes);
        ConfigHelper.normalizeConfiguredConnector(TOP_LEVEL_VIRTUAL_RESOURCE_GROUP_KEY, resourceConfigEntry.getKey(), resourceConfig.getConnector());
    }

    private static void normalizeResourceConfig(Map.Entry<String, ResourceGroupConfig> resourceGroupConfigEntry, Map.Entry<String, ResourceConfig> resourceConfigEntry) {
        ResourceGroupConfig resourceGroupConfig = resourceGroupConfigEntry.getValue();
        ResourceConfig resourceConfig = resourceConfigEntry.getValue();
        if (resourceConfig.getCollectPeriod() == null) {
            resourceConfig.setCollectPeriod(resourceGroupConfig.getCollectPeriod());
        }
        if (resourceConfig.getDiscoveryCycle() == null) {
            resourceConfig.setDiscoveryCycle(resourceGroupConfig.getDiscoveryCycle());
        }
        if (resourceConfig.getLoggerLevel() == null) {
            resourceConfig.setLoggerLevel(resourceGroupConfig.getLoggerLevel());
        }
        if (resourceConfig.getOutputDirectory() == null) {
            resourceConfig.setOutputDirectory(resourceGroupConfig.getOutputDirectory());
        }
        if (resourceConfig.getSequential() == null) {
            resourceConfig.setSequential(resourceGroupConfig.getSequential());
        }
        if (resourceConfig.getEnableSelfMonitoring() == null) {
            resourceConfig.setEnableSelfMonitoring(resourceGroupConfig.getEnableSelfMonitoring());
        }
        if (resourceConfig.getMonitorFilters() == null) {
            resourceConfig.setMonitorFilters(resourceGroupConfig.getMonitorFilters());
        }
        AlertingSystemConfig resourceGroupAlertingSystemConfig = resourceGroupConfig.getAlertingSystemConfig();
        AlertingSystemConfig alertingSystemConfig = resourceConfig.getAlertingSystemConfig();
        if (alertingSystemConfig == null) {
            resourceConfig.setAlertingSystemConfig(resourceGroupAlertingSystemConfig);
        } else if (alertingSystemConfig.getProblemTemplate() == null) {
            alertingSystemConfig.setProblemTemplate(resourceGroupAlertingSystemConfig.getProblemTemplate());
        } else if (alertingSystemConfig.getDisable() == null) {
            alertingSystemConfig.setDisable(resourceGroupAlertingSystemConfig.getDisable());
        }
        if (resourceConfig.getResolveHostnameToFqdn() == null) {
            resourceConfig.setResolveHostnameToFqdn(resourceGroupConfig.getResolveHostnameToFqdn());
        }
        if (resourceConfig.getJobTimeout() == null) {
            resourceConfig.setJobTimeout(resourceGroupConfig.getJobTimeout());
        }
        if (resourceConfig.getStateSetCompression() == null) {
            resourceConfig.setStateSetCompression(resourceGroupConfig.getStateSetCompression());
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        ConfigHelper.mergeAttributes(resourceGroupConfig.getAttributes(), attributes);
        ConfigHelper.mergeAttributes(resourceConfig.getAttributes(), attributes);
        resourceConfig.setAttributes(attributes);
        ConfigHelper.normalizeConfiguredConnector(resourceGroupConfigEntry.getKey(), resourceConfigEntry.getKey(), resourceConfig.getConnector());
    }

    private static void normalizeResourceGroupConfig(AgentConfig agentConfig, ResourceGroupConfig resourceGroupConfig) {
        if (resourceGroupConfig.getCollectPeriod() == null) {
            resourceGroupConfig.setCollectPeriod(agentConfig.getCollectPeriod());
        }
        if (resourceGroupConfig.getDiscoveryCycle() == null) {
            resourceGroupConfig.setDiscoveryCycle(agentConfig.getDiscoveryCycle());
        }
        if (resourceGroupConfig.getLoggerLevel() == null) {
            resourceGroupConfig.setLoggerLevel(agentConfig.getLoggerLevel());
        }
        if (resourceGroupConfig.getOutputDirectory() == null) {
            resourceGroupConfig.setOutputDirectory(agentConfig.getOutputDirectory());
        }
        if (resourceGroupConfig.getSequential() == null) {
            resourceGroupConfig.setSequential(agentConfig.isSequential());
        }
        if (resourceGroupConfig.getEnableSelfMonitoring() == null) {
            resourceGroupConfig.setEnableSelfMonitoring(agentConfig.isEnableSelfMonitoring());
        }
        if (resourceGroupConfig.getMonitorFilters() == null) {
            resourceGroupConfig.setMonitorFilters(agentConfig.getMonitorFilters());
        }
        AlertingSystemConfig alertingSystemConfig = resourceGroupConfig.getAlertingSystemConfig();
        AlertingSystemConfig globalAlertingSystemConfig = agentConfig.getAlertingSystemConfig();
        if (alertingSystemConfig == null) {
            resourceGroupConfig.setAlertingSystemConfig(globalAlertingSystemConfig);
        } else if (alertingSystemConfig.getProblemTemplate() == null) {
            alertingSystemConfig.setProblemTemplate(globalAlertingSystemConfig.getProblemTemplate());
        } else if (alertingSystemConfig.getDisable() == null) {
            alertingSystemConfig.setDisable(globalAlertingSystemConfig.getDisable());
        }
        if (resourceGroupConfig.getResolveHostnameToFqdn() == null) {
            resourceGroupConfig.setResolveHostnameToFqdn(agentConfig.isResolveHostnameToFqdn());
        }
        if (resourceGroupConfig.getJobTimeout() == null) {
            resourceGroupConfig.setJobTimeout(agentConfig.getJobTimeout());
        }
        if (resourceGroupConfig.getStateSetCompression() == null) {
            resourceGroupConfig.setStateSetCompression(agentConfig.getStateSetCompression());
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        ConfigHelper.mergeAttributes(agentConfig.getAttributes(), attributes);
        ConfigHelper.mergeAttributes(resourceGroupConfig.getAttributes(), attributes);
        resourceGroupConfig.setAttributes(attributes);
    }

    public static void mergeAttributes(Map<String, String> attributes, Map<String, String> destinationAttributes) {
        destinationAttributes.putAll(attributes);
    }

    public static void configureGlobalLogger(String loggerLevelStr, String outputDirectory) {
        Level loggerLevel = ConfigHelper.getLoggerLevel(loggerLevelStr);
        ThreadContext.put("logId", "metricshub-agent-global");
        ThreadContext.put("loggerLevel", loggerLevel.toString());
        if (outputDirectory != null) {
            ThreadContext.put("outputDirectory", outputDirectory);
        }
    }

    public static Level getLoggerLevel(String loggerLevel) {
        Level level = loggerLevel != null ? Level.getLevel(loggerLevel.toUpperCase()) : null;
        return level != null ? level : Level.OFF;
    }

    public static Map<String, Map<String, TelemetryManager>> buildTelemetryManagers(@NonNull AgentConfig agentConfig, @NonNull ConnectorStore connectorStore) {
        if (agentConfig == null) {
            throw new IllegalArgumentException("agentConfig is marked non-null but is null");
        }
        if (connectorStore == null) {
            throw new IllegalArgumentException("connectorStore is marked non-null but is null");
        }
        HashMap<String, Map<String, TelemetryManager>> telemetryManagers = new HashMap<String, Map<String, TelemetryManager>>();
        agentConfig.getResourceGroups().forEach((resourceGroupKey, resourceKeyGroupConfig) -> {
            HashMap resourceGroupTelemetryManagers = new HashMap();
            telemetryManagers.put((String)resourceGroupKey, resourceGroupTelemetryManagers);
            resourceKeyGroupConfig.getResources().forEach((resourceKey, resourceConfig) -> ConfigHelper.updateResourceGroupTelemetryManagers(resourceGroupTelemetryManagers, resourceGroupKey, resourceKey, resourceConfig, connectorStore));
        });
        HashMap topLevelResourcesTelemetryManagers = new HashMap();
        agentConfig.getResources().forEach((resourceKey, resourceConfig) -> ConfigHelper.updateResourceGroupTelemetryManagers(topLevelResourcesTelemetryManagers, TOP_LEVEL_VIRTUAL_RESOURCE_GROUP_KEY, resourceKey, resourceConfig, connectorStore));
        telemetryManagers.put(TOP_LEVEL_VIRTUAL_RESOURCE_GROUP_KEY, topLevelResourcesTelemetryManagers);
        return telemetryManagers;
    }

    private static void updateResourceGroupTelemetryManagers(@NonNull Map<String, TelemetryManager> resourceGroupTelemetryManagers, @NonNull String resourceGroupKey, @NonNull String resourceKey, ResourceConfig resourceConfig, @NonNull ConnectorStore connectorStore) {
        if (resourceGroupTelemetryManagers == null) {
            throw new IllegalArgumentException("resourceGroupTelemetryManagers is marked non-null but is null");
        }
        if (resourceGroupKey == null) {
            throw new IllegalArgumentException("resourceGroupKey is marked non-null but is null");
        }
        if (resourceKey == null) {
            throw new IllegalArgumentException("resourceKey is marked non-null but is null");
        }
        if (connectorStore == null) {
            throw new IllegalArgumentException("connectorStore is marked non-null but is null");
        }
        if (resourceConfig == null) {
            return;
        }
        try {
            ConnectorStore resourceConnectorStore = connectorStore.newConnectorStore();
            HostConfiguration hostConfiguration = ConfigHelper.buildHostConfiguration(resourceConfig, resourceConfig.getConnectors(), resourceKey);
            ConfigHelper.validateAndNormalizeProtocols(resourceKey, resourceConfig, hostConfiguration.getHostname());
            ConfigHelper.addConfiguredConnector(resourceConnectorStore, resourceConfig.getConnector());
            AdditionalConnectorsParsingResult additionalConnectorsParsingResult = ConfigHelper.readConnectorsWithConfigurationVariablesSafe(resourceGroupKey, resourceKey, resourceConfig);
            ConfigHelper.updateConnectorStore(resourceConnectorStore, additionalConnectorsParsingResult.getCustomConnectorsMap());
            hostConfiguration.getConnectors().addAll(additionalConnectorsParsingResult.getHostConnectors());
            resourceGroupTelemetryManagers.putIfAbsent(resourceKey, TelemetryManager.builder().connectorStore(resourceConnectorStore).hostConfiguration(hostConfiguration).build());
        }
        catch (Exception e) {
            log.warn("Resource {} - Under the resource group configuration {}, the resource configuration {} has been staged as invalid. Reason: {}", resourceKey, resourceGroupKey, resourceKey, e.getMessage());
        }
    }

    private static AdditionalConnectorsParsingResult readConnectorsWithConfigurationVariablesSafe(String resourceGroupKey, String resourceKey, ResourceConfig resourceConfig) {
        ConnectorVariablesLibraryParser connectorVariablesLibraryParser = new ConnectorVariablesLibraryParser();
        try {
            return connectorVariablesLibraryParser.parse(ConfigHelper.getSubDirectory("connectors", false), resourceConfig.getAdditionalConnectors());
        }
        catch (Exception e) {
            log.warn("Resource {} - Under the resource group configuration {}, the resource configuration {} will not load connectors with configuration variables. Reason: {}.", resourceKey, resourceGroupKey, resourceKey, e.getMessage());
            return new AdditionalConnectorsParsingResult();
        }
    }

    protected static void updateConnectorStore(ConnectorStore resourceConnectorStore, Map<String, Connector> customConnectors) {
        resourceConnectorStore.addMany(customConnectors);
    }

    static void normalizeConfiguredConnector(String resourceGroupKey, String resourceKey, Connector configuredConnector) {
        if (configuredConnector != null) {
            ConnectorIdentity identity = configuredConnector.getOrCreateConnectorIdentity();
            String connectorId = String.format("MetricsHub-Configured-Connector-%s-%s", resourceGroupKey, resourceKey);
            String connectorName = String.format("Configured Connector on resource %s (Group %s)", resourceKey, resourceGroupKey);
            identity.setCompiledFilename(connectorId);
            identity.setDisplayName(connectorName);
        }
    }

    static void addConfiguredConnector(ConnectorStore resourceConnectorStore, Connector configuredConnector) {
        if (configuredConnector != null) {
            resourceConnectorStore.addOne(configuredConnector.getConnectorIdentity().getCompiledFilename(), configuredConnector);
        }
    }

    private static void validateAndNormalizeProtocols(@NonNull String resourceKey, ResourceConfig resourceConfig, String hostname) throws InvalidConfigurationException {
        if (resourceKey == null) {
            throw new IllegalArgumentException("resourceKey is marked non-null but is null");
        }
        Map<String, IConfiguration> protocols = resourceConfig.getProtocols();
        if (protocols == null) {
            return;
        }
        for (Map.Entry<String, IConfiguration> entry : protocols.entrySet()) {
            IConfiguration protocolConfig = entry.getValue();
            if (protocolConfig == null) continue;
            if (protocolConfig.getHostname() == null) {
                protocolConfig.setHostname(hostname);
            }
            protocolConfig.validateConfiguration(resourceKey);
        }
    }

    static HostConfiguration buildHostConfiguration(ResourceConfig resourceConfig, Set<String> connectorsConfiguration, String resourceKey) {
        String hostTypeAttribute;
        String hostId;
        Map<String, IConfiguration> protocols = resourceConfig.getProtocols();
        HashMap<Class<? extends IConfiguration>, IConfiguration> protocolConfigurations = protocols == null ? new HashMap<Class<? extends IConfiguration>, IConfiguration>() : protocols.values().stream().filter(Objects::nonNull).collect(Collectors.toMap((Function<IConfiguration, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lorg/sentrysoftware/metricshub/engine/configuration/IConfiguration;)Ljava/lang/Class;)(), Function.identity()));
        Map<String, String> attributes = resourceConfig.getAttributes();
        String hostname = attributes.get("host.name");
        if (hostname == null) {
            hostname = resourceKey;
        }
        if ((hostId = attributes.get("host.id")) == null) {
            hostId = resourceKey;
        }
        DeviceKind hostType = (hostTypeAttribute = attributes.get("host.type")) == null ? DeviceKind.OTHER : ConfigHelper.detectHostTypeFromAttribute(hostTypeAttribute);
        String configuredConnectorId = null;
        Connector configuredConnector = resourceConfig.getConnector();
        if (configuredConnector != null) {
            configuredConnectorId = configuredConnector.getCompiledFilename();
        }
        HashSet<String> includedMonitors = null;
        HashSet<String> excludedMonitors = null;
        Set<String> monitorFilters = resourceConfig.getMonitorFilters();
        if (monitorFilters != null && !monitorFilters.isEmpty()) {
            for (String monitorFilter : monitorFilters) {
                if (monitorFilter == null || monitorFilter.length() <= 1) continue;
                if (monitorFilter.startsWith("+")) {
                    if (includedMonitors == null) {
                        includedMonitors = new HashSet<String>();
                    }
                    includedMonitors.add(monitorFilter.substring(1));
                    continue;
                }
                if (!monitorFilter.startsWith("!")) continue;
                if (excludedMonitors == null) {
                    excludedMonitors = new HashSet<String>();
                }
                excludedMonitors.add(monitorFilter.substring(1));
            }
        }
        return HostConfiguration.builder().strategyTimeout(resourceConfig.getJobTimeout()).configurations(protocolConfigurations).connectors(connectorsConfiguration).hostname(hostname).hostId(hostId).hostType(hostType).sequential(Boolean.TRUE.equals(resourceConfig.getSequential())).enableSelfMonitoring(Boolean.TRUE.equals(resourceConfig.getEnableSelfMonitoring())).includedMonitors(includedMonitors).excludedMonitors(excludedMonitors).configuredConnectorId(configuredConnectorId).connectorVariables(resourceConfig.getConnectorVariables()).resolveHostnameToFqdn(resourceConfig.getResolveHostnameToFqdn()).build();
    }

    private static DeviceKind detectHostTypeFromAttribute(String hostTypeAttribute) {
        try {
            return DeviceKind.detect(hostTypeAttribute);
        }
        catch (Exception e) {
            return DeviceKind.OTHER;
        }
    }

    public static Path getDirectoryPath(File file) {
        return file.getAbsoluteFile().toPath().getParent();
    }

    public static MetricDefinitions readHostMetricDefinitions() throws IOException {
        return JsonHelper.deserialize((ObjectMapper)ConfigHelper.newObjectMapper(), new ClassPathResource("metricshub-host-metrics.yaml").getInputStream(), MetricDefinitions.class);
    }

    public static Map<String, MetricDefinition> fetchMetricDefinitions(ConnectorStore connectorStore, String connectorId) {
        Map<String, MetricDefinition> connectorMetricDefinitions;
        Connector connector;
        HashMap<String, MetricDefinition> metricDefinitions = new HashMap<String, MetricDefinition>();
        if (connectorStore != null && connectorId != null && (connector = connectorStore.getStore().get(connectorId)) != null && (connectorMetricDefinitions = connector.getMetrics()) != null) {
            metricDefinitions.putAll(connectorMetricDefinitions);
        }
        metricDefinitions.computeIfAbsent("metricshub.connector.status", key -> MetricsHubConstants.CONNECTOR_STATUS_METRIC_DEFINITION);
        return metricDefinitions;
    }

    public static String calculateMD5Checksum(File file) {
        try {
            byte[] data = Files.readAllBytes(file.toPath());
            byte[] hash = MessageDigest.getInstance("MD5").digest(data);
            return new BigInteger(1, hash).toString(16);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ExtensionManager loadExtensionManager() {
        try {
            return new ExtensionLoader(ConfigHelper.getSubDirectory("extensions", false).toFile()).load();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot load extensions.", e);
        }
    }

    public static ConnectorStore buildConnectorStore(ExtensionManager extensionManager, String connectorsPatchPath) {
        ConnectorStore connectorStore = extensionManager.aggregateExtensionConnectorStores();
        connectorStore.addMany(new ConnectorStore(ConfigHelper.getSubDirectory("connectors", false)).getStore());
        if (connectorsPatchPath != null) {
            connectorStore.addMany(new ConnectorStore(Path.of(connectorsPatchPath, new String[0])).getStore());
        }
        return connectorStore;
    }

    @Generated
    private ConfigHelper() {
    }
}

