/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.helper;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.agent.config.AgentConfig;
import org.sentrysoftware.metricshub.agent.helper.ConfigHelper;
import org.sentrysoftware.metricshub.agent.helper.OtelSdkConfigConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtelConfigHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OtelConfigHelper.class);

    static Optional<String> getSecurityFilePath(@NonNull String securityFileDir, @NonNull String defaultSecurityFilename, String securityFile, @NonNull String otlpEndpoint) {
        if (securityFileDir == null) {
            throw new IllegalArgumentException("securityFileDir is marked non-null but is null");
        }
        if (defaultSecurityFilename == null) {
            throw new IllegalArgumentException("defaultSecurityFilename is marked non-null but is null");
        }
        if (otlpEndpoint == null) {
            throw new IllegalArgumentException("otlpEndpoint is marked non-null but is null");
        }
        Path securityFilePath = securityFile == null || securityFile.isBlank() ? ConfigHelper.getSubPath(String.format("%s/%s", securityFileDir, defaultSecurityFilename)) : Path.of(securityFile, new String[0]);
        if (otlpEndpoint.toLowerCase().startsWith("http://")) {
            log.debug("There is no Otel security file to load for the OTLP exporter[endpoint: {}]. The security file {} is loaded only for https connections.", (Object)otlpEndpoint, (Object)securityFilePath);
            return Optional.empty();
        }
        if (!Files.exists(securityFilePath, new LinkOption[0])) {
            log.debug("There is no Otel security file to load. Expected path: {}.", (Object)securityFilePath);
            return Optional.empty();
        }
        return Optional.of(securityFilePath.toAbsolutePath().toString());
    }

    public static Map<String, String> buildOtelSdkConfiguration(AgentConfig agentConfig) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(agentConfig.getOtelSdkConfig());
        OtelConfigHelper.populateCertificate(properties, "otel.exporter.otlp.metrics.endpoint", "otel.exporter.otlp.metrics.certificate");
        OtelConfigHelper.populateCertificate(properties, "otel.exporter.otlp.logs.endpoint", "otel.exporter.otlp.logs.certificate");
        OtelConfigHelper.populateCertificate(properties, "otel.exporter.otlp.endpoint", "otel.exporter.otlp.certificate");
        properties.put("otel.metric.export.interval", OtelSdkConfigConstants.DEFAULT_METRICS_EXPORT_INTERVAL);
        return properties;
    }

    private static void populateCertificate(Map<String, String> properties, String otlpEndpointPropertyKey, String otlpCertificatePropertyKey) {
        String otlpEndpoint = properties.get(otlpEndpointPropertyKey);
        if (otlpEndpoint != null) {
            OtelConfigHelper.getSecurityFilePath("security", "otel.crt", properties.get(otlpCertificatePropertyKey), otlpEndpoint).ifPresent(trustedCertificatesFile -> properties.put(otlpCertificatePropertyKey, (String)trustedCertificatesFile));
        }
    }

    @Generated
    private OtelConfigHelper() {
    }
}

