/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.helper;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.resources.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;

public class OtelHelper {
    public static Resource createOpenTelemetryResource(@NonNull Map<String, String> attributeMap) {
        if (attributeMap == null) {
            throw new IllegalArgumentException("attributeMap is marked non-null but is null");
        }
        return Resource.create(OtelHelper.buildOtelAttributesFromMap(attributeMap));
    }

    public static Attributes buildOtelAttributesFromMap(@NonNull Map<String, String> attributeMap) {
        if (attributeMap == null) {
            throw new IllegalArgumentException("attributeMap is marked non-null but is null");
        }
        return attributeMap.entrySet().stream().filter(entry -> Objects.nonNull(entry.getValue())).filter(entry -> OtelHelper.isAcceptedKey((String)entry.getKey())).map(entry -> Attributes.of(AttributeKey.stringKey((String)entry.getKey()), (String)entry.getValue())).reduce((attributes1, attributes2) -> Attributes.builder().putAll((Attributes)attributes1).putAll((Attributes)attributes2).build()).orElseGet(() -> Attributes.builder().build());
    }

    public static boolean isAcceptedKey(String key) {
        return !key.startsWith("__");
    }

    public static AutoConfiguredOpenTelemetrySdk initOpenTelemetrySdk(@NonNull Resource resource, @NonNull Map<String, String> otelSdkConfiguration) {
        if (resource == null) {
            throw new IllegalArgumentException("resource is marked non-null but is null");
        }
        if (otelSdkConfiguration == null) {
            throw new IllegalArgumentException("otelSdkConfiguration is marked non-null but is null");
        }
        return ((AutoConfiguredOpenTelemetrySdkBuilder)((AutoConfiguredOpenTelemetrySdkBuilder)AutoConfiguredOpenTelemetrySdk.builder().addPropertiesSupplier(() -> otelSdkConfiguration)).addResourceCustomizer((r, c) -> resource)).disableShutdownHook().build();
    }

    public static Resource createHostResource(@NonNull Map<String, String> computedHostResourceAttributes, @NonNull Map<String, String> userAttributes) {
        if (computedHostResourceAttributes == null) {
            throw new IllegalArgumentException("computedHostResourceAttributes is marked non-null but is null");
        }
        if (userAttributes == null) {
            throw new IllegalArgumentException("userAttributes is marked non-null but is null");
        }
        HashMap<String, String> attributes = new HashMap<String, String>(computedHostResourceAttributes);
        userAttributes.entrySet().stream().filter(keyValue -> {
            String key = (String)keyValue.getKey();
            return !key.equals("host.name") && !key.equals("host.type");
        }).forEach(entry -> attributes.put((String)entry.getKey(), (String)entry.getValue()));
        return OtelHelper.createOpenTelemetryResource(attributes);
    }

    public static Attributes mergeOtelAttributes(Attributes firstAttributes, Attributes secondAttributes) {
        return Attributes.builder().putAll(firstAttributes).putAll(secondAttributes).build();
    }

    @Generated
    private OtelHelper() {
    }
}

