/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.process.config;

import lombok.Generated;
import org.sentrysoftware.metricshub.agent.process.config.Slf4jLevel;
import org.sentrysoftware.metricshub.agent.process.io.ProcessorHelper;
import org.sentrysoftware.metricshub.agent.process.io.StreamProcessor;
import org.slf4j.Logger;

public class ProcessOutput {
    final StreamProcessor outputProcessor;
    final StreamProcessor errorProcessor;

    public static ProcessOutput namedConsoleOutput(String label) {
        return ProcessOutput.builder().outputProcessor(ProcessorHelper.namedConsole(String.format("[%s output]", label), false)).build();
    }

    public static ProcessOutput namedConsole(String label) {
        return ProcessOutput.builder().outputProcessor(ProcessorHelper.namedConsole(String.format("[%s output]", label), false)).errorProcessor(ProcessorHelper.namedConsole(String.format("[%s error]", label), true)).build();
    }

    public static ProcessOutput silent() {
        return ProcessOutput.builder().build();
    }

    public static ProcessOutput log(Logger logger) {
        return ProcessOutput.builder().outputProcessor(ProcessorHelper.safeLogger(logger, Slf4jLevel.DEBUG)).errorProcessor(ProcessorHelper.safeLogger(logger, Slf4jLevel.ERROR)).build();
    }

    public static ProcessOutput logOutput(Logger logger) {
        return ProcessOutput.builder().outputProcessor(ProcessorHelper.safeLogger(logger, Slf4jLevel.DEBUG)).build();
    }

    @Generated
    ProcessOutput(StreamProcessor outputProcessor, StreamProcessor errorProcessor) {
        this.outputProcessor = outputProcessor;
        this.errorProcessor = errorProcessor;
    }

    @Generated
    public static ProcessOutputBuilder builder() {
        return new ProcessOutputBuilder();
    }

    @Generated
    public StreamProcessor getOutputProcessor() {
        return this.outputProcessor;
    }

    @Generated
    public StreamProcessor getErrorProcessor() {
        return this.errorProcessor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessOutput)) {
            return false;
        }
        ProcessOutput other = (ProcessOutput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StreamProcessor this$outputProcessor = this.getOutputProcessor();
        StreamProcessor other$outputProcessor = other.getOutputProcessor();
        if (this$outputProcessor == null ? other$outputProcessor != null : !this$outputProcessor.equals(other$outputProcessor)) {
            return false;
        }
        StreamProcessor this$errorProcessor = this.getErrorProcessor();
        StreamProcessor other$errorProcessor = other.getErrorProcessor();
        return !(this$errorProcessor == null ? other$errorProcessor != null : !this$errorProcessor.equals(other$errorProcessor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessOutput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StreamProcessor $outputProcessor = this.getOutputProcessor();
        result = result * 59 + ($outputProcessor == null ? 43 : $outputProcessor.hashCode());
        StreamProcessor $errorProcessor = this.getErrorProcessor();
        result = result * 59 + ($errorProcessor == null ? 43 : $errorProcessor.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProcessOutput(outputProcessor=" + String.valueOf(this.getOutputProcessor()) + ", errorProcessor=" + String.valueOf(this.getErrorProcessor()) + ")";
    }

    @Generated
    public static class ProcessOutputBuilder {
        @Generated
        private StreamProcessor outputProcessor;
        @Generated
        private StreamProcessor errorProcessor;

        @Generated
        ProcessOutputBuilder() {
        }

        @Generated
        public ProcessOutputBuilder outputProcessor(StreamProcessor outputProcessor) {
            this.outputProcessor = outputProcessor;
            return this;
        }

        @Generated
        public ProcessOutputBuilder errorProcessor(StreamProcessor errorProcessor) {
            this.errorProcessor = errorProcessor;
            return this;
        }

        @Generated
        public ProcessOutput build() {
            return new ProcessOutput(this.outputProcessor, this.errorProcessor);
        }

        @Generated
        public String toString() {
            return "ProcessOutput.ProcessOutputBuilder(outputProcessor=" + String.valueOf(this.outputProcessor) + ", errorProcessor=" + String.valueOf(this.errorProcessor) + ")";
        }
    }
}

