/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.process.io;

import java.io.BufferedReader;
import java.io.Reader;
import lombok.NonNull;
import org.sentrysoftware.metricshub.agent.process.io.AbstractReaderProcessor;
import org.sentrysoftware.metricshub.agent.process.io.StreamProcessor;

public class LineReaderProcessor
extends AbstractReaderProcessor {
    public LineReaderProcessor(@NonNull Reader reader, @NonNull StreamProcessor streamProcessor) {
        super(reader, streamProcessor);
        if (reader == null) {
            throw new IllegalArgumentException("reader is marked non-null but is null");
        }
        if (streamProcessor == null) {
            throw new IllegalArgumentException("streamProcessor is marked non-null but is null");
        }
    }

    @Override
    public void run() {
        try (BufferedReader br = new BufferedReader(this.reader);){
            String line;
            while ((line = br.readLine()) != null) {
                this.streamProcessor.process(line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

