/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.process.io;

import java.io.Reader;
import java.util.Optional;
import java.util.function.BiFunction;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.agent.process.config.Slf4jLevel;
import org.sentrysoftware.metricshub.agent.process.io.AbstractReaderProcessor;
import org.sentrysoftware.metricshub.agent.process.io.ConsoleStreamProcessor;
import org.sentrysoftware.metricshub.agent.process.io.NamedStreamProcessor;
import org.sentrysoftware.metricshub.agent.process.io.Slf4jSafeStreamProcessor;
import org.sentrysoftware.metricshub.agent.process.io.Slf4jStreamProcessor;
import org.sentrysoftware.metricshub.agent.process.io.StreamProcessor;
import org.slf4j.Logger;

public class ProcessorHelper {
    public static StreamProcessor namedConsole(String name, boolean isError) {
        return ProcessorHelper.named(name, ProcessorHelper.console(isError));
    }

    public static StreamProcessor named(String name, StreamProcessor destination) {
        return new NamedStreamProcessor(name, destination);
    }

    public static StreamProcessor console(boolean isError) {
        return new ConsoleStreamProcessor(isError);
    }

    public static StreamProcessor logger(Logger logger, Slf4jLevel level) {
        return new Slf4jStreamProcessor(logger, level);
    }

    public static StreamProcessor safeLogger(Logger logger, Slf4jLevel level) {
        return new Slf4jSafeStreamProcessor(ProcessorHelper.logger(logger, level));
    }

    public static StreamProcessor namedLogger(String name, Logger logger, Slf4jLevel level) {
        return ProcessorHelper.named(name, ProcessorHelper.safeLogger(logger, level));
    }

    public static Optional<Thread> connect(Reader reader, StreamProcessor processor, @NonNull BiFunction<Reader, StreamProcessor, AbstractReaderProcessor> linkerFunction) {
        if (linkerFunction == null) {
            throw new IllegalArgumentException("linkerFunction is marked non-null but is null");
        }
        if (reader == null || processor == null) {
            return Optional.empty();
        }
        Thread thread2 = new Thread(linkerFunction.apply(reader, processor));
        thread2.setDaemon(true);
        thread2.start();
        return Optional.of(thread2);
    }

    @Generated
    private ProcessorHelper() {
    }
}

