/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.process.io;

import java.io.Reader;
import lombok.NonNull;
import org.sentrysoftware.metricshub.agent.process.io.AbstractReaderProcessor;
import org.sentrysoftware.metricshub.agent.process.io.StreamProcessor;

public class ReaderProcessor
extends AbstractReaderProcessor {
    private static final int CHAR_BUFFER_LENGTH = 512;

    public ReaderProcessor(@NonNull Reader reader, @NonNull StreamProcessor streamProcessor) {
        super(reader, streamProcessor);
        if (reader == null) {
            throw new IllegalArgumentException("reader is marked non-null but is null");
        }
        if (streamProcessor == null) {
            throw new IllegalArgumentException("streamProcessor is marked non-null but is null");
        }
    }

    @Override
    public void run() {
        try {
            int read;
            char[] buffer = new char[512];
            while ((read = this.reader.read(buffer)) != -1) {
                this.streamProcessor.process(new String(buffer, 0, read));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

