/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.process.runtime;

import java.io.IOException;
import java.io.Reader;
import lombok.Generated;
import org.sentrysoftware.metricshub.agent.process.config.ProcessConfig;
import org.sentrysoftware.metricshub.agent.process.config.ProcessOutput;
import org.sentrysoftware.metricshub.agent.process.runtime.IStoppable;
import org.sentrysoftware.metricshub.agent.process.runtime.ProcessControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcess
implements IStoppable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractProcess.class);
    protected final ProcessConfig processConfig;
    protected ProcessControl processControl;
    protected boolean stopped;

    protected AbstractProcess(ProcessConfig processConfig) {
        this.processConfig = processConfig;
    }

    public void start() throws IOException {
        try {
            this.onBeforeProcess();
            ProcessOutput output = this.processConfig.getOutput();
            ProcessBuilder processBuilder = ProcessControl.newProcessBuilder(this.processConfig.getCommandLine(), this.processConfig.getEnvironment(), this.processConfig.getWorkingDir(), output != null && output.getErrorProcessor() == null);
            this.onBeforeProcessStart(processBuilder);
            this.processControl = ProcessControl.start(processBuilder);
            ProcessControl.addShutdownHook(this::stop);
            this.onAfterProcessStart();
            this.stopped = false;
            log.info("Started process with command line: {}", (Object)this.processConfig.getCommandLine());
        }
        catch (Exception e) {
            log.error("Cannot start the process due to an exception: {}", (Object)e.getMessage());
            log.debug("Exception: ", e);
            this.stop();
            throw e;
        }
    }

    @Override
    public void stop() {
        if (!this.stopped) {
            this.onBeforeProcessStop();
            this.stopInternal();
            this.stopped = true;
            this.onAfterProcessStop();
            log.info("Stopped process previously launched with command line: {}", (Object)this.processConfig.getCommandLine());
        }
    }

    protected final void stopProcess() {
        if (this.processControl != null) {
            this.processControl.stop();
        }
    }

    protected abstract void onBeforeProcess();

    protected abstract void onBeforeProcessStart(ProcessBuilder var1);

    protected abstract void onAfterProcessStart();

    protected abstract void onBeforeProcessStop();

    protected abstract void onAfterProcessStop();

    protected abstract void stopInternal();

    protected Reader getReader() {
        return this.processControl.getReader();
    }

    protected Reader getError() {
        return this.processControl.getError();
    }

    @Generated
    public ProcessConfig getProcessConfig() {
        return this.processConfig;
    }

    @Generated
    public ProcessControl getProcessControl() {
        return this.processControl;
    }

    @Generated
    public boolean isStopped() {
        return this.stopped;
    }
}

