/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.process.runtime;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ProcessControl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessControl.class);
    private final Process process;
    private InputStreamReader reader;
    private InputStreamReader error;

    ProcessControl(Process process) {
        InputStream errorStream;
        this.process = process;
        InputStream inputStream2 = process.getInputStream();
        if (inputStream2 != null) {
            this.reader = new InputStreamReader(inputStream2);
        }
        if ((errorStream = process.getErrorStream()) != null) {
            this.error = new InputStreamReader(errorStream);
        }
    }

    public static ProcessBuilder newProcessBuilder(@NonNull List<String> commandLine, @NonNull Map<String, String> environment2, File workingDir, boolean redirectErrorStream) {
        if (commandLine == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        if (environment2 == null) {
            throw new IllegalArgumentException("environment is marked non-null but is null");
        }
        Assert.isTrue(!commandLine.isEmpty(), "Command line cannot be empty.");
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        processBuilder.environment().putAll(environment2);
        if (workingDir != null) {
            processBuilder.directory(workingDir);
        }
        processBuilder.redirectErrorStream(redirectErrorStream);
        return processBuilder;
    }

    public static ProcessControl start(ProcessBuilder processBuilder) throws IOException {
        return new ProcessControl(processBuilder.start());
    }

    public void stop() {
        try {
            this.close(this.process.getErrorStream());
            this.close(this.process.getInputStream());
            this.close(this.process.getOutputStream());
            this.process.destroy();
        }
        catch (Exception e) {
            log.error("Error detected when terminating the process. Message {}.", (Object)e.getMessage());
            log.debug("Exception: ", e);
        }
        this.reader = null;
        this.error = null;
    }

    private void close(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void addShutdownHook(Runnable runnable2) {
        Runtime.getRuntime().addShutdownHook(new Thread(runnable2));
    }

    @Generated
    public Process getProcess() {
        return this.process;
    }

    @Generated
    public InputStreamReader getReader() {
        return this.reader;
    }

    @Generated
    public InputStreamReader getError() {
        return this.error;
    }
}

