/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.security;

import java.io.Console;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import lombok.Generated;
import org.sentrysoftware.metricshub.agent.helper.ConfigHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.LocalOsHandler;
import org.sentrysoftware.metricshub.engine.common.helpers.ResourceHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.security.SecurityManager;

public class PasswordEncrypt {
    public static File getKeyStoreFile(boolean mkdir) {
        Path securityDirectoryPath = LocalOsHandler.isWindows() ? PasswordEncrypt.getSecurityFolderOnWindows() : PasswordEncrypt.getSecurityFolderFromInstallDir();
        return PasswordEncrypt.resolveKeyStoreFile(securityDirectoryPath, mkdir);
    }

    static Path getSecurityFolderOnWindows() {
        return ConfigHelper.getProgramDataPath().stream().map(path -> Paths.get(path, "MetricsHub", "security")).findFirst().orElseGet(PasswordEncrypt::getSecurityFolderFromInstallDir);
    }

    static Path getSecurityFolderFromInstallDir() {
        File sourceDirectory;
        try {
            sourceDirectory = ResourceHelper.findSourceDirectory(PasswordEncrypt.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error detected when getting local source file to get the keyStore.", e);
        }
        if (sourceDirectory == null) {
            throw new IllegalStateException("Could not get the local source file to get the keyStore.");
        }
        Path path = sourceDirectory.getAbsoluteFile().toPath();
        Path parentLibPath = path.getParent();
        if (parentLibPath == null) {
            parentLibPath = path;
        }
        return Paths.get(parentLibPath.toString(), "..", "security");
    }

    static File resolveKeyStoreFile(Path securityDirectory, boolean mkdir) {
        if (mkdir && !Files.isDirectory(securityDirectory, new LinkOption[0])) {
            securityDirectory = ConfigHelper.createDirectories(securityDirectory);
        }
        return Paths.get(securityDirectory.toAbsolutePath().toString(), "metricshub-keystore.p12").toFile();
    }

    public static void main(String[] args2) {
        try {
            char[] password;
            if (args2.length > 0) {
                password = args2[0].toCharArray();
            } else {
                Console console = System.console();
                if (console == null) {
                    System.out.println("No console. Cannot read passwords without console.");
                    return;
                }
                System.out.print("Enter the password to encrypt: ");
                password = console.readPassword();
            }
            System.out.println(SecurityManager.encrypt(password, PasswordEncrypt.getKeyStoreFile(true)));
        }
        catch (Exception e) {
            System.err.println(String.format("Error while encrypting password: %s", StringHelper.getStackMessages(e)));
        }
    }

    @Generated
    private PasswordEncrypt() {
    }

    static {
        Locale.setDefault(Locale.US);
    }
}

