/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.service;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.sentrysoftware.metricshub.agent.config.AgentConfig;
import org.sentrysoftware.metricshub.agent.config.otel.OtelCollectorConfig;
import org.sentrysoftware.metricshub.agent.config.otel.OtelCollectorOutput;
import org.sentrysoftware.metricshub.agent.process.config.ProcessOutput;
import org.sentrysoftware.metricshub.agent.process.io.LineReaderProcessor;
import org.sentrysoftware.metricshub.agent.process.io.ProcessorHelper;
import org.sentrysoftware.metricshub.agent.process.runtime.AbstractProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtelCollectorProcessService
extends AbstractProcess {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OtelCollectorProcessService.class);
    private AgentConfig agentConfig;

    public OtelCollectorProcessService(AgentConfig agentConfig) {
        super(agentConfig.getOtelCollector().toProcessConfig());
        this.agentConfig = agentConfig;
    }

    @Override
    protected void onBeforeProcess() {
    }

    @Override
    protected void onBeforeProcessStart(ProcessBuilder processBuilder) {
    }

    @Override
    protected void onAfterProcessStart() {
        ProcessOutput outputConfig = this.processConfig.getOutput();
        if (outputConfig != null) {
            ProcessorHelper.connect(this.getReader(), outputConfig.getOutputProcessor(), LineReaderProcessor::new);
            ProcessorHelper.connect(this.getError(), outputConfig.getErrorProcessor(), LineReaderProcessor::new);
        }
    }

    @Override
    protected void onBeforeProcessStop() {
    }

    @Override
    protected void stopInternal() {
        super.stopProcess();
    }

    @Override
    protected void onAfterProcessStop() {
    }

    public void launch() {
        OtelCollectorConfig otelCollectorConfig = this.agentConfig.getOtelCollector();
        if (this.agentConfig.getOtelCollector().isDisabled()) {
            log.info("The MetricsHub Agent is configured to not start the OpenTelemetry Collector.");
            return;
        }
        List<String> commandLine = this.processConfig.getCommandLine();
        if (commandLine.isEmpty() || !Files.exists(Paths.get(commandLine.get(0), new String[0]), new LinkOption[0])) {
            log.info("The MetricsHub Agent will not start the OpenTelemetry Collector because the executable is not present.");
            return;
        }
        ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
        singleThreadExecutor.submit(() -> {
            ThreadContext.put("logId", "otelcol");
            String loggerLevel = Level.DEBUG.name();
            if (otelCollectorConfig.getOutput() != OtelCollectorOutput.LOG) {
                loggerLevel = Level.OFF.name();
            }
            ThreadContext.put("loggerLevel", loggerLevel);
            String outputDirectory = this.agentConfig.getOutputDirectory();
            if (outputDirectory != null) {
                ThreadContext.put("outputDirectory", outputDirectory);
            }
            try {
                this.start();
            }
            catch (Exception e) {
                log.error("Could not start process using command line: {}.", (Object)this.processConfig.getCommandLine());
                log.debug("Error: ", e);
            }
        });
        try {
            singleThreadExecutor.awaitTermination(otelCollectorConfig.getStartupDelay(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("Startup process has been interrupted after {} seconds. Command line: {}.", (Object)otelCollectorConfig.getStartupDelay(), (Object)this.processConfig.getCommandLine());
            log.debug("Error: ", e);
        }
    }
}

