/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.service;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import lombok.Generated;
import org.sentrysoftware.metricshub.agent.config.AgentConfig;
import org.sentrysoftware.metricshub.agent.config.ResourceConfig;
import org.sentrysoftware.metricshub.agent.config.ResourceGroupConfig;
import org.sentrysoftware.metricshub.agent.context.AgentInfo;
import org.sentrysoftware.metricshub.agent.context.MetricDefinitions;
import org.sentrysoftware.metricshub.agent.service.OtelCollectorProcessService;
import org.sentrysoftware.metricshub.agent.service.scheduling.ResourceGroupScheduling;
import org.sentrysoftware.metricshub.agent.service.scheduling.ResourceScheduling;
import org.sentrysoftware.metricshub.agent.service.scheduling.SelfObserverScheduling;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class TaskSchedulingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskSchedulingService.class);
    private File configFile;
    private AgentConfig agentConfig;
    private AgentInfo agentInfo;
    private ThreadPoolTaskScheduler taskScheduler;
    private Map<String, ScheduledFuture<?>> schedules;
    private OtelCollectorProcessService otelCollectorProcessService;
    private Map<String, Map<String, TelemetryManager>> telemetryManagers;
    private Map<String, String> otelSdkConfiguration;
    private MetricDefinitions hostMetricDefinitions;
    private ExtensionManager extensionManager;

    public void start() {
        this.scheduleSelfObserver();
        this.scheduleTopLevelResourcesObservers();
        this.scheduleResourceGroupObservers();
    }

    void scheduleSelfObserver() {
        SelfObserverScheduling.builder().withAgentConfig(this.agentConfig).withAgentInfo(this.agentInfo).withOtelSdkConfiguration(this.otelSdkConfiguration).withSchedules(this.schedules).withTaskScheduler(this.taskScheduler).build().schedule();
    }

    void scheduleResourceGroupObservers() {
        this.agentConfig.getResourceGroups().entrySet().stream().filter(entry -> Objects.nonNull(entry.getValue())).forEach(entry -> {
            ResourceGroupConfig resourceGroupConfig = (ResourceGroupConfig)entry.getValue();
            String resourceGroupKey = (String)entry.getKey();
            this.scheduleResourceGroup(resourceGroupKey, resourceGroupConfig);
            this.scheduleResourcesInResourceGroups(resourceGroupKey, resourceGroupConfig);
        });
        log.info("Resource Group Observers scheduled.");
    }

    void scheduleTopLevelResourcesObservers() {
        this.agentConfig.getResources().entrySet().stream().filter(entry -> Objects.nonNull(entry.getValue())).forEach(entry -> this.scheduleResource("metricshub-top-level-rg", (String)entry.getKey(), (ResourceConfig)entry.getValue()));
        log.info("Top level resources Observers scheduled.");
    }

    void scheduleResourceGroup(String resourceGroupKey, ResourceGroupConfig resourceGroupConfig) {
        ResourceGroupScheduling.builder().withAgentConfig(this.agentConfig).withOtelSdkConfiguration(this.otelSdkConfiguration).withSchedules(this.schedules).withTaskScheduler(this.taskScheduler).withResourceGroupKey(resourceGroupKey).withResourceGroupConfig(resourceGroupConfig).build().schedule();
    }

    void scheduleResourcesInResourceGroups(String resourceGroupKey, ResourceGroupConfig resourceGroupConfig) {
        resourceGroupConfig.getResources().entrySet().stream().filter(entry -> Objects.nonNull(entry.getValue())).forEach(entry -> this.scheduleResource(resourceGroupKey, (String)entry.getKey(), (ResourceConfig)entry.getValue()));
    }

    void scheduleResource(String resourceGroupKey, String resourceKey, ResourceConfig resourceConfig) {
        Map<String, TelemetryManager> perGroupTelemetryManagers = this.telemetryManagers.get(resourceGroupKey);
        if (perGroupTelemetryManagers == null) {
            log.info("The resource group {} has been removed from the configuration.", (Object)resourceGroupKey);
            return;
        }
        TelemetryManager telemetryManager = perGroupTelemetryManagers.get(resourceKey);
        if (telemetryManager == null) {
            log.info("The resource {} has been removed from the configuration.", (Object)resourceKey);
            return;
        }
        ResourceScheduling.builder().withOtelSdkConfiguration(this.otelSdkConfiguration).withSchedules(this.schedules).withTaskScheduler(this.taskScheduler).withResourceGroupKey(resourceGroupKey).withResourceKey(resourceKey).withResourceConfig(resourceConfig).withTelemetryManager(telemetryManager).withHostMetricDefinitions(this.hostMetricDefinitions).withExtensionManager(this.extensionManager).build().schedule();
    }

    public static ThreadPoolTaskScheduler newScheduler(int jobPoolSize) {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(jobPoolSize);
        threadPoolTaskScheduler.setThreadNamePrefix("metricshub-task-");
        threadPoolTaskScheduler.initialize();
        return threadPoolTaskScheduler;
    }

    public void stop() {
        this.schedules.values().forEach(action -> action.cancel(true));
        this.taskScheduler.destroy();
    }

    @Generated
    TaskSchedulingService(File configFile, AgentConfig agentConfig, AgentInfo agentInfo, ThreadPoolTaskScheduler taskScheduler, Map<String, ScheduledFuture<?>> schedules, OtelCollectorProcessService otelCollectorProcessService, Map<String, Map<String, TelemetryManager>> telemetryManagers, Map<String, String> otelSdkConfiguration, MetricDefinitions hostMetricDefinitions, ExtensionManager extensionManager) {
        this.configFile = configFile;
        this.agentConfig = agentConfig;
        this.agentInfo = agentInfo;
        this.taskScheduler = taskScheduler;
        this.schedules = schedules;
        this.otelCollectorProcessService = otelCollectorProcessService;
        this.telemetryManagers = telemetryManagers;
        this.otelSdkConfiguration = otelSdkConfiguration;
        this.hostMetricDefinitions = hostMetricDefinitions;
        this.extensionManager = extensionManager;
    }

    @Generated
    public static TaskSchedulingServiceBuilder builder() {
        return new TaskSchedulingServiceBuilder();
    }

    @Generated
    public File getConfigFile() {
        return this.configFile;
    }

    @Generated
    public AgentConfig getAgentConfig() {
        return this.agentConfig;
    }

    @Generated
    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    @Generated
    public ThreadPoolTaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    @Generated
    public Map<String, ScheduledFuture<?>> getSchedules() {
        return this.schedules;
    }

    @Generated
    public OtelCollectorProcessService getOtelCollectorProcessService() {
        return this.otelCollectorProcessService;
    }

    @Generated
    public Map<String, Map<String, TelemetryManager>> getTelemetryManagers() {
        return this.telemetryManagers;
    }

    @Generated
    public Map<String, String> getOtelSdkConfiguration() {
        return this.otelSdkConfiguration;
    }

    @Generated
    public MetricDefinitions getHostMetricDefinitions() {
        return this.hostMetricDefinitions;
    }

    @Generated
    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Generated
    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    @Generated
    public void setAgentConfig(AgentConfig agentConfig) {
        this.agentConfig = agentConfig;
    }

    @Generated
    public void setAgentInfo(AgentInfo agentInfo) {
        this.agentInfo = agentInfo;
    }

    @Generated
    public void setTaskScheduler(ThreadPoolTaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    @Generated
    public void setSchedules(Map<String, ScheduledFuture<?>> schedules) {
        this.schedules = schedules;
    }

    @Generated
    public void setOtelCollectorProcessService(OtelCollectorProcessService otelCollectorProcessService) {
        this.otelCollectorProcessService = otelCollectorProcessService;
    }

    @Generated
    public void setTelemetryManagers(Map<String, Map<String, TelemetryManager>> telemetryManagers) {
        this.telemetryManagers = telemetryManagers;
    }

    @Generated
    public void setOtelSdkConfiguration(Map<String, String> otelSdkConfiguration) {
        this.otelSdkConfiguration = otelSdkConfiguration;
    }

    @Generated
    public void setHostMetricDefinitions(MetricDefinitions hostMetricDefinitions) {
        this.hostMetricDefinitions = hostMetricDefinitions;
    }

    @Generated
    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskSchedulingService)) {
            return false;
        }
        TaskSchedulingService other = (TaskSchedulingService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$configFile = this.getConfigFile();
        File other$configFile = other.getConfigFile();
        if (this$configFile == null ? other$configFile != null : !((Object)this$configFile).equals(other$configFile)) {
            return false;
        }
        AgentConfig this$agentConfig = this.getAgentConfig();
        AgentConfig other$agentConfig = other.getAgentConfig();
        if (this$agentConfig == null ? other$agentConfig != null : !((Object)this$agentConfig).equals(other$agentConfig)) {
            return false;
        }
        AgentInfo this$agentInfo = this.getAgentInfo();
        AgentInfo other$agentInfo = other.getAgentInfo();
        if (this$agentInfo == null ? other$agentInfo != null : !this$agentInfo.equals(other$agentInfo)) {
            return false;
        }
        ThreadPoolTaskScheduler this$taskScheduler = this.getTaskScheduler();
        ThreadPoolTaskScheduler other$taskScheduler = other.getTaskScheduler();
        if (this$taskScheduler == null ? other$taskScheduler != null : !this$taskScheduler.equals(other$taskScheduler)) {
            return false;
        }
        Map<String, ScheduledFuture<?>> this$schedules = this.getSchedules();
        Map<String, ScheduledFuture<?>> other$schedules = other.getSchedules();
        if (this$schedules == null ? other$schedules != null : !((Object)this$schedules).equals(other$schedules)) {
            return false;
        }
        OtelCollectorProcessService this$otelCollectorProcessService = this.getOtelCollectorProcessService();
        OtelCollectorProcessService other$otelCollectorProcessService = other.getOtelCollectorProcessService();
        if (this$otelCollectorProcessService == null ? other$otelCollectorProcessService != null : !this$otelCollectorProcessService.equals(other$otelCollectorProcessService)) {
            return false;
        }
        Map<String, Map<String, TelemetryManager>> this$telemetryManagers = this.getTelemetryManagers();
        Map<String, Map<String, TelemetryManager>> other$telemetryManagers = other.getTelemetryManagers();
        if (this$telemetryManagers == null ? other$telemetryManagers != null : !((Object)this$telemetryManagers).equals(other$telemetryManagers)) {
            return false;
        }
        Map<String, String> this$otelSdkConfiguration = this.getOtelSdkConfiguration();
        Map<String, String> other$otelSdkConfiguration = other.getOtelSdkConfiguration();
        if (this$otelSdkConfiguration == null ? other$otelSdkConfiguration != null : !((Object)this$otelSdkConfiguration).equals(other$otelSdkConfiguration)) {
            return false;
        }
        MetricDefinitions this$hostMetricDefinitions = this.getHostMetricDefinitions();
        MetricDefinitions other$hostMetricDefinitions = other.getHostMetricDefinitions();
        if (this$hostMetricDefinitions == null ? other$hostMetricDefinitions != null : !((Object)this$hostMetricDefinitions).equals(other$hostMetricDefinitions)) {
            return false;
        }
        ExtensionManager this$extensionManager = this.getExtensionManager();
        ExtensionManager other$extensionManager = other.getExtensionManager();
        return !(this$extensionManager == null ? other$extensionManager != null : !((Object)this$extensionManager).equals(other$extensionManager));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskSchedulingService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $configFile = this.getConfigFile();
        result = result * 59 + ($configFile == null ? 43 : ((Object)$configFile).hashCode());
        AgentConfig $agentConfig = this.getAgentConfig();
        result = result * 59 + ($agentConfig == null ? 43 : ((Object)$agentConfig).hashCode());
        AgentInfo $agentInfo = this.getAgentInfo();
        result = result * 59 + ($agentInfo == null ? 43 : $agentInfo.hashCode());
        ThreadPoolTaskScheduler $taskScheduler = this.getTaskScheduler();
        result = result * 59 + ($taskScheduler == null ? 43 : $taskScheduler.hashCode());
        Map<String, ScheduledFuture<?>> $schedules = this.getSchedules();
        result = result * 59 + ($schedules == null ? 43 : ((Object)$schedules).hashCode());
        OtelCollectorProcessService $otelCollectorProcessService = this.getOtelCollectorProcessService();
        result = result * 59 + ($otelCollectorProcessService == null ? 43 : $otelCollectorProcessService.hashCode());
        Map<String, Map<String, TelemetryManager>> $telemetryManagers = this.getTelemetryManagers();
        result = result * 59 + ($telemetryManagers == null ? 43 : ((Object)$telemetryManagers).hashCode());
        Map<String, String> $otelSdkConfiguration = this.getOtelSdkConfiguration();
        result = result * 59 + ($otelSdkConfiguration == null ? 43 : ((Object)$otelSdkConfiguration).hashCode());
        MetricDefinitions $hostMetricDefinitions = this.getHostMetricDefinitions();
        result = result * 59 + ($hostMetricDefinitions == null ? 43 : ((Object)$hostMetricDefinitions).hashCode());
        ExtensionManager $extensionManager = this.getExtensionManager();
        result = result * 59 + ($extensionManager == null ? 43 : ((Object)$extensionManager).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskSchedulingService(configFile=" + String.valueOf(this.getConfigFile()) + ", agentConfig=" + String.valueOf(this.getAgentConfig()) + ", agentInfo=" + String.valueOf(this.getAgentInfo()) + ", taskScheduler=" + String.valueOf(this.getTaskScheduler()) + ", schedules=" + String.valueOf(this.getSchedules()) + ", otelCollectorProcessService=" + String.valueOf(this.getOtelCollectorProcessService()) + ", telemetryManagers=" + String.valueOf(this.getTelemetryManagers()) + ", otelSdkConfiguration=" + String.valueOf(this.getOtelSdkConfiguration()) + ", hostMetricDefinitions=" + String.valueOf(this.getHostMetricDefinitions()) + ", extensionManager=" + String.valueOf(this.getExtensionManager()) + ")";
    }

    @Generated
    public static class TaskSchedulingServiceBuilder {
        @Generated
        private File configFile;
        @Generated
        private AgentConfig agentConfig;
        @Generated
        private AgentInfo agentInfo;
        @Generated
        private ThreadPoolTaskScheduler taskScheduler;
        @Generated
        private Map<String, ScheduledFuture<?>> schedules;
        @Generated
        private OtelCollectorProcessService otelCollectorProcessService;
        @Generated
        private Map<String, Map<String, TelemetryManager>> telemetryManagers;
        @Generated
        private Map<String, String> otelSdkConfiguration;
        @Generated
        private MetricDefinitions hostMetricDefinitions;
        @Generated
        private ExtensionManager extensionManager;

        @Generated
        TaskSchedulingServiceBuilder() {
        }

        @Generated
        public TaskSchedulingServiceBuilder withConfigFile(File configFile) {
            this.configFile = configFile;
            return this;
        }

        @Generated
        public TaskSchedulingServiceBuilder withAgentConfig(AgentConfig agentConfig) {
            this.agentConfig = agentConfig;
            return this;
        }

        @Generated
        public TaskSchedulingServiceBuilder withAgentInfo(AgentInfo agentInfo) {
            this.agentInfo = agentInfo;
            return this;
        }

        @Generated
        public TaskSchedulingServiceBuilder withTaskScheduler(ThreadPoolTaskScheduler taskScheduler) {
            this.taskScheduler = taskScheduler;
            return this;
        }

        @Generated
        public TaskSchedulingServiceBuilder withSchedules(Map<String, ScheduledFuture<?>> schedules) {
            this.schedules = schedules;
            return this;
        }

        @Generated
        public TaskSchedulingServiceBuilder withOtelCollectorProcessService(OtelCollectorProcessService otelCollectorProcessService) {
            this.otelCollectorProcessService = otelCollectorProcessService;
            return this;
        }

        @Generated
        public TaskSchedulingServiceBuilder withTelemetryManagers(Map<String, Map<String, TelemetryManager>> telemetryManagers) {
            this.telemetryManagers = telemetryManagers;
            return this;
        }

        @Generated
        public TaskSchedulingServiceBuilder withOtelSdkConfiguration(Map<String, String> otelSdkConfiguration) {
            this.otelSdkConfiguration = otelSdkConfiguration;
            return this;
        }

        @Generated
        public TaskSchedulingServiceBuilder withHostMetricDefinitions(MetricDefinitions hostMetricDefinitions) {
            this.hostMetricDefinitions = hostMetricDefinitions;
            return this;
        }

        @Generated
        public TaskSchedulingServiceBuilder withExtensionManager(ExtensionManager extensionManager) {
            this.extensionManager = extensionManager;
            return this;
        }

        @Generated
        public TaskSchedulingService build() {
            return new TaskSchedulingService(this.configFile, this.agentConfig, this.agentInfo, this.taskScheduler, this.schedules, this.otelCollectorProcessService, this.telemetryManagers, this.otelSdkConfiguration, this.hostMetricDefinitions, this.extensionManager);
        }

        @Generated
        public String toString() {
            return "TaskSchedulingService.TaskSchedulingServiceBuilder(configFile=" + String.valueOf(this.configFile) + ", agentConfig=" + String.valueOf(this.agentConfig) + ", agentInfo=" + String.valueOf(this.agentInfo) + ", taskScheduler=" + String.valueOf(this.taskScheduler) + ", schedules=" + String.valueOf(this.schedules) + ", otelCollectorProcessService=" + String.valueOf(this.otelCollectorProcessService) + ", telemetryManagers=" + String.valueOf(this.telemetryManagers) + ", otelSdkConfiguration=" + String.valueOf(this.otelSdkConfiguration) + ", hostMetricDefinitions=" + String.valueOf(this.hostMetricDefinitions) + ", extensionManager=" + String.valueOf(this.extensionManager) + ")";
        }
    }
}

