/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.service.scheduling;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.resources.Resource;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.agent.config.AgentConfig;
import org.sentrysoftware.metricshub.agent.config.ResourceGroupConfig;
import org.sentrysoftware.metricshub.agent.helper.OtelHelper;
import org.sentrysoftware.metricshub.agent.service.scheduling.AbstractScheduling;
import org.sentrysoftware.metricshub.agent.service.signal.SimpleGaugeMetricObserver;
import org.sentrysoftware.metricshub.engine.telemetry.MetricFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.support.PeriodicTrigger;

public class ResourceGroupScheduling
extends AbstractScheduling {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceGroupScheduling.class);
    public static final String METRICSHUB_RESOURCE_GROUP_KEY_FORMAT = "metricshub-resource-group-%s";
    public static final String HW_SITE_PUE_METRIC = "hw.site.pue";
    public static final String HW_SITE_ELECTRICITY_COST_METRIC = "hw.site.electricity_cost";
    public static final String HW_SITE_CARBON_INTENSITY_METRIC = "hw.site.carbon_intensity";
    private static final Map<String, String> KNOWN_METRIC_UNITS = Map.of("hw.site.carbon_intensity", "g", "hw.site.electricity_cost", "", "hw.site.pue", "1");
    @NonNull
    private ResourceGroupConfig resourceGroupConfig;
    @NonNull
    private String resourceGroupKey;
    @NonNull
    private AgentConfig agentConfig;

    public ResourceGroupScheduling(@NonNull TaskScheduler taskScheduler, @NonNull Map<String, ScheduledFuture<?>> schedules, @NonNull Map<String, String> otelSdkConfiguration, @NonNull String resourceGroupKey, @NonNull ResourceGroupConfig resourceGroupConfig, @NonNull AgentConfig agentConfig) {
        super(taskScheduler, schedules, otelSdkConfiguration);
        if (taskScheduler == null) {
            throw new IllegalArgumentException("taskScheduler is marked non-null but is null");
        }
        if (schedules == null) {
            throw new IllegalArgumentException("schedules is marked non-null but is null");
        }
        if (otelSdkConfiguration == null) {
            throw new IllegalArgumentException("otelSdkConfiguration is marked non-null but is null");
        }
        if (resourceGroupKey == null) {
            throw new IllegalArgumentException("resourceGroupKey is marked non-null but is null");
        }
        if (resourceGroupConfig == null) {
            throw new IllegalArgumentException("resourceGroupConfig is marked non-null but is null");
        }
        if (agentConfig == null) {
            throw new IllegalArgumentException("agentConfig is marked non-null but is null");
        }
        this.resourceGroupConfig = resourceGroupConfig;
        this.resourceGroupKey = resourceGroupKey;
        this.agentConfig = agentConfig;
    }

    @Override
    public void schedule() {
        Resource resource = OtelHelper.createOpenTelemetryResource(this.resourceGroupConfig.getAttributes());
        AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk = OtelHelper.initOpenTelemetrySdk(resource, this.otelSdkConfiguration);
        PeriodicTrigger trigger = new PeriodicTrigger(Duration.of(this.agentConfig.getCollectPeriod(), ChronoUnit.SECONDS));
        SdkMeterProvider meterProvider = autoConfiguredOpenTelemetrySdk.getOpenTelemetrySdk().getSdkMeterProvider();
        Attributes resourceGroupAttributes = OtelHelper.buildOtelAttributesFromMap(this.resourceGroupConfig.getAttributes());
        this.resourceGroupConfig.getMetrics().entrySet().stream().filter(metricEntry -> Objects.nonNull(metricEntry.getValue())).forEach(metricEntry -> {
            String metricKey = (String)metricEntry.getKey();
            String metricName = MetricFactory.extractName(metricKey);
            Attributes attributes = OtelHelper.mergeOtelAttributes(resourceGroupAttributes, OtelHelper.buildOtelAttributesFromMap(MetricFactory.extractAttributesFromMetricName(metricKey)));
            SimpleGaugeMetricObserver.builder().withMetricName(metricName).withMetricValue((Double)metricEntry.getValue()).withMeter(this.getMeter(meterProvider, metricKey)).withAttributes(attributes).withUnit(KNOWN_METRIC_UNITS.get(metricName)).withDescription(String.format("Reports metric %s", metricName)).build().init();
        });
        ScheduledFuture<?> scheduledFuture = this.taskScheduler.schedule(meterProvider::forceFlush, trigger);
        this.schedules.put(String.format(METRICSHUB_RESOURCE_GROUP_KEY_FORMAT, this.resourceGroupKey), scheduledFuture);
        log.info("Resource Group {} scheduled.", (Object)this.resourceGroupKey);
    }

    private Meter getMeter(SdkMeterProvider sdkMeterProvider, String metricName) {
        return sdkMeterProvider.get(String.format("org.sentrysoftware.metricshub.resource.group.%s.%s", this.resourceGroupKey, metricName));
    }

    @Generated
    public static ResourceGroupSchedulingBuilder builder() {
        return new ResourceGroupSchedulingBuilder();
    }

    @Generated
    public static class ResourceGroupSchedulingBuilder {
        @Generated
        private TaskScheduler taskScheduler;
        @Generated
        private Map<String, ScheduledFuture<?>> schedules;
        @Generated
        private Map<String, String> otelSdkConfiguration;
        @Generated
        private String resourceGroupKey;
        @Generated
        private ResourceGroupConfig resourceGroupConfig;
        @Generated
        private AgentConfig agentConfig;

        @Generated
        ResourceGroupSchedulingBuilder() {
        }

        @Generated
        public ResourceGroupSchedulingBuilder withTaskScheduler(@NonNull TaskScheduler taskScheduler) {
            if (taskScheduler == null) {
                throw new IllegalArgumentException("taskScheduler is marked non-null but is null");
            }
            this.taskScheduler = taskScheduler;
            return this;
        }

        @Generated
        public ResourceGroupSchedulingBuilder withSchedules(@NonNull Map<String, ScheduledFuture<?>> schedules) {
            if (schedules == null) {
                throw new IllegalArgumentException("schedules is marked non-null but is null");
            }
            this.schedules = schedules;
            return this;
        }

        @Generated
        public ResourceGroupSchedulingBuilder withOtelSdkConfiguration(@NonNull Map<String, String> otelSdkConfiguration) {
            if (otelSdkConfiguration == null) {
                throw new IllegalArgumentException("otelSdkConfiguration is marked non-null but is null");
            }
            this.otelSdkConfiguration = otelSdkConfiguration;
            return this;
        }

        @Generated
        public ResourceGroupSchedulingBuilder withResourceGroupKey(@NonNull String resourceGroupKey) {
            if (resourceGroupKey == null) {
                throw new IllegalArgumentException("resourceGroupKey is marked non-null but is null");
            }
            this.resourceGroupKey = resourceGroupKey;
            return this;
        }

        @Generated
        public ResourceGroupSchedulingBuilder withResourceGroupConfig(@NonNull ResourceGroupConfig resourceGroupConfig) {
            if (resourceGroupConfig == null) {
                throw new IllegalArgumentException("resourceGroupConfig is marked non-null but is null");
            }
            this.resourceGroupConfig = resourceGroupConfig;
            return this;
        }

        @Generated
        public ResourceGroupSchedulingBuilder withAgentConfig(@NonNull AgentConfig agentConfig) {
            if (agentConfig == null) {
                throw new IllegalArgumentException("agentConfig is marked non-null but is null");
            }
            this.agentConfig = agentConfig;
            return this;
        }

        @Generated
        public ResourceGroupScheduling build() {
            return new ResourceGroupScheduling(this.taskScheduler, this.schedules, this.otelSdkConfiguration, this.resourceGroupKey, this.resourceGroupConfig, this.agentConfig);
        }

        @Generated
        public String toString() {
            return "ResourceGroupScheduling.ResourceGroupSchedulingBuilder(taskScheduler=" + String.valueOf(this.taskScheduler) + ", schedules=" + String.valueOf(this.schedules) + ", otelSdkConfiguration=" + String.valueOf(this.otelSdkConfiguration) + ", resourceGroupKey=" + this.resourceGroupKey + ", resourceGroupConfig=" + String.valueOf(this.resourceGroupConfig) + ", agentConfig=" + String.valueOf(this.agentConfig) + ")";
        }
    }
}

