/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.service.scheduling;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.agent.config.ResourceConfig;
import org.sentrysoftware.metricshub.agent.context.MetricDefinitions;
import org.sentrysoftware.metricshub.agent.service.scheduling.AbstractScheduling;
import org.sentrysoftware.metricshub.agent.service.task.MonitoringTask;
import org.sentrysoftware.metricshub.agent.service.task.MonitoringTaskInfo;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.support.PeriodicTrigger;

public class ResourceScheduling
extends AbstractScheduling {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceScheduling.class);
    public static final String METRICSHUB_RESOURCE_KEY_FORMAT = "metricshub-resource-%s-%s";
    @NonNull
    private String resourceGroupKey;
    @NonNull
    private String resourceKey;
    @NonNull
    private ResourceConfig resourceConfig;
    @NonNull
    private TelemetryManager telemetryManager;
    @NonNull
    private MetricDefinitions hostMetricDefinitions;
    @NonNull
    private ExtensionManager extensionManager;

    public ResourceScheduling(@NonNull TaskScheduler taskScheduler, @NonNull Map<String, ScheduledFuture<?>> schedules, @NonNull Map<String, String> otelSdkConfiguration, @NonNull String resourceGroupKey, @NonNull String resourceKey, @NonNull ResourceConfig resourceConfig, @NonNull TelemetryManager telemetryManager, @NonNull MetricDefinitions hostMetricDefinitions, @NonNull ExtensionManager extensionManager) {
        super(taskScheduler, schedules, otelSdkConfiguration);
        if (taskScheduler == null) {
            throw new IllegalArgumentException("taskScheduler is marked non-null but is null");
        }
        if (schedules == null) {
            throw new IllegalArgumentException("schedules is marked non-null but is null");
        }
        if (otelSdkConfiguration == null) {
            throw new IllegalArgumentException("otelSdkConfiguration is marked non-null but is null");
        }
        if (resourceGroupKey == null) {
            throw new IllegalArgumentException("resourceGroupKey is marked non-null but is null");
        }
        if (resourceKey == null) {
            throw new IllegalArgumentException("resourceKey is marked non-null but is null");
        }
        if (resourceConfig == null) {
            throw new IllegalArgumentException("resourceConfig is marked non-null but is null");
        }
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (hostMetricDefinitions == null) {
            throw new IllegalArgumentException("hostMetricDefinitions is marked non-null but is null");
        }
        if (extensionManager == null) {
            throw new IllegalArgumentException("extensionManager is marked non-null but is null");
        }
        this.resourceGroupKey = resourceGroupKey;
        this.resourceKey = resourceKey;
        this.resourceConfig = resourceConfig;
        this.telemetryManager = telemetryManager;
        this.hostMetricDefinitions = hostMetricDefinitions;
        this.extensionManager = extensionManager;
    }

    @Override
    public void schedule() {
        PeriodicTrigger trigger = new PeriodicTrigger(Duration.of(this.resourceConfig.getCollectPeriod(), ChronoUnit.SECONDS));
        MonitoringTask monitoringTask = new MonitoringTask(MonitoringTaskInfo.builder().telemetryManager(this.telemetryManager).resourceConfig(this.resourceConfig).resourceGroupKey(this.resourceGroupKey).resourceKey(this.resourceKey).otelSdkConfiguration(this.otelSdkConfiguration).hostMetricDefinitions(this.hostMetricDefinitions).extensionManager(this.extensionManager).build());
        ScheduledFuture<?> scheduledFuture = this.taskScheduler.schedule((Runnable)monitoringTask, trigger);
        this.schedules.put(String.format(METRICSHUB_RESOURCE_KEY_FORMAT, this.resourceGroupKey, this.resourceKey), scheduledFuture);
        log.info("Scheduled job for resource id {} defined in resource group id {}.", (Object)this.resourceKey, (Object)this.resourceGroupKey);
    }

    @Generated
    public static ResourceSchedulingBuilder builder() {
        return new ResourceSchedulingBuilder();
    }

    @Generated
    public static class ResourceSchedulingBuilder {
        @Generated
        private TaskScheduler taskScheduler;
        @Generated
        private Map<String, ScheduledFuture<?>> schedules;
        @Generated
        private Map<String, String> otelSdkConfiguration;
        @Generated
        private String resourceGroupKey;
        @Generated
        private String resourceKey;
        @Generated
        private ResourceConfig resourceConfig;
        @Generated
        private TelemetryManager telemetryManager;
        @Generated
        private MetricDefinitions hostMetricDefinitions;
        @Generated
        private ExtensionManager extensionManager;

        @Generated
        ResourceSchedulingBuilder() {
        }

        @Generated
        public ResourceSchedulingBuilder withTaskScheduler(@NonNull TaskScheduler taskScheduler) {
            if (taskScheduler == null) {
                throw new IllegalArgumentException("taskScheduler is marked non-null but is null");
            }
            this.taskScheduler = taskScheduler;
            return this;
        }

        @Generated
        public ResourceSchedulingBuilder withSchedules(@NonNull Map<String, ScheduledFuture<?>> schedules) {
            if (schedules == null) {
                throw new IllegalArgumentException("schedules is marked non-null but is null");
            }
            this.schedules = schedules;
            return this;
        }

        @Generated
        public ResourceSchedulingBuilder withOtelSdkConfiguration(@NonNull Map<String, String> otelSdkConfiguration) {
            if (otelSdkConfiguration == null) {
                throw new IllegalArgumentException("otelSdkConfiguration is marked non-null but is null");
            }
            this.otelSdkConfiguration = otelSdkConfiguration;
            return this;
        }

        @Generated
        public ResourceSchedulingBuilder withResourceGroupKey(@NonNull String resourceGroupKey) {
            if (resourceGroupKey == null) {
                throw new IllegalArgumentException("resourceGroupKey is marked non-null but is null");
            }
            this.resourceGroupKey = resourceGroupKey;
            return this;
        }

        @Generated
        public ResourceSchedulingBuilder withResourceKey(@NonNull String resourceKey) {
            if (resourceKey == null) {
                throw new IllegalArgumentException("resourceKey is marked non-null but is null");
            }
            this.resourceKey = resourceKey;
            return this;
        }

        @Generated
        public ResourceSchedulingBuilder withResourceConfig(@NonNull ResourceConfig resourceConfig) {
            if (resourceConfig == null) {
                throw new IllegalArgumentException("resourceConfig is marked non-null but is null");
            }
            this.resourceConfig = resourceConfig;
            return this;
        }

        @Generated
        public ResourceSchedulingBuilder withTelemetryManager(@NonNull TelemetryManager telemetryManager) {
            if (telemetryManager == null) {
                throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
            }
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public ResourceSchedulingBuilder withHostMetricDefinitions(@NonNull MetricDefinitions hostMetricDefinitions) {
            if (hostMetricDefinitions == null) {
                throw new IllegalArgumentException("hostMetricDefinitions is marked non-null but is null");
            }
            this.hostMetricDefinitions = hostMetricDefinitions;
            return this;
        }

        @Generated
        public ResourceSchedulingBuilder withExtensionManager(@NonNull ExtensionManager extensionManager) {
            if (extensionManager == null) {
                throw new IllegalArgumentException("extensionManager is marked non-null but is null");
            }
            this.extensionManager = extensionManager;
            return this;
        }

        @Generated
        public ResourceScheduling build() {
            return new ResourceScheduling(this.taskScheduler, this.schedules, this.otelSdkConfiguration, this.resourceGroupKey, this.resourceKey, this.resourceConfig, this.telemetryManager, this.hostMetricDefinitions, this.extensionManager);
        }

        @Generated
        public String toString() {
            return "ResourceScheduling.ResourceSchedulingBuilder(taskScheduler=" + String.valueOf(this.taskScheduler) + ", schedules=" + String.valueOf(this.schedules) + ", otelSdkConfiguration=" + String.valueOf(this.otelSdkConfiguration) + ", resourceGroupKey=" + this.resourceGroupKey + ", resourceKey=" + this.resourceKey + ", resourceConfig=" + String.valueOf(this.resourceConfig) + ", telemetryManager=" + String.valueOf(this.telemetryManager) + ", hostMetricDefinitions=" + String.valueOf(this.hostMetricDefinitions) + ", extensionManager=" + String.valueOf(this.extensionManager) + ")";
        }
    }
}

