/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.service.scheduling;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.resources.Resource;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.agent.config.AgentConfig;
import org.sentrysoftware.metricshub.agent.context.AgentInfo;
import org.sentrysoftware.metricshub.agent.helper.ConfigHelper;
import org.sentrysoftware.metricshub.agent.helper.OtelHelper;
import org.sentrysoftware.metricshub.agent.service.scheduling.AbstractScheduling;
import org.sentrysoftware.metricshub.agent.service.signal.SimpleGaugeMetricObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.support.PeriodicTrigger;

public class SelfObserverScheduling
extends AbstractScheduling {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelfObserverScheduling.class);
    public static final String METRICSHUB_OVERALL_SELF_TASK_KEY = "metricshub-overall-self-task";
    private static final String METRICS_HUB_AGENT_INFORMATION = "MetricsHub agent information.";
    @NonNull
    private AgentInfo agentInfo;
    @NonNull
    private AgentConfig agentConfig;

    public SelfObserverScheduling(@NonNull TaskScheduler taskScheduler, @NonNull Map<String, ScheduledFuture<?>> schedules, @NonNull Map<String, String> otelSdkConfiguration, @NonNull AgentInfo agentInfo, @NonNull AgentConfig agentConfig) {
        super(taskScheduler, schedules, otelSdkConfiguration);
        if (taskScheduler == null) {
            throw new IllegalArgumentException("taskScheduler is marked non-null but is null");
        }
        if (schedules == null) {
            throw new IllegalArgumentException("schedules is marked non-null but is null");
        }
        if (otelSdkConfiguration == null) {
            throw new IllegalArgumentException("otelSdkConfiguration is marked non-null but is null");
        }
        if (agentInfo == null) {
            throw new IllegalArgumentException("agentInfo is marked non-null but is null");
        }
        if (agentConfig == null) {
            throw new IllegalArgumentException("agentConfig is marked non-null but is null");
        }
        this.agentConfig = agentConfig;
        this.agentInfo = agentInfo;
    }

    @Override
    public void schedule() {
        HashMap<String, String> resourceAttributes = new HashMap<String, String>();
        ConfigHelper.mergeAttributes(this.agentInfo.getResourceAttributes(), resourceAttributes);
        ConfigHelper.mergeAttributes(this.agentConfig.getAttributes(), resourceAttributes);
        Resource resource = OtelHelper.createOpenTelemetryResource(resourceAttributes);
        AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk = OtelHelper.initOpenTelemetrySdk(resource, this.otelSdkConfiguration);
        PeriodicTrigger trigger = new PeriodicTrigger(Duration.of(this.agentConfig.getCollectPeriod(), ChronoUnit.SECONDS));
        SdkMeterProvider meterProvider = autoConfiguredOpenTelemetrySdk.getOpenTelemetrySdk().getSdkMeterProvider();
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        ConfigHelper.mergeAttributes(this.agentInfo.getResourceAttributes(), attributeMap);
        ConfigHelper.mergeAttributes(this.agentInfo.getMetricAttributes(), attributeMap);
        ConfigHelper.mergeAttributes(this.agentConfig.getAttributes(), attributeMap);
        Attributes attributes = OtelHelper.buildOtelAttributesFromMap(attributeMap);
        SimpleGaugeMetricObserver.builder().withDescription(METRICS_HUB_AGENT_INFORMATION).withMeter(meterProvider.get("org.sentrysoftware.metricshub.agent")).withMetricValue(1.0).withAttributes(attributes).withMetricName("metricshub.agent.info").build().init();
        ScheduledFuture<?> scheduledFuture = this.taskScheduler.schedule(meterProvider::forceFlush, trigger);
        this.schedules.put(METRICSHUB_OVERALL_SELF_TASK_KEY, scheduledFuture);
        log.info("Self Observer scheduled.");
    }

    @Generated
    public static SelfObserverSchedulingBuilder builder() {
        return new SelfObserverSchedulingBuilder();
    }

    @Generated
    public static class SelfObserverSchedulingBuilder {
        @Generated
        private TaskScheduler taskScheduler;
        @Generated
        private Map<String, ScheduledFuture<?>> schedules;
        @Generated
        private Map<String, String> otelSdkConfiguration;
        @Generated
        private AgentInfo agentInfo;
        @Generated
        private AgentConfig agentConfig;

        @Generated
        SelfObserverSchedulingBuilder() {
        }

        @Generated
        public SelfObserverSchedulingBuilder withTaskScheduler(@NonNull TaskScheduler taskScheduler) {
            if (taskScheduler == null) {
                throw new IllegalArgumentException("taskScheduler is marked non-null but is null");
            }
            this.taskScheduler = taskScheduler;
            return this;
        }

        @Generated
        public SelfObserverSchedulingBuilder withSchedules(@NonNull Map<String, ScheduledFuture<?>> schedules) {
            if (schedules == null) {
                throw new IllegalArgumentException("schedules is marked non-null but is null");
            }
            this.schedules = schedules;
            return this;
        }

        @Generated
        public SelfObserverSchedulingBuilder withOtelSdkConfiguration(@NonNull Map<String, String> otelSdkConfiguration) {
            if (otelSdkConfiguration == null) {
                throw new IllegalArgumentException("otelSdkConfiguration is marked non-null but is null");
            }
            this.otelSdkConfiguration = otelSdkConfiguration;
            return this;
        }

        @Generated
        public SelfObserverSchedulingBuilder withAgentInfo(@NonNull AgentInfo agentInfo) {
            if (agentInfo == null) {
                throw new IllegalArgumentException("agentInfo is marked non-null but is null");
            }
            this.agentInfo = agentInfo;
            return this;
        }

        @Generated
        public SelfObserverSchedulingBuilder withAgentConfig(@NonNull AgentConfig agentConfig) {
            if (agentConfig == null) {
                throw new IllegalArgumentException("agentConfig is marked non-null but is null");
            }
            this.agentConfig = agentConfig;
            return this;
        }

        @Generated
        public SelfObserverScheduling build() {
            return new SelfObserverScheduling(this.taskScheduler, this.schedules, this.otelSdkConfiguration, this.agentInfo, this.agentConfig);
        }

        @Generated
        public String toString() {
            return "SelfObserverScheduling.SelfObserverSchedulingBuilder(taskScheduler=" + String.valueOf(this.taskScheduler) + ", schedules=" + String.valueOf(this.schedules) + ", otelSdkConfiguration=" + String.valueOf(this.otelSdkConfiguration) + ", agentInfo=" + String.valueOf(this.agentInfo) + ", agentConfig=" + String.valueOf(this.agentConfig) + ")";
        }
    }
}

