/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.service.signal;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleCounterBuilder;
import io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import io.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import lombok.Generated;

public abstract class AbstractMetricObserver {
    protected final Meter meter;
    protected final Attributes attributes;
    protected final String metricName;
    protected final String unit;
    protected final String description;

    public abstract void init();

    protected DoubleCounterBuilder newDoubleCounterBuilder() {
        DoubleCounterBuilder builder = this.meter.counterBuilder(this.metricName).setDescription(this.description).ofDoubles();
        if (this.unit != null && !this.unit.isBlank()) {
            builder.setUnit(this.unit);
        }
        return builder;
    }

    protected DoubleGaugeBuilder newDoubleGaugeBuilder() {
        DoubleGaugeBuilder builder = this.meter.gaugeBuilder(this.metricName).setDescription(this.description);
        if (this.unit != null && !this.unit.isBlank()) {
            builder.setUnit(this.unit);
        }
        return builder;
    }

    protected DoubleUpDownCounterBuilder newDoubleUpDownCounterBuilder() {
        DoubleUpDownCounterBuilder builder = this.meter.upDownCounterBuilder(this.metricName).setDescription(this.description).ofDoubles();
        if (this.unit != null && !this.unit.isBlank()) {
            builder.setUnit(this.unit);
        }
        return builder;
    }

    @Generated
    public AbstractMetricObserver(Meter meter, Attributes attributes, String metricName, String unit, String description) {
        this.meter = meter;
        this.attributes = attributes;
        this.metricName = metricName;
        this.unit = unit;
        this.description = description;
    }

    @Generated
    public Meter getMeter() {
        return this.meter;
    }

    @Generated
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Generated
    public String getMetricName() {
        return this.metricName;
    }

    @Generated
    public String getUnit() {
        return this.unit;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractMetricObserver)) {
            return false;
        }
        AbstractMetricObserver other = (AbstractMetricObserver)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Meter this$meter = this.getMeter();
        Meter other$meter = other.getMeter();
        if (this$meter == null ? other$meter != null : !this$meter.equals(other$meter)) {
            return false;
        }
        Attributes this$attributes = this.getAttributes();
        Attributes other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) {
            return false;
        }
        String this$metricName = this.getMetricName();
        String other$metricName = other.getMetricName();
        if (this$metricName == null ? other$metricName != null : !this$metricName.equals(other$metricName)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractMetricObserver;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Meter $meter = this.getMeter();
        result = result * 59 + ($meter == null ? 43 : $meter.hashCode());
        Attributes $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : $attributes.hashCode());
        String $metricName = this.getMetricName();
        result = result * 59 + ($metricName == null ? 43 : $metricName.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractMetricObserver(meter=" + String.valueOf(this.getMeter()) + ", attributes=" + String.valueOf(this.getAttributes()) + ", metricName=" + this.getMetricName() + ", unit=" + this.getUnit() + ", description=" + this.getDescription() + ")";
    }
}

