/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.service.signal;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import java.util.Optional;
import lombok.Generated;
import org.sentrysoftware.metricshub.agent.service.signal.AbstractMetricObserver;
import org.sentrysoftware.metricshub.engine.telemetry.metric.NumberMetric;

public abstract class AbstractNumberMetricObserver
extends AbstractMetricObserver {
    protected NumberMetric metric;

    protected AbstractNumberMetricObserver(Meter meter, Attributes attributes, String metricName, String unit, String description, NumberMetric metric) {
        super(meter, attributes, metricName, unit, description);
        this.metric = metric;
    }

    protected void observeNumberMetric(ObservableDoubleMeasurement recorder) {
        this.getMetricValue().ifPresent(value -> {
            if ("hw.energy".equals(this.metricName) && !this.increasedEnergyUsage((Double)value)) {
                return;
            }
            recorder.record((double)value, this.attributes);
        });
    }

    public Optional<Double> getMetricValue() {
        if (this.metric != null && this.metric.isUpdated()) {
            return Optional.ofNullable(this.metric.getValue());
        }
        return Optional.empty();
    }

    boolean increasedEnergyUsage(Double energy) {
        Double previousValue = this.metric.getPreviousValue();
        if (previousValue == null) {
            return true;
        }
        return energy > previousValue;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractNumberMetricObserver)) {
            return false;
        }
        AbstractNumberMetricObserver other = (AbstractNumberMetricObserver)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NumberMetric this$metric = this.metric;
        NumberMetric other$metric = other.metric;
        return !(this$metric == null ? other$metric != null : !((Object)this$metric).equals(other$metric));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractNumberMetricObserver;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        NumberMetric $metric = this.metric;
        result = result * 59 + ($metric == null ? 43 : ((Object)$metric).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractNumberMetricObserver(super=" + super.toString() + ", metric=" + String.valueOf(this.metric) + ")";
    }
}

