/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.service.signal;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import java.util.Optional;
import lombok.Generated;
import org.sentrysoftware.metricshub.agent.service.signal.AbstractMetricObserver;
import org.sentrysoftware.metricshub.engine.telemetry.metric.StateSetMetric;

public abstract class AbstractStateMetricObserver
extends AbstractMetricObserver {
    protected String state;
    protected StateSetMetric metric;

    protected AbstractStateMetricObserver(Meter meter, Attributes attributes, String metricName, String unit, String description, String state, StateSetMetric metric) {
        super(meter, attributes, metricName, unit, description);
        this.state = state;
        this.metric = metric;
    }

    protected void observeStateMetric(ObservableDoubleMeasurement recorder) {
        this.getMetricValue().ifPresent(value -> this.recordMetricValue(recorder, (String)value));
    }

    protected abstract void recordMetricValue(ObservableDoubleMeasurement var1, String var2);

    protected Optional<String> getMetricValue() {
        if (this.metric != null && this.metric.isUpdated()) {
            return Optional.ofNullable(this.metric.getValue());
        }
        return Optional.empty();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractStateMetricObserver)) {
            return false;
        }
        AbstractStateMetricObserver other = (AbstractStateMetricObserver)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$state = this.state;
        String other$state = other.state;
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        StateSetMetric this$metric = this.metric;
        StateSetMetric other$metric = other.metric;
        return !(this$metric == null ? other$metric != null : !((Object)this$metric).equals(other$metric));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractStateMetricObserver;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $state = this.state;
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        StateSetMetric $metric = this.metric;
        result = result * 59 + ($metric == null ? 43 : ((Object)$metric).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractStateMetricObserver(super=" + super.toString() + ", state=" + this.state + ", metric=" + String.valueOf(this.metric) + ")";
    }
}

