/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.service.signal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import java.util.function.Consumer;
import lombok.Generated;
import org.sentrysoftware.metricshub.agent.helper.OtelHelper;
import org.sentrysoftware.metricshub.agent.service.signal.CounterMetricObserver;
import org.sentrysoftware.metricshub.agent.service.signal.CounterStateMetricObserver;
import org.sentrysoftware.metricshub.agent.service.signal.CounterSuppressZerosStateMetricObserver;
import org.sentrysoftware.metricshub.agent.service.signal.GaugeMetricObserver;
import org.sentrysoftware.metricshub.agent.service.signal.GaugeStateMetricObserver;
import org.sentrysoftware.metricshub.agent.service.signal.GaugeSuppressZerosStateMetricObserver;
import org.sentrysoftware.metricshub.agent.service.signal.UpDownCounterMetricObserver;
import org.sentrysoftware.metricshub.agent.service.signal.UpDownCounterStateMetricObserver;
import org.sentrysoftware.metricshub.agent.service.signal.UpDownCounterSuppressZerosStateMetricObserver;
import org.sentrysoftware.metricshub.engine.connector.model.metric.MetricDefinition;
import org.sentrysoftware.metricshub.engine.connector.model.metric.MetricType;
import org.sentrysoftware.metricshub.engine.telemetry.metric.AbstractMetric;
import org.sentrysoftware.metricshub.engine.telemetry.metric.NumberMetric;
import org.sentrysoftware.metricshub.engine.telemetry.metric.StateSetMetric;

public class MetricTypeVisitor
implements MetricType.IMetricTypeVisitor {
    protected static final String METRIC_STATE_ATTRIBUTE = "state";
    private SdkMeterProvider sdkMeterProvider;
    private MetricDefinition metricDefinition;
    private AbstractMetric metric;
    private String monitorId;
    private String resourceKey;
    private String resourceGroupKey;
    private String metricName;
    private Attributes attributes;
    private String stateSetCompression;

    @Override
    public void visit(MetricType.Gauge gauge) {
        String metricKey = this.metric.getName();
        AbstractMetric abstractMetric = this.metric;
        if (abstractMetric instanceof NumberMetric) {
            NumberMetric numberMetric = (NumberMetric)abstractMetric;
            GaugeMetricObserver.builder().withAttributes(this.attributes).withDescription(this.metricDefinition.getDescription()).withUnit(this.metricDefinition.getUnit()).withMeter(this.getNumberMetricMeter(metricKey)).withMetric(numberMetric).withMetricName(this.metricName).build().init();
        } else {
            abstractMetric = this.metric;
            if (abstractMetric instanceof StateSetMetric) {
                StateSetMetric stateSetMetric = (StateSetMetric)abstractMetric;
                Consumer<String> observerInitializer = "suppressZeros".equalsIgnoreCase(this.stateSetCompression) ? state -> GaugeSuppressZerosStateMetricObserver.builder().withAttributes(this.addStateAttribute(this.attributes, (String)state)).withDescription(this.metricDefinition.getDescription()).withUnit(this.metricDefinition.getUnit()).withMeter(this.getStateSetMetricMeter(metricKey, (String)state)).withMetric(stateSetMetric).withMetricName(this.metricName).withState((String)state).build().init() : state -> GaugeStateMetricObserver.builder().withAttributes(this.addStateAttribute(this.attributes, (String)state)).withDescription(this.metricDefinition.getDescription()).withUnit(this.metricDefinition.getUnit()).withMeter(this.getStateSetMetricMeter(metricKey, (String)state)).withMetric(stateSetMetric).withMetricName(this.metricName).withState((String)state).build().init();
                for (String state2 : stateSetMetric.getStateSet()) {
                    observerInitializer.accept(state2);
                }
            }
        }
    }

    private Meter getNumberMetricMeter(String metricKey) {
        return this.sdkMeterProvider.get(String.format("%s.%s.%s.%s", this.resourceGroupKey, this.resourceKey, this.monitorId, metricKey));
    }

    private Meter getStateSetMetricMeter(String metricKey, String state) {
        return this.sdkMeterProvider.get(String.format("%s.%s.%s.%s.%s", this.resourceGroupKey, this.resourceKey, this.monitorId, metricKey, state));
    }

    @Override
    public void visit(MetricType.Counter counter) {
        String metricKey = this.metric.getName();
        AbstractMetric abstractMetric = this.metric;
        if (abstractMetric instanceof NumberMetric) {
            NumberMetric numberMetric = (NumberMetric)abstractMetric;
            CounterMetricObserver.builder().withAttributes(this.attributes).withDescription(this.metricDefinition.getDescription()).withUnit(this.metricDefinition.getUnit()).withMeter(this.getNumberMetricMeter(metricKey)).withMetric(numberMetric).withMetricName(this.metricName).build().init();
        } else {
            abstractMetric = this.metric;
            if (abstractMetric instanceof StateSetMetric) {
                StateSetMetric stateSetMetric = (StateSetMetric)abstractMetric;
                Consumer<String> observerInitializer = "suppressZeros".equalsIgnoreCase(this.stateSetCompression) ? state -> CounterSuppressZerosStateMetricObserver.builder().withAttributes(this.addStateAttribute(this.attributes, (String)state)).withDescription(this.metricDefinition.getDescription()).withUnit(this.metricDefinition.getUnit()).withMeter(this.getStateSetMetricMeter(metricKey, (String)state)).withMetric(stateSetMetric).withMetricName(this.metricName).withState((String)state).build().init() : state -> CounterStateMetricObserver.builder().withAttributes(this.addStateAttribute(this.attributes, (String)state)).withDescription(this.metricDefinition.getDescription()).withUnit(this.metricDefinition.getUnit()).withMeter(this.getStateSetMetricMeter(metricKey, (String)state)).withMetric(stateSetMetric).withMetricName(this.metricName).withState((String)state).build().init();
                for (String state2 : stateSetMetric.getStateSet()) {
                    observerInitializer.accept(state2);
                }
            }
        }
    }

    @Override
    public void visit(MetricType.UpDownCounter upDownCounter) {
        String metricKey = this.metric.getName();
        AbstractMetric abstractMetric = this.metric;
        if (abstractMetric instanceof NumberMetric) {
            NumberMetric numberMetric = (NumberMetric)abstractMetric;
            UpDownCounterMetricObserver.builder().withAttributes(this.attributes).withDescription(this.metricDefinition.getDescription()).withUnit(this.metricDefinition.getUnit()).withMeter(this.getNumberMetricMeter(metricKey)).withMetric(numberMetric).withMetricName(this.metricName).build().init();
        } else {
            abstractMetric = this.metric;
            if (abstractMetric instanceof StateSetMetric) {
                StateSetMetric stateSetMetric = (StateSetMetric)abstractMetric;
                Consumer<String> observerInitializer = "suppressZeros".equalsIgnoreCase(this.stateSetCompression) ? state -> UpDownCounterSuppressZerosStateMetricObserver.builder().withAttributes(this.addStateAttribute(this.attributes, (String)state)).withDescription(this.metricDefinition.getDescription()).withUnit(this.metricDefinition.getUnit()).withMeter(this.getStateSetMetricMeter(metricKey, (String)state)).withMetric(stateSetMetric).withMetricName(this.metricName).withState((String)state).build().init() : state -> UpDownCounterStateMetricObserver.builder().withAttributes(this.addStateAttribute(this.attributes, (String)state)).withDescription(this.metricDefinition.getDescription()).withUnit(this.metricDefinition.getUnit()).withMeter(this.getStateSetMetricMeter(metricKey, (String)state)).withMetric(stateSetMetric).withMetricName(this.metricName).withState((String)state).build().init();
                for (String state2 : stateSetMetric.getStateSet()) {
                    observerInitializer.accept(state2);
                }
            }
        }
    }

    Attributes addStateAttribute(Attributes attributes, String stateValue) {
        return OtelHelper.mergeOtelAttributes(attributes, Attributes.of(AttributeKey.stringKey(METRIC_STATE_ATTRIBUTE), stateValue));
    }

    @Generated
    public static MetricTypeVisitorBuilder builder() {
        return new MetricTypeVisitorBuilder();
    }

    @Generated
    public SdkMeterProvider getSdkMeterProvider() {
        return this.sdkMeterProvider;
    }

    @Generated
    public MetricDefinition getMetricDefinition() {
        return this.metricDefinition;
    }

    @Generated
    public AbstractMetric getMetric() {
        return this.metric;
    }

    @Generated
    public String getMonitorId() {
        return this.monitorId;
    }

    @Generated
    public String getResourceKey() {
        return this.resourceKey;
    }

    @Generated
    public String getResourceGroupKey() {
        return this.resourceGroupKey;
    }

    @Generated
    public String getMetricName() {
        return this.metricName;
    }

    @Generated
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Generated
    public String getStateSetCompression() {
        return this.stateSetCompression;
    }

    @Generated
    public void setSdkMeterProvider(SdkMeterProvider sdkMeterProvider) {
        this.sdkMeterProvider = sdkMeterProvider;
    }

    @Generated
    public void setMetricDefinition(MetricDefinition metricDefinition) {
        this.metricDefinition = metricDefinition;
    }

    @Generated
    public void setMetric(AbstractMetric metric) {
        this.metric = metric;
    }

    @Generated
    public void setMonitorId(String monitorId) {
        this.monitorId = monitorId;
    }

    @Generated
    public void setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
    }

    @Generated
    public void setResourceGroupKey(String resourceGroupKey) {
        this.resourceGroupKey = resourceGroupKey;
    }

    @Generated
    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    @Generated
    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setStateSetCompression(String stateSetCompression) {
        this.stateSetCompression = stateSetCompression;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricTypeVisitor)) {
            return false;
        }
        MetricTypeVisitor other = (MetricTypeVisitor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SdkMeterProvider this$sdkMeterProvider = this.getSdkMeterProvider();
        SdkMeterProvider other$sdkMeterProvider = other.getSdkMeterProvider();
        if (this$sdkMeterProvider == null ? other$sdkMeterProvider != null : !this$sdkMeterProvider.equals(other$sdkMeterProvider)) {
            return false;
        }
        MetricDefinition this$metricDefinition = this.getMetricDefinition();
        MetricDefinition other$metricDefinition = other.getMetricDefinition();
        if (this$metricDefinition == null ? other$metricDefinition != null : !((Object)this$metricDefinition).equals(other$metricDefinition)) {
            return false;
        }
        AbstractMetric this$metric = this.getMetric();
        AbstractMetric other$metric = other.getMetric();
        if (this$metric == null ? other$metric != null : !((Object)this$metric).equals(other$metric)) {
            return false;
        }
        String this$monitorId = this.getMonitorId();
        String other$monitorId = other.getMonitorId();
        if (this$monitorId == null ? other$monitorId != null : !this$monitorId.equals(other$monitorId)) {
            return false;
        }
        String this$resourceKey = this.getResourceKey();
        String other$resourceKey = other.getResourceKey();
        if (this$resourceKey == null ? other$resourceKey != null : !this$resourceKey.equals(other$resourceKey)) {
            return false;
        }
        String this$resourceGroupKey = this.getResourceGroupKey();
        String other$resourceGroupKey = other.getResourceGroupKey();
        if (this$resourceGroupKey == null ? other$resourceGroupKey != null : !this$resourceGroupKey.equals(other$resourceGroupKey)) {
            return false;
        }
        String this$metricName = this.getMetricName();
        String other$metricName = other.getMetricName();
        if (this$metricName == null ? other$metricName != null : !this$metricName.equals(other$metricName)) {
            return false;
        }
        Attributes this$attributes = this.getAttributes();
        Attributes other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) {
            return false;
        }
        String this$stateSetCompression = this.getStateSetCompression();
        String other$stateSetCompression = other.getStateSetCompression();
        return !(this$stateSetCompression == null ? other$stateSetCompression != null : !this$stateSetCompression.equals(other$stateSetCompression));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetricTypeVisitor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SdkMeterProvider $sdkMeterProvider = this.getSdkMeterProvider();
        result = result * 59 + ($sdkMeterProvider == null ? 43 : $sdkMeterProvider.hashCode());
        MetricDefinition $metricDefinition = this.getMetricDefinition();
        result = result * 59 + ($metricDefinition == null ? 43 : ((Object)$metricDefinition).hashCode());
        AbstractMetric $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : ((Object)$metric).hashCode());
        String $monitorId = this.getMonitorId();
        result = result * 59 + ($monitorId == null ? 43 : $monitorId.hashCode());
        String $resourceKey = this.getResourceKey();
        result = result * 59 + ($resourceKey == null ? 43 : $resourceKey.hashCode());
        String $resourceGroupKey = this.getResourceGroupKey();
        result = result * 59 + ($resourceGroupKey == null ? 43 : $resourceGroupKey.hashCode());
        String $metricName = this.getMetricName();
        result = result * 59 + ($metricName == null ? 43 : $metricName.hashCode());
        Attributes $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : $attributes.hashCode());
        String $stateSetCompression = this.getStateSetCompression();
        result = result * 59 + ($stateSetCompression == null ? 43 : $stateSetCompression.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetricTypeVisitor(sdkMeterProvider=" + String.valueOf(this.getSdkMeterProvider()) + ", metricDefinition=" + String.valueOf(this.getMetricDefinition()) + ", metric=" + String.valueOf(this.getMetric()) + ", monitorId=" + this.getMonitorId() + ", resourceKey=" + this.getResourceKey() + ", resourceGroupKey=" + this.getResourceGroupKey() + ", metricName=" + this.getMetricName() + ", attributes=" + String.valueOf(this.getAttributes()) + ", stateSetCompression=" + this.getStateSetCompression() + ")";
    }

    @Generated
    public MetricTypeVisitor(SdkMeterProvider sdkMeterProvider, MetricDefinition metricDefinition, AbstractMetric metric, String monitorId, String resourceKey, String resourceGroupKey, String metricName, Attributes attributes, String stateSetCompression) {
        this.sdkMeterProvider = sdkMeterProvider;
        this.metricDefinition = metricDefinition;
        this.metric = metric;
        this.monitorId = monitorId;
        this.resourceKey = resourceKey;
        this.resourceGroupKey = resourceGroupKey;
        this.metricName = metricName;
        this.attributes = attributes;
        this.stateSetCompression = stateSetCompression;
    }

    @Generated
    public static class MetricTypeVisitorBuilder {
        @Generated
        private SdkMeterProvider sdkMeterProvider;
        @Generated
        private MetricDefinition metricDefinition;
        @Generated
        private AbstractMetric metric;
        @Generated
        private String monitorId;
        @Generated
        private String resourceKey;
        @Generated
        private String resourceGroupKey;
        @Generated
        private String metricName;
        @Generated
        private Attributes attributes;
        @Generated
        private String stateSetCompression;

        @Generated
        MetricTypeVisitorBuilder() {
        }

        @Generated
        public MetricTypeVisitorBuilder withSdkMeterProvider(SdkMeterProvider sdkMeterProvider) {
            this.sdkMeterProvider = sdkMeterProvider;
            return this;
        }

        @Generated
        public MetricTypeVisitorBuilder withMetricDefinition(MetricDefinition metricDefinition) {
            this.metricDefinition = metricDefinition;
            return this;
        }

        @Generated
        public MetricTypeVisitorBuilder withMetric(AbstractMetric metric) {
            this.metric = metric;
            return this;
        }

        @Generated
        public MetricTypeVisitorBuilder withMonitorId(String monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        @Generated
        public MetricTypeVisitorBuilder withResourceKey(String resourceKey) {
            this.resourceKey = resourceKey;
            return this;
        }

        @Generated
        public MetricTypeVisitorBuilder withResourceGroupKey(String resourceGroupKey) {
            this.resourceGroupKey = resourceGroupKey;
            return this;
        }

        @Generated
        public MetricTypeVisitorBuilder withMetricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Generated
        public MetricTypeVisitorBuilder withAttributes(Attributes attributes) {
            this.attributes = attributes;
            return this;
        }

        @Generated
        public MetricTypeVisitorBuilder withStateSetCompression(String stateSetCompression) {
            this.stateSetCompression = stateSetCompression;
            return this;
        }

        @Generated
        public MetricTypeVisitor build() {
            return new MetricTypeVisitor(this.sdkMeterProvider, this.metricDefinition, this.metric, this.monitorId, this.resourceKey, this.resourceGroupKey, this.metricName, this.attributes, this.stateSetCompression);
        }

        @Generated
        public String toString() {
            return "MetricTypeVisitor.MetricTypeVisitorBuilder(sdkMeterProvider=" + String.valueOf(this.sdkMeterProvider) + ", metricDefinition=" + String.valueOf(this.metricDefinition) + ", metric=" + String.valueOf(this.metric) + ", monitorId=" + this.monitorId + ", resourceKey=" + this.resourceKey + ", resourceGroupKey=" + this.resourceGroupKey + ", metricName=" + this.metricName + ", attributes=" + String.valueOf(this.attributes) + ", stateSetCompression=" + this.stateSetCompression + ")";
        }
    }
}

