/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.service.task;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.agent.helper.ConfigHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcherTask
extends Thread {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileWatcherTask.class);
    @NonNull
    private File file;
    @NonNull
    private Predicate<WatchEvent<?>> filter;
    @NonNull
    private Runnable onChange;
    private long await;
    @NonNull
    private String checksum;

    @Override
    public void run() {
        try {
            this.watchFile();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.error("The watcher on file could not be started: {}. Error: {}.", (Object)this.file.getAbsolutePath(), (Object)e.getMessage());
            log.debug("Error: ", e);
        }
    }

    void watchFile() throws IOException, InterruptedException {
        try (WatchService watchService = FileSystems.getDefault().newWatchService();){
            block5: while (!Thread.currentThread().isInterrupted()) {
                WatchKey key;
                Path path = ConfigHelper.getDirectoryPath(this.file);
                path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                while ((key = watchService.take()) != null) {
                    key.pollEvents().stream().filter(event -> this.filter.test((WatchEvent<?>)event)).forEach(event -> {
                        String newChecksum = ConfigHelper.calculateMD5Checksum(this.file);
                        if (this.checksum != null && !this.checksum.equals(newChecksum)) {
                            this.checksum = newChecksum;
                            this.performAction();
                        }
                    });
                    if (key.reset()) continue;
                    continue block5;
                }
            }
        }
    }

    private void performAction() {
        try {
            if (this.await > 0L) {
                FileWatcherTask.sleep(this.await);
            }
            this.onChange.run();
        }
        catch (InterruptedException e) {
            log.info("FileWatcherTask onChange - Received Interrupted Exception: {}.", (Object)e.getMessage());
            this.interrupt();
        }
        catch (Exception e) {
            log.info("FileWatcherTask onChange - Error detected: {}.", (Object)e.getMessage());
        }
    }

    @Generated
    FileWatcherTask(@NonNull File file, @NonNull Predicate<WatchEvent<?>> filter, @NonNull Runnable onChange, long await, @NonNull String checksum) {
        if (file == null) {
            throw new IllegalArgumentException("file is marked non-null but is null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("filter is marked non-null but is null");
        }
        if (onChange == null) {
            throw new IllegalArgumentException("onChange is marked non-null but is null");
        }
        if (checksum == null) {
            throw new IllegalArgumentException("checksum is marked non-null but is null");
        }
        this.file = file;
        this.filter = filter;
        this.onChange = onChange;
        this.await = await;
        this.checksum = checksum;
    }

    @Generated
    public static FileWatcherTaskBuilder builder() {
        return new FileWatcherTaskBuilder();
    }

    @Generated
    public static class FileWatcherTaskBuilder {
        @Generated
        private File file;
        @Generated
        private Predicate<WatchEvent<?>> filter;
        @Generated
        private Runnable onChange;
        @Generated
        private long await;
        @Generated
        private String checksum;

        @Generated
        FileWatcherTaskBuilder() {
        }

        @Generated
        public FileWatcherTaskBuilder file(@NonNull File file) {
            if (file == null) {
                throw new IllegalArgumentException("file is marked non-null but is null");
            }
            this.file = file;
            return this;
        }

        @Generated
        public FileWatcherTaskBuilder filter(@NonNull Predicate<WatchEvent<?>> filter) {
            if (filter == null) {
                throw new IllegalArgumentException("filter is marked non-null but is null");
            }
            this.filter = filter;
            return this;
        }

        @Generated
        public FileWatcherTaskBuilder onChange(@NonNull Runnable onChange) {
            if (onChange == null) {
                throw new IllegalArgumentException("onChange is marked non-null but is null");
            }
            this.onChange = onChange;
            return this;
        }

        @Generated
        public FileWatcherTaskBuilder await(long await) {
            this.await = await;
            return this;
        }

        @Generated
        public FileWatcherTaskBuilder checksum(@NonNull String checksum) {
            if (checksum == null) {
                throw new IllegalArgumentException("checksum is marked non-null but is null");
            }
            this.checksum = checksum;
            return this;
        }

        @Generated
        public FileWatcherTask build() {
            return new FileWatcherTask(this.file, this.filter, this.onChange, this.await, this.checksum);
        }

        @Generated
        public String toString() {
            return "FileWatcherTask.FileWatcherTaskBuilder(file=" + String.valueOf(this.file) + ", filter=" + String.valueOf(this.filter) + ", onChange=" + String.valueOf(this.onChange) + ", await=" + this.await + ", checksum=" + this.checksum + ")";
        }
    }
}

