/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.agent.service.task;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.ThreadContext;
import org.sentrysoftware.metricshub.agent.config.ResourceConfig;
import org.sentrysoftware.metricshub.agent.helper.ConfigHelper;
import org.sentrysoftware.metricshub.agent.helper.OtelHelper;
import org.sentrysoftware.metricshub.agent.service.signal.MetricTypeVisitor;
import org.sentrysoftware.metricshub.agent.service.signal.SimpleUpDownCounterMetricObserver;
import org.sentrysoftware.metricshub.agent.service.task.MonitoringTaskInfo;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.connector.model.ConnectorStore;
import org.sentrysoftware.metricshub.engine.connector.model.metric.MetricDefinition;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.strategy.collect.CollectStrategy;
import org.sentrysoftware.metricshub.engine.strategy.collect.PrepareCollectStrategy;
import org.sentrysoftware.metricshub.engine.strategy.collect.ProtocolHealthCheckStrategy;
import org.sentrysoftware.metricshub.engine.strategy.detection.DetectionStrategy;
import org.sentrysoftware.metricshub.engine.strategy.discovery.DiscoveryStrategy;
import org.sentrysoftware.metricshub.engine.strategy.simple.SimpleStrategy;
import org.sentrysoftware.metricshub.engine.telemetry.MetricFactory;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.engine.telemetry.metric.AbstractMetric;
import org.sentrysoftware.metricshub.hardware.strategy.HardwarePostCollectStrategy;
import org.sentrysoftware.metricshub.hardware.strategy.HardwarePostDiscoveryStrategy;
import org.sentrysoftware.metricshub.hardware.strategy.HardwareStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringTask
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitoringTask.class);
    private static final String HOST_CONFIGURED_METRIC_NAME = "metricshub.host.configured";
    private static final String GENERIC_METRIC_DESCRIPTION_FORMAT = "Reports Metric %s";
    @NonNull
    private final MonitoringTaskInfo monitoringTaskInfo;
    private int numberOfCollects;
    private AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk;
    private Map<String, Set<String>> initializedMetricsPerMonitorId = new HashMap<String, Set<String>>();
    private Map<String, String> mainResourceAttributes;

    @Override
    public void run() {
        TelemetryManager telemetryManager = this.monitoringTaskInfo.getTelemetryManager();
        ResourceConfig resourceConfig = this.monitoringTaskInfo.getResourceConfig();
        int discoveryCycle = resourceConfig.getDiscoveryCycle();
        ExtensionManager extensionManager = this.monitoringTaskInfo.getExtensionManager();
        String hostId = telemetryManager.getHostConfiguration().getHostId();
        this.configureLoggerContext(hostId);
        ClientsExecutor clientsExecutor = new ClientsExecutor(telemetryManager);
        long discoveryTime = System.currentTimeMillis();
        if (this.numberOfCollects == 0) {
            log.info("Calling the engine to discover resource: {}.", (Object)hostId);
            telemetryManager.run(new DetectionStrategy(telemetryManager, discoveryTime, clientsExecutor, extensionManager), new DiscoveryStrategy(telemetryManager, (Long)discoveryTime, clientsExecutor, extensionManager), new SimpleStrategy(telemetryManager, (Long)discoveryTime, clientsExecutor, extensionManager), new HardwarePostDiscoveryStrategy(telemetryManager, discoveryTime, clientsExecutor, extensionManager));
            this.initOtelSdk(telemetryManager, resourceConfig);
            this.initAllObservers(telemetryManager);
            this.autoConfiguredOpenTelemetrySdk.getOpenTelemetrySdk().getSdkMeterProvider().forceFlush();
        }
        log.info("Calling the engine to collect resource: {}.", (Object)hostId);
        long collectTime = System.currentTimeMillis();
        telemetryManager.run(new PrepareCollectStrategy(telemetryManager, collectTime, clientsExecutor, extensionManager), new ProtocolHealthCheckStrategy(telemetryManager, collectTime, clientsExecutor, extensionManager), new CollectStrategy(telemetryManager, collectTime, clientsExecutor, extensionManager), new SimpleStrategy(telemetryManager, (Long)collectTime, clientsExecutor, extensionManager), new HardwarePostCollectStrategy(telemetryManager, collectTime, clientsExecutor, extensionManager));
        telemetryManager.run(new HardwareStrategy(telemetryManager, collectTime));
        this.initAllObservers(telemetryManager);
        this.autoConfiguredOpenTelemetrySdk.getOpenTelemetrySdk().getSdkMeterProvider().forceFlush();
        ++this.numberOfCollects;
        if (this.numberOfCollects >= discoveryCycle) {
            this.numberOfCollects = 0;
        }
    }

    void initAllObservers(TelemetryManager telemetryManager) {
        ConnectorStore connectorStore = telemetryManager.getConnectorStore();
        telemetryManager.getMonitors().values().stream().map(Map::values).flatMap(Collection::stream).forEach(monitor -> {
            if (monitor.isEndpointHost()) {
                Map<String, MetricDefinition> hostMetricDefinitions = this.monitoringTaskInfo.getHostMetricDefinitions().metrics();
                this.initMonitorMetricObservers((Monitor)monitor, telemetryManager, hostMetricDefinitions);
                this.initializeHostConfiguredMetricObserver((Monitor)monitor, hostMetricDefinitions);
            } else {
                this.initMonitorMetricObservers((Monitor)monitor, telemetryManager, ConfigHelper.fetchMetricDefinitions(connectorStore, monitor.getAttribute("connector_id")));
            }
        });
    }

    void initializeHostConfiguredMetricObserver(Monitor host, Map<String, MetricDefinition> hostMetricDefinitions) {
        if (!this.isMetricObserverNotInitialized(host.getId(), HOST_CONFIGURED_METRIC_NAME)) {
            return;
        }
        MetricDefinition metricDefinition = MonitoringTask.lookupMetricDefinition(HOST_CONFIGURED_METRIC_NAME, hostMetricDefinitions);
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        ConfigHelper.mergeAttributes(this.mainResourceAttributes, attributesMap);
        ConfigHelper.mergeAttributes(host.getAttributes(), attributesMap);
        SdkMeterProvider sdkMeterProvider = this.autoConfiguredOpenTelemetrySdk.getOpenTelemetrySdk().getSdkMeterProvider();
        SimpleUpDownCounterMetricObserver.builder().withMetricName(HOST_CONFIGURED_METRIC_NAME).withMetricValue(1.0).withMeter(sdkMeterProvider.get(String.format("%s.%s.%s.%s", this.monitoringTaskInfo.getResourceGroupKey(), this.monitoringTaskInfo.getResourceKey(), host.getId(), HOST_CONFIGURED_METRIC_NAME))).withAttributes(OtelHelper.buildOtelAttributesFromMap(attributesMap)).withUnit(metricDefinition.getUnit()).withDescription(metricDefinition.getDescription()).build().init();
        this.initializedMetricsPerMonitorId.computeIfAbsent(host.getId(), id -> new HashSet()).add(HOST_CONFIGURED_METRIC_NAME);
    }

    void initMonitorMetricObservers(Monitor monitor, TelemetryManager telemetryManager, Map<String, MetricDefinition> metricDefinitionMap) {
        monitor.getMetrics().entrySet().stream().filter(entry -> Objects.nonNull(entry.getValue())).filter(entry -> OtelHelper.isAcceptedKey((String)entry.getKey())).filter(metricEntry -> this.isMetricObserverNotInitialized(monitor.getId(), (String)metricEntry.getKey())).forEach(metricEntry -> this.initMetricObserver(monitor, metricDefinitionMap, (Map.Entry<String, AbstractMetric>)metricEntry));
    }

    void initMetricObserver(Monitor monitor, Map<String, MetricDefinition> metricDefinitionMap, Map.Entry<String, AbstractMetric> metricEntry) {
        String metricKey = metricEntry.getKey();
        String metricName = MetricFactory.extractName(metricKey);
        MetricDefinition metricDefinition = MonitoringTask.lookupMetricDefinition(metricName, metricDefinitionMap);
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        ConfigHelper.mergeAttributes(this.mainResourceAttributes, attributesMap);
        ConfigHelper.mergeAttributes(monitor.getAttributes(), attributesMap);
        AbstractMetric metric = metricEntry.getValue();
        SdkMeterProvider sdkMeterProvider = this.autoConfiguredOpenTelemetrySdk.getOpenTelemetrySdk().getSdkMeterProvider();
        Attributes attributes = OtelHelper.mergeOtelAttributes(OtelHelper.buildOtelAttributesFromMap(attributesMap), OtelHelper.buildOtelAttributesFromMap(metric.getAttributes()));
        metricDefinition.getType().get().getMetricKeyType().accept(MetricTypeVisitor.builder().withMetric(metric).withMetricDefinition(metricDefinition).withSdkMeterProvider(sdkMeterProvider).withAttributes(attributes).withMetricName(metricName).withMonitorId(monitor.getId()).withResourceGroupKey(this.monitoringTaskInfo.getResourceGroupKey()).withResourceKey(this.monitoringTaskInfo.getResourceKey()).withStateSetCompression(this.monitoringTaskInfo.getResourceConfig().getStateSetCompression()).build());
        this.initializedMetricsPerMonitorId.computeIfAbsent(monitor.getId(), id -> new HashSet()).add(metricKey);
    }

    static MetricDefinition lookupMetricDefinition(String metricName, Map<String, MetricDefinition> metricDefinitionMap) {
        return Optional.ofNullable(metricDefinitionMap.get(metricName)).orElseGet(() -> MetricDefinition.builder().description(String.format(GENERIC_METRIC_DESCRIPTION_FORMAT, metricName)).build());
    }

    boolean isMetricObserverNotInitialized(String monitorId, String metricKey) {
        Set<String> metricKeys = this.initializedMetricsPerMonitorId.get(monitorId);
        return metricKeys == null || !metricKeys.contains(metricKey);
    }

    void initOtelSdk(TelemetryManager telemetryManager, ResourceConfig resourceConfig) {
        if (this.autoConfiguredOpenTelemetrySdk == null) {
            Monitor hostMonitor = telemetryManager.getEndpointHostMonitor();
            Map<String, String> userAttributes = resourceConfig.getAttributes();
            org.sentrysoftware.metricshub.engine.telemetry.Resource monitorResource = hostMonitor.getResource();
            Map<String, String> hostMonitorResourceAttributes = monitorResource != null ? monitorResource.getAttributes() : Map.of();
            Resource resource = OtelHelper.createHostResource(hostMonitorResourceAttributes, userAttributes);
            this.mainResourceAttributes = resource.getAttributes().asMap().entrySet().stream().collect(Collectors.toMap(entry -> ((AttributeKey)entry.getKey()).getKey(), entry -> entry.getValue().toString(), (oldValue, newValue) -> oldValue, HashMap::new));
            this.autoConfiguredOpenTelemetrySdk = OtelHelper.initOpenTelemetrySdk(resource, this.monitoringTaskInfo.getOtelSdkConfiguration());
        }
    }

    void configureLoggerContext(String logId) {
        ThreadContext.put("logId", String.format("metricshub-agent-%s", logId));
        ResourceConfig resourceConfig = this.monitoringTaskInfo.getResourceConfig();
        ThreadContext.put("loggerLevel", ConfigHelper.getLoggerLevel(resourceConfig.getLoggerLevel()).name());
        String outputDirectory = resourceConfig.getOutputDirectory();
        if (outputDirectory != null) {
            ThreadContext.put("outputDirectory", outputDirectory);
        }
    }

    @Generated
    public MonitoringTask(@NonNull MonitoringTaskInfo monitoringTaskInfo) {
        if (monitoringTaskInfo == null) {
            throw new IllegalArgumentException("monitoringTaskInfo is marked non-null but is null");
        }
        this.monitoringTaskInfo = monitoringTaskInfo;
    }

    @NonNull
    @Generated
    public MonitoringTaskInfo getMonitoringTaskInfo() {
        return this.monitoringTaskInfo;
    }

    @Generated
    public int getNumberOfCollects() {
        return this.numberOfCollects;
    }

    @Generated
    public AutoConfiguredOpenTelemetrySdk getAutoConfiguredOpenTelemetrySdk() {
        return this.autoConfiguredOpenTelemetrySdk;
    }

    @Generated
    public Map<String, Set<String>> getInitializedMetricsPerMonitorId() {
        return this.initializedMetricsPerMonitorId;
    }

    @Generated
    public Map<String, String> getMainResourceAttributes() {
        return this.mainResourceAttributes;
    }

    @Generated
    public void setNumberOfCollects(int numberOfCollects) {
        this.numberOfCollects = numberOfCollects;
    }

    @Generated
    public void setAutoConfiguredOpenTelemetrySdk(AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk) {
        this.autoConfiguredOpenTelemetrySdk = autoConfiguredOpenTelemetrySdk;
    }

    @Generated
    public void setInitializedMetricsPerMonitorId(Map<String, Set<String>> initializedMetricsPerMonitorId) {
        this.initializedMetricsPerMonitorId = initializedMetricsPerMonitorId;
    }

    @Generated
    public void setMainResourceAttributes(Map<String, String> mainResourceAttributes) {
        this.mainResourceAttributes = mainResourceAttributes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitoringTask)) {
            return false;
        }
        MonitoringTask other = (MonitoringTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumberOfCollects() != other.getNumberOfCollects()) {
            return false;
        }
        MonitoringTaskInfo this$monitoringTaskInfo = this.getMonitoringTaskInfo();
        MonitoringTaskInfo other$monitoringTaskInfo = other.getMonitoringTaskInfo();
        if (this$monitoringTaskInfo == null ? other$monitoringTaskInfo != null : !((Object)this$monitoringTaskInfo).equals(other$monitoringTaskInfo)) {
            return false;
        }
        AutoConfiguredOpenTelemetrySdk this$autoConfiguredOpenTelemetrySdk = this.getAutoConfiguredOpenTelemetrySdk();
        AutoConfiguredOpenTelemetrySdk other$autoConfiguredOpenTelemetrySdk = other.getAutoConfiguredOpenTelemetrySdk();
        if (this$autoConfiguredOpenTelemetrySdk == null ? other$autoConfiguredOpenTelemetrySdk != null : !this$autoConfiguredOpenTelemetrySdk.equals(other$autoConfiguredOpenTelemetrySdk)) {
            return false;
        }
        Map<String, Set<String>> this$initializedMetricsPerMonitorId = this.getInitializedMetricsPerMonitorId();
        Map<String, Set<String>> other$initializedMetricsPerMonitorId = other.getInitializedMetricsPerMonitorId();
        if (this$initializedMetricsPerMonitorId == null ? other$initializedMetricsPerMonitorId != null : !((Object)this$initializedMetricsPerMonitorId).equals(other$initializedMetricsPerMonitorId)) {
            return false;
        }
        Map<String, String> this$mainResourceAttributes = this.getMainResourceAttributes();
        Map<String, String> other$mainResourceAttributes = other.getMainResourceAttributes();
        return !(this$mainResourceAttributes == null ? other$mainResourceAttributes != null : !((Object)this$mainResourceAttributes).equals(other$mainResourceAttributes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MonitoringTask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumberOfCollects();
        MonitoringTaskInfo $monitoringTaskInfo = this.getMonitoringTaskInfo();
        result = result * 59 + ($monitoringTaskInfo == null ? 43 : ((Object)$monitoringTaskInfo).hashCode());
        AutoConfiguredOpenTelemetrySdk $autoConfiguredOpenTelemetrySdk = this.getAutoConfiguredOpenTelemetrySdk();
        result = result * 59 + ($autoConfiguredOpenTelemetrySdk == null ? 43 : $autoConfiguredOpenTelemetrySdk.hashCode());
        Map<String, Set<String>> $initializedMetricsPerMonitorId = this.getInitializedMetricsPerMonitorId();
        result = result * 59 + ($initializedMetricsPerMonitorId == null ? 43 : ((Object)$initializedMetricsPerMonitorId).hashCode());
        Map<String, String> $mainResourceAttributes = this.getMainResourceAttributes();
        result = result * 59 + ($mainResourceAttributes == null ? 43 : ((Object)$mainResourceAttributes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MonitoringTask(monitoringTaskInfo=" + String.valueOf(this.getMonitoringTaskInfo()) + ", numberOfCollects=" + this.getNumberOfCollects() + ", autoConfiguredOpenTelemetrySdk=" + String.valueOf(this.getAutoConfiguredOpenTelemetrySdk()) + ", initializedMetricsPerMonitorId=" + String.valueOf(this.getInitializedMetricsPerMonitorId()) + ", mainResourceAttributes=" + String.valueOf(this.getMainResourceAttributes()) + ")";
    }
}

