/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.ConsoleService;
import org.sentrysoftware.metricshub.cli.service.MetricsHubCliService;
import org.sentrysoftware.metricshub.cli.service.PrintExceptionMessageHandlerService;
import org.sentrysoftware.metricshub.engine.common.IQuery;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import picocli.CommandLine;

@CommandLine.Command(name="httpcli", description={"\nList of valid options: \n"}, footer={"\nExamples:\n\nhttpcli --method <GET|POST|PUT|DELETE> --url <URL> --username <USERNAME> --password <PASSWORD> [--body <BODY> or --body-file <BODY FILE PATH>] [--header <HEADER> --header <HEADER> or --header-file <HEADER FILE PATH>] --timeout <TIMEOUT>\n\n@|green # HTTP GET request with a body and two headers.|@\nhttpcli --method get --url https://dev-01:443/users --username username --password password --header=\"Content-Type: application/xml\" --header=\"Accept:application/json\" --body=\"<aaaLogin inName=\"username\" inPassword=\"password\" />\" --timeout 2m\n\n@|green # HTTP POST request with a header file and a body file.|@\nhttpcli --method post --url https://dev-01:443/users --username admin --password pass --header-file=\"/opt/metricshub/header.txt\" --body-file=\"/opt/metricshub/body.txt\" --timeout 2m\n\nNote: If --password is not provided, you will be prompted interactively.\n"}, usageHelpWidth=180)
public class HttpCli
implements IQuery,
Callable<Integer> {
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 443;
    public static final String FOOTER = "\nExamples:\n\nhttpcli --method <GET|POST|PUT|DELETE> --url <URL> --username <USERNAME> --password <PASSWORD> [--body <BODY> or --body-file <BODY FILE PATH>] [--header <HEADER> --header <HEADER> or --header-file <HEADER FILE PATH>] --timeout <TIMEOUT>\n\n@|green # HTTP GET request with a body and two headers.|@\nhttpcli --method get --url https://dev-01:443/users --username username --password password --header=\"Content-Type: application/xml\" --header=\"Accept:application/json\" --body=\"<aaaLogin inName=\"username\" inPassword=\"password\" />\" --timeout 2m\n\n@|green # HTTP POST request with a header file and a body file.|@\nhttpcli --method post --url https://dev-01:443/users --username admin --password pass --header-file=\"/opt/metricshub/header.txt\" --body-file=\"/opt/metricshub/body.txt\" --timeout 2m\n\nNote: If --password is not provided, you will be prompted interactively.\n";
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--url"}, order=1, paramLabel="URL", description={"Url for HTTP request."})
    private String url;
    @CommandLine.Option(names={"--method"}, defaultValue="GET", order=2, paramLabel="METHOD", description={"HTTP method (GET|POST|PUT|DELETE)"})
    private String method;
    @CommandLine.Option(names={"--header"}, order=3, paramLabel="HEADER", split=":", description={"Header to be added to the HTTP request. Repeatable for multiple headers."})
    private Map<String, String> headers;
    @CommandLine.Option(names={"--header-file", "--headerfile"}, order=4, paramLabel="HEADERFILE", description={"Path of the file containing header to be added to the HTTP request."})
    private String headerFile;
    @CommandLine.Option(names={"--body"}, order=5, paramLabel="BODY", description={"Body of the HTTP request."})
    private String body;
    @CommandLine.Option(names={"--body-file", "--bodyfile"}, order=6, paramLabel="BODYFILE", description={"Path of the file containing the HTTP request body."})
    private String bodyFile;
    @CommandLine.Option(names={"--username"}, order=7, paramLabel="USER", description={"Username for HTTP authentication"})
    private String username;
    @CommandLine.Option(names={"--password"}, order=8, paramLabel="P4SSW0RD", description={"Password for the HTTP protocol"}, arity="0..1", interactive=true)
    private char[] password;
    @CommandLine.Option(names={"--timeout"}, order=9, paramLabel="TIMEOUT", defaultValue="120", description={"Timeout in seconds for HTTP operations (default: ${DEFAULT-VALUE} s)"})
    private String timeout;
    @CommandLine.Option(names={"-h", "-?", "--help"}, order=10, usageHelp=true, description={"Shows this help message and exits"})
    boolean usageHelpRequested;
    @CommandLine.Option(names={"-v"}, order=11, description={"Verbose mode (repeat the option to increase verbosity)"})
    boolean[] verbose;
    URL parsedUrl;
    PrintWriter printWriter;
    String headerContent;
    String bodyContent;

    @Override
    public JsonNode getQuery() {
        ObjectNode queryNode = JsonNodeFactory.instance.objectNode();
        queryNode.set("method", new TextNode(this.method.toUpperCase()));
        queryNode.set("url", new TextNode(this.url));
        if (this.headerContent != null) {
            queryNode.set("header", new TextNode(this.headerContent));
        }
        if (this.bodyContent != null) {
            queryNode.set("body", new TextNode(this.bodyContent));
        }
        queryNode.set("resultContent", new TextNode("all_with_status"));
        return queryNode;
    }

    public void populateBodyContent() throws IOException {
        if (this.body != null) {
            this.bodyContent = this.body;
        } else if (this.bodyFile != null) {
            try (Stream<String> stream = Files.lines(Path.of(this.bodyFile, new String[0]), StandardCharsets.UTF_8);){
                this.bodyContent = stream.collect(Collectors.joining("\n"));
            }
        }
    }

    public void populateHeaderContent() throws IOException {
        if (this.headers != null) {
            this.headerContent = this.headers.entrySet().stream().map(entry -> "%s: %s".formatted(entry.getKey(), entry.getValue())).collect(Collectors.joining("\n"));
        } else if (this.headerFile != null) {
            try (Stream<String> stream = Files.lines(Path.of(this.headerFile, new String[0]), StandardCharsets.UTF_8);){
                this.headerContent = stream.collect(Collectors.joining("\n"));
            }
        }
    }

    void tryInteractivePassword(MetricsHubCliService.CliPasswordReader<char[]> passwordReader) {
        if (this.username != null && this.password == null) {
            this.password = passwordReader.read("%s password for HTTP: ", this.username);
        }
    }

    void validate() throws CommandLine.ParameterException {
        boolean interactive = ConsoleService.hasConsole();
        if (interactive) {
            this.tryInteractivePassword(System.console()::readPassword);
        }
        this.validateUrl();
        if (this.headers != null && this.headerFile != null) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Conflict - Two headers have been configured: --header and --header-file.");
        }
        if (this.headerFile != null) {
            try {
                this.populateHeaderContent();
            }
            catch (IOException e) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("Error while reading header file %s : %s", this.headerFile, e));
            }
        }
        if (this.body != null && this.bodyFile != null) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Conflict - Two bodies have been configured: --body and --body-file.");
        }
        if (this.bodyFile != null) {
            try {
                this.populateBodyContent();
            }
            catch (IOException e) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("Error while reading body file %s : %s", this.bodyFile, e));
            }
        }
    }

    void validateUrl() {
        try {
            this.parsedUrl = new URL(this.url);
            this.parsedUrl.toURI();
        }
        catch (MalformedURLException e) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Malformed URL: " + e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "URL contains invalid characters: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Invalid URL: " + e.getMessage(), e);
        }
    }

    int resolvePortFromUrl() {
        int port = this.parsedUrl.getPort();
        if (port != -1) {
            return port;
        }
        String protocol = this.parsedUrl.getProtocol();
        if (HTTP.equalsIgnoreCase(protocol)) {
            return 80;
        }
        if (HTTPS.equalsIgnoreCase(protocol)) {
            return 443;
        }
        return 443;
    }

    public static void main(String[] args2) {
        System.setProperty("log4j2.configurationFile", "log4j2-cli.xml");
        AnsiConsole.systemInstall();
        CommandLine cli = new CommandLine(new HttpCli());
        cli.setExecutionExceptionHandler(new PrintExceptionMessageHandlerService());
        cli.setCaseInsensitiveEnumValuesAllowed(true);
        cli.setOptionsCaseInsensitive(true);
        int exitCode = cli.execute(args2);
        AnsiConsole.systemUninstall();
        System.exit(exitCode);
    }

    @Override
    public Integer call() throws Exception {
        this.validate();
        this.printWriter = this.spec.commandLine().getOut();
        MetricsHubCliService.setLogLevel(this.verbose);
        CliExtensionManager.getExtensionManagerSingleton().findExtensionByType(HTTP).ifPresent(extension -> {
            try {
                ObjectNode configurationNode = JsonNodeFactory.instance.objectNode();
                configurationNode.set(HTTPS, BooleanNode.valueOf(this.parsedUrl.getProtocol().equals(HTTPS)));
                configurationNode.set("port", new IntNode(this.resolvePortFromUrl()));
                configurationNode.set("timeout", new TextNode(this.timeout));
                configurationNode.set("username", new TextNode(this.username));
                configurationNode.set("password", new TextNode(String.valueOf(this.password)));
                IConfiguration configuration = extension.buildConfiguration(HTTP, configurationNode, null);
                String hostname = this.parsedUrl.getHost();
                configuration.setHostname(hostname);
                configuration.validateConfiguration(hostname);
                this.displayRequest();
                String result = extension.executeQuery(configuration, this.getQuery());
                this.displayResult(result);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Failed to execute HTTP %s query.%n", this.method), e);
            }
        });
        return 0;
    }

    void displayRequest() {
        this.printWriter.println(String.format("Hostname %s - Executing %s %s request:", this.parsedUrl.getHost(), this.parsedUrl.getProtocol(), this.method));
        this.printWriter.println(Ansi.ansi().a("Url: ").fgBrightBlack().a(this.url).reset().toString());
        if (this.headerContent != null) {
            this.printWriter.println(Ansi.ansi().a("Header:\n").fgBrightBlack().a(this.headerContent).reset().toString());
        }
        if (this.bodyContent != null) {
            this.printWriter.println(Ansi.ansi().a("Body:\n").fgBrightBlack().a(this.bodyContent).reset().toString());
        }
        this.printWriter.flush();
    }

    void displayResult(String result) {
        this.printWriter.println(Ansi.ansi().fgBlue().bold().a("Result:\n").reset().a(result).toString());
        this.printWriter.flush();
    }

    @Generated
    public HttpCli() {
    }

    @Generated
    public CommandLine.Model.CommandSpec getSpec() {
        return this.spec;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public String getHeaderFile() {
        return this.headerFile;
    }

    @Generated
    public String getBody() {
        return this.body;
    }

    @Generated
    public String getBodyFile() {
        return this.bodyFile;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public boolean isUsageHelpRequested() {
        return this.usageHelpRequested;
    }

    @Generated
    public boolean[] getVerbose() {
        return this.verbose;
    }

    @Generated
    public URL getParsedUrl() {
        return this.parsedUrl;
    }

    @Generated
    public PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    @Generated
    public String getHeaderContent() {
        return this.headerContent;
    }

    @Generated
    public String getBodyContent() {
        return this.bodyContent;
    }

    @Generated
    public void setSpec(CommandLine.Model.CommandSpec spec) {
        this.spec = spec;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Generated
    public void setHeaderFile(String headerFile) {
        this.headerFile = headerFile;
    }

    @Generated
    public void setBody(String body) {
        this.body = body;
    }

    @Generated
    public void setBodyFile(String bodyFile) {
        this.bodyFile = bodyFile;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    @Generated
    public void setUsageHelpRequested(boolean usageHelpRequested) {
        this.usageHelpRequested = usageHelpRequested;
    }

    @Generated
    public void setVerbose(boolean[] verbose) {
        this.verbose = verbose;
    }

    @Generated
    public void setParsedUrl(URL parsedUrl) {
        this.parsedUrl = parsedUrl;
    }

    @Generated
    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    @Generated
    public void setHeaderContent(String headerContent) {
        this.headerContent = headerContent;
    }

    @Generated
    public void setBodyContent(String bodyContent) {
        this.bodyContent = bodyContent;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpCli)) {
            return false;
        }
        HttpCli other = (HttpCli)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUsageHelpRequested() != other.isUsageHelpRequested()) {
            return false;
        }
        CommandLine.Model.CommandSpec this$spec = this.getSpec();
        CommandLine.Model.CommandSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$headerFile = this.getHeaderFile();
        String other$headerFile = other.getHeaderFile();
        if (this$headerFile == null ? other$headerFile != null : !this$headerFile.equals(other$headerFile)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$bodyFile = this.getBodyFile();
        String other$bodyFile = other.getBodyFile();
        if (this$bodyFile == null ? other$bodyFile != null : !this$bodyFile.equals(other$bodyFile)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        if (!Arrays.equals(this.getVerbose(), other.getVerbose())) {
            return false;
        }
        URL this$parsedUrl = this.getParsedUrl();
        URL other$parsedUrl = other.getParsedUrl();
        if (this$parsedUrl == null ? other$parsedUrl != null : !((Object)this$parsedUrl).equals(other$parsedUrl)) {
            return false;
        }
        PrintWriter this$printWriter = this.getPrintWriter();
        PrintWriter other$printWriter = other.getPrintWriter();
        if (this$printWriter == null ? other$printWriter != null : !this$printWriter.equals(other$printWriter)) {
            return false;
        }
        String this$headerContent = this.getHeaderContent();
        String other$headerContent = other.getHeaderContent();
        if (this$headerContent == null ? other$headerContent != null : !this$headerContent.equals(other$headerContent)) {
            return false;
        }
        String this$bodyContent = this.getBodyContent();
        String other$bodyContent = other.getBodyContent();
        return !(this$bodyContent == null ? other$bodyContent != null : !this$bodyContent.equals(other$bodyContent));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpCli;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUsageHelpRequested() ? 79 : 97);
        CommandLine.Model.CommandSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $headerFile = this.getHeaderFile();
        result = result * 59 + ($headerFile == null ? 43 : $headerFile.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $bodyFile = this.getBodyFile();
        result = result * 59 + ($bodyFile == null ? 43 : $bodyFile.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        result = result * 59 + Arrays.hashCode(this.getVerbose());
        URL $parsedUrl = this.getParsedUrl();
        result = result * 59 + ($parsedUrl == null ? 43 : ((Object)$parsedUrl).hashCode());
        PrintWriter $printWriter = this.getPrintWriter();
        result = result * 59 + ($printWriter == null ? 43 : $printWriter.hashCode());
        String $headerContent = this.getHeaderContent();
        result = result * 59 + ($headerContent == null ? 43 : $headerContent.hashCode());
        String $bodyContent = this.getBodyContent();
        result = result * 59 + ($bodyContent == null ? 43 : $bodyContent.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HttpCli(spec=" + String.valueOf(this.getSpec()) + ", url=" + this.getUrl() + ", method=" + this.getMethod() + ", headers=" + String.valueOf(this.getHeaders()) + ", headerFile=" + this.getHeaderFile() + ", body=" + this.getBody() + ", bodyFile=" + this.getBodyFile() + ", username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", timeout=" + this.getTimeout() + ", usageHelpRequested=" + this.isUsageHelpRequested() + ", verbose=" + Arrays.toString(this.getVerbose()) + ", parsedUrl=" + String.valueOf(this.getParsedUrl()) + ", printWriter=" + String.valueOf(this.getPrintWriter()) + ", headerContent=" + this.getHeaderContent() + ", bodyContent=" + this.getBodyContent() + ")";
    }
}

