/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.PrintWriter;
import java.util.concurrent.Callable;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.ConsoleService;
import org.sentrysoftware.metricshub.cli.service.MetricsHubCliService;
import org.sentrysoftware.metricshub.cli.service.PrintExceptionMessageHandlerService;
import org.sentrysoftware.metricshub.engine.common.IQuery;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import picocli.CommandLine;

@CommandLine.Command(name="ipmicli", description={"\nList of valid options: \n"}, footer={"\nExample:\n\nipmicli <HOSTNAME> --username <USERNAME> --password <PASSWORD> --bmc-key <KEY> --timeout <TIMEOUT> --skip-auth <BOOLEAN>\n\nipmicli dev-01 --username username --password password --bmc-key AE4C7AB47FD --timeout 1m --skip-auth false\n\nNote: If --password is not provided, you will be prompted interactively.\n"}, usageHelpWidth=180)
public class IpmiCli
implements IQuery,
Callable<Integer> {
    private static final String PROTOCOL_IDENTIFIER = "ipmi";
    public static final String FOOTER = "\nExample:\n\nipmicli <HOSTNAME> --username <USERNAME> --password <PASSWORD> --bmc-key <KEY> --timeout <TIMEOUT> --skip-auth <BOOLEAN>\n\nipmicli dev-01 --username username --password password --bmc-key AE4C7AB47FD --timeout 1m --skip-auth false\n\nNote: If --password is not provided, you will be prompted interactively.\n";
    @CommandLine.Parameters(index="0", paramLabel="HOSTNAME", description={"Hostname or IP address of the host to monitor"})
    String hostname;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--username"}, order=1, paramLabel="USER", description={"Username for IPMI-over-LAN authentication"})
    private String username;
    @CommandLine.Option(names={"--password"}, order=2, paramLabel="P4SSW0RD", description={"Password for IPMI-over-LAN authentication"}, interactive=true, arity="0..1")
    private char[] password;
    @CommandLine.Option(names={"--bmc-key", "--key"}, order=3, paramLabel="KEY", description={"BMC key for IPMI-over-LAN two-key authentication (in hexadecimal)"})
    private String bmcKey;
    @CommandLine.Option(names={"--skip-auth"}, order=4, defaultValue="false", description={"Skips IPMI-over-LAN authentication"})
    private boolean skipAuth;
    @CommandLine.Option(names={"--timeout"}, order=5, paramLabel="TIMEOUT", defaultValue="120", description={"Timeout in seconds for IPMI operations (default: ${DEFAULT-VALUE} s)"})
    private String timeout;
    @CommandLine.Option(names={"-h", "-?", "--help"}, order=6, usageHelp=true, description={"Shows this help message and exits"})
    boolean usageHelpRequested;
    @CommandLine.Option(names={"-v"}, order=7, description={"Verbose mode (repeat the option to increase verbosity)"})
    boolean[] verbose;
    PrintWriter printWriter;

    @Override
    public JsonNode getQuery() {
        return null;
    }

    void tryInteractivePassword(MetricsHubCliService.CliPasswordReader<char[]> passwordReader) {
        if (this.username != null && this.password == null) {
            this.password = passwordReader.read("%s password for IPMI: ", this.username);
        }
    }

    void validate() {
        boolean interactive = ConsoleService.hasConsole();
        if (interactive) {
            this.tryInteractivePassword(System.console()::readPassword);
        }
    }

    public static void main(String[] args2) {
        System.setProperty("log4j2.configurationFile", "log4j2-cli.xml");
        AnsiConsole.systemInstall();
        CommandLine cli = new CommandLine(new IpmiCli());
        cli.setExecutionExceptionHandler(new PrintExceptionMessageHandlerService());
        cli.setCaseInsensitiveEnumValuesAllowed(true);
        cli.setOptionsCaseInsensitive(true);
        int exitCode = cli.execute(args2);
        AnsiConsole.systemUninstall();
        System.exit(exitCode);
    }

    @Override
    public Integer call() throws Exception {
        this.validate();
        this.printWriter = this.spec.commandLine().getOut();
        MetricsHubCliService.setLogLevel(this.verbose);
        CliExtensionManager.getExtensionManagerSingleton().findExtensionByType(PROTOCOL_IDENTIFIER).ifPresent(extension -> {
            try {
                ObjectNode configurationNode = JsonNodeFactory.instance.objectNode();
                configurationNode.set("username", new TextNode(this.username));
                if (this.password != null) {
                    configurationNode.set("password", new TextNode(String.valueOf(this.password)));
                }
                configurationNode.set("timeout", new TextNode(this.timeout));
                configurationNode.set("skipAuth", BooleanNode.valueOf(this.skipAuth));
                configurationNode.set("bmcKey", new TextNode(this.bmcKey));
                IConfiguration configuration = extension.buildConfiguration(PROTOCOL_IDENTIFIER, configurationNode, null);
                configuration.setHostname(this.hostname);
                configuration.validateConfiguration(this.hostname);
                this.displayRequest();
                String result = extension.executeQuery(configuration, null);
                this.displayResult(result);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to execute IPMI query.\n", e);
            }
        });
        return 0;
    }

    void displayRequest() {
        this.printWriter.println(Ansi.ansi().a("Hostname ").bold().a(this.hostname).a(" - Executing SQL request."));
        this.printWriter.flush();
    }

    void displayResult(String result) {
        this.printWriter.println(Ansi.ansi().fgBlue().bold().a("Result:\n").reset().a(result).toString());
        this.printWriter.flush();
    }
}

