/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.MetricsHubCliService;
import org.sentrysoftware.metricshub.cli.service.PrintExceptionMessageHandlerService;
import org.sentrysoftware.metricshub.engine.common.IQuery;
import org.sentrysoftware.metricshub.engine.common.helpers.NetworkHelper;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="pingcli", description={"\nList of valid options: \n"}, footer={"\nExample:\n\npingcli <HOSTNAME> --timeout <TIMEOUT>\n\npingcli dev-01 --timeout 5s\n"}, usageHelpWidth=180)
public class PingCli
implements IQuery,
Callable<Integer> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PingCli.class);
    public static final String PROTOCOL_IDENTIFIER = "ping";
    public static final long DEFAULT_TIMEOUT = 5L;
    public static final String FOOTER = "\nExample:\n\npingcli <HOSTNAME> --timeout <TIMEOUT>\n\npingcli dev-01 --timeout 5s\n";
    @CommandLine.Parameters(index="0", paramLabel="HOSTNAME", description={"Hostname or IP address of the host to monitor"})
    String hostname;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--timeout"}, order=1, paramLabel="TIMEOUT", description={"Timeout in seconds for ICMP Ping operations (default: ${DEFAULT-VALUE} s)"}, defaultValue="5")
    private String timeout;
    @CommandLine.Option(names={"-h", "-?", "--help"}, order=2, usageHelp=true, description={"Shows this help message and exits"})
    boolean usageHelpRequested;
    @CommandLine.Option(names={"-v"}, order=3, description={"Verbose mode (repeat the option to increase verbosity)"})
    boolean[] verbose;
    PrintWriter printWriter;

    @Override
    public JsonNode getQuery() {
        return null;
    }

    public static void main(String[] args2) {
        System.setProperty("log4j2.configurationFile", "log4j2-cli.xml");
        AnsiConsole.systemInstall();
        CommandLine cli = new CommandLine(new PingCli());
        cli.setExecutionExceptionHandler(new PrintExceptionMessageHandlerService());
        cli.setCaseInsensitiveEnumValuesAllowed(true);
        cli.setOptionsCaseInsensitive(true);
        int exitCode = cli.execute(args2);
        AnsiConsole.systemUninstall();
        System.exit(exitCode);
    }

    @Override
    public Integer call() throws Exception {
        MetricsHubCliService.setLogLevel(this.verbose);
        this.printWriter = this.spec.commandLine().getOut();
        CliExtensionManager.getExtensionManagerSingleton().findExtensionByType(PROTOCOL_IDENTIFIER).ifPresent(extension -> {
            try {
                ObjectNode configurationNode = JsonNodeFactory.instance.objectNode();
                configurationNode.set("timeout", new TextNode(this.timeout));
                IConfiguration configuration = extension.buildConfiguration(PROTOCOL_IDENTIFIER, configurationNode, null);
                configuration.setHostname(this.hostname);
                configuration.validateConfiguration(this.hostname);
                this.displayQuery();
                long startTime = System.currentTimeMillis();
                String result = extension.executeQuery(configuration, this.getQuery());
                long responseTime = System.currentTimeMillis() - startTime;
                this.displayResult(result, responseTime);
            }
            catch (Exception e) {
                this.displayResult(Boolean.toString(false), null);
            }
        });
        return 0;
    }

    void displayQuery() {
        String fqdn = this.hostname;
        String ipAddress = null;
        this.printWriter.println("Executing an ICMP ping request:");
        try {
            fqdn = NetworkHelper.getFqdn(this.hostname);
        }
        catch (Exception e) {
            log.debug("Unable to retrieve FQDN for {}.\n", (Object)this.hostname);
        }
        try {
            ipAddress = NetworkHelper.resolveDns(this.hostname);
        }
        catch (Exception e) {
            log.debug("Unable to retrieve IP Address for {}.\n", (Object)this.hostname);
        }
        this.printWriter.println(Ansi.ansi().a("Hostname: ").fgBrightBlack().a(fqdn).reset().toString());
        if (ipAddress != null) {
            this.printWriter.println(Ansi.ansi().a("IP Address: ").fgBrightBlack().a(ipAddress).reset().toString());
        }
        this.printWriter.flush();
    }

    void displayResult(String result, Long responseTime) {
        if (Boolean.TRUE.toString().equals(result)) {
            this.printWriter.println(Ansi.ansi().bold().a("Status: ").reset().fgGreen().a("Reachable").reset().toString());
            this.printWriter.println(Ansi.ansi().a("Response Time: ").fgBrightBlack().a(responseTime).a("ms").reset().toString());
        } else {
            this.printWriter.println(Ansi.ansi().bold().a("Status: ").reset().fgRed().a("Unreachable").toString());
        }
        this.printWriter.flush();
    }

    @Generated
    public PingCli() {
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public CommandLine.Model.CommandSpec getSpec() {
        return this.spec;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public boolean isUsageHelpRequested() {
        return this.usageHelpRequested;
    }

    @Generated
    public boolean[] getVerbose() {
        return this.verbose;
    }

    @Generated
    public PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public void setSpec(CommandLine.Model.CommandSpec spec) {
        this.spec = spec;
    }

    @Generated
    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    @Generated
    public void setUsageHelpRequested(boolean usageHelpRequested) {
        this.usageHelpRequested = usageHelpRequested;
    }

    @Generated
    public void setVerbose(boolean[] verbose) {
        this.verbose = verbose;
    }

    @Generated
    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PingCli)) {
            return false;
        }
        PingCli other = (PingCli)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUsageHelpRequested() != other.isUsageHelpRequested()) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        CommandLine.Model.CommandSpec this$spec = this.getSpec();
        CommandLine.Model.CommandSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        if (!Arrays.equals(this.getVerbose(), other.getVerbose())) {
            return false;
        }
        PrintWriter this$printWriter = this.getPrintWriter();
        PrintWriter other$printWriter = other.getPrintWriter();
        return !(this$printWriter == null ? other$printWriter != null : !this$printWriter.equals(other$printWriter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PingCli;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUsageHelpRequested() ? 79 : 97);
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        CommandLine.Model.CommandSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        result = result * 59 + Arrays.hashCode(this.getVerbose());
        PrintWriter $printWriter = this.getPrintWriter();
        result = result * 59 + ($printWriter == null ? 43 : $printWriter.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PingCli(hostname=" + this.getHostname() + ", spec=" + String.valueOf(this.getSpec()) + ", timeout=" + this.getTimeout() + ", usageHelpRequested=" + this.isUsageHelpRequested() + ", verbose=" + Arrays.toString(this.getVerbose()) + ", printWriter=" + String.valueOf(this.getPrintWriter()) + ")";
    }
}

