/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import lombok.Generated;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.MetricsHubCliService;
import org.sentrysoftware.metricshub.cli.service.PrintExceptionMessageHandlerService;
import org.sentrysoftware.metricshub.engine.common.IQuery;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import picocli.CommandLine;

@CommandLine.Command(name="snmpcli", description={"\nList of valid options: \n"}, footer={"\nExamples:\n\n@|green # SNMP Get request|@\nsnmpcli <HOSTNAME> --get <OID> --community <COMMUNITY> --version <VERSION> --port <PORT> --timeout <TIMEOUT> --retry <INTERVAL1>,<INTERVAL2>,...\nsnmpcli <HOSTNAME> --get 1.3.6.1.4.1.674.10892.5.5.1.20.130.4.1.1.1 --community public --version v2c --port 161 --timeout 1m --retry 500,1000\n\n@|green # SNMP Get Next request|@\nsnmpcli <HOSTNAME> --getNext <OID> --community <COMMUNITY> --version <VERSION> --port <PORT> --timeout <TIMEOUT> --retry <INTERVAL1>,<INTERVAL2>,...\nsnmpcli <HOSTNAME> --getNext 1.3.6.1.4.1.674.10892.5.5.1.20.130.4 --community public --version v2c --port 161 --timeout 1m --retry 500,1000\n\n@|green # SNMP Walk request|@\nsnmpcli <HOSTNAME> --walk <OID> --community <COMMUNITY> --version <VERSION> --port <PORT> --timeout <TIMEOUT> --retry <INTERVAL1>,<INTERVAL2>,...\nsnmpcli <HOSTNAME> --walk 1.3.6.1 --community public --version v1 --port 161 --timeout 1m --retry 500,1000\n\n@|green # SNMP Table request|@\nsnmpcli <HOSTNAME> --table <OID> --columns <COLUMN, COLUMN, ...> --community <COMMUNITY> --version <VERSION> --port <PORT> --timeout <TIMEOUT> --retry <INTERVAL1>,<INTERVAL2>,...\nsnmpcli <HOSTNAME> --table 1.3.6.1.4.1.674.10892.5.4.300.10.1 --columns 1,3,8,9,11 --community public --version v1 --port 161 --timeout 1m --retry 500,1000\n"}, usageHelpWidth=180)
public class SnmpCli
implements IQuery,
Callable<Integer> {
    private static final String PROTOCOL_IDENTIFIER = "snmp";
    public static final String FOOTER = "\nExamples:\n\n@|green # SNMP Get request|@\nsnmpcli <HOSTNAME> --get <OID> --community <COMMUNITY> --version <VERSION> --port <PORT> --timeout <TIMEOUT> --retry <INTERVAL1>,<INTERVAL2>,...\nsnmpcli <HOSTNAME> --get 1.3.6.1.4.1.674.10892.5.5.1.20.130.4.1.1.1 --community public --version v2c --port 161 --timeout 1m --retry 500,1000\n\n@|green # SNMP Get Next request|@\nsnmpcli <HOSTNAME> --getNext <OID> --community <COMMUNITY> --version <VERSION> --port <PORT> --timeout <TIMEOUT> --retry <INTERVAL1>,<INTERVAL2>,...\nsnmpcli <HOSTNAME> --getNext 1.3.6.1.4.1.674.10892.5.5.1.20.130.4 --community public --version v2c --port 161 --timeout 1m --retry 500,1000\n\n@|green # SNMP Walk request|@\nsnmpcli <HOSTNAME> --walk <OID> --community <COMMUNITY> --version <VERSION> --port <PORT> --timeout <TIMEOUT> --retry <INTERVAL1>,<INTERVAL2>,...\nsnmpcli <HOSTNAME> --walk 1.3.6.1 --community public --version v1 --port 161 --timeout 1m --retry 500,1000\n\n@|green # SNMP Table request|@\nsnmpcli <HOSTNAME> --table <OID> --columns <COLUMN, COLUMN, ...> --community <COMMUNITY> --version <VERSION> --port <PORT> --timeout <TIMEOUT> --retry <INTERVAL1>,<INTERVAL2>,...\nsnmpcli <HOSTNAME> --table 1.3.6.1.4.1.674.10892.5.4.300.10.1 --columns 1,3,8,9,11 --community public --version v1 --port 161 --timeout 1m --retry 500,1000\n";
    @CommandLine.Parameters(index="0", paramLabel="HOSTNAME", description={"Hostname or IP address of the host to monitor"})
    String hostname;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--version"}, order=1, defaultValue="v2c", paramLabel="VERSION", description={"Enables SNMP protocol version: 1 or 2 (default: ${DEFAULT-VALUE})"})
    String snmpVersion;
    @CommandLine.Option(names={"--community"}, order=2, paramLabel="COMMUNITY", defaultValue="public", description={"Community string for SNMP version 1 and 2 (default: ${DEFAULT-VALUE})"})
    char[] community;
    @CommandLine.Option(names={"--port"}, order=3, paramLabel="PORT", defaultValue="161", description={"Port of the SNMP agent (default: ${DEFAULT-VALUE})"})
    int port;
    @CommandLine.Option(names={"--timeout"}, order=4, paramLabel="TIMEOUT", defaultValue="30", description={"Timeout in seconds for SNMP operations (default: ${DEFAULT-VALUE} s)"})
    String timeout;
    @CommandLine.Option(names={"--retry-intervals", "--retry"}, order=5, paramLabel="RETRYINTERVALS", split=",", description={"Timeout in milliseconds after which the elementary operations will be retried"})
    int[] retryIntervals;
    @CommandLine.Option(names={"--get"}, order=6, paramLabel="OID", description={"SNMP Get request"})
    String get;
    @CommandLine.Option(names={"--getNext", "--get-next"}, order=7, paramLabel="OID", description={"SNMP Get Next request"})
    String getNext;
    @CommandLine.Option(names={"--walk"}, order=8, paramLabel="OID", description={"SNMP Walk request"})
    String walk;
    @CommandLine.Option(names={"--table"}, order=9, paramLabel="OID", description={"SNMP Table request"})
    String table;
    @CommandLine.Option(names={"--columns"}, order=10, paramLabel="COLUMNS", split=",", description={"SNMP Table selected columns"})
    String[] columns;
    @CommandLine.Option(names={"-h", "-?", "--help"}, order=11, usageHelp=true, description={"Shows this help message and exits"})
    boolean usageHelpRequested;
    @CommandLine.Option(names={"-v"}, order=12, description={"Verbose mode (repeat the option to increase verbosity)"})
    boolean[] verbose;
    PrintWriter printWriter;

    @Override
    public JsonNode getQuery() {
        String oid;
        String action;
        ObjectNode queryNode = JsonNodeFactory.instance.objectNode();
        if (this.get != null) {
            action = "get";
            oid = this.get;
        } else if (this.getNext != null) {
            action = "getNext";
            oid = this.getNext;
        } else if (this.walk != null) {
            action = "walk";
            oid = this.walk;
        } else {
            action = "table";
            oid = this.table;
            ArrayNode columnsNode = JsonNodeFactory.instance.arrayNode();
            Arrays.stream(this.columns).forEach(columnsNode::add);
            queryNode.set("columns", columnsNode);
        }
        queryNode.set("action", new TextNode(action));
        queryNode.set("oid", new TextNode(oid));
        return queryNode;
    }

    void validate() throws CommandLine.ParameterException {
        long count = Stream.of(this.get, this.getNext, this.walk, this.table).filter(Objects::nonNull).count();
        if (count == 0L) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "At least one SNMP query must be specified: --get, --get-next, --walk, --table.");
        }
        if (count > 1L) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Only one SNMP query can be specified at a time: --get, --get-next, --walk, --table.");
        }
        if (this.table == null ^ this.columns == null) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "SNMP Table query requires columns to select: both --table and --columns must be specified.");
        }
    }

    public static void main(String[] args2) {
        System.setProperty("log4j2.configurationFile", "log4j2-cli.xml");
        AnsiConsole.systemInstall();
        CommandLine cli = new CommandLine(new SnmpCli());
        cli.setExecutionExceptionHandler(new PrintExceptionMessageHandlerService());
        cli.setCaseInsensitiveEnumValuesAllowed(true);
        cli.setOptionsCaseInsensitive(true);
        int exitCode = cli.execute(args2);
        AnsiConsole.systemUninstall();
        System.exit(exitCode);
    }

    @Override
    public Integer call() throws Exception {
        this.validate();
        this.printWriter = this.spec.commandLine().getOut();
        MetricsHubCliService.setLogLevel(this.verbose);
        CliExtensionManager.getExtensionManagerSingleton().findExtensionByType(PROTOCOL_IDENTIFIER).ifPresent(extension -> {
            try {
                ObjectNode snmpConfigNode = JsonNodeFactory.instance.objectNode();
                snmpConfigNode.set("version", new TextNode(this.snmpVersion));
                snmpConfigNode.set("community", new TextNode(String.valueOf(this.community)));
                snmpConfigNode.set("port", new IntNode(this.port));
                snmpConfigNode.set("timeout", new TextNode(this.timeout));
                if (this.retryIntervals != null) {
                    ArrayNode retryIntervalsArrayNode = snmpConfigNode.putArray("retryIntervals");
                    Arrays.stream(this.retryIntervals).forEach(retryIntervalsArrayNode::add);
                }
                IConfiguration configuration = extension.buildConfiguration(PROTOCOL_IDENTIFIER, snmpConfigNode, null);
                configuration.setHostname(this.hostname);
                configuration.validateConfiguration(this.hostname);
                JsonNode queryNode = this.getQuery();
                this.displayQuery(queryNode.get("action").asText(), queryNode.get("oid").asText());
                String result = extension.executeQuery(configuration, queryNode);
                this.displayResult(result);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to execute SNMP query.\n", e);
            }
        });
        return 0;
    }

    void displayQuery(String action, String oid) {
        this.printWriter.println(String.format("Hostname %s - Executing SNMP %s query:", this.hostname, action));
        this.printWriter.println(Ansi.ansi().a("OID: ").fgBrightBlack().a(oid).reset().toString());
        this.printWriter.flush();
    }

    void displayResult(String result) {
        this.printWriter.println(Ansi.ansi().fgBlue().bold().a("Result:\n").reset().a(result).toString());
        this.printWriter.flush();
    }

    @Generated
    public SnmpCli() {
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public CommandLine.Model.CommandSpec getSpec() {
        return this.spec;
    }

    @Generated
    public String getSnmpVersion() {
        return this.snmpVersion;
    }

    @Generated
    public char[] getCommunity() {
        return this.community;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public int[] getRetryIntervals() {
        return this.retryIntervals;
    }

    @Generated
    public String getGet() {
        return this.get;
    }

    @Generated
    public String getGetNext() {
        return this.getNext;
    }

    @Generated
    public String getWalk() {
        return this.walk;
    }

    @Generated
    public String getTable() {
        return this.table;
    }

    @Generated
    public String[] getColumns() {
        return this.columns;
    }

    @Generated
    public boolean isUsageHelpRequested() {
        return this.usageHelpRequested;
    }

    @Generated
    public boolean[] getVerbose() {
        return this.verbose;
    }

    @Generated
    public PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public void setSpec(CommandLine.Model.CommandSpec spec) {
        this.spec = spec;
    }

    @Generated
    public void setSnmpVersion(String snmpVersion) {
        this.snmpVersion = snmpVersion;
    }

    @Generated
    public void setCommunity(char[] community) {
        this.community = community;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    @Generated
    public void setRetryIntervals(int[] retryIntervals) {
        this.retryIntervals = retryIntervals;
    }

    @Generated
    public void setGet(String get2) {
        this.get = get2;
    }

    @Generated
    public void setGetNext(String getNext) {
        this.getNext = getNext;
    }

    @Generated
    public void setWalk(String walk) {
        this.walk = walk;
    }

    @Generated
    public void setTable(String table) {
        this.table = table;
    }

    @Generated
    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    @Generated
    public void setUsageHelpRequested(boolean usageHelpRequested) {
        this.usageHelpRequested = usageHelpRequested;
    }

    @Generated
    public void setVerbose(boolean[] verbose) {
        this.verbose = verbose;
    }

    @Generated
    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnmpCli)) {
            return false;
        }
        SnmpCli other = (SnmpCli)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isUsageHelpRequested() != other.isUsageHelpRequested()) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        CommandLine.Model.CommandSpec this$spec = this.getSpec();
        CommandLine.Model.CommandSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
            return false;
        }
        String this$snmpVersion = this.getSnmpVersion();
        String other$snmpVersion = other.getSnmpVersion();
        if (this$snmpVersion == null ? other$snmpVersion != null : !this$snmpVersion.equals(other$snmpVersion)) {
            return false;
        }
        if (!Arrays.equals(this.getCommunity(), other.getCommunity())) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        if (!Arrays.equals(this.getRetryIntervals(), other.getRetryIntervals())) {
            return false;
        }
        String this$get = this.getGet();
        String other$get = other.getGet();
        if (this$get == null ? other$get != null : !this$get.equals(other$get)) {
            return false;
        }
        String this$getNext = this.getGetNext();
        String other$getNext = other.getGetNext();
        if (this$getNext == null ? other$getNext != null : !this$getNext.equals(other$getNext)) {
            return false;
        }
        String this$walk = this.getWalk();
        String other$walk = other.getWalk();
        if (this$walk == null ? other$walk != null : !this$walk.equals(other$walk)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getColumns(), other.getColumns())) {
            return false;
        }
        if (!Arrays.equals(this.getVerbose(), other.getVerbose())) {
            return false;
        }
        PrintWriter this$printWriter = this.getPrintWriter();
        PrintWriter other$printWriter = other.getPrintWriter();
        return !(this$printWriter == null ? other$printWriter != null : !this$printWriter.equals(other$printWriter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnmpCli;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isUsageHelpRequested() ? 79 : 97);
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        CommandLine.Model.CommandSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
        String $snmpVersion = this.getSnmpVersion();
        result = result * 59 + ($snmpVersion == null ? 43 : $snmpVersion.hashCode());
        result = result * 59 + Arrays.hashCode(this.getCommunity());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        result = result * 59 + Arrays.hashCode(this.getRetryIntervals());
        String $get = this.getGet();
        result = result * 59 + ($get == null ? 43 : $get.hashCode());
        String $getNext = this.getGetNext();
        result = result * 59 + ($getNext == null ? 43 : $getNext.hashCode());
        String $walk = this.getWalk();
        result = result * 59 + ($walk == null ? 43 : $walk.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getColumns());
        result = result * 59 + Arrays.hashCode(this.getVerbose());
        PrintWriter $printWriter = this.getPrintWriter();
        result = result * 59 + ($printWriter == null ? 43 : $printWriter.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SnmpCli(hostname=" + this.getHostname() + ", spec=" + String.valueOf(this.getSpec()) + ", snmpVersion=" + this.getSnmpVersion() + ", community=" + Arrays.toString(this.getCommunity()) + ", port=" + this.getPort() + ", timeout=" + this.getTimeout() + ", retryIntervals=" + Arrays.toString(this.getRetryIntervals()) + ", get=" + this.getGet() + ", getNext=" + this.getGetNext() + ", walk=" + this.getWalk() + ", table=" + this.getTable() + ", columns=" + Arrays.deepToString(this.getColumns()) + ", usageHelpRequested=" + this.isUsageHelpRequested() + ", verbose=" + Arrays.toString(this.getVerbose()) + ", printWriter=" + String.valueOf(this.getPrintWriter()) + ")";
    }
}

