/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import lombok.Generated;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.MetricsHubCliService;
import org.sentrysoftware.metricshub.cli.service.PrintExceptionMessageHandlerService;
import org.sentrysoftware.metricshub.engine.common.IQuery;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import picocli.CommandLine;

@CommandLine.Command(name="snmpv3cli", description={"\nList of valid options: \n"}, footer={"\nExample:\n\n@|green # SNMPv3 Get request:|@\nsnmpv3cli <HOSTNAME> --get <OID> --privacy <DES|AES> --privacy-password <PRIVACY-PASSWORD> --auth <SHA|MD5> --username username --password password --context-name <CONTEXT> --timeout <TIMEOUT> --retry <INTERVAL1>,<INTERVAL2>,...\n\nsnmpv3cli dev-01 --get 1.3.6.1.4.1.674.10892.5.5.1.20.130.4.1.1.1 --privacy AES --privacy-password privacyPassword --auth MD5 --username username --password password --context-name context --timeout 2m --retry 500,1000\n\n@|green # SNMPv3 Get Next request:|@\nsnmpv3cli <HOSTNAME> --getNext <OID> --privacy <DES|AES> --privacy-password <PRIVACY-PASSWORD> --auth <SHA|MD5> --username username --password password --context-name <CONTEXT> --timeout <TIMEOUT> --retry <INTERVAL1>,<INTERVAL2>,...\n\nsnmpv3cli dev-01 --getNext 1.3.6.1.4.1.674.10892.5.5.1.20.130.4 --privacy AES --privacy-password privacyPassword --auth MD5 --username username --password password --context-name context --timeout 2m --retry 500,1000\n\n@|green # SNMPv3 Walk request:|@\nsnmpv3cli <HOSTNAME> --walk <OID> --privacy <DES|AES> --privacy-password <PRIVACY-PASSWORD> --auth <SHA|MD5> --username username --password password --context-name <CONTEXT> --timeout <TIMEOUT> --retry <INTERVAL1>,<INTERVAL2>,...\n\nsnmpv3cli dev-01 --walk 1.3.6.1 --privacy AES --privacy-password privacyPassword --auth MD5 --username username --password password --context-name context --timeout 2m --retry 500,1000\n\n@|green # SNMPv3 Table request:|@\nsnmpv3cli <HOSTNAME> --table <OID> --columns <COLUMN1>,<COLUMN2>,... --privacy <DES|AES> --privacy-password <PRIVACY-PASSWORD> --auth <SHA|MD5> --username username --password password --context-name <CONTEXT> --timeout <TIMEOUT> --retry <INTERVAL1>,<INTERVAL2>,...\n\nsnmpv3cli dev-01 --table 1.3.6.1.4.1.674.10892.5.4.300.10.1 --columns 1,3,8,9,11 --privacy AES --privacy-password privacyPassword --auth MD5 --username username --password password --context-name context --timeout 2m --retry 500,1000\n\nNote: If --password is not provided, you will be prompted interactively.\n"}, usageHelpWidth=180)
public class SnmpV3Cli
implements IQuery,
Callable<Integer> {
    private static final String PROTOCOL_IDENTIFIER = "snmpv3";
    public static final String FOOTER = "\nExample:\n\n@|green # SNMPv3 Get request:|@\nsnmpv3cli <HOSTNAME> --get <OID> --privacy <DES|AES> --privacy-password <PRIVACY-PASSWORD> --auth <SHA|MD5> --username username --password password --context-name <CONTEXT> --timeout <TIMEOUT> --retry <INTERVAL1>,<INTERVAL2>,...\n\nsnmpv3cli dev-01 --get 1.3.6.1.4.1.674.10892.5.5.1.20.130.4.1.1.1 --privacy AES --privacy-password privacyPassword --auth MD5 --username username --password password --context-name context --timeout 2m --retry 500,1000\n\n@|green # SNMPv3 Get Next request:|@\nsnmpv3cli <HOSTNAME> --getNext <OID> --privacy <DES|AES> --privacy-password <PRIVACY-PASSWORD> --auth <SHA|MD5> --username username --password password --context-name <CONTEXT> --timeout <TIMEOUT> --retry <INTERVAL1>,<INTERVAL2>,...\n\nsnmpv3cli dev-01 --getNext 1.3.6.1.4.1.674.10892.5.5.1.20.130.4 --privacy AES --privacy-password privacyPassword --auth MD5 --username username --password password --context-name context --timeout 2m --retry 500,1000\n\n@|green # SNMPv3 Walk request:|@\nsnmpv3cli <HOSTNAME> --walk <OID> --privacy <DES|AES> --privacy-password <PRIVACY-PASSWORD> --auth <SHA|MD5> --username username --password password --context-name <CONTEXT> --timeout <TIMEOUT> --retry <INTERVAL1>,<INTERVAL2>,...\n\nsnmpv3cli dev-01 --walk 1.3.6.1 --privacy AES --privacy-password privacyPassword --auth MD5 --username username --password password --context-name context --timeout 2m --retry 500,1000\n\n@|green # SNMPv3 Table request:|@\nsnmpv3cli <HOSTNAME> --table <OID> --columns <COLUMN1>,<COLUMN2>,... --privacy <DES|AES> --privacy-password <PRIVACY-PASSWORD> --auth <SHA|MD5> --username username --password password --context-name <CONTEXT> --timeout <TIMEOUT> --retry <INTERVAL1>,<INTERVAL2>,...\n\nsnmpv3cli dev-01 --table 1.3.6.1.4.1.674.10892.5.4.300.10.1 --columns 1,3,8,9,11 --privacy AES --privacy-password privacyPassword --auth MD5 --username username --password password --context-name context --timeout 2m --retry 500,1000\n\nNote: If --password is not provided, you will be prompted interactively.\n";
    @CommandLine.Parameters(index="0", paramLabel="HOSTNAME", description={"Hostname or IP address of the host to monitor"})
    String hostname;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--privacy"}, order=1, paramLabel="DES|AES", description={"Privacy (encryption type) for SNMP version 3 (DES, AES, or none)"})
    private String privacy;
    @CommandLine.Option(names={"--privacy-password"}, order=2, paramLabel="PRIVACY-PASSWORD", description={"Privacy (encryption) password for SNMP version 3"})
    private char[] privacyPassword;
    @CommandLine.Option(names={"--auth"}, order=3, paramLabel="SHA|MD5", description={"Authentication type for SNMP version 3 (SHA, MD5 or NO_AUTH)"})
    private String authType;
    @CommandLine.Option(names={"--username"}, order=4, paramLabel="USERNAME", description={"Username for SNMP version 3 with MD5 or SHA"})
    private String username;
    @CommandLine.Option(names={"--password"}, order=5, paramLabel="PASSWORD", description={"Password for SNMP version 3 with MD5 or SHA"})
    private char[] password;
    @CommandLine.Option(names={"--context-name"}, order=6, paramLabel="CONTEXT-NAME", description={"Context name for SNMP version 3"})
    private String contextName;
    @CommandLine.Option(names={"--timeout"}, order=7, paramLabel="TIMEOUT", defaultValue="30", description={"Timeout in seconds for SNMP version 3 operations (default: ${DEFAULT-VALUE} s)"})
    private String timeout;
    @CommandLine.Option(names={"--port"}, order=8, paramLabel="PORT", defaultValue="161", description={"Port of the SNMP version 3 agent (default: ${DEFAULT-VALUE})"})
    private int port;
    @CommandLine.Option(names={"--retryIntervals"}, order=9, paramLabel="RETRY INTERVALS", split=",", description={"Comma-separated retry intervals in milliseconds for SNMP version 3 operations"})
    private int[] retryIntervals;
    @CommandLine.Option(names={"--get"}, order=10, paramLabel="OID", description={"SNMP Get request"})
    String get;
    @CommandLine.Option(names={"--get-next", "--getNext"}, order=11, paramLabel="OID", description={"SNMP Get Next request"})
    String getNext;
    @CommandLine.Option(names={"--walk"}, order=12, paramLabel="OID", description={"SNMP Walk request"})
    String walk;
    @CommandLine.Option(names={"--table"}, order=13, paramLabel="OID", description={"SNMP Table request"})
    String table;
    @CommandLine.Option(names={"--columns"}, split=",", order=14, paramLabel="COLUMNS", description={"SNMP Table selected columns"})
    String[] columns;
    @CommandLine.Option(names={"-h", "-?", "--help"}, order=15, usageHelp=true, description={"Shows this help message and exits"})
    boolean usageHelpRequested;
    @CommandLine.Option(names={"-v"}, order=16, description={"Verbose mode (repeat the option to increase verbosity)"})
    boolean[] verbose;
    PrintWriter printWriter;

    @Override
    public JsonNode getQuery() {
        String oid;
        String action;
        ObjectNode queryNode = JsonNodeFactory.instance.objectNode();
        if (this.get != null) {
            action = "get";
            oid = this.get;
        } else if (this.getNext != null) {
            action = "getNext";
            oid = this.getNext;
        } else if (this.walk != null) {
            action = "walk";
            oid = this.walk;
        } else {
            action = "table";
            oid = this.table;
            ArrayNode columnsNode = JsonNodeFactory.instance.arrayNode();
            Arrays.stream(this.columns).forEach(columnsNode::add);
            queryNode.set("columns", columnsNode);
        }
        queryNode.set("action", new TextNode(action));
        queryNode.set("oid", new TextNode(oid));
        return queryNode;
    }

    void validate() throws CommandLine.ParameterException {
        long count = Stream.of(this.get, this.getNext, this.walk, this.table).filter(Objects::nonNull).count();
        if (count == 0L) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "At least one SNMP V3 query must be specified: --get, --get-next, --walk, --table.");
        }
        if (count > 1L) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Only one SNMP V3 query can be specified at a time: --get, --get-next, --walk, --table.");
        }
    }

    public static void main(String[] args2) {
        System.setProperty("log4j2.configurationFile", "log4j2-cli.xml");
        AnsiConsole.systemInstall();
        CommandLine cli = new CommandLine(new SnmpV3Cli());
        cli.setExecutionExceptionHandler(new PrintExceptionMessageHandlerService());
        cli.setCaseInsensitiveEnumValuesAllowed(true);
        cli.setOptionsCaseInsensitive(true);
        int exitCode = cli.execute(args2);
        AnsiConsole.systemUninstall();
        System.exit(exitCode);
    }

    @Override
    public Integer call() throws Exception {
        this.validate();
        this.printWriter = this.spec.commandLine().getOut();
        MetricsHubCliService.setLogLevel(this.verbose);
        CliExtensionManager.getExtensionManagerSingleton().findExtensionByType(PROTOCOL_IDENTIFIER).ifPresent(extension -> {
            try {
                ObjectNode configurationNode = JsonNodeFactory.instance.objectNode();
                configurationNode.set("username", new TextNode(this.username));
                if (this.password != null) {
                    configurationNode.set("password", new TextNode(String.valueOf(this.password)));
                }
                configurationNode.set("privacy", new TextNode(this.privacy));
                if (this.privacyPassword != null) {
                    configurationNode.set("privacyPassword", new TextNode(String.valueOf(this.privacyPassword)));
                }
                configurationNode.set("authType", new TextNode(this.authType));
                configurationNode.set("contextName", new TextNode(this.contextName));
                configurationNode.set("timeout", new TextNode(this.timeout));
                configurationNode.set("port", new IntNode(this.port));
                if (this.retryIntervals != null) {
                    ArrayNode retryIntervalsArrayNode = configurationNode.putArray("retryIntervals");
                    Arrays.stream(this.retryIntervals).forEach(retryIntervalsArrayNode::add);
                }
                IConfiguration configuration = extension.buildConfiguration(PROTOCOL_IDENTIFIER, configurationNode, null);
                configuration.setHostname(this.hostname);
                configuration.validateConfiguration(this.hostname);
                JsonNode queryNode = this.getQuery();
                this.displayQuery(queryNode.get("action").asText(), queryNode.get("oid").asText());
                String result = extension.executeQuery(configuration, queryNode);
                this.displayResult(result);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to execute SNMPv3 query.\n", e);
            }
        });
        return 0;
    }

    void displayQuery(String action, String oid) {
        this.printWriter.println(String.format("Hostname %s - Executing SNMPv3 %s query:", this.hostname, action));
        this.printWriter.println(Ansi.ansi().a("OID: ").fgBrightBlack().a(oid).reset().toString());
        this.printWriter.flush();
    }

    void displayResult(String result) {
        this.printWriter.println(Ansi.ansi().fgBlue().bold().a("Result:\n").reset().a(result).toString());
        this.printWriter.flush();
    }

    @Generated
    public SnmpV3Cli() {
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public CommandLine.Model.CommandSpec getSpec() {
        return this.spec;
    }

    @Generated
    public String getPrivacy() {
        return this.privacy;
    }

    @Generated
    public char[] getPrivacyPassword() {
        return this.privacyPassword;
    }

    @Generated
    public String getAuthType() {
        return this.authType;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public String getContextName() {
        return this.contextName;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public int[] getRetryIntervals() {
        return this.retryIntervals;
    }

    @Generated
    public String getGet() {
        return this.get;
    }

    @Generated
    public String getGetNext() {
        return this.getNext;
    }

    @Generated
    public String getWalk() {
        return this.walk;
    }

    @Generated
    public String getTable() {
        return this.table;
    }

    @Generated
    public String[] getColumns() {
        return this.columns;
    }

    @Generated
    public boolean isUsageHelpRequested() {
        return this.usageHelpRequested;
    }

    @Generated
    public boolean[] getVerbose() {
        return this.verbose;
    }

    @Generated
    public PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public void setSpec(CommandLine.Model.CommandSpec spec) {
        this.spec = spec;
    }

    @Generated
    public void setPrivacy(String privacy) {
        this.privacy = privacy;
    }

    @Generated
    public void setPrivacyPassword(char[] privacyPassword) {
        this.privacyPassword = privacyPassword;
    }

    @Generated
    public void setAuthType(String authType) {
        this.authType = authType;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    @Generated
    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setRetryIntervals(int[] retryIntervals) {
        this.retryIntervals = retryIntervals;
    }

    @Generated
    public void setGet(String get2) {
        this.get = get2;
    }

    @Generated
    public void setGetNext(String getNext) {
        this.getNext = getNext;
    }

    @Generated
    public void setWalk(String walk) {
        this.walk = walk;
    }

    @Generated
    public void setTable(String table) {
        this.table = table;
    }

    @Generated
    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    @Generated
    public void setUsageHelpRequested(boolean usageHelpRequested) {
        this.usageHelpRequested = usageHelpRequested;
    }

    @Generated
    public void setVerbose(boolean[] verbose) {
        this.verbose = verbose;
    }

    @Generated
    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnmpV3Cli)) {
            return false;
        }
        SnmpV3Cli other = (SnmpV3Cli)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isUsageHelpRequested() != other.isUsageHelpRequested()) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        CommandLine.Model.CommandSpec this$spec = this.getSpec();
        CommandLine.Model.CommandSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
            return false;
        }
        String this$privacy = this.getPrivacy();
        String other$privacy = other.getPrivacy();
        if (this$privacy == null ? other$privacy != null : !this$privacy.equals(other$privacy)) {
            return false;
        }
        if (!Arrays.equals(this.getPrivacyPassword(), other.getPrivacyPassword())) {
            return false;
        }
        String this$authType = this.getAuthType();
        String other$authType = other.getAuthType();
        if (this$authType == null ? other$authType != null : !this$authType.equals(other$authType)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$contextName = this.getContextName();
        String other$contextName = other.getContextName();
        if (this$contextName == null ? other$contextName != null : !this$contextName.equals(other$contextName)) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        if (!Arrays.equals(this.getRetryIntervals(), other.getRetryIntervals())) {
            return false;
        }
        String this$get = this.getGet();
        String other$get = other.getGet();
        if (this$get == null ? other$get != null : !this$get.equals(other$get)) {
            return false;
        }
        String this$getNext = this.getGetNext();
        String other$getNext = other.getGetNext();
        if (this$getNext == null ? other$getNext != null : !this$getNext.equals(other$getNext)) {
            return false;
        }
        String this$walk = this.getWalk();
        String other$walk = other.getWalk();
        if (this$walk == null ? other$walk != null : !this$walk.equals(other$walk)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getColumns(), other.getColumns())) {
            return false;
        }
        if (!Arrays.equals(this.getVerbose(), other.getVerbose())) {
            return false;
        }
        PrintWriter this$printWriter = this.getPrintWriter();
        PrintWriter other$printWriter = other.getPrintWriter();
        return !(this$printWriter == null ? other$printWriter != null : !this$printWriter.equals(other$printWriter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnmpV3Cli;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isUsageHelpRequested() ? 79 : 97);
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        CommandLine.Model.CommandSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
        String $privacy = this.getPrivacy();
        result = result * 59 + ($privacy == null ? 43 : $privacy.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPrivacyPassword());
        String $authType = this.getAuthType();
        result = result * 59 + ($authType == null ? 43 : $authType.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $contextName = this.getContextName();
        result = result * 59 + ($contextName == null ? 43 : $contextName.hashCode());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        result = result * 59 + Arrays.hashCode(this.getRetryIntervals());
        String $get = this.getGet();
        result = result * 59 + ($get == null ? 43 : $get.hashCode());
        String $getNext = this.getGetNext();
        result = result * 59 + ($getNext == null ? 43 : $getNext.hashCode());
        String $walk = this.getWalk();
        result = result * 59 + ($walk == null ? 43 : $walk.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getColumns());
        result = result * 59 + Arrays.hashCode(this.getVerbose());
        PrintWriter $printWriter = this.getPrintWriter();
        result = result * 59 + ($printWriter == null ? 43 : $printWriter.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SnmpV3Cli(hostname=" + this.getHostname() + ", spec=" + String.valueOf(this.getSpec()) + ", privacy=" + this.getPrivacy() + ", privacyPassword=" + Arrays.toString(this.getPrivacyPassword()) + ", authType=" + this.getAuthType() + ", username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", contextName=" + this.getContextName() + ", timeout=" + this.getTimeout() + ", port=" + this.getPort() + ", retryIntervals=" + Arrays.toString(this.getRetryIntervals()) + ", get=" + this.getGet() + ", getNext=" + this.getGetNext() + ", walk=" + this.getWalk() + ", table=" + this.getTable() + ", columns=" + Arrays.deepToString(this.getColumns()) + ", usageHelpRequested=" + this.isUsageHelpRequested() + ", verbose=" + Arrays.toString(this.getVerbose()) + ", printWriter=" + String.valueOf(this.getPrintWriter()) + ")";
    }
}

