/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.ConsoleService;
import org.sentrysoftware.metricshub.cli.service.MetricsHubCliService;
import org.sentrysoftware.metricshub.cli.service.PrintExceptionMessageHandlerService;
import org.sentrysoftware.metricshub.engine.common.IQuery;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import picocli.CommandLine;

@CommandLine.Command(name="sshcli", description={"\nList of valid options: \n"}, footer={"\nExample:\n\n@|green # SSH basic authentication with username and password:|@\nsshcli <HOSTNAME> --username <USERNAME> --password <PASSWORD> --command <COMMAND> --timeout <TIMEOUT> --port <PORT>\n\nsshcli dev-01 --username username --password password --command=\"echo test\" --timeout 30s --port 22\n\n@|green # SSH authentication with a public key:|@\nsshcli <HOSTNAME> --public-key <PATH> --command <COMMAND> --timeout <TIMEOUT> --port <PORT>\n\nsshcli dev-01 --public-key=\"/opt/ssh-rsa.txt\" --command=\"echo test\" --timeout 30s --port 22\n\nNote: If --password is not provided, you will be prompted interactively.\n"}, usageHelpWidth=180)
public class SshCli
implements IQuery,
Callable<Integer> {
    public static final String PROTOCOL_IDENTIFIER = "ssh";
    public static final int DEFAULT_TIMEOUT = 30;
    public static final int DEFAULT_PORT = 22;
    public static final String FOOTER = "\nExample:\n\n@|green # SSH basic authentication with username and password:|@\nsshcli <HOSTNAME> --username <USERNAME> --password <PASSWORD> --command <COMMAND> --timeout <TIMEOUT> --port <PORT>\n\nsshcli dev-01 --username username --password password --command=\"echo test\" --timeout 30s --port 22\n\n@|green # SSH authentication with a public key:|@\nsshcli <HOSTNAME> --public-key <PATH> --command <COMMAND> --timeout <TIMEOUT> --port <PORT>\n\nsshcli dev-01 --public-key=\"/opt/ssh-rsa.txt\" --command=\"echo test\" --timeout 30s --port 22\n\nNote: If --password is not provided, you will be prompted interactively.\n";
    @CommandLine.Parameters(index="0", paramLabel="HOSTNAME", description={"Hostname or IP address of the host to monitor"})
    String hostname;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--username"}, order=1, paramLabel="USER", description={"Username for SSH authentication"})
    private String username;
    @CommandLine.Option(names={"--password"}, order=2, paramLabel="P4SSW0RD", description={"Password or SSH authentication"}, interactive=true, arity="0..1")
    private char[] password;
    @CommandLine.Option(names={"--publickey", "--public-key"}, order=3, paramLabel="PATH", description={"Path to the public key file for SSH authentication"})
    private String publicKeyFilePath;
    @CommandLine.Option(names={"--timeout"}, order=4, paramLabel="TIMEOUT", description={"Timeout in seconds for SSH operations (default: ${DEFAULT-VALUE} s)"}, defaultValue="30")
    private String timeout;
    @CommandLine.Option(names={"--port"}, order=5, paramLabel="PORT", defaultValue="22", description={"Port number for SSH connection (default: ${DEFAULT-VALUE})"})
    private Integer port;
    @CommandLine.Option(names={"--command-line", "--command"}, required=true, order=8, paramLabel="COMMANDLINE", description={"Command Line to execute"}, defaultValue="sudo")
    private String commandLine;
    @CommandLine.Option(names={"-h", "-?", "--help"}, order=9, usageHelp=true, description={"Shows this help message and exits"})
    boolean usageHelpRequested;
    @CommandLine.Option(names={"-v"}, order=10, description={"Verbose mode (repeat the option to increase verbosity)"})
    boolean[] verbose;
    PrintWriter printWriter;

    @Override
    public JsonNode getQuery() {
        ObjectNode queryNode = JsonNodeFactory.instance.objectNode();
        queryNode.set("commandLine", new TextNode(this.commandLine));
        return queryNode;
    }

    void validate() {
        boolean interactive = ConsoleService.hasConsole();
        if (interactive) {
            this.tryInteractivePassword(System.console()::readPassword);
        }
        if (this.commandLine.isBlank()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "SSH command line must not be empty nor blank.");
        }
    }

    void tryInteractivePassword(MetricsHubCliService.CliPasswordReader<char[]> passwordReader) {
        if (this.username != null && this.password == null) {
            this.password = passwordReader.read("%s password for SSH: ", this.username);
        }
    }

    public static void main(String[] args2) {
        System.setProperty("log4j2.configurationFile", "log4j2-cli.xml");
        AnsiConsole.systemInstall();
        CommandLine cli = new CommandLine(new SshCli());
        cli.setExecutionExceptionHandler(new PrintExceptionMessageHandlerService());
        cli.setCaseInsensitiveEnumValuesAllowed(true);
        cli.setOptionsCaseInsensitive(true);
        int exitCode = cli.execute(args2);
        AnsiConsole.systemUninstall();
        System.exit(exitCode);
    }

    @Override
    public Integer call() throws Exception {
        this.validate();
        this.printWriter = this.spec.commandLine().getOut();
        MetricsHubCliService.setLogLevel(this.verbose);
        CliExtensionManager.getExtensionManagerSingleton().findExtensionByType(PROTOCOL_IDENTIFIER).ifPresent(extension -> {
            try {
                ObjectNode configurationNode = JsonNodeFactory.instance.objectNode();
                configurationNode.set("username", new TextNode(this.username));
                if (this.password != null) {
                    configurationNode.set("password", new TextNode(String.valueOf(this.password)));
                }
                configurationNode.set("publicKey", new TextNode(this.publicKeyFilePath));
                configurationNode.set("timeout", new TextNode(this.timeout));
                configurationNode.set("port", new IntNode(this.getPort()));
                IConfiguration configuration = extension.buildConfiguration(PROTOCOL_IDENTIFIER, configurationNode, null);
                configuration.setHostname(this.hostname);
                configuration.validateConfiguration(this.hostname);
                this.displayQuery();
                String result = extension.executeQuery(configuration, this.getQuery());
                this.displayResult(result);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to execute command line through SSH.\n", e);
            }
        });
        return 0;
    }

    void displayQuery() {
        this.printWriter.println(Ansi.ansi().a("Hostname ").bold().a(this.hostname).a(" - Executing command line through SSH."));
        this.printWriter.println(Ansi.ansi().a("Command line: ").fgBrightBlack().a(this.commandLine).reset().toString());
        this.printWriter.flush();
    }

    void displayResult(String result) {
        this.printWriter.println(Ansi.ansi().fgBlue().bold().a("Result:\n").reset().a(result).toString());
        this.printWriter.flush();
    }

    @Generated
    public SshCli() {
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public CommandLine.Model.CommandSpec getSpec() {
        return this.spec;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public String getPublicKeyFilePath() {
        return this.publicKeyFilePath;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getCommandLine() {
        return this.commandLine;
    }

    @Generated
    public boolean isUsageHelpRequested() {
        return this.usageHelpRequested;
    }

    @Generated
    public boolean[] getVerbose() {
        return this.verbose;
    }

    @Generated
    public PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public void setSpec(CommandLine.Model.CommandSpec spec) {
        this.spec = spec;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setPublicKeyFilePath(String publicKeyFilePath) {
        this.publicKeyFilePath = publicKeyFilePath;
    }

    @Generated
    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    @Generated
    public void setUsageHelpRequested(boolean usageHelpRequested) {
        this.usageHelpRequested = usageHelpRequested;
    }

    @Generated
    public void setVerbose(boolean[] verbose) {
        this.verbose = verbose;
    }

    @Generated
    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SshCli)) {
            return false;
        }
        SshCli other = (SshCli)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUsageHelpRequested() != other.isUsageHelpRequested()) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        CommandLine.Model.CommandSpec this$spec = this.getSpec();
        CommandLine.Model.CommandSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$publicKeyFilePath = this.getPublicKeyFilePath();
        String other$publicKeyFilePath = other.getPublicKeyFilePath();
        if (this$publicKeyFilePath == null ? other$publicKeyFilePath != null : !this$publicKeyFilePath.equals(other$publicKeyFilePath)) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        String this$commandLine = this.getCommandLine();
        String other$commandLine = other.getCommandLine();
        if (this$commandLine == null ? other$commandLine != null : !this$commandLine.equals(other$commandLine)) {
            return false;
        }
        if (!Arrays.equals(this.getVerbose(), other.getVerbose())) {
            return false;
        }
        PrintWriter this$printWriter = this.getPrintWriter();
        PrintWriter other$printWriter = other.getPrintWriter();
        return !(this$printWriter == null ? other$printWriter != null : !this$printWriter.equals(other$printWriter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SshCli;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUsageHelpRequested() ? 79 : 97);
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        CommandLine.Model.CommandSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $publicKeyFilePath = this.getPublicKeyFilePath();
        result = result * 59 + ($publicKeyFilePath == null ? 43 : $publicKeyFilePath.hashCode());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        String $commandLine = this.getCommandLine();
        result = result * 59 + ($commandLine == null ? 43 : $commandLine.hashCode());
        result = result * 59 + Arrays.hashCode(this.getVerbose());
        PrintWriter $printWriter = this.getPrintWriter();
        result = result * 59 + ($printWriter == null ? 43 : $printWriter.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SshCli(hostname=" + this.getHostname() + ", spec=" + String.valueOf(this.getSpec()) + ", username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", publicKeyFilePath=" + this.getPublicKeyFilePath() + ", timeout=" + this.getTimeout() + ", port=" + this.getPort() + ", commandLine=" + this.getCommandLine() + ", usageHelpRequested=" + this.isUsageHelpRequested() + ", verbose=" + Arrays.toString(this.getVerbose()) + ", printWriter=" + String.valueOf(this.getPrintWriter()) + ")";
    }
}

