/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.ConsoleService;
import org.sentrysoftware.metricshub.cli.service.MetricsHubCliService;
import org.sentrysoftware.metricshub.cli.service.PrintExceptionMessageHandlerService;
import org.sentrysoftware.metricshub.engine.common.IQuery;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import picocli.CommandLine;

@CommandLine.Command(name="winrmcli", description={"\nList of valid options: \n"}, footer={"\nExample:\n\nwinrmcli <HOSTNAME> --username <USERNAME> --password <PASSWORD> --namespace <NAMESPACE> --query <QUERY> --transport <PROTOCOL> --port <PORT> --timeout <TIMEOUT> --authentications <AUTH1>,<AUTH2>,...\n\nwinrmcli dev-01 --username username --password password --namespace=\"root/cimv2\" --query =\"SELECT * FROM Win32_OperatingSystem\" --transport https --port 5986 --timeout 30s --authentications NTLM,KERBEROS\n\nNote: If --password is not provided, you will be prompted interactively.\n"}, usageHelpWidth=180)
public class WinRmCli
implements IQuery,
Callable<Integer> {
    private static final String PROTOCOL_IDENTIFIER = "winrm";
    public static final int DEFAULT_TIMEOUT = 30;
    public static final Integer DEFAULT_HTTP_PORT = 5985;
    public static final Integer DEFAULT_HTTPS_PORT = 5986;
    public static final Set<String> AUTHENTICATION_SCHEMAS = Set.of("NTLM", "KERBEROS");
    public static final String FOOTER = "\nExample:\n\nwinrmcli <HOSTNAME> --username <USERNAME> --password <PASSWORD> --namespace <NAMESPACE> --query <QUERY> --transport <PROTOCOL> --port <PORT> --timeout <TIMEOUT> --authentications <AUTH1>,<AUTH2>,...\n\nwinrmcli dev-01 --username username --password password --namespace=\"root/cimv2\" --query =\"SELECT * FROM Win32_OperatingSystem\" --transport https --port 5986 --timeout 30s --authentications NTLM,KERBEROS\n\nNote: If --password is not provided, you will be prompted interactively.\n";
    @CommandLine.Parameters(index="0", paramLabel="HOSTNAME", description={"Hostname or IP address of the host to monitor"})
    String hostname;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--transport"}, order=1, paramLabel="HTTP|HTTPS", defaultValue="HTTP", description={"Transport protocol for WinRM (default: ${DEFAULT-VALUE})"})
    private String protocol;
    @CommandLine.Option(names={"--username"}, order=2, paramLabel="USER", description={"Username for WinRM authentication"})
    private String username;
    @CommandLine.Option(names={"--password"}, order=3, paramLabel="P4SSW0RD", description={"Password for the WinRM authentication"}, arity="0..1", interactive=true)
    private char[] password;
    @CommandLine.Option(names={"--port"}, order=4, paramLabel="PORT", description={"Port for WinRM service (default: 5985 for HTTP, 5986 for HTTPS)"})
    private Integer port;
    @CommandLine.Option(names={"--timeout"}, order=5, paramLabel="TIMEOUT", defaultValue="30", description={"Timeout in seconds for WinRM operations (default: ${DEFAULT-VALUE} s)"})
    private String timeout;
    @CommandLine.Option(names={"--authentications", "--auth"}, description={"Comma-separated ordered list of authentication schemes. Possible values are NTLM and KERBEROS. By default, only NTLM is used"}, order=6, paramLabel="AUTH", split=",")
    private List<String> authentications;
    @CommandLine.Option(names={"--query"}, required=true, order=7, paramLabel="QUERY", description={"WinRm query to execute"})
    private String query;
    @CommandLine.Option(names={"--namespace"}, order=8, paramLabel="NAMESPACE", description={"Forces a specific namespace for connectors that perform namespace auto-detection (advanced)"})
    private String namespace;
    @CommandLine.Option(names={"-h", "-?", "--help"}, order=9, usageHelp=true, description={"Shows this help message and exits"})
    boolean usageHelpRequested;
    @CommandLine.Option(names={"-v"}, order=10, description={"Verbose mode (repeat the option to increase verbosity)"})
    boolean[] verbose;
    PrintWriter printWriter;

    @Override
    public JsonNode getQuery() {
        ObjectNode queryNode = JsonNodeFactory.instance.objectNode();
        queryNode.set("query", new TextNode(this.query));
        return queryNode;
    }

    void validate() {
        boolean interactive = ConsoleService.hasConsole();
        if (interactive) {
            this.tryInteractivePassword(System.console()::readPassword);
        }
        if (this.query.isBlank()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "WinRm query must not be empty nor blank.");
        }
        if (this.namespace.isBlank()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "WinRm namespace must not be empty nor blank.");
        }
        if (this.authentications != null) {
            this.authentications.forEach(authentication -> {
                if (!AUTHENTICATION_SCHEMAS.contains(authentication.toUpperCase())) {
                    throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("Invalid authentication schema %s. Possible values are NTLM or KERBEROS", authentication));
                }
            });
        }
    }

    void tryInteractivePassword(MetricsHubCliService.CliPasswordReader<char[]> passwordReader) {
        if (this.username != null && this.password == null) {
            this.password = passwordReader.read("%s password for WinRm: ", this.username);
        }
    }

    public static void main(String[] args2) {
        System.setProperty("log4j2.configurationFile", "log4j2-cli.xml");
        AnsiConsole.systemInstall();
        CommandLine cli = new CommandLine(new WinRmCli());
        cli.setExecutionExceptionHandler(new PrintExceptionMessageHandlerService());
        cli.setCaseInsensitiveEnumValuesAllowed(true);
        cli.setOptionsCaseInsensitive(true);
        int exitCode = cli.execute(args2);
        AnsiConsole.systemUninstall();
        System.exit(exitCode);
    }

    @Override
    public Integer call() throws Exception {
        this.validate();
        this.printWriter = this.spec.commandLine().getOut();
        MetricsHubCliService.setLogLevel(this.verbose);
        CliExtensionManager.getExtensionManagerSingleton().findExtensionByType(PROTOCOL_IDENTIFIER).ifPresent(extension -> {
            try {
                ObjectNode configurationNode = JsonNodeFactory.instance.objectNode();
                configurationNode.set("protocol", new TextNode(this.protocol));
                configurationNode.set("username", new TextNode(this.username));
                if (this.password != null) {
                    configurationNode.set("password", new TextNode(String.valueOf(this.password)));
                }
                configurationNode.set("port", new IntNode(this.getOrDeducePortNumber()));
                configurationNode.set("timeout", new TextNode(this.timeout));
                configurationNode.set("namespace", new TextNode(this.namespace));
                if (this.authentications != null) {
                    ArrayNode authenticationsNode = JsonNodeFactory.instance.arrayNode();
                    this.authentications.stream().forEach(authenticationsNode::add);
                    configurationNode.set("authentications", authenticationsNode);
                }
                IConfiguration configuration = extension.buildConfiguration(PROTOCOL_IDENTIFIER, configurationNode, null);
                configuration.setHostname(this.hostname);
                configuration.validateConfiguration(this.hostname);
                this.displayQuery();
                String result = extension.executeQuery(configuration, this.getQuery());
                this.displayResult(result);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to execute WinRm query.\n", e);
            }
        });
        return 0;
    }

    protected int getOrDeducePortNumber() {
        if (this.port != null) {
            return this.port;
        }
        if ("https".equals(this.protocol)) {
            return DEFAULT_HTTPS_PORT;
        }
        return DEFAULT_HTTP_PORT;
    }

    void displayQuery() {
        this.printWriter.println(Ansi.ansi().a("Hostname ").bold().a(this.hostname).a(" - Executing WinRm request."));
        this.printWriter.println(Ansi.ansi().a("Query: ").fgBrightBlack().a(this.query).reset().toString());
        this.printWriter.println(Ansi.ansi().a("Namespace: ").fgBrightBlack().a(this.namespace).reset().toString());
        this.printWriter.flush();
    }

    void displayResult(String result) {
        this.printWriter.println(Ansi.ansi().fgBlue().bold().a("Result:\n").reset().a(result).toString());
        this.printWriter.flush();
    }

    @Generated
    public WinRmCli() {
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public CommandLine.Model.CommandSpec getSpec() {
        return this.spec;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public List<String> getAuthentications() {
        return this.authentications;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public boolean isUsageHelpRequested() {
        return this.usageHelpRequested;
    }

    @Generated
    public boolean[] getVerbose() {
        return this.verbose;
    }

    @Generated
    public PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public void setSpec(CommandLine.Model.CommandSpec spec) {
        this.spec = spec;
    }

    @Generated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    @Generated
    public void setAuthentications(List<String> authentications) {
        this.authentications = authentications;
    }

    @Generated
    public void setQuery(String query) {
        this.query = query;
    }

    @Generated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Generated
    public void setUsageHelpRequested(boolean usageHelpRequested) {
        this.usageHelpRequested = usageHelpRequested;
    }

    @Generated
    public void setVerbose(boolean[] verbose) {
        this.verbose = verbose;
    }

    @Generated
    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WinRmCli)) {
            return false;
        }
        WinRmCli other = (WinRmCli)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUsageHelpRequested() != other.isUsageHelpRequested()) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        CommandLine.Model.CommandSpec this$spec = this.getSpec();
        CommandLine.Model.CommandSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        List<String> this$authentications = this.getAuthentications();
        List<String> other$authentications = other.getAuthentications();
        if (this$authentications == null ? other$authentications != null : !((Object)this$authentications).equals(other$authentications)) {
            return false;
        }
        JsonNode this$query = this.getQuery();
        JsonNode other$query = other.getQuery();
        if (this$query == null ? other$query != null : !((Object)this$query).equals(other$query)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        if (!Arrays.equals(this.getVerbose(), other.getVerbose())) {
            return false;
        }
        PrintWriter this$printWriter = this.getPrintWriter();
        PrintWriter other$printWriter = other.getPrintWriter();
        return !(this$printWriter == null ? other$printWriter != null : !this$printWriter.equals(other$printWriter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WinRmCli;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUsageHelpRequested() ? 79 : 97);
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        CommandLine.Model.CommandSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        List<String> $authentications = this.getAuthentications();
        result = result * 59 + ($authentications == null ? 43 : ((Object)$authentications).hashCode());
        JsonNode $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        result = result * 59 + Arrays.hashCode(this.getVerbose());
        PrintWriter $printWriter = this.getPrintWriter();
        result = result * 59 + ($printWriter == null ? 43 : $printWriter.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WinRmCli(hostname=" + this.getHostname() + ", spec=" + String.valueOf(this.getSpec()) + ", protocol=" + this.getProtocol() + ", username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", port=" + this.getPort() + ", timeout=" + this.getTimeout() + ", authentications=" + String.valueOf(this.getAuthentications()) + ", query=" + String.valueOf(this.getQuery()) + ", namespace=" + this.getNamespace() + ", usageHelpRequested=" + this.isUsageHelpRequested() + ", verbose=" + Arrays.toString(this.getVerbose()) + ", printWriter=" + String.valueOf(this.getPrintWriter()) + ")";
    }
}

