/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.ConsoleService;
import org.sentrysoftware.metricshub.cli.service.MetricsHubCliService;
import org.sentrysoftware.metricshub.cli.service.PrintExceptionMessageHandlerService;
import org.sentrysoftware.metricshub.engine.common.IQuery;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import picocli.CommandLine;

@CommandLine.Command(name="wmicli", description={"\nList of valid options: \n"}, footer={"\nExample:\n\nwmicli <HOSTNAME> --username <USERNAME> --password <PASSWORD> --namespace <NAMESPACE> --query <QUERY> --timeout <TIMEOUT>\n\nwmicli dev-01 --username username --password password --namespace=\"root/cimv2 --query =\"SELECT * FROM Win32_OperatingSystem\" --timeout 30s\n\nNote: If --password is not provided, you will be prompted interactively.\n"}, usageHelpWidth=180)
public class WmiCli
implements IQuery,
Callable<Integer> {
    private static final String PROTOCOL_IDENTIFIER = "wmi";
    public static final int DEFAULT_TIMEOUT = 30;
    public static final String FOOTER = "\nExample:\n\nwmicli <HOSTNAME> --username <USERNAME> --password <PASSWORD> --namespace <NAMESPACE> --query <QUERY> --timeout <TIMEOUT>\n\nwmicli dev-01 --username username --password password --namespace=\"root/cimv2 --query =\"SELECT * FROM Win32_OperatingSystem\" --timeout 30s\n\nNote: If --password is not provided, you will be prompted interactively.\n";
    @CommandLine.Parameters(index="0", paramLabel="HOSTNAME", description={"Hostname or IP address of the host to monitor"})
    String hostname;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--username"}, order=1, paramLabel="USER", description={"Username for WMI authentication"})
    private String username;
    @CommandLine.Option(names={"--password"}, order=2, paramLabel="P4SSW0RD", description={"Password for WMI authentication"}, interactive=true, arity="0..1")
    private char[] password;
    @CommandLine.Option(names={"--timeout"}, order=3, paramLabel="TIMEOUT", defaultValue="30", description={"Timeout in seconds for WMI operations (default: ${DEFAULT-VALUE} s)"})
    private String timeout;
    @CommandLine.Option(names={"--query"}, required=true, order=4, paramLabel="QUERY", description={"WMI query to execute"})
    private String query;
    @CommandLine.Option(names={"--namespace"}, required=true, order=5, paramLabel="NAMESPACE", description={"Force a specific namespace for connectors that perform namespace auto-detection (advanced)"})
    private String namespace;
    @CommandLine.Option(names={"-h", "-?", "--help"}, order=6, usageHelp=true, description={"Shows this help message and exits"})
    boolean usageHelpRequested;
    @CommandLine.Option(names={"-v"}, order=7, description={"Verbose mode (repeat the option to increase verbosity)"})
    boolean[] verbose;
    PrintWriter printWriter;

    @Override
    public JsonNode getQuery() {
        ObjectNode queryNode = JsonNodeFactory.instance.objectNode();
        queryNode.set("query", new TextNode(this.query));
        return queryNode;
    }

    void validate() {
        boolean interactive = ConsoleService.hasConsole();
        if (interactive) {
            this.tryInteractivePassword(System.console()::readPassword);
        }
        if (this.query.isBlank()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "WMI query must not be empty nor blank.");
        }
        if (this.namespace.isBlank()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "WMI namespace must not be empty nor blank.");
        }
    }

    void tryInteractivePassword(MetricsHubCliService.CliPasswordReader<char[]> passwordReader) {
        if (this.username != null && this.password == null) {
            this.password = passwordReader.read("%s password for WMI: ", this.username);
        }
    }

    public static void main(String[] args2) {
        System.setProperty("log4j2.configurationFile", "log4j2-cli.xml");
        AnsiConsole.systemInstall();
        CommandLine cli = new CommandLine(new WmiCli());
        cli.setExecutionExceptionHandler(new PrintExceptionMessageHandlerService());
        cli.setCaseInsensitiveEnumValuesAllowed(true);
        cli.setOptionsCaseInsensitive(true);
        int exitCode = cli.execute(args2);
        AnsiConsole.systemUninstall();
        System.exit(exitCode);
    }

    @Override
    public Integer call() throws Exception {
        this.validate();
        this.printWriter = this.spec.commandLine().getOut();
        MetricsHubCliService.setLogLevel(this.verbose);
        CliExtensionManager.getExtensionManagerSingleton().findExtensionByType(PROTOCOL_IDENTIFIER).ifPresent(extension -> {
            try {
                ObjectNode configurationNode = JsonNodeFactory.instance.objectNode();
                configurationNode.set("username", new TextNode(this.username));
                configurationNode.set("password", new TextNode(String.valueOf(this.password)));
                configurationNode.set("timeout", new TextNode(this.timeout));
                configurationNode.set("namespace", new TextNode(this.namespace));
                IConfiguration configuration = extension.buildConfiguration(this.hostname, configurationNode, null);
                configuration.setHostname(this.hostname);
                configuration.validateConfiguration(this.hostname);
                this.displayQuery();
                String result = extension.executeQuery(configuration, this.getQuery());
                this.displayResult(result);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to execute WMI query.\n", e);
            }
        });
        return 0;
    }

    void displayQuery() {
        this.printWriter.println(Ansi.ansi().a("Hostname ").bold().a(this.hostname).a(" - Executing WMI request."));
        this.printWriter.println(Ansi.ansi().a("Query: ").fgBrightBlack().a(this.query).reset().toString());
        this.printWriter.println(Ansi.ansi().a("Namespace: ").fgBrightBlack().a(this.namespace).reset().toString());
        this.printWriter.flush();
    }

    void displayResult(String result) {
        this.printWriter.println(Ansi.ansi().fgBlue().bold().a("Result:\n").reset().a(result).toString());
        this.printWriter.flush();
    }

    @Generated
    public WmiCli() {
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public CommandLine.Model.CommandSpec getSpec() {
        return this.spec;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public boolean isUsageHelpRequested() {
        return this.usageHelpRequested;
    }

    @Generated
    public boolean[] getVerbose() {
        return this.verbose;
    }

    @Generated
    public PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public void setSpec(CommandLine.Model.CommandSpec spec) {
        this.spec = spec;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    @Generated
    public void setQuery(String query) {
        this.query = query;
    }

    @Generated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Generated
    public void setUsageHelpRequested(boolean usageHelpRequested) {
        this.usageHelpRequested = usageHelpRequested;
    }

    @Generated
    public void setVerbose(boolean[] verbose) {
        this.verbose = verbose;
    }

    @Generated
    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WmiCli)) {
            return false;
        }
        WmiCli other = (WmiCli)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUsageHelpRequested() != other.isUsageHelpRequested()) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        CommandLine.Model.CommandSpec this$spec = this.getSpec();
        CommandLine.Model.CommandSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        JsonNode this$query = this.getQuery();
        JsonNode other$query = other.getQuery();
        if (this$query == null ? other$query != null : !((Object)this$query).equals(other$query)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        if (!Arrays.equals(this.getVerbose(), other.getVerbose())) {
            return false;
        }
        PrintWriter this$printWriter = this.getPrintWriter();
        PrintWriter other$printWriter = other.getPrintWriter();
        return !(this$printWriter == null ? other$printWriter != null : !this$printWriter.equals(other$printWriter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WmiCli;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUsageHelpRequested() ? 79 : 97);
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        CommandLine.Model.CommandSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        JsonNode $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        result = result * 59 + Arrays.hashCode(this.getVerbose());
        PrintWriter $printWriter = this.getPrintWriter();
        result = result * 59 + ($printWriter == null ? 43 : $printWriter.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WmiCli(hostname=" + this.getHostname() + ", spec=" + String.valueOf(this.getSpec()) + ", username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", timeout=" + this.getTimeout() + ", query=" + String.valueOf(this.getQuery()) + ", namespace=" + this.getNamespace() + ", usageHelpRequested=" + this.isUsageHelpRequested() + ", verbose=" + Arrays.toString(this.getVerbose()) + ", printWriter=" + String.valueOf(this.getPrintWriter()) + ")";
    }
}

