/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli.service;

import java.io.PrintWriter;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.fusesource.jansi.Ansi;
import org.sentrysoftware.metricshub.agent.helper.ConfigHelper;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.ConsoleService;
import org.sentrysoftware.metricshub.cli.service.PrettyPrinterService;
import org.sentrysoftware.metricshub.cli.service.VersionService;
import org.sentrysoftware.metricshub.cli.service.converter.DeviceKindConverter;
import org.sentrysoftware.metricshub.cli.service.protocol.HttpConfigCli;
import org.sentrysoftware.metricshub.cli.service.protocol.IpmiConfigCli;
import org.sentrysoftware.metricshub.cli.service.protocol.JdbcConfigCli;
import org.sentrysoftware.metricshub.cli.service.protocol.SnmpConfigCli;
import org.sentrysoftware.metricshub.cli.service.protocol.SnmpV3ConfigCli;
import org.sentrysoftware.metricshub.cli.service.protocol.SshConfigCli;
import org.sentrysoftware.metricshub.cli.service.protocol.WbemConfigCli;
import org.sentrysoftware.metricshub.cli.service.protocol.WinRmConfigCli;
import org.sentrysoftware.metricshub.cli.service.protocol.WmiConfigCli;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.configuration.HostConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.ConnectorStore;
import org.sentrysoftware.metricshub.engine.connector.model.common.DeviceKind;
import org.sentrysoftware.metricshub.engine.strategy.collect.CollectStrategy;
import org.sentrysoftware.metricshub.engine.strategy.collect.PrepareCollectStrategy;
import org.sentrysoftware.metricshub.engine.strategy.collect.ProtocolHealthCheckStrategy;
import org.sentrysoftware.metricshub.engine.strategy.detection.ConnectorStagingManager;
import org.sentrysoftware.metricshub.engine.strategy.detection.DetectionStrategy;
import org.sentrysoftware.metricshub.engine.strategy.discovery.DiscoveryStrategy;
import org.sentrysoftware.metricshub.engine.strategy.simple.SimpleStrategy;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.hardware.strategy.HardwarePostCollectStrategy;
import org.sentrysoftware.metricshub.hardware.strategy.HardwarePostDiscoveryStrategy;
import org.sentrysoftware.metricshub.hardware.strategy.HardwareStrategy;
import picocli.CommandLine;

@CommandLine.Command(name="metricshub", sortOptions=false, usageHelpAutoWidth=true, versionProvider=VersionService.class, headerHeading="%n", header={"Gather metrics from the specified host."}, synopsisHeading="%n@|bold,underline Usage|@:%n%n", descriptionHeading="%n@|bold,underline Description|@:%n%n", description={"This tool is the CLI version of the @|italic MetricsHub|@ engine. MetricsHub monitors diverse technologies, encompassing applications, servers, and devices, particularly those without readily available monitoring solutions.%n%nIt natively leverages various system management protocols to discover the hardware components of a system and report their operational status.%n%nAdditionally, MetricsHub measures the power consumption of the system, or makes an estimation if no power sensor is detected."}, parameterListHeading="%n@|bold,underline Parameters|@:%n", optionListHeading="%n@|bold,underline Options|@:%n", customSynopsis={"@|bold ${ROOT-COMMAND-NAME}|@ @|yellow HOSTNAME|@ @|yellow -t|@=@|italic TYPE|@ <@|yellow --http|@|@|yellow --https|@|@|yellow --ipmi|@|@|yellow --jdbc|@|@|yellow --snmp|@=@|italic VERSION|@|@|yellow --ssh|@|@|yellow --wbem|@|@|yellow --wmi|@|@|yellow --winrm|@> [@|yellow -u|@=@|italic USER|@ [@|yellow -p|@=@|italic P4SSW0RD|@]] [OPTIONS]..."})
public class MetricsHubCliService
implements Callable<Integer> {
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-V", "--version"}, versionHelp=true, description={"Prints version information and exits"})
    boolean versionInfoRequested;
    @CommandLine.Option(names={"-h", "-?", "--help"}, usageHelp=true, description={"Shows this help message and exits"})
    boolean usageHelpRequested;
    @CommandLine.Parameters(index="0", paramLabel="HOSTNAME", description={"Hostname or IP address of the host to monitor"})
    String hostname;
    @CommandLine.Option(names={"-t", "--type"}, order=1, required=true, paramLabel="TYPE", description={"Reports the type of the host to monitor (lin, linux, win, windows, mgmt, management, storage, network, aix, hpux, solaris, tru64, vms)"}, converter={DeviceKindConverter.class})
    DeviceKind deviceType;
    @CommandLine.ArgGroup(exclusive=false, heading="%n@|bold,underline IPMI Options|@:%n")
    IpmiConfigCli ipmiConfigCli;
    @CommandLine.ArgGroup(exclusive=false, heading="%n@|bold,underline SSH Options|@:%n")
    SshConfigCli sshConfigCli;
    @CommandLine.ArgGroup(exclusive=false, heading="%n@|bold,underline SNMP Options|@:%n")
    SnmpConfigCli snmpConfigCli;
    @CommandLine.ArgGroup(exclusive=false, heading="%n@|bold,underline SNMP V3 Options|@:%n")
    SnmpV3ConfigCli snmpV3ConfigCli;
    @CommandLine.ArgGroup(exclusive=false, heading="%n@|bold,underline HTTP Options|@:%n")
    HttpConfigCli httpConfigCli;
    @CommandLine.ArgGroup(exclusive=false, heading="%n@|bold,underline WBEM Options|@:%n")
    WbemConfigCli wbemConfigCli;
    @CommandLine.ArgGroup(exclusive=false, heading="%n@|bold,underline WMI Options|@:%n")
    WmiConfigCli wmiConfigCli;
    @CommandLine.ArgGroup(exclusive=false, heading="%n@|bold,underline WinRM Options|@:%n")
    WinRmConfigCli winRmConfigCli;
    @CommandLine.ArgGroup(exclusive=false, heading="%n@|bold,underline JDBC Options|@:%n")
    JdbcConfigCli jdbcConfigCli;
    @CommandLine.Option(names={"-u", "--username"}, order=2, paramLabel="USER", description={"Username for authentication"})
    String username;
    @CommandLine.Option(names={"-p", "--password"}, order=3, paramLabel="P4SSW0RD", description={"Associated password"}, arity="0..1", interactive=true)
    char[] password;
    @CommandLine.Option(names={"-c", "--connectors"}, order=4, split=",", paramLabel="CONNECTOR", description={"Specifies the setup of connectors to connect to the host.%n To force a connector, precede the connector identifier with a plus sign (+), as in +MIB2%n. To exclude a connector from automatic detection, precede the connector identifier with an exclamation mark (!), like !MIB2.%n To stage a connector for processing by automatic detection, configure the connector identifier, for instance, MIB2.%n To stage a category of connectors for processing by automatic detection, precede the category tag with a hash (#), such as #hardware.%n To exclude a category of connectors from automatic detection, precede the category tag to be excluded with an exclamation mark and a hash sign (!#), such as !#system.%n Use @|bold ${ROOT-COMMAND-NAME} -l|@ to get the list of connectors)."})
    Set<String> connectors;
    @CommandLine.Option(names={"-pd", "--patch-directory"}, order=5, description={"Patch path to the connectors directory"})
    String patchDirectory;
    @CommandLine.Option(names={"-s", "--sequential"}, order=6, defaultValue="false", description={"Forces all network calls to be executed in sequential order. (default: ${DEFAULT-VALUE})"}, help=true)
    boolean sequential;
    @CommandLine.Option(names={"-v"}, order=7, description={"Verbose mode (repeat the option to increase verbosity)"})
    boolean[] verbose;
    @CommandLine.Option(names={"-l", "--list"}, help=true, order=8, description={"Lists all connectors bundled in the engine that can be selected or excluded"})
    boolean listConnectors;
    @CommandLine.Option(names={"-i", "--iterations"}, help=true, order=9, defaultValue="1", description={"Executes the collect strategies N times, where N is the number of iterations"})
    int iterations;
    @CommandLine.Option(names={"-si", "--sleep-iteration"}, help=true, order=10, defaultValue="5", description={"Adds a sleep period in seconds between collect iterations"})
    long sleepIteration;
    @CommandLine.Option(names={"-m", "--monitors"}, order=11, paramLabel="MONITOR", split=",", description={"Comma-separated list of monitor types to filter. %nExamples: +disk,+file_system,!memory"})
    Set<String> monitorTypes;
    @CommandLine.Option(names={"-r", "--resolve-fqdn"}, order=12, defaultValue="false", description={"Resolves the provided HOSTNAME to its Fully Qualified Domain Name (FQDN)"}, help=true)
    boolean resolveHostnameToFqdn;

    @Override
    public Integer call() throws Exception {
        this.validateIterations(this.iterations);
        if (this.listConnectors) {
            return this.listAllConnectors(ConfigHelper.buildConnectorStore(CliExtensionManager.getExtensionManagerSingleton(), this.patchDirectory), this.spec.commandLine().getOut());
        }
        this.validate();
        MetricsHubCliService.setLogLevel(this.verbose);
        HostConfiguration hostConfiguration = HostConfiguration.builder().hostId(this.hostname).hostname(this.hostname).hostType(this.deviceType).sequential(this.sequential).resolveHostnameToFqdn(this.resolveHostnameToFqdn).build();
        if (this.connectors != null) {
            hostConfiguration.setConnectors(this.connectors);
        }
        Map<Class<? extends IConfiguration>, IConfiguration> configurations = this.buildConfigurations();
        configurations.values().forEach(configuration -> configuration.setHostname(this.hostname));
        hostConfiguration.setConfigurations(configurations);
        TelemetryManager telemetryManager = TelemetryManager.builder().connectorStore(ConfigHelper.buildConnectorStore(CliExtensionManager.getExtensionManagerSingleton(), this.patchDirectory)).hostConfiguration(hostConfiguration).build();
        ClientsExecutor clientsExecutor = new ClientsExecutor(telemetryManager);
        long discoveryTime = System.currentTimeMillis();
        PrintWriter printWriter = this.spec.commandLine().getOut();
        if (ConsoleService.hasConsole()) {
            String protocolDisplay = configurations.values().stream().map(proto -> Ansi.ansi().bold().a(proto.toString()).boldOff().toString()).collect(Collectors.joining(", "));
            printWriter.print("Performing detection on ");
            printWriter.print(Ansi.ansi().bold().a(this.hostname).boldOff().toString());
            printWriter.print(" using ");
            printWriter.print(protocolDisplay);
            printWriter.println("...");
            printWriter.flush();
        }
        telemetryManager.run(new DetectionStrategy(telemetryManager, discoveryTime, clientsExecutor, CliExtensionManager.getExtensionManagerSingleton()));
        if (ConsoleService.hasConsole()) {
            Map<String, Monitor> connectorMonitors = telemetryManager.findMonitorsByType(KnownMonitorType.CONNECTOR.getKey());
            if (connectorMonitors == null || connectorMonitors.isEmpty()) {
                printWriter.println(Ansi.ansi().fgBrightRed().a("No connector detected. Stopping.").reset().toString());
                printWriter.println(Ansi.ansi().fgYellow().a("Please verify that your credentials are correct and that your network connection is stable and not blocking the communication. For detailed troubleshooting steps, use the -vvvv option to display more diagnostic logs.").reset().toString());
                printWriter.flush();
                return 1;
            }
            int connectorCount = telemetryManager.findMonitorsByType(KnownMonitorType.CONNECTOR.getKey()).size();
            printWriter.print("Performing discovery with ");
            printWriter.print(Ansi.ansi().bold().a(connectorCount).boldOff().toString());
            printWriter.println(connectorCount > 1 ? " connectors..." : " connector...");
            printWriter.flush();
        }
        telemetryManager.run(new DiscoveryStrategy(telemetryManager, (Long)discoveryTime, clientsExecutor, CliExtensionManager.getExtensionManagerSingleton()), new SimpleStrategy(telemetryManager, (Long)discoveryTime, clientsExecutor, CliExtensionManager.getExtensionManagerSingleton()), new HardwarePostDiscoveryStrategy(telemetryManager, discoveryTime, clientsExecutor, CliExtensionManager.getExtensionManagerSingleton()));
        for (int i = 0; i < this.iterations; ++i) {
            if (ConsoleService.hasConsole()) {
                long monitorCount = telemetryManager.getMonitors().values().stream().map(Map::values).mapToLong(Collection::size).sum();
                printWriter.print("Performing collect on ");
                printWriter.print(Ansi.ansi().bold().a(monitorCount).boldOff().toString());
                printWriter.println(monitorCount > 1L ? " monitors..." : " monitor...");
                printWriter.flush();
            }
            long collectTime = System.currentTimeMillis();
            telemetryManager.run(new PrepareCollectStrategy(telemetryManager, collectTime, clientsExecutor, CliExtensionManager.getExtensionManagerSingleton()), new ProtocolHealthCheckStrategy(telemetryManager, collectTime, clientsExecutor, CliExtensionManager.getExtensionManagerSingleton()), new CollectStrategy(telemetryManager, collectTime, clientsExecutor, CliExtensionManager.getExtensionManagerSingleton()), new SimpleStrategy(telemetryManager, (Long)collectTime, clientsExecutor, CliExtensionManager.getExtensionManagerSingleton()), new HardwarePostCollectStrategy(telemetryManager, collectTime, clientsExecutor, CliExtensionManager.getExtensionManagerSingleton()));
            telemetryManager.run(new HardwareStrategy(telemetryManager, collectTime));
            if (i == this.iterations - 1 || this.sleepIteration <= 0L) continue;
            printWriter.println(String.format("Pausing for %d seconds before the next iteration...", this.sleepIteration));
            Thread.sleep(this.sleepIteration * 1000L);
        }
        if (ConsoleService.hasConsole()) {
            printWriter.print("\n");
        }
        new PrettyPrinterService(telemetryManager, printWriter).print(this.monitorTypes);
        return 0;
    }

    private void validateIterations(int iterations) {
        if (iterations <= 0) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Number of iterations must be greater than 0.");
        }
    }

    private Map<Class<? extends IConfiguration>, IConfiguration> buildConfigurations() {
        return Stream.of(this.ipmiConfigCli, this.snmpConfigCli, this.snmpV3ConfigCli, this.sshConfigCli, this.httpConfigCli, this.wmiConfigCli, this.winRmConfigCli, this.wbemConfigCli, this.jdbcConfigCli).filter(Objects::nonNull).map(protocolConfig -> {
            try {
                IConfiguration protocol = protocolConfig.toConfiguration(this.username, this.password);
                protocol.validateConfiguration(this.hostname);
                return protocol;
            }
            catch (InvalidConfigurationException e) {
                throw new IllegalStateException("Invalid configuration detected.", e);
            }
        }).collect(Collectors.toMap((Function<IConfiguration, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lorg/sentrysoftware/metricshub/engine/configuration/IConfiguration;)Ljava/lang/Class;)(), Function.identity()));
    }

    private void validate() {
        boolean protocolsNotConfigured;
        boolean interactive = ConsoleService.hasConsole();
        if (interactive) {
            this.tryInteractivePasswords(System.console()::readPassword);
        }
        if (protocolsNotConfigured = Stream.of(this.ipmiConfigCli, this.snmpConfigCli, this.snmpV3ConfigCli, this.sshConfigCli, this.httpConfigCli, this.wmiConfigCli, this.winRmConfigCli, this.wbemConfigCli, this.jdbcConfigCli).allMatch(Objects::isNull)) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "At least one protocol must be specified: --http[s], --ipmi, --jdbc, --snmp, --snmpv3, --ssh, --wbem, --winrm, --wmi.");
        }
    }

    public static void setLogLevel(boolean[] verbose) {
        ThreadContext.put("disableAnsi", Boolean.toString(!ConsoleService.hasConsole()));
        if (verbose != null) {
            Level logLevel = switch (verbose.length) {
                case 0 -> Level.ERROR;
                case 1 -> Level.WARN;
                case 2 -> Level.INFO;
                case 3 -> Level.DEBUG;
                default -> Level.ALL;
            };
            LoggerContext loggerContext = (LoggerContext)LogManager.getContext(false);
            Configuration config = loggerContext.getConfiguration();
            LoggerConfig sentryLoggerConfig = config.getLoggerConfig("org.sentrysoftware");
            sentryLoggerConfig.setLevel(logLevel);
            loggerContext.updateLoggers();
        }
    }

    void tryInteractivePasswords(CliPasswordReader<char[]> passwordReader) {
        this.tryInteractiveGlobalPassword(passwordReader);
        this.tryInteractiveIpmiPassword(passwordReader);
        this.tryInteractiveSshPassword(passwordReader);
        this.tryInteractiveHttpPassword(passwordReader);
        this.tryInteractiveWmiPassword(passwordReader);
        this.tryInteractiveWbemPassword(passwordReader);
        this.tryInteractiveWinRmPassword(passwordReader);
        this.tryInteractiveSnmpV3Password(passwordReader);
        this.tryInteractiveJdbcPassword(passwordReader);
    }

    void tryInteractiveGlobalPassword(CliPasswordReader<char[]> passwordReader) {
        if (this.username != null && this.password == null) {
            this.password = passwordReader.read("%s password: ", this.username);
        }
    }

    void tryInteractiveIpmiPassword(CliPasswordReader<char[]> passwordReader) {
        if (this.ipmiConfigCli != null && this.ipmiConfigCli.getUsername() != null && this.ipmiConfigCli.getPassword() == null) {
            this.ipmiConfigCli.setPassword(passwordReader.read("%s password for IPMI: ", this.ipmiConfigCli.getUsername()));
        }
    }

    void tryInteractiveSshPassword(CliPasswordReader<char[]> passwordReader) {
        if (this.sshConfigCli != null && this.sshConfigCli.getUsername() != null && this.sshConfigCli.getPassword() == null) {
            this.sshConfigCli.setPassword(passwordReader.read("%s password for SSH: ", this.sshConfigCli.getUsername()));
        }
    }

    void tryInteractiveHttpPassword(CliPasswordReader<char[]> passwordReader) {
        if (this.httpConfigCli != null && this.httpConfigCli.getUsername() != null && this.httpConfigCli.getPassword() == null) {
            this.httpConfigCli.setPassword(passwordReader.read("%s password for HTTP: ", this.httpConfigCli.getUsername()));
        }
    }

    void tryInteractiveWmiPassword(CliPasswordReader<char[]> passwordReader) {
        if (this.wmiConfigCli != null && this.wmiConfigCli.getUsername() != null && this.wmiConfigCli.getPassword() == null) {
            this.wmiConfigCli.setPassword(passwordReader.read("%s password for WMI: ", this.wmiConfigCli.getUsername()));
        }
    }

    void tryInteractiveWbemPassword(CliPasswordReader<char[]> passwordReader) {
        if (this.wbemConfigCli != null && this.wbemConfigCli.getUsername() != null && this.wbemConfigCli.getPassword() == null) {
            this.wbemConfigCli.setPassword(passwordReader.read("%s password for WBEM: ", this.wbemConfigCli.getUsername()));
        }
    }

    void tryInteractiveWinRmPassword(CliPasswordReader<char[]> passwordReader) {
        if (this.winRmConfigCli != null && this.winRmConfigCli.getUsername() != null && this.winRmConfigCli.getPassword() == null) {
            this.winRmConfigCli.setPassword(passwordReader.read("%s password for WinRM: ", this.winRmConfigCli.getUsername()));
        }
    }

    void tryInteractiveSnmpV3Password(CliPasswordReader<char[]> passwordReader) {
        if (this.snmpV3ConfigCli != null && this.snmpV3ConfigCli.getUsername() != null && this.snmpV3ConfigCli.getPassword() == null) {
            this.snmpV3ConfigCli.setPassword(passwordReader.read("%s password for SNMP V3: ", this.snmpV3ConfigCli.getUsername()));
        }
    }

    void tryInteractiveJdbcPassword(CliPasswordReader<char[]> passwordReader) {
        if (this.jdbcConfigCli != null && this.jdbcConfigCli.getUsername() != null && this.jdbcConfigCli.getPassword() == null) {
            this.jdbcConfigCli.setPassword(passwordReader.read("%s password for JDBC connection: ", this.jdbcConfigCli.getUsername()));
        }
    }

    int listAllConnectors(ConnectorStore connectorStore, PrintWriter printWriter) {
        ConnectorStagingManager connectorStagingManager = new ConnectorStagingManager();
        ConnectorStagingManager.StagedConnectorIdentifiers stagedConnectorIds = connectorStagingManager.stage(connectorStore, this.connectors);
        TreeSet<String> stagedConnectorIdsSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        stagedConnectorIdsSet.addAll(stagedConnectorIds.getAutoDetectionConnectorIds());
        stagedConnectorIdsSet.addAll(stagedConnectorIds.getForcedConnectorIds());
        if (!connectorStore.getStore().isEmpty()) {
            printWriter.println(Ansi.ansi().fgYellow().a(Ansi.Attribute.INTENSITY_BOLD).a(String.format("%-40s ", "ID")).fgMagenta().a(String.format("%-20s ", "Tags")).fgCyan().a(String.format("%-70s ", "System Types")).fgDefault().a("Display Name").a(Ansi.Attribute.INTENSITY_BOLD_OFF).toString());
        }
        connectorStore.getStore().entrySet().stream().filter(Objects::nonNull).filter(e -> e.getValue() != null && ((Connector)e.getValue()).getCompiledFilename() != null).filter(entry -> stagedConnectorIdsSet.contains(entry.getKey())).sorted((e1, e2) -> ((Connector)e1.getValue()).getCompiledFilename().compareToIgnoreCase(((Connector)e2.getValue()).getCompiledFilename())).forEachOrdered(connectorEntry -> {
            String connectorName = (String)connectorEntry.getKey();
            Connector connector = (Connector)connectorEntry.getValue();
            String osList = connector.getConnectorIdentity().getDetection().getAppliesTo().stream().map(DeviceKind::getDisplayName).collect(Collectors.joining(", "));
            String connectorCategories = connector.getConnectorIdentity().getDetection().getTags().stream().collect(Collectors.joining(", "));
            printWriter.println(Ansi.ansi().fgYellow().a(String.format("%-40s ", connectorName)).fgMagenta().a(String.format("%-20s ", connectorCategories)).a(Ansi.Attribute.ITALIC).fgCyan().a(String.format("%-70s ", osList)).fgDefault().a(Ansi.Attribute.ITALIC_OFF).a(connector.getConnectorIdentity().getDisplayName()).toString());
            printWriter.flush();
        });
        return 0;
    }

    @Generated
    public CommandLine.Model.CommandSpec getSpec() {
        return this.spec;
    }

    @Generated
    public boolean isVersionInfoRequested() {
        return this.versionInfoRequested;
    }

    @Generated
    public boolean isUsageHelpRequested() {
        return this.usageHelpRequested;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public DeviceKind getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public IpmiConfigCli getIpmiConfigCli() {
        return this.ipmiConfigCli;
    }

    @Generated
    public SshConfigCli getSshConfigCli() {
        return this.sshConfigCli;
    }

    @Generated
    public SnmpConfigCli getSnmpConfigCli() {
        return this.snmpConfigCli;
    }

    @Generated
    public SnmpV3ConfigCli getSnmpV3ConfigCli() {
        return this.snmpV3ConfigCli;
    }

    @Generated
    public HttpConfigCli getHttpConfigCli() {
        return this.httpConfigCli;
    }

    @Generated
    public WbemConfigCli getWbemConfigCli() {
        return this.wbemConfigCli;
    }

    @Generated
    public WmiConfigCli getWmiConfigCli() {
        return this.wmiConfigCli;
    }

    @Generated
    public WinRmConfigCli getWinRmConfigCli() {
        return this.winRmConfigCli;
    }

    @Generated
    public JdbcConfigCli getJdbcConfigCli() {
        return this.jdbcConfigCli;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public Set<String> getConnectors() {
        return this.connectors;
    }

    @Generated
    public String getPatchDirectory() {
        return this.patchDirectory;
    }

    @Generated
    public boolean isSequential() {
        return this.sequential;
    }

    @Generated
    public boolean[] getVerbose() {
        return this.verbose;
    }

    @Generated
    public boolean isListConnectors() {
        return this.listConnectors;
    }

    @Generated
    public int getIterations() {
        return this.iterations;
    }

    @Generated
    public long getSleepIteration() {
        return this.sleepIteration;
    }

    @Generated
    public Set<String> getMonitorTypes() {
        return this.monitorTypes;
    }

    @Generated
    public boolean isResolveHostnameToFqdn() {
        return this.resolveHostnameToFqdn;
    }

    @Generated
    public void setSpec(CommandLine.Model.CommandSpec spec) {
        this.spec = spec;
    }

    @Generated
    public void setVersionInfoRequested(boolean versionInfoRequested) {
        this.versionInfoRequested = versionInfoRequested;
    }

    @Generated
    public void setUsageHelpRequested(boolean usageHelpRequested) {
        this.usageHelpRequested = usageHelpRequested;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public void setDeviceType(DeviceKind deviceType) {
        this.deviceType = deviceType;
    }

    @Generated
    public void setIpmiConfigCli(IpmiConfigCli ipmiConfigCli) {
        this.ipmiConfigCli = ipmiConfigCli;
    }

    @Generated
    public void setSshConfigCli(SshConfigCli sshConfigCli) {
        this.sshConfigCli = sshConfigCli;
    }

    @Generated
    public void setSnmpConfigCli(SnmpConfigCli snmpConfigCli) {
        this.snmpConfigCli = snmpConfigCli;
    }

    @Generated
    public void setSnmpV3ConfigCli(SnmpV3ConfigCli snmpV3ConfigCli) {
        this.snmpV3ConfigCli = snmpV3ConfigCli;
    }

    @Generated
    public void setHttpConfigCli(HttpConfigCli httpConfigCli) {
        this.httpConfigCli = httpConfigCli;
    }

    @Generated
    public void setWbemConfigCli(WbemConfigCli wbemConfigCli) {
        this.wbemConfigCli = wbemConfigCli;
    }

    @Generated
    public void setWmiConfigCli(WmiConfigCli wmiConfigCli) {
        this.wmiConfigCli = wmiConfigCli;
    }

    @Generated
    public void setWinRmConfigCli(WinRmConfigCli winRmConfigCli) {
        this.winRmConfigCli = winRmConfigCli;
    }

    @Generated
    public void setJdbcConfigCli(JdbcConfigCli jdbcConfigCli) {
        this.jdbcConfigCli = jdbcConfigCli;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setConnectors(Set<String> connectors) {
        this.connectors = connectors;
    }

    @Generated
    public void setPatchDirectory(String patchDirectory) {
        this.patchDirectory = patchDirectory;
    }

    @Generated
    public void setSequential(boolean sequential) {
        this.sequential = sequential;
    }

    @Generated
    public void setVerbose(boolean[] verbose) {
        this.verbose = verbose;
    }

    @Generated
    public void setListConnectors(boolean listConnectors) {
        this.listConnectors = listConnectors;
    }

    @Generated
    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    @Generated
    public void setSleepIteration(long sleepIteration) {
        this.sleepIteration = sleepIteration;
    }

    @Generated
    public void setMonitorTypes(Set<String> monitorTypes) {
        this.monitorTypes = monitorTypes;
    }

    @Generated
    public void setResolveHostnameToFqdn(boolean resolveHostnameToFqdn) {
        this.resolveHostnameToFqdn = resolveHostnameToFqdn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricsHubCliService)) {
            return false;
        }
        MetricsHubCliService other = (MetricsHubCliService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isVersionInfoRequested() != other.isVersionInfoRequested()) {
            return false;
        }
        if (this.isUsageHelpRequested() != other.isUsageHelpRequested()) {
            return false;
        }
        if (this.isSequential() != other.isSequential()) {
            return false;
        }
        if (this.isListConnectors() != other.isListConnectors()) {
            return false;
        }
        if (this.getIterations() != other.getIterations()) {
            return false;
        }
        if (this.getSleepIteration() != other.getSleepIteration()) {
            return false;
        }
        if (this.isResolveHostnameToFqdn() != other.isResolveHostnameToFqdn()) {
            return false;
        }
        CommandLine.Model.CommandSpec this$spec = this.getSpec();
        CommandLine.Model.CommandSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        DeviceKind this$deviceType = this.getDeviceType();
        DeviceKind other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !((Object)((Object)this$deviceType)).equals((Object)other$deviceType)) {
            return false;
        }
        IpmiConfigCli this$ipmiConfigCli = this.getIpmiConfigCli();
        IpmiConfigCli other$ipmiConfigCli = other.getIpmiConfigCli();
        if (this$ipmiConfigCli == null ? other$ipmiConfigCli != null : !((Object)this$ipmiConfigCli).equals(other$ipmiConfigCli)) {
            return false;
        }
        SshConfigCli this$sshConfigCli = this.getSshConfigCli();
        SshConfigCli other$sshConfigCli = other.getSshConfigCli();
        if (this$sshConfigCli == null ? other$sshConfigCli != null : !((Object)this$sshConfigCli).equals(other$sshConfigCli)) {
            return false;
        }
        SnmpConfigCli this$snmpConfigCli = this.getSnmpConfigCli();
        SnmpConfigCli other$snmpConfigCli = other.getSnmpConfigCli();
        if (this$snmpConfigCli == null ? other$snmpConfigCli != null : !((Object)this$snmpConfigCli).equals(other$snmpConfigCli)) {
            return false;
        }
        SnmpV3ConfigCli this$snmpV3ConfigCli = this.getSnmpV3ConfigCli();
        SnmpV3ConfigCli other$snmpV3ConfigCli = other.getSnmpV3ConfigCli();
        if (this$snmpV3ConfigCli == null ? other$snmpV3ConfigCli != null : !((Object)this$snmpV3ConfigCli).equals(other$snmpV3ConfigCli)) {
            return false;
        }
        HttpConfigCli this$httpConfigCli = this.getHttpConfigCli();
        HttpConfigCli other$httpConfigCli = other.getHttpConfigCli();
        if (this$httpConfigCli == null ? other$httpConfigCli != null : !((Object)this$httpConfigCli).equals(other$httpConfigCli)) {
            return false;
        }
        WbemConfigCli this$wbemConfigCli = this.getWbemConfigCli();
        WbemConfigCli other$wbemConfigCli = other.getWbemConfigCli();
        if (this$wbemConfigCli == null ? other$wbemConfigCli != null : !((Object)this$wbemConfigCli).equals(other$wbemConfigCli)) {
            return false;
        }
        WmiConfigCli this$wmiConfigCli = this.getWmiConfigCli();
        WmiConfigCli other$wmiConfigCli = other.getWmiConfigCli();
        if (this$wmiConfigCli == null ? other$wmiConfigCli != null : !((Object)this$wmiConfigCli).equals(other$wmiConfigCli)) {
            return false;
        }
        WinRmConfigCli this$winRmConfigCli = this.getWinRmConfigCli();
        WinRmConfigCli other$winRmConfigCli = other.getWinRmConfigCli();
        if (this$winRmConfigCli == null ? other$winRmConfigCli != null : !((Object)this$winRmConfigCli).equals(other$winRmConfigCli)) {
            return false;
        }
        JdbcConfigCli this$jdbcConfigCli = this.getJdbcConfigCli();
        JdbcConfigCli other$jdbcConfigCli = other.getJdbcConfigCli();
        if (this$jdbcConfigCli == null ? other$jdbcConfigCli != null : !((Object)this$jdbcConfigCli).equals(other$jdbcConfigCli)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        Set<String> this$connectors = this.getConnectors();
        Set<String> other$connectors = other.getConnectors();
        if (this$connectors == null ? other$connectors != null : !((Object)this$connectors).equals(other$connectors)) {
            return false;
        }
        String this$patchDirectory = this.getPatchDirectory();
        String other$patchDirectory = other.getPatchDirectory();
        if (this$patchDirectory == null ? other$patchDirectory != null : !this$patchDirectory.equals(other$patchDirectory)) {
            return false;
        }
        if (!Arrays.equals(this.getVerbose(), other.getVerbose())) {
            return false;
        }
        Set<String> this$monitorTypes = this.getMonitorTypes();
        Set<String> other$monitorTypes = other.getMonitorTypes();
        return !(this$monitorTypes == null ? other$monitorTypes != null : !((Object)this$monitorTypes).equals(other$monitorTypes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetricsHubCliService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isVersionInfoRequested() ? 79 : 97);
        result = result * 59 + (this.isUsageHelpRequested() ? 79 : 97);
        result = result * 59 + (this.isSequential() ? 79 : 97);
        result = result * 59 + (this.isListConnectors() ? 79 : 97);
        result = result * 59 + this.getIterations();
        long $sleepIteration = this.getSleepIteration();
        result = result * 59 + (int)($sleepIteration >>> 32 ^ $sleepIteration);
        result = result * 59 + (this.isResolveHostnameToFqdn() ? 79 : 97);
        CommandLine.Model.CommandSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        DeviceKind $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : ((Object)((Object)$deviceType)).hashCode());
        IpmiConfigCli $ipmiConfigCli = this.getIpmiConfigCli();
        result = result * 59 + ($ipmiConfigCli == null ? 43 : ((Object)$ipmiConfigCli).hashCode());
        SshConfigCli $sshConfigCli = this.getSshConfigCli();
        result = result * 59 + ($sshConfigCli == null ? 43 : ((Object)$sshConfigCli).hashCode());
        SnmpConfigCli $snmpConfigCli = this.getSnmpConfigCli();
        result = result * 59 + ($snmpConfigCli == null ? 43 : ((Object)$snmpConfigCli).hashCode());
        SnmpV3ConfigCli $snmpV3ConfigCli = this.getSnmpV3ConfigCli();
        result = result * 59 + ($snmpV3ConfigCli == null ? 43 : ((Object)$snmpV3ConfigCli).hashCode());
        HttpConfigCli $httpConfigCli = this.getHttpConfigCli();
        result = result * 59 + ($httpConfigCli == null ? 43 : ((Object)$httpConfigCli).hashCode());
        WbemConfigCli $wbemConfigCli = this.getWbemConfigCli();
        result = result * 59 + ($wbemConfigCli == null ? 43 : ((Object)$wbemConfigCli).hashCode());
        WmiConfigCli $wmiConfigCli = this.getWmiConfigCli();
        result = result * 59 + ($wmiConfigCli == null ? 43 : ((Object)$wmiConfigCli).hashCode());
        WinRmConfigCli $winRmConfigCli = this.getWinRmConfigCli();
        result = result * 59 + ($winRmConfigCli == null ? 43 : ((Object)$winRmConfigCli).hashCode());
        JdbcConfigCli $jdbcConfigCli = this.getJdbcConfigCli();
        result = result * 59 + ($jdbcConfigCli == null ? 43 : ((Object)$jdbcConfigCli).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        Set<String> $connectors = this.getConnectors();
        result = result * 59 + ($connectors == null ? 43 : ((Object)$connectors).hashCode());
        String $patchDirectory = this.getPatchDirectory();
        result = result * 59 + ($patchDirectory == null ? 43 : $patchDirectory.hashCode());
        result = result * 59 + Arrays.hashCode(this.getVerbose());
        Set<String> $monitorTypes = this.getMonitorTypes();
        result = result * 59 + ($monitorTypes == null ? 43 : ((Object)$monitorTypes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetricsHubCliService(spec=" + String.valueOf(this.getSpec()) + ", versionInfoRequested=" + this.isVersionInfoRequested() + ", usageHelpRequested=" + this.isUsageHelpRequested() + ", hostname=" + this.getHostname() + ", deviceType=" + String.valueOf((Object)this.getDeviceType()) + ", ipmiConfigCli=" + String.valueOf(this.getIpmiConfigCli()) + ", sshConfigCli=" + String.valueOf(this.getSshConfigCli()) + ", snmpConfigCli=" + String.valueOf(this.getSnmpConfigCli()) + ", snmpV3ConfigCli=" + String.valueOf(this.getSnmpV3ConfigCli()) + ", httpConfigCli=" + String.valueOf(this.getHttpConfigCli()) + ", wbemConfigCli=" + String.valueOf(this.getWbemConfigCli()) + ", wmiConfigCli=" + String.valueOf(this.getWmiConfigCli()) + ", winRmConfigCli=" + String.valueOf(this.getWinRmConfigCli()) + ", jdbcConfigCli=" + String.valueOf(this.getJdbcConfigCli()) + ", username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", connectors=" + String.valueOf(this.getConnectors()) + ", patchDirectory=" + this.getPatchDirectory() + ", sequential=" + this.isSequential() + ", verbose=" + Arrays.toString(this.getVerbose()) + ", listConnectors=" + this.isListConnectors() + ", iterations=" + this.getIterations() + ", sleepIteration=" + this.getSleepIteration() + ", monitorTypes=" + String.valueOf(this.getMonitorTypes()) + ", resolveHostnameToFqdn=" + this.isResolveHostnameToFqdn() + ")";
    }

    @Generated
    public MetricsHubCliService() {
    }

    @FunctionalInterface
    public static interface CliPasswordReader<R> {
        public R read(String var1, Object ... var2);
    }
}

