/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli.service;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import lombok.Generated;
import lombok.NonNull;
import org.fusesource.jansi.Ansi;
import org.sentrysoftware.metricshub.agent.context.MetricDefinitions;
import org.sentrysoftware.metricshub.agent.helper.ConfigHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.common.helpers.NumberHelper;
import org.sentrysoftware.metricshub.engine.connector.model.metric.MetricDefinition;
import org.sentrysoftware.metricshub.engine.telemetry.MetricFactory;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.Resource;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.engine.telemetry.metric.AbstractMetric;
import org.sentrysoftware.metricshub.engine.telemetry.metric.NumberMetric;
import org.sentrysoftware.metricshub.engine.telemetry.metric.StateSetMetric;

public class PrettyPrinterService {
    static final String RESOURCE_HEADER = "Resource:";
    static final String ATTRIBUTES_HEADER = "Attributes:";
    public static final Map<String, Integer> MONITOR_TYPE_PRIORITY = Map.of(KnownMonitorType.HOST.getKey(), 1, KnownMonitorType.CONNECTOR.getKey(), 2, KnownMonitorType.ENCLOSURE.getKey(), 3, KnownMonitorType.BLADE.getKey(), 4, KnownMonitorType.DISK_CONTROLLER.getKey(), 5, KnownMonitorType.CPU.getKey(), 6);
    @NonNull
    private TelemetryManager telemetryManager;
    @NonNull
    private PrintWriter printWriter;
    private MetricDefinitions hostMetricDefinitions;

    public PrettyPrinterService(@NonNull TelemetryManager telemetryManager, @NonNull PrintWriter printWriter) throws IOException {
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (printWriter == null) {
            throw new IllegalArgumentException("printWriter is marked non-null but is null");
        }
        this.telemetryManager = telemetryManager;
        this.printWriter = printWriter;
        this.hostMetricDefinitions = ConfigHelper.readHostMetricDefinitions();
    }

    public void print(Set<String> monitorTypes) {
        HashSet<String> includedMonitorTypes = new HashSet<String>();
        HashSet<String> excludedMonitorTypes = new HashSet<String>();
        if (monitorTypes != null) {
            for (String type : monitorTypes) {
                if (type.startsWith("+")) {
                    includedMonitorTypes.add(type.substring(1));
                    continue;
                }
                if (!type.startsWith("!")) continue;
                excludedMonitorTypes.add(type.substring(1));
            }
        }
        MonitorChildren root = MonitorChildren.build(this.telemetryManager.getEndpointHostMonitor(), this.telemetryManager.getMonitors().values().stream().map(Map::values).flatMap(Collection::stream).filter(monitor -> !monitor.isEndpointHost()).filter(monitor -> includedMonitorTypes.isEmpty() || includedMonitorTypes.contains(monitor.getType())).filter(monitor -> !excludedMonitorTypes.contains(monitor.getType())).toList());
        this.print(root, 0);
    }

    private void print(MonitorChildren monitorChildren, int indentation) {
        Monitor monitor = monitorChildren.getMonitor();
        String monitorType = monitor.getType();
        this.addMargin(indentation);
        this.printWriter.print("- ");
        this.printWriter.print(monitorType);
        this.printWriter.print(": ");
        this.printWriter.println(Ansi.ansi().fgCyan().a(this.getMonitorDisplayName(monitor)).reset().toString());
        this.printAttributes(monitor.getAttributes(), indentation + 2, ATTRIBUTES_HEADER);
        Resource resource = monitor.getResource();
        if (resource != null) {
            this.printAttributes(resource.getAttributes(), indentation + 2, RESOURCE_HEADER);
        }
        this.printMetrics(monitor, indentation + 2);
        this.printTextParameters(monitor, indentation + 2);
        this.printWriter.println();
        this.printWriter.flush();
        Comparator<Map.Entry> comparator = Comparator.comparing(entry -> MONITOR_TYPE_PRIORITY.getOrDefault(entry.getKey(), Integer.MAX_VALUE));
        comparator.thenComparing(Map.Entry::getKey);
        monitorChildren.getChildren().entrySet().stream().sorted(comparator).forEach(entry -> {
            this.addMargin(indentation + 4);
            this.printWriter.println(Ansi.ansi().bold().a((String)entry.getKey()).boldOff().a(" monitors:").toString());
            ((Set)entry.getValue()).forEach(children -> this.print((MonitorChildren)children, indentation + 4));
        });
    }

    void printMetrics(Monitor monitor, int indentation) {
        Map<String, AbstractMetric> metrics = monitor.getMetrics();
        if (metrics == null || metrics.isEmpty()) {
            return;
        }
        this.printWriter.println();
        this.addMargin(indentation);
        this.printWriter.println("Metrics:");
        int metricMaxLength = metrics.keySet().stream().mapToInt(String::length).max().orElseThrow();
        String metricNameFormat = String.format("%%-%ds", metricMaxLength + 5);
        Map<String, MetricDefinition> metricDefinitions = monitor.isEndpointHost() ? this.hostMetricDefinitions.metrics() : ConfigHelper.fetchMetricDefinitions(this.telemetryManager.getConnectorStore(), monitor.getAttribute("connector_id"));
        metrics.entrySet().stream().filter(entry -> this.shouldDisplayKey((String)entry.getKey())).filter(entry -> entry.getValue() != null).sorted((entry1, entry2) -> ((String)entry1.getKey()).compareToIgnoreCase((String)entry2.getKey())).forEach(e -> {
            String metricName = (String)e.getKey();
            AbstractMetric metric = (AbstractMetric)e.getValue();
            String formattedMetricName = String.format(metricNameFormat, metricName);
            this.addMargin(indentation);
            if (metric instanceof NumberMetric) {
                NumberMetric numberMetric = (NumberMetric)metric;
                Optional<String> maybeUnit = PrettyPrinterService.fetchUnit(MetricFactory.extractName(metricName), metricDefinitions);
                this.printNumberMetric(formattedMetricName, numberMetric, maybeUnit);
            } else if (metric instanceof StateSetMetric) {
                StateSetMetric stateSetMetric = (StateSetMetric)metric;
                this.printStateSetMetric(formattedMetricName, stateSetMetric);
            }
        });
    }

    private void printStateSetMetric(String formattedMetricName, StateSetMetric stateSetMetric) {
        String state = stateSetMetric.getValue();
        if (state == null) {
            return;
        }
        switch (state) {
            case "ok": {
                this.printWriter.println(Ansi.ansi().a(formattedMetricName).bold().fgBrightGreen().a(state).reset().toString());
                break;
            }
            case "degraded": {
                this.printWriter.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_FAINT).a(formattedMetricName).bold().fgYellow().a(state).reset().toString());
                break;
            }
            case "failed": {
                this.printWriter.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_FAINT).a(formattedMetricName).bold().fgRed().a(state).reset().toString());
                break;
            }
            default: {
                this.printWriter.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_FAINT).a(formattedMetricName).bold().a(state).reset().toString());
            }
        }
    }

    private void printNumberMetric(String formattedMetricName, NumberMetric numberMetric, Optional<String> maybeUnit) {
        Double value = numberMetric.getValue();
        if (value == null) {
            return;
        }
        Ansi ansi = Ansi.ansi().a(Ansi.Attribute.INTENSITY_FAINT).a(formattedMetricName).bold().a(NumberHelper.formatNumber(value));
        if (maybeUnit.isPresent()) {
            ansi = ansi.a(" ").a(maybeUnit.get());
        }
        this.printWriter.println(ansi.boldOff().reset().toString());
    }

    private String getMonitorDisplayName(Monitor monitor) {
        String displayName = monitor.getAttribute("name");
        displayName = displayName != null ? displayName : monitor.getAttribute("id");
        return displayName != null ? displayName : monitor.getId();
    }

    void printAttributes(Map<String, String> attributes, int indentation, String header) {
        this.printWriter.println();
        this.addMargin(indentation);
        this.printWriter.println(header);
        attributes.entrySet().stream().filter(entry -> this.shouldDisplayKey((String)entry.getKey())).filter(entry -> entry.getValue() != null && !((String)entry.getValue()).isBlank()).sorted((entry1, entry2) -> ((String)entry1.getKey()).compareToIgnoreCase((String)entry2.getKey())).forEach(e -> {
            this.addMargin(indentation);
            this.printWriter.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_FAINT).a((String)e.getKey()).a(": ").reset().a(((String)e.getValue()).trim()).toString());
        });
    }

    void printTextParameters(Monitor monitor, int indentation) {
        Map<String, String> textParameters = monitor.getLegacyTextParameters();
        if (textParameters.isEmpty()) {
            return;
        }
        this.printWriter.println();
        this.addMargin(indentation);
        this.printWriter.println("Text parameters:");
        textParameters.entrySet().stream().filter(entry -> this.shouldDisplayKey((String)entry.getKey())).filter(entry -> entry.getValue() != null && !((String)entry.getValue()).isBlank()).sorted((entry1, entry2) -> ((String)entry1.getKey()).compareToIgnoreCase((String)entry2.getKey())).forEach(e -> {
            this.addMargin(indentation + 2);
            this.printWriter.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_FAINT).a((String)e.getKey()).a(": ").reset().a("\n").a(((String)e.getValue()).trim().indent(indentation + 2)).toString());
        });
    }

    private boolean shouldDisplayKey(String key) {
        return !key.startsWith("__");
    }

    void addMargin(int indentation) {
        this.printWriter.print(" ".repeat(indentation));
    }

    static Optional<String> fetchUnit(String metricName, Map<String, MetricDefinition> metricDefinitionMap) {
        return Optional.ofNullable(metricDefinitionMap.get(metricName)).map(MetricDefinition::getUnit).filter(unit -> Objects.nonNull(unit) && !unit.isBlank());
    }

    @NonNull
    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @NonNull
    @Generated
    public PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    @Generated
    public MetricDefinitions getHostMetricDefinitions() {
        return this.hostMetricDefinitions;
    }

    @Generated
    public void setTelemetryManager(@NonNull TelemetryManager telemetryManager) {
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public void setPrintWriter(@NonNull PrintWriter printWriter) {
        if (printWriter == null) {
            throw new IllegalArgumentException("printWriter is marked non-null but is null");
        }
        this.printWriter = printWriter;
    }

    @Generated
    public void setHostMetricDefinitions(MetricDefinitions hostMetricDefinitions) {
        this.hostMetricDefinitions = hostMetricDefinitions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrettyPrinterService)) {
            return false;
        }
        PrettyPrinterService other = (PrettyPrinterService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        if (this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager)) {
            return false;
        }
        PrintWriter this$printWriter = this.getPrintWriter();
        PrintWriter other$printWriter = other.getPrintWriter();
        if (this$printWriter == null ? other$printWriter != null : !this$printWriter.equals(other$printWriter)) {
            return false;
        }
        MetricDefinitions this$hostMetricDefinitions = this.getHostMetricDefinitions();
        MetricDefinitions other$hostMetricDefinitions = other.getHostMetricDefinitions();
        return !(this$hostMetricDefinitions == null ? other$hostMetricDefinitions != null : !((Object)this$hostMetricDefinitions).equals(other$hostMetricDefinitions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PrettyPrinterService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        PrintWriter $printWriter = this.getPrintWriter();
        result = result * 59 + ($printWriter == null ? 43 : $printWriter.hashCode());
        MetricDefinitions $hostMetricDefinitions = this.getHostMetricDefinitions();
        result = result * 59 + ($hostMetricDefinitions == null ? 43 : ((Object)$hostMetricDefinitions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PrettyPrinterService(telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ", printWriter=" + String.valueOf(this.getPrintWriter()) + ", hostMetricDefinitions=" + String.valueOf(this.getHostMetricDefinitions()) + ")";
    }

    private static class MonitorChildren
    implements Comparable<MonitorChildren> {
        private static final String MONITOR_ATTRIBUTE_PARENT_TYPE = "parent.type";
        private static final String MONITOR_ID_FORMAT = "%s_%s";
        @NonNull
        private Monitor monitor;
        private Map<String, Set<MonitorChildren>> children = new TreeMap<String, Set<MonitorChildren>>();

        private void addOne(MonitorChildren monitorChildren) {
            this.children.computeIfAbsent(monitorChildren.getMonitor().getType(), t2 -> new TreeSet()).add(monitorChildren);
        }

        public static MonitorChildren build(Monitor rootMonitor, List<Monitor> monitors) {
            MonitorChildren root = new MonitorChildren(rootMonitor);
            HashMap<String, MonitorChildren> monitorMap = new HashMap<String, MonitorChildren>();
            for (Monitor monitorInstance : monitors) {
                MonitorChildren monitorChildren = new MonitorChildren(monitorInstance);
                String attributeId = monitorInstance.getAttribute("id");
                String monitorType = monitorInstance.getType();
                monitorMap.put(String.format(MONITOR_ID_FORMAT, monitorType, attributeId), monitorChildren);
            }
            for (MonitorChildren monitorChildren : monitorMap.values()) {
                Optional<MonitorChildren> maybeParent = MonitorChildren.lookupParent(monitorMap, monitorChildren);
                maybeParent.ifPresentOrElse(parent -> parent.addOne(monitorChildren), () -> root.addOne(monitorChildren));
            }
            return root;
        }

        private static Optional<MonitorChildren> lookupParent(Map<String, MonitorChildren> monitorChildrenMap, MonitorChildren monitorChildren) {
            String parentType;
            String parentId = monitorChildren.getMonitor().getAttribute("parent.id");
            if (parentId == null) {
                parentId = monitorChildren.getMonitor().getAttributes().entrySet().stream().filter(attribute -> ((String)attribute.getKey()).contains("parent.id")).findFirst().map(Map.Entry::getValue).orElse(null);
            }
            if ((parentType = monitorChildren.getMonitor().getAttribute(MONITOR_ATTRIBUTE_PARENT_TYPE)) == null) {
                parentType = monitorChildren.getMonitor().getAttributes().entrySet().stream().filter(attribute -> ((String)attribute.getKey()).contains(MONITOR_ATTRIBUTE_PARENT_TYPE)).findFirst().map(Map.Entry::getValue).orElse(null);
            }
            return parentId != null && parentType != null ? Optional.ofNullable(monitorChildrenMap.get(String.format(MONITOR_ID_FORMAT, parentType, parentId))) : Optional.empty();
        }

        @Override
        public int compareTo(MonitorChildren other) {
            String currentName = this.monitor.getAttribute("name");
            String otherName = other.getMonitor().getAttribute("name");
            if (currentName != null && otherName != null) {
                return currentName.compareTo(otherName);
            }
            return this.monitor.getId().compareTo(other.getMonitor().getId());
        }

        @NonNull
        @Generated
        public Monitor getMonitor() {
            return this.monitor;
        }

        @Generated
        public Map<String, Set<MonitorChildren>> getChildren() {
            return this.children;
        }

        @Generated
        public void setMonitor(@NonNull Monitor monitor) {
            if (monitor == null) {
                throw new IllegalArgumentException("monitor is marked non-null but is null");
            }
            this.monitor = monitor;
        }

        @Generated
        public void setChildren(Map<String, Set<MonitorChildren>> children) {
            this.children = children;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MonitorChildren)) {
                return false;
            }
            MonitorChildren other = (MonitorChildren)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Monitor this$monitor = this.getMonitor();
            Monitor other$monitor = other.getMonitor();
            if (this$monitor == null ? other$monitor != null : !((Object)this$monitor).equals(other$monitor)) {
                return false;
            }
            Map<String, Set<MonitorChildren>> this$children = this.getChildren();
            Map<String, Set<MonitorChildren>> other$children = other.getChildren();
            return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MonitorChildren;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Monitor $monitor = this.getMonitor();
            result = result * 59 + ($monitor == null ? 43 : ((Object)$monitor).hashCode());
            Map<String, Set<MonitorChildren>> $children = this.getChildren();
            result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PrettyPrinterService.MonitorChildren(monitor=" + String.valueOf(this.getMonitor()) + ", children=" + String.valueOf(this.getChildren()) + ")";
        }

        @Generated
        public MonitorChildren(@NonNull Monitor monitor) {
            if (monitor == null) {
                throw new IllegalArgumentException("monitor is marked non-null but is null");
            }
            this.monitor = monitor;
        }
    }
}

