/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli.service;

import picocli.CommandLine;

public class PrintExceptionMessageHandlerService
implements CommandLine.IExecutionExceptionHandler {
    private static final int MAXIMUM_CAUSE_DEPTH = 10;

    @Override
    public int handleExecutionException(Exception exception, CommandLine commandLine, CommandLine.ParseResult parseResult) {
        int depth = 0;
        for (Throwable cause = exception; depth < 10 && cause != null; cause = cause.getCause(), ++depth) {
            String message = " ".repeat(depth * 2) + cause.getClass().getSimpleName();
            if (cause.getMessage() != null) {
                message = message + ": " + cause.getMessage();
            }
            commandLine.getErr().println(commandLine.getColorScheme().errorText(message));
        }
        return 1;
    }
}

