/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli.service;

import org.sentrysoftware.metricshub.agent.context.ApplicationProperties;
import org.sentrysoftware.metricshub.agent.helper.AgentConstants;
import org.sentrysoftware.metricshub.engine.common.helpers.JsonHelper;
import org.springframework.core.io.ClassPathResource;
import picocli.CommandLine;

public class VersionService
implements CommandLine.IVersionProvider {
    @Override
    public String[] getVersion() throws Exception {
        ClassPathResource classPathResource = new ClassPathResource("application.yaml");
        ApplicationProperties applicationProperties = JsonHelper.deserialize(AgentConstants.OBJECT_MAPPER, classPathResource.getInputStream(), ApplicationProperties.class);
        ApplicationProperties.Project project = applicationProperties.project();
        String projectName = project.name();
        String projectVersion = project.version();
        String buildNumber = applicationProperties.buildNumber();
        String buildDate = applicationProperties.buildDate();
        String ccVersion = applicationProperties.ccVersion();
        return new String[]{" __  __          _            _                _    _           _      \u00ae  ", "|  \\/  |        | |          (_)              | |  | |         | |       ", "| \\  / |   ___  | |_   _ __   _    ___   ___  | |__| |  _   _  | |__     ", "| |\\/| |  / _ \\ | __| | '__| | |  / __| / __| |  __  | | | | | | '_ \\  ", "| |  | | |  __/ | |_  | |    | | | (__  \\__ \\ | |  | | | |_| | | |_) |  ", "|_|  |_|  \\___|  \\__| |_|    |_|  \\___| |___/ |_|  |_|  \\__,_| |_.__/ ", "                                 @|faint Copyright (c) Sentry Software|@", "", String.format("@|bold %s|@ version @|bold,magenta %s|@", projectName, projectVersion), String.format("@|faint - Build Number:|@ @|magenta %s (on %s)|@", buildNumber, buildDate), String.format("- Community Connector Library version @|green,bold %s|@", ccVersion), "", "Java version @|magenta,bold ${java.version}|@ @|faint (${java.vendor} ${java.vm.name} ${java.vm.version})|@", "@|faint - Java Home:|@ @|magenta ${java.home}|@", "@|faint - System:|@ @|magenta ${os.name} ${os.version} ${os.arch}|@"};
    }
}

