/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli.service.protocol;

import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import lombok.Generated;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.protocol.AbstractTransportProtocolCli;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import picocli.CommandLine;

public class HttpConfigCli
extends AbstractTransportProtocolCli {
    public static final int DEFAULT_TIMEOUT = 30;
    @CommandLine.ArgGroup(exclusive=true, multiplicity="0..1")
    HttpOrHttps httpOrHttps;
    @CommandLine.Option(names={"--http-port"}, order=3, paramLabel="PORT", description={"Port for HTTP/HTTPS connections (default: 80 for HTTP, 443 for HTTPS)"})
    private Integer port;
    @CommandLine.Option(names={"--http-username"}, order=4, paramLabel="USER", description={"Username for HTTP authentication"})
    private String username;
    @CommandLine.Option(names={"--http-password"}, order=5, paramLabel="P4SSW0RD", description={"Password for the HTTP protocol"}, arity="0..1", interactive=true)
    private char[] password;
    @CommandLine.Option(names={"--http-timeout"}, order=6, paramLabel="TIMEOUT", defaultValue="30", description={"Timeout in seconds for HTTP operations (default: ${DEFAULT-VALUE} s)"})
    private String timeout;

    @Override
    public IConfiguration toConfiguration(String defaultUsername, char[] defaultPassword) throws InvalidConfigurationException {
        char[] finalPassword;
        ObjectNode configuration = JsonNodeFactory.instance.objectNode();
        configuration.set("https", BooleanNode.valueOf(this.isHttps()));
        String finalUsername = this.username == null ? defaultUsername : this.username;
        configuration.set("username", new TextNode(finalUsername));
        char[] cArray = finalPassword = this.username == null ? defaultPassword : this.password;
        if (finalPassword != null) {
            configuration.set("password", new TextNode(String.valueOf(finalPassword)));
        }
        configuration.set("port", new IntNode(this.getOrDeducePortNumber()));
        configuration.set("timeout", new TextNode(this.timeout));
        return CliExtensionManager.getExtensionManagerSingleton().buildConfigurationFromJsonNode("http", configuration, value -> value).orElseThrow();
    }

    @Override
    protected boolean isHttps() {
        return this.httpOrHttps.https;
    }

    @Override
    protected int defaultHttpsPortNumber() {
        return 443;
    }

    @Override
    protected int defaultHttpPortNumber() {
        return 80;
    }

    @Generated
    public HttpConfigCli() {
    }

    @Generated
    public HttpOrHttps getHttpOrHttps() {
        return this.httpOrHttps;
    }

    @Override
    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setHttpOrHttps(HttpOrHttps httpOrHttps) {
        this.httpOrHttps = httpOrHttps;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    @Generated
    public String toString() {
        return "HttpConfigCli(httpOrHttps=" + String.valueOf(this.getHttpOrHttps()) + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", timeout=" + this.getTimeout() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpConfigCli)) {
            return false;
        }
        HttpConfigCli other = (HttpConfigCli)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        HttpOrHttps this$httpOrHttps = this.getHttpOrHttps();
        HttpOrHttps other$httpOrHttps = other.getHttpOrHttps();
        if (this$httpOrHttps == null ? other$httpOrHttps != null : !this$httpOrHttps.equals(other$httpOrHttps)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        return !(this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpConfigCli;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        HttpOrHttps $httpOrHttps = this.getHttpOrHttps();
        result = result * 59 + ($httpOrHttps == null ? 43 : $httpOrHttps.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        return result;
    }

    public static class HttpOrHttps {
        @CommandLine.Option(names={"--http"}, order=1, description={"Enables HTTP"}, required=true)
        boolean http;
        @CommandLine.Option(names={"--https"}, order=2, description={"Enables HTTPS"}, required=true)
        boolean https;

        @Generated
        public boolean isHttp() {
            return this.http;
        }

        @Generated
        public boolean isHttps() {
            return this.https;
        }
    }
}

