/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli.service.protocol;

import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import lombok.Generated;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.protocol.IProtocolConfigCli;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import picocli.CommandLine;

public class IpmiConfigCli
implements IProtocolConfigCli {
    public static final int DEFAULT_TIMEOUT = 120;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--ipmi"}, order=1, description={"Enables IPMI-over-LAN"})
    private boolean useIpmi;
    @CommandLine.Option(names={"--ipmi-username"}, order=2, paramLabel="USER", description={"Username for IPMI-over-LAN authentication"})
    private String username;
    @CommandLine.Option(names={"--ipmi-password"}, order=3, paramLabel="P4SSW0RD", description={"Password for IPMI-over-LAN authentication"}, interactive=true, arity="0..1")
    private char[] password;
    @CommandLine.Option(names={"--ipmi-bmc-key"}, order=4, paramLabel="KEY", description={"BMC key for IPMI-over-LAN two-key authentication (in hexadecimal)"})
    private String bmcKey;
    @CommandLine.Option(names={"--ipmi-skip-auth"}, order=5, defaultValue="false", description={"Skips IPMI-over-LAN authentication"})
    private boolean skipAuth;
    @CommandLine.Option(names={"--ipmi-timeout"}, order=6, paramLabel="TIMEOUT", defaultValue="120", description={"Timeout in seconds for HTTP operations (default: ${DEFAULT-VALUE} s)"})
    private String timeout;

    @Override
    public IConfiguration toConfiguration(String defaultUsername, char[] defaultPassword) throws InvalidConfigurationException {
        char[] finalPassword;
        ObjectNode configuration = JsonNodeFactory.instance.objectNode();
        String finalUsername = this.username == null ? defaultUsername : this.username;
        configuration.set("username", new TextNode(finalUsername));
        char[] cArray = finalPassword = this.username == null ? defaultPassword : this.password;
        if (finalPassword != null) {
            configuration.set("password", new TextNode(String.valueOf(finalPassword)));
        }
        configuration.set("timeout", new TextNode(this.timeout));
        configuration.set("skipAuth", BooleanNode.valueOf(this.skipAuth));
        configuration.set("bmcKey", new TextNode(this.bmcKey));
        return CliExtensionManager.getExtensionManagerSingleton().buildConfigurationFromJsonNode("ipmi", configuration, value -> value).orElseThrow();
    }

    @Generated
    public IpmiConfigCli() {
    }

    @Generated
    public CommandLine.Model.CommandSpec getSpec() {
        return this.spec;
    }

    @Generated
    public boolean isUseIpmi() {
        return this.useIpmi;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public String getBmcKey() {
        return this.bmcKey;
    }

    @Generated
    public boolean isSkipAuth() {
        return this.skipAuth;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setSpec(CommandLine.Model.CommandSpec spec) {
        this.spec = spec;
    }

    @Generated
    public void setUseIpmi(boolean useIpmi) {
        this.useIpmi = useIpmi;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setBmcKey(String bmcKey) {
        this.bmcKey = bmcKey;
    }

    @Generated
    public void setSkipAuth(boolean skipAuth) {
        this.skipAuth = skipAuth;
    }

    @Generated
    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IpmiConfigCli)) {
            return false;
        }
        IpmiConfigCli other = (IpmiConfigCli)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseIpmi() != other.isUseIpmi()) {
            return false;
        }
        if (this.isSkipAuth() != other.isSkipAuth()) {
            return false;
        }
        CommandLine.Model.CommandSpec this$spec = this.getSpec();
        CommandLine.Model.CommandSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$bmcKey = this.getBmcKey();
        String other$bmcKey = other.getBmcKey();
        if (this$bmcKey == null ? other$bmcKey != null : !this$bmcKey.equals(other$bmcKey)) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        return !(this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IpmiConfigCli;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseIpmi() ? 79 : 97);
        result = result * 59 + (this.isSkipAuth() ? 79 : 97);
        CommandLine.Model.CommandSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $bmcKey = this.getBmcKey();
        result = result * 59 + ($bmcKey == null ? 43 : $bmcKey.hashCode());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IpmiConfigCli(spec=" + String.valueOf(this.getSpec()) + ", useIpmi=" + this.isUseIpmi() + ", username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", bmcKey=" + this.getBmcKey() + ", skipAuth=" + this.isSkipAuth() + ", timeout=" + this.getTimeout() + ")";
    }
}

